/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.aggregator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.aggregator.AggregatingDataSourceFactory;
import org.autoplot.aggregator.AggregationPollUpdating;
import org.autoplot.aggregator.StreamingCapability;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Streaming;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.capability.Updating;
import org.das2.CancelledOperationException;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.BundleBuilder;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qds.util.Reduction;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public final class AggregatingDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger("apdss.agg");
    public static final String MSG_NO_FILES_FOUND = "No files in interval";
    public static final String PARAM_AVAIL = "avail";
    private FileStorageModel fsm;
    DataSourceFactory delegateDataSourceFactory;
    AggregationPollUpdating upd;
    Map<String, Object> metadata;
    MetadataModel metadataModel;
    TimeSeriesBrowse tsb;
    private static DatumRange DEFAULT_TIME_RANGE = DatumRangeUtil.parseTimeRangeValid("1970-01-01");
    private DatumRange viewRange = DEFAULT_TIME_RANGE;
    private Datum resolution = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String sparams = "";

    public AggregatingDataSource(URI uri, DataSourceFactory delegateFactory) throws MalformedURLException, FileSystem.FileSystemOfflineException, IOException, ParseException {
        super(uri);
        String filePollUpdates;
        String stimeRange;
        this.delegateDataSourceFactory = delegateFactory;
        if (AggregatingDataSourceFactory.hasTimeFields(uri.toString())) {
            this.tsb = new AggTimeSeriesBrowse();
            this.addCapability(TimeSeriesBrowse.class, this.tsb);
            this.addCapability(Streaming.class, new StreamingCapability(uri, this));
        }
        if ((stimeRange = this.params.get("timerange")) != null) {
            if (this.params.get("timeRange") != null) {
                stimeRange = this.params.get("timeRange");
            }
            if (stimeRange == null) {
                throw new IllegalArgumentException("timerange not found");
            }
            stimeRange = stimeRange.replaceAll("\\+", " ");
            this.viewRange = DatumRangeUtil.parseTimeRange(stimeRange);
        }
        if ((filePollUpdates = this.getParam("filePollUpdates", "")).length() > 0) {
            String surl = DataSetURI.fromUri(uri);
            FileStorageModel fsm1 = AggregatingDataSourceFactory.getFileStorageModel(surl);
            double ffilePollUpdates = Math.ceil(Double.parseDouble(filePollUpdates));
            this.upd = new AggregationPollUpdating(fsm1, this.viewRange, (long)ffilePollUpdates);
            this.addCapability(Updating.class, this.upd);
        }
    }

    private MutablePropertyDataSet checkBoundaries(DatumRange bounds, MutablePropertyDataSet ads0) {
        int ien;
        int ist;
        logger.entering("org.autoplot.aggregator.AggregatingDataSource", "checkBoundaries");
        QDataSet dep0_0 = (QDataSet)ads0.property("DEPEND_0");
        if (dep0_0 == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ads0))) {
            dep0_0 = ads0;
        } else if (dep0_0 == null) {
            return ads0;
        }
        if (!UnitsUtil.isTimeLocation(SemanticOps.getUnits(dep0_0))) {
            return ads0;
        }
        if (dep0_0.rank() != 1) {
            return ads0;
        }
        for (ist = 0; ist < dep0_0.length() && DatumRangeUtil.normalize(bounds, DataSetUtil.asDatum(dep0_0.slice(ist))) < -0.5; ++ist) {
        }
        for (ien = ads0.length(); ien > 0 && DatumRangeUtil.normalize(bounds, DataSetUtil.asDatum(dep0_0.slice(ien - 1))) > 1.5; --ien) {
        }
        if (ist > 0 || ien < ads0.length()) {
            if (ist > 0) {
                logger.log(Level.INFO, "trimming records 0-{0} to remove timetags outside the bounds.", new Object[]{ist - 1});
            }
            if (ien < ads0.length()) {
                logger.log(Level.INFO, "trimming records {0}-{1} to remove timetags outside the bounds.", new Object[]{ien - 1, ads0.length() - 1});
            }
            WritableDataSet result = Ops.maybeCopy((MutablePropertyDataSet)ads0.trim(ist, ien));
            logger.exiting("org.autoplot.aggregator.AggregatingDataSource", "checkBoundaries");
            return result;
        }
        logger.exiting("org.autoplot.aggregator.AggregatingDataSource", "checkBoundaries");
        return ads0;
    }

    private MutablePropertyDataSet checkSort(MutablePropertyDataSet ads0) {
        logger.entering("org.autoplot.aggregator.AggregatingDataSource", "checkSort");
        QDataSet dep0_0 = (QDataSet)ads0.property("DEPEND_0");
        if (dep0_0 == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ads0))) {
            dep0_0 = ads0;
        } else if (dep0_0 == null) {
            return ads0;
        }
        QDataSet sort = Ops.sort(dep0_0);
        if (ads0 instanceof WritableDataSet) {
            if (ads0.isImmutable()) {
                ads0 = Ops.copy(ads0);
            }
            DataSetOps.applyIndexInSitu((WritableDataSet)ads0, sort);
        } else {
            ads0 = Ops.copy(ads0);
            DataSetOps.applyIndexInSitu((WritableDataSet)ads0, sort);
        }
        ((WritableDataSet)dep0_0).putProperty("MONOTONIC", Boolean.TRUE);
        logger.exiting("org.autoplot.aggregator.AggregatingDataSource", "checkSort");
        return ads0;
    }

    private QDataSet trimOverlap(QDataSet ads0, QDataSet ads1) {
        int i;
        logger.entering("org.autoplot.aggregator.AggregatingDataSource", "trimOverlap");
        QDataSet dep0_0 = (QDataSet)ads0.property("DEPEND_0");
        QDataSet dep0_1 = (QDataSet)ads1.property("DEPEND_0");
        if (dep0_0 == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ads0))) {
            dep0_0 = ads0;
        }
        if (dep0_1 == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ads1))) {
            dep0_0 = ads1;
        }
        if (dep0_0 == null || dep0_1 == null) {
            return ads1;
        }
        if (dep0_1.rank() > 1) {
            throw new IllegalArgumentException("expected rank 1 depend0");
        }
        if (Ops.gt(dep0_1.slice(0), dep0_0.slice(dep0_0.length() - 1)).value() == 1.0) {
            logger.exiting("org.autoplot.aggregator.AggregatingDataSource", "trimOverlap");
            return ads1;
        }
        for (i = 0; i < dep0_1.length() && Ops.le(dep0_1.slice(i), dep0_0.slice(dep0_0.length() - 1)).value() == 1.0; ++i) {
        }
        logger.exiting("org.autoplot.aggregator.AggregatingDataSource", "trimOverlap");
        return ads1.trim(i, ads1.length());
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        logger.log(Level.FINE, "getDataSet {0}", this.uri);
        boolean useReferenceCache = "true".equals(System.getProperty("enableReferenceCache", "false"));
        String theUri = this.tsb != null ? this.tsb.getURI() : this.uri.toString();
        ReferenceCache.ReferenceCacheEntry cacheEntry = null;
        if (useReferenceCache) {
            cacheEntry = ReferenceCache.getInstance().getDataSetOrLock(theUri, mon);
            if (!cacheEntry.shouldILoad(Thread.currentThread())) {
                logger.log(Level.FINE, "wait for other thread {0}", this.uri);
                QDataSet result = cacheEntry.park(mon);
                return result;
            }
            logger.log(Level.FINE, "reference cache in use, {0} is loading {1}", new Object[]{Thread.currentThread().toString(), theUri});
        }
        logger.log(Level.FINE, "reading {0}", this.uri);
        try {
            QDataSet result = this.getDataSet(mon, this.viewRange, this.resolution);
            if (cacheEntry != null) {
                cacheEntry.finished(result);
            }
            return result;
        }
        catch (Exception ex) {
            if (cacheEntry != null) {
                cacheEntry.exception(ex);
            }
            throw ex;
        }
    }

    public QDataSet getDataSet(ProgressMonitor mon, DatumRange lviewRange, Datum lresolution) throws Exception {
        DDataSet notes;
        Units dep0units;
        ArrayDataSet dep0;
        mon.started();
        String[] ss = this.getFsm().getBestNamesFor(lviewRange, mon.getSubtaskMonitor(this.sparams));
        if ("true".equals(System.getProperty("enableCleanCache"))) {
            logger.fine("enableCleanCache is true");
            this.getFsm().cacheCleanup();
        }
        boolean avail = this.getParam(PARAM_AVAIL, "F").equals("T");
        boolean reduce = this.getParam("reduce", "F").equals("T");
        if (avail) {
            logger.log(Level.FINE, "availablility {0} ", new Object[]{lviewRange});
            DataSetBuilder build = new DataSetBuilder(2, ss.length, 4);
            TimeLocationUnits u = Units.us2000;
            EnumerationUnits eu = new EnumerationUnits("default");
            for (String s : ss) {
                DatumRange dr = this.getFsm().getRangeFor(s);
                build.putValues(-1, DDataSet.wrap(new double[]{dr.min().doubleValue(u), dr.max().doubleValue(u), 8454016.0, eu.createDatum(s).doubleValue(eu)}), 4);
                build.nextRecord();
            }
            DDataSet result = build.getDataSet();
            DDataSet bds = DDataSet.createRank2(4, 0);
            bds.putProperty("NAME__0", "StartTime");
            bds.putProperty("UNITS__0", u);
            bds.putProperty("NAME__1", "StopTime");
            bds.putProperty("UNITS__1", u);
            bds.putProperty("NAME__2", "Color");
            bds.putProperty("NAME__3", "Filename");
            bds.putProperty("UNITS__3", eu);
            result.putProperty("BUNDLE_1", bds);
            result.putProperty("RENDER_TYPE", "eventsBar");
            result.putProperty("LABEL", "Availability");
            URISplit split = URISplit.parse(this.getURI());
            result.putProperty("TITLE", split.file);
            mon.finished();
            return result;
        }
        logger.log(Level.FINE, "aggregating {0} files for {1}", new Object[]{ss.length, lviewRange});
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder log = new StringBuilder("== getDataSet will read the following ==");
            for (String s : ss) {
                log.append("\n").append(s);
            }
            logger.log(Level.FINE, log.toString());
        }
        QDataSet result = null;
        JoinDataSet altResult = null;
        DataSetBuilder dep0Builder = null;
        if (ss.length == 0) {
            if (null == this.getFsm().getRepresentativeFile(mon.getSubtaskMonitor("get representative file"))) {
                throw new FileNotFoundException("Unable to find representative file: No files found matching " + this.getFsm().toString());
            }
            throw new FileNotFoundException("No files in interval " + lviewRange);
        }
        if (ss.length > 1) {
            mon.setTaskSize(ss.length * 10);
        }
        DatumRange cacheRange1 = null;
        EnumerationUnits exunits = EnumerationUnits.create("notes");
        DataSetBuilder notesBuilder = new DataSetBuilder(2, ss.length / 2, 3);
        BundleBuilder bds = new BundleBuilder(3);
        bds.putProperty("NAME", 0, "startTime");
        bds.putProperty("NAME", 1, "stopTime");
        bds.putProperty("NAME", 2, "note");
        bds.putProperty("UNITS", 0, Units.us2000);
        bds.putProperty("UNITS", 1, Units.us2000);
        bds.putProperty("UNITS", 2, exunits);
        notesBuilder.putProperty("BUNDLE_1", bds.getDataSet());
        if (this.delegateDataSourceFactory == null) {
            throw new IllegalArgumentException("unable to identify data source");
        }
        boolean doThrow = false;
        for (int i = 0; i < ss.length; ++i) {
            ArrayList<String> problems;
            ProgressMonitor mon1;
            URI delegateUri;
            DataSource delegateDataSource;
            String scompUrl = this.getFsm().getFileSystem().getRootURI().toString() + ss[i];
            if (!this.sparams.equals("")) {
                scompUrl = scompUrl + "?" + this.sparams;
            }
            if ((delegateDataSource = this.delegateDataSourceFactory.getDataSource(delegateUri = DataSetURI.getURIValid(scompUrl))).getCapability(TimeSeriesBrowse.class) != null) {
                TimeSeriesBrowse delegateTsb = delegateDataSource.getCapability(TimeSeriesBrowse.class);
                delegateTsb.setTimeRange(lviewRange);
                delegateTsb.setTimeResolution(lresolution);
                this.setResolution(delegateTsb.getTimeResolution());
            }
            this.metadataModel = delegateDataSource.getMetadataModel();
            if (ss.length > 1) {
                mon.setProgressMessage("getting " + ss[i]);
                mon1 = mon.getSubtaskMonitor(i * 10, 10 * (i + 1), "getting " + ss[i]);
                if (mon1.isCancelled()) break;
                mon1.setTaskProgress(0L);
            } else if (ss.length == 1) {
                mon.setProgressMessage("getting " + ss[0]);
                mon1 = mon.getSubtaskMonitor("getting " + ss[0]);
                if (mon1.isCancelled()) break;
                mon1.started();
                mon1.setTaskProgress(0L);
            } else {
                mon1 = mon.getSubtaskMonitor("no files found");
                if (mon1.isCancelled()) break;
            }
            DatumRange drex = null;
            try {
                QDataSet dep02;
                ArrayList<String> problems2;
                QDataSet xds;
                DatumRange dr1;
                drex = dr1 = this.getFsm().getRangeFor(ss[i]);
                logger.log(Level.FINER, "delegate URI: {0}", new Object[]{delegateDataSource.getURI()});
                Object ds1 = delegateDataSource.getDataSet(mon1);
                logger.log(Level.FINER, "  read: {0}", new Object[]{ds1});
                if (ds1 == null) {
                    logger.warning("delegate returned null");
                    ds1 = delegateDataSource.getDataSet(mon1);
                    if (ds1 == null) continue;
                }
                if ((xds = SemanticOps.xtagsDataSet((QDataSet)ds1)) != null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(xds)) && !SemanticOps.isJoin(xds) && xds.length() > 0) {
                    QDataSet exds = Ops.extent(xds);
                    if (!UnitsUtil.isTimeLocation(dr1.getUnits()) || !UnitsUtil.isTimeLocation(SemanticOps.getUnits(exds))) {
                        logger.log(Level.WARNING, "Hey units! \"{0}\" \"{1}\"", new Object[]{dr1.getUnits(), SemanticOps.getUnits(exds)});
                    }
                    if (!dr1.intersects(DataSetUtil.asDatumRange(exds))) {
                        logger.log(Level.WARNING, "file for {0} contains data from an unexpected interval: {1}", new Object[]{dr1, exds});
                    }
                }
                if (!DataSetUtil.validate((QDataSet)ds1, problems2 = new ArrayList<String>())) {
                    for (String p : problems2) {
                        System.err.println("problem with aggregation element " + ss[i] + ": " + p);
                        logger.log(Level.WARNING, "problem with aggregation element {0}: {1}", new Object[]{ss[i], p});
                    }
                }
                if (reduce && ds1.rank() < 3 && SemanticOps.isTimeSeries((QDataSet)ds1)) {
                    dep02 = (QDataSet)ds1.property("DEPEND_0");
                    if (dep02 != null) {
                        if (DataSetUtil.isMonotonic(dep02)) {
                            logger.fine("trimming dataset to save memory");
                            mon1.setProgressMessage("trim to visible: " + lviewRange);
                            int imin = DataSetUtil.closestIndex(dep02, lviewRange.min());
                            int imax = DataSetUtil.closestIndex(dep02, lviewRange.max());
                            if (imin > 0 || ++imax < ds1.length()) {
                                ds1 = ds1.trim(imin, imax);
                            }
                            logger.log(Level.FINER, "dataset trimmed to {0}", ds1);
                        }
                        logger.fine("reducing resolution to save memory");
                        mon1.setProgressMessage("reducing resolution");
                        if (lresolution != null) {
                            ds1 = Reduction.reducex((QDataSet)ds1, DataSetUtil.asDataSet(lresolution));
                            logger.log(Level.FINER, "dataset reduced to {0}", ds1);
                        }
                    } else {
                        logger.fine("data is not time series, cannot reduce");
                    }
                }
                if (result == null && altResult == null) {
                    if (ds1 instanceof JoinDataSet) {
                        altResult = JoinDataSet.copy((JoinDataSet)ds1);
                        DDataSet mpds = DDataSet.create(new int[0]);
                        altResult.putProperty("JOIN_0", mpds);
                    } else {
                        boolean isSeriesOfImages;
                        dep02 = (QDataSet)ds1.property("DEPEND_0");
                        boolean bl = isSeriesOfImages = dep02 == null && (ds1.rank() > 2 || ds1.rank() == 2 && ds1.length(0) > 50);
                        if (isSeriesOfImages) {
                            result = new JoinDataSet((QDataSet)ds1);
                            dep0Builder = new DataSetBuilder(1, ss.length);
                            dep0Builder.nextRecord(dr1.middle());
                        } else if (ds1 instanceof BufferDataSet) {
                            if (ss.length == 1) {
                                result = BufferDataSet.maybeCopy((QDataSet)ds1);
                            } else {
                                result = BufferDataSet.copy((QDataSet)ds1);
                                ((BufferDataSet)result).grow(result.length() * ss.length * 11 / 10);
                            }
                        } else if (ss.length == 1) {
                            result = ArrayDataSet.maybeCopy((QDataSet)ds1);
                        } else {
                            result = ArrayDataSet.copy((QDataSet)ds1);
                            ((ArrayDataSet)result).grow(result.length() * ss.length * 11 / 10);
                        }
                    }
                    this.metadata = delegateDataSource.getMetadata(new NullProgressMonitor());
                    cacheRange1 = dr1;
                } else {
                    if (ds1 instanceof JoinDataSet) {
                        assert (altResult != null);
                        altResult.joinAll((JoinDataSet)ds1);
                    } else if (result instanceof BufferDataSet) {
                        assert (result != null);
                        BufferDataSet bresult = (BufferDataSet)result;
                        BufferDataSet ads1 = (BufferDataSet)Ops.maybeCopy((QDataSet)ds1);
                        try {
                            if (bresult.canAppend(ads1)) {
                                bresult.append(ads1);
                            }
                            bresult.grow(result.length() + ads1.length() * (ss.length - i));
                            bresult.append(ads1);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new IllegalArgumentException("can't append data from " + delegateUri, ex);
                        }
                        catch (Exception ex) {
                            doThrow = true;
                            throw ex;
                        }
                    } else if (result instanceof ArrayDataSet) {
                        assert (result != null);
                        ArrayDataSet aresult = (ArrayDataSet)result;
                        ArrayDataSet ads1 = ArrayDataSet.maybeCopy(aresult.getComponentType(), (QDataSet)ds1);
                        try {
                            if (aresult.canAppend(ads1)) {
                                ArrayDataSet saveAds1 = ads1;
                                if (ads1.length() != saveAds1.length()) {
                                    QDataSet saveDep0 = (QDataSet)saveAds1.property("DEPEND_0");
                                    logger.log(Level.WARNING, "data trimmed from dataset to avoid overlap at {0}", saveDep0.slice(0));
                                }
                                aresult.append(ads1);
                            }
                            aresult.grow(result.length() + ads1.length() * (ss.length - i));
                            aresult.append(ads1);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new IllegalArgumentException("can't append data from " + delegateUri, ex);
                        }
                        catch (Exception ex) {
                            doThrow = true;
                            throw ex;
                        }
                    } else {
                        assert (result instanceof JoinDataSet);
                        assert (dep0Builder != null);
                        ((JoinDataSet)result).join((QDataSet)ds1);
                        dep0Builder.nextRecord(dr1.middle());
                    }
                    cacheRange1 = new DatumRange(cacheRange1.min(), dr1.max());
                }
            }
            catch (Exception ex) {
                if (doThrow) {
                    throw ex;
                }
                if (ex instanceof NoDataInIntervalException && ss.length > 1) {
                    logger.log(Level.FINE, "no data found in {0}", delegateUri);
                }
                if (ss.length == 1) {
                    throw ex;
                }
                if (drex == null) {
                    throw new RuntimeException("internal error where drex is null because the name didn't belong to the aggregation.");
                }
                notesBuilder.putValue(-1, 0, drex.min().doubleValue(Units.us2000));
                notesBuilder.putValue(-1, 1, drex.max().doubleValue(Units.us2000));
                notesBuilder.putValue(-1, 2, exunits.createDatum(DataSourceUtil.getMessage(ex)).doubleValue(exunits));
                notesBuilder.nextRecord();
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            if (ss.length > 1 && mon.isCancelled()) {
                throw new CancelledOperationException("cancel pressed");
            }
            if (result == null || DataSetUtil.validate(result, problems = new ArrayList<String>())) continue;
            for (String p : problems) {
                logger.log(Level.WARNING, "problem in aggregation: {0}", p);
            }
        }
        mon.finished();
        HashMap<String, String[]> userProps = new HashMap<String, String[]>();
        userProps.put("files", ss);
        if (altResult != null) {
            dep0 = (ArrayDataSet)altResult.property("DEPEND_0");
            Units units = dep0units = dep0 == null ? null : SemanticOps.getUnits(dep0);
            if (dep0 == null) {
                dep0 = (ArrayDataSet)altResult.property("JOIN_0");
                QDataSet d = (QDataSet)altResult.property("DEPEND_0", 0);
                if (d != null) {
                    dep0units = SemanticOps.getUnits(d);
                }
                if (dep0 != null) {
                    dep0.putProperty("UNITS", dep0units);
                }
            }
            if (dep0 != null && dep0units != null && cacheRange1.getUnits().isConvertibleTo(dep0units)) {
                dep0.putProperty("CACHE_TAG", new CacheTag(cacheRange1, reduce ? lresolution : null));
                dep0.putProperty("TYPICAL_MIN", lviewRange.min().doubleValue(dep0units));
                dep0.putProperty("TYPICAL_MAX", lviewRange.max().doubleValue(dep0units));
            }
            if ((notes = notesBuilder.getDataSet()).length() > 0) {
                altResult.putProperty("NOTES", notes);
            }
            altResult.putProperty("USER_PROPERTIES", userProps);
            logger.log(Level.FINE, "loaded {0} {1}", new Object[]{altResult, this.describeRange(result)});
            return altResult;
        }
        if (dep0Builder != null) {
            assert (result != null);
            dep0 = dep0Builder.getDataSet();
            result.putProperty("DEPEND_0", dep0);
        } else {
            dep0 = result == null ? null : (MutablePropertyDataSet)result.property("DEPEND_0");
        }
        Units units = dep0units = dep0 == null ? null : SemanticOps.getUnits(dep0);
        if (dep0 != null && cacheRange1.getUnits().isConvertibleTo(dep0units)) {
            dep0.putProperty("CACHE_TAG", new CacheTag(cacheRange1, reduce ? lresolution : null));
            dep0.putProperty("TYPICAL_MIN", lviewRange.min().doubleValue(dep0units));
            dep0.putProperty("TYPICAL_MAX", lviewRange.max().doubleValue(dep0units));
        }
        notes = notesBuilder.getDataSet();
        if (result != null && notes.length() > 0) {
            result.putProperty("NOTES", notes);
        }
        if (result != null && !result.isImmutable()) {
            result.putProperty("USER_PROPERTIES", userProps);
        }
        if (result == null && notes.length() > 0) {
            Units u = (Units)((QDataSet)notes.property("BUNDLE_1")).property("UNITS", 2);
            int n0 = (int)notes.value(0, 2);
            StringBuilder nns = new StringBuilder(u.createDatum(n0).toString());
            for (int i = 1; i < notes.length(); ++i) {
                if (notes.value(i, 2) == (double)n0) continue;
                nns.append(",").append(u.createDatum(notes.value(i, 2)).toString());
            }
            if (nns.length() > 120) {
                throw new IllegalArgumentException(nns.substring(0, 120) + "...");
            }
            throw new IllegalArgumentException(nns.toString());
        }
        if (reduce && result != null && result.rank() == 1) {
            result.putProperty("RENDER_TYPE", "series");
        }
        logger.log(Level.FINE, "loaded {0} {1}", new Object[]{result, this.describeRange(result)});
        return result;
    }

    private DatumRange describeRange(QDataSet result) {
        MutablePropertyDataSet dep0;
        MutablePropertyDataSet mutablePropertyDataSet = dep0 = result == null ? null : (MutablePropertyDataSet)result.property("DEPEND_0");
        if (dep0 == null) {
            return null;
        }
        QDataSet b = SemanticOps.bounds(dep0).slice(1);
        return DatumRangeUtil.roundSections(DataSetUtil.asDatumRange(b, true), 24);
    }

    @Override
    public MetadataModel getMetadataModel() {
        return this.metadataModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if (this.metadata == null) {
            mon.setTaskSize(10L);
            mon.started();
            try {
                URISplit split = URISplit.parse(this.getURI());
                LinkedHashMap<String, String> params1 = URISplit.parseParams(split.params);
                String avail = (String)params1.get(PARAM_AVAIL);
                if (avail != null && avail.equals("T")) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                DatumRange vr = this.getViewRange();
                String scompUrl = vr != null ? this.getFsm().getFileSystem().getRootURI().toString() + this.getFsm().getRepresentativeFile(mon.getSubtaskMonitor(0, 5, "get representative file"), null, vr) : this.getFsm().getFileSystem().getRootURI().toString() + this.getFsm().getRepresentativeFile(mon.getSubtaskMonitor(0, 5, "get representative file"));
                if (!this.sparams.equals("")) {
                    scompUrl = scompUrl + "?" + this.sparams;
                }
                URI delegateUri = DataSetURI.getURIValid(scompUrl);
                DataSource delegateDataSource = this.delegateDataSourceFactory.getDataSource(delegateUri);
                this.metadata = delegateDataSource.getMetadata(mon.getSubtaskMonitor(5, 10, "get metadata"));
                this.metadataModel = delegateDataSource.getMetadataModel();
            }
            finally {
                mon.finished();
            }
            return this.metadata;
        }
        return this.metadata;
    }

    public Datum getResolution() {
        return this.resolution;
    }

    public void setResolution(Datum resolution) {
        Datum old = this.resolution;
        this.resolution = resolution;
        this.propertyChangeSupport.firePropertyChange("resolution", old, resolution);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public DatumRange getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(DatumRange viewRange) {
        DatumRange oldViewRange = this.viewRange;
        this.viewRange = viewRange;
        logger.log(Level.FINE, "setViewRange({0})", viewRange);
        this.propertyChangeSupport.firePropertyChange("viewRange", oldViewRange, viewRange);
    }

    public FileStorageModel getFsm() {
        return this.fsm;
    }

    public void setFsm(FileStorageModel fsm) {
        this.fsm = fsm;
    }

    public void setParams(String params) {
        String oldParams = this.sparams;
        this.sparams = params;
        this.propertyChangeSupport.firePropertyChange("args", oldParams, params);
    }

    protected String getSParams() {
        return this.sparams;
    }

    @Override
    public String getURI() {
        return super.getURI();
    }

    public class AggTimeSeriesBrowse
    implements TimeSeriesBrowse {
        @Override
        public void setTimeRange(DatumRange dr) {
            if (AggregatingDataSource.this.getParam("reduce", "F").equals("F")) {
                AggregatingDataSource.this.viewRange = AggregatingDataSource.this.fsm.quantize(dr);
            } else {
                AggregatingDataSource.this.viewRange = dr;
            }
            logger.log(Level.FINE, "set timerange={0}", AggregatingDataSource.this.viewRange);
        }

        @Override
        public void setTimeResolution(Datum d) {
            AggregatingDataSource.this.resolution = d;
            logger.log(Level.FINE, "set resolution={0}", d);
        }

        @Override
        public String getURI() {
            String surl = DataSetURI.fromUri(AggregatingDataSource.this.resourceURI) + "?";
            if (AggregatingDataSource.this.sparams != null && !AggregatingDataSource.this.sparams.equals("")) {
                surl = surl + AggregatingDataSource.this.sparams + "&";
            }
            surl = surl + "timerange=" + String.valueOf(AggregatingDataSource.this.viewRange);
            URISplit split = URISplit.parse(surl);
            LinkedHashMap<String, String> mparams = URISplit.parseParams(split.params);
            String stimeRange = AggregatingDataSource.this.viewRange.toString();
            mparams.put("timerange", stimeRange);
            if (AggregatingDataSource.this.resolution != null) {
                mparams.put("resolution", String.valueOf(AggregatingDataSource.this.resolution));
            }
            split.params = URISplit.formatParams(mparams);
            URISplit split2 = URISplit.parse(AggregatingDataSource.this.uri);
            split.vapScheme = split2.vapScheme;
            return URISplit.format(split);
        }

        @Override
        public DatumRange getTimeRange() {
            return AggregatingDataSource.this.viewRange;
        }

        @Override
        public Datum getTimeResolution() {
            return AggregatingDataSource.this.resolution;
        }

        public String toString() {
            return "aggtsb: " + AggregatingDataSource.this.viewRange + "@" + (AggregatingDataSource.this.resolution == null ? "intrinsic" : AggregatingDataSource.this.resolution);
        }

        @Override
        public void setURI(String suri) throws ParseException {
            AggregatingDataSource.this.viewRange = URISplit.parseTimeRange(suri);
            logger.log(Level.FINE, "setURI sets viewRange to {0}", AggregatingDataSource.this.viewRange);
        }

        @Override
        public String blurURI() {
            String surl = DataSetURI.fromUri(AggregatingDataSource.this.resourceURI) + "?";
            if (AggregatingDataSource.this.sparams != null && !AggregatingDataSource.this.sparams.equals("")) {
                surl = surl + AggregatingDataSource.this.sparams + "&";
            }
            URISplit split = URISplit.parse(surl);
            LinkedHashMap<String, String> mparams = URISplit.parseParams(split.params);
            mparams.remove("resolution");
            split.params = URISplit.formatParams(mparams);
            URISplit split2 = URISplit.parse(AggregatingDataSource.this.uri);
            split.vapScheme = split2.vapScheme;
            return URISplit.format(split);
        }
    }
}

