/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class UriTimeRangeToggleButton
extends JComponent {
    public static final String PROP_POSITION = "position";
    BufferedImage img;
    BufferedImage imgUp;
    BufferedImage imgDn;

    public UriTimeRangeToggleButton() {
        try {
            this.img = ImageIO.read(UriTimeRangeToggleButton.class.getResource("/resources/tinyButton2.png"));
            this.imgUp = ImageIO.read(UriTimeRangeToggleButton.class.getResource("/resources/tinyButtonUp.png"));
            this.imgDn = ImageIO.read(UriTimeRangeToggleButton.class.getResource("/resources/tinyButtonDn.png"));
            this.setPosition(0);
        }
        catch (IOException ex) {
            Logger.getLogger(UriTimeRangeToggleButton.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setPreferredSize(new Dimension(this.img.getHeight(), this.img.getWidth()));
        this.setMaximumSize(new Dimension(this.img.getHeight(), this.img.getWidth()));
        this.setMinimumSize(new Dimension(this.img.getHeight(), this.img.getWidth()));
        this.setToolTipText("Green Data Set Selector, Blue for Time Range Selector");
        this.addMouseListener(this.getMouseAdapter());
    }

    public final void setPosition(int pos) {
        this.img = pos == 1 ? this.imgUp : this.imgDn;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.img.getWidth() + 2, this.img.getHeight() + 2);
        g.drawImage(this.img, 0, 0, this);
    }

    private MouseAdapter getMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getY() < UriTimeRangeToggleButton.this.img.getHeight() / 2) {
                    UriTimeRangeToggleButton.this.firePropertyChange(UriTimeRangeToggleButton.PROP_POSITION, -1, 1);
                } else {
                    UriTimeRangeToggleButton.this.firePropertyChange(UriTimeRangeToggleButton.PROP_POSITION, -1, 0);
                }
            }
        };
    }
}

