/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ApplicationModel;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.layout.LayoutConstants;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.util.LoggerManager;
import org.xml.sax.SAXException;

public class UriDropTargetListener
implements DropTargetListener {
    private static final Logger logger = LoggerManager.getLogger("autoplot.gui.droptarget");
    DataSetSelector dss;
    ApplicationModel model;

    public UriDropTargetListener(DataSetSelector dss, ApplicationModel model) {
        this.model = model;
        this.dss = dss;
    }

    private String getURILinux(DropTargetDropEvent dtde) {
        try {
            DataFlavor nixFileDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            if (dtde.isDataFlavorSupported(nixFileDataFlavor)) {
                String data = (String)dtde.getTransferable().getTransferData(nixFileDataFlavor);
                return data;
            }
            return null;
        }
        catch (UnsupportedFlavorException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private String getURI(DropTargetDropEvent dtde) {
        try {
            boolean haveAcceptedDrop = false;
            Bookmark item = null;
            List<Bookmark> items = null;
            if (logger.isLoggable(Level.FINE)) {
                for (DataFlavor df : dtde.getCurrentDataFlavors()) {
                    logger.log(Level.FINE, "drop data flavor: {0} {1}", new Object[]{df.getMimeType(), df.getHumanPresentableName()});
                }
            }
            if (dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data;
                if (!haveAcceptedDrop) {
                    dtde.acceptDrop(1);
                    haveAcceptedDrop = true;
                }
                if ((data = ((String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor)).trim()).length() > 19 && data.startsWith("<bookmark-list")) {
                    items = Bookmark.parseBookmarks(data);
                } else {
                    item = data.length() > 14 && data.startsWith("<bookmark") ? Bookmark.parseBookmark(data) : new Bookmark.Item(data);
                }
            }
            if (item == null) {
                DataFlavor df;
                dtde.getCurrentDataFlavorsAsList();
                try {
                    df = new DataFlavor("application/x-java-url;class=java.net.URL");
                    if (dtde.isDataFlavorSupported(df)) {
                        String data;
                        if (!haveAcceptedDrop) {
                            dtde.acceptDrop(1);
                            haveAcceptedDrop = true;
                        }
                        if ((data = String.valueOf(dtde.getTransferable().getTransferData(df))).startsWith("file://localhost/")) {
                            data = data.substring(16);
                        }
                        item = new Bookmark.Item(data);
                    } else {
                        DataFlavor nixFileDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                        if (dtde.isDataFlavorSupported(nixFileDataFlavor)) {
                            String data;
                            if (!haveAcceptedDrop) {
                                dtde.acceptDrop(1);
                                haveAcceptedDrop = true;
                            }
                            if ((data = (String)dtde.getTransferable().getTransferData(nixFileDataFlavor)) != null) {
                                item = new Bookmark.Item(data);
                            }
                        }
                    }
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.FINE, "class not found for flavor, wrong platform");
                }
                try {
                    df = new DataFlavor("application/x-java-file-list;class=java.util.List");
                    if (dtde.isDataFlavorSupported(df)) {
                        List list;
                        if (!haveAcceptedDrop) {
                            dtde.acceptDrop(1);
                            haveAcceptedDrop = true;
                        }
                        if ((list = (List)dtde.getTransferable().getTransferData(df)).size() == 1) {
                            String data = list.get(0).toString();
                            if (data.startsWith("file://localhost/")) {
                                data = data.substring(16);
                            }
                            item = new Bookmark.Item(data);
                        }
                    }
                }
                catch (ClassNotFoundException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            String uri = null;
            if (item != null) {
                if (item instanceof Bookmark.Item) {
                    uri = ((Bookmark.Item)item).getUri();
                } else {
                    this.model.showMessage("only one URI can be dropped", "only one URI", 2);
                }
            } else if (items != null) {
                this.model.showMessage("only one URI can be dropped", "only one URI", 2);
            } else {
                this.model.showMessage("couldn't find URI in drop target", "no URI", 2);
            }
            return uri;
        }
        catch (UnsupportedFlavorException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (BookmarksException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Component c;
        Object s = dtde.getSource();
        DasCanvasComponent cc = null;
        if (s instanceof DropTarget && (c = ((DropTarget)s).getComponent()) instanceof DasCanvasComponent) {
            cc = (DasCanvasComponent)c;
        }
        if (cc instanceof DasPlot && dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(1);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Plot plot;
        Component c;
        String uri = this.getURI(dtde);
        if (uri == null) {
            return;
        }
        DasCanvasComponent cc = null;
        Object s = dtde.getSource();
        if (s instanceof DropTarget && (c = ((DropTarget)s).getComponent()) instanceof DasCanvasComponent) {
            cc = (DasCanvasComponent)c;
        }
        if (cc instanceof DasPlot) {
            plot = this.model.dom.getController().getPlotFor(cc);
            if (plot == null) {
                plot = null;
            }
        } else {
            plot = null;
        }
        if (plot == null) {
            DasCanvasComponent dcc = this.model.getCanvas().getCanvasComponentAt(dtde.getLocation().x, dtde.getLocation().y - 50);
            if (dcc != null) {
                plot = this.model.dom.getController().getPlotFor(dcc);
                plot = this.model.dom.getController().addPlot(plot, LayoutConstants.BELOW);
            } else {
                dcc = this.model.getCanvas().getCanvasComponentAt(dtde.getLocation().x, dtde.getLocation().y + 50);
                if (dcc != null) {
                    plot = this.model.dom.getController().getPlotFor(dcc);
                    plot = this.model.dom.getController().addPlot(plot, LayoutConstants.ABOVE);
                }
            }
            if (plot == null) {
                this.model.showMessage("URIs may only be dropped on plots, just above, or just below", "not plot target", 2);
            } else {
                PlotElement pe = this.model.dom.getController().addPlotElement(plot, null);
                this.model.dom.getController().setPlotElement(pe);
                this.dss.setValue(uri);
                this.dss.maybePlot(true);
            }
            return;
        }
        List<PlotElement> pe = this.model.dom.getController().getPlotElementsFor(plot);
        if (pe.size() == 0) {
            this.model.showMessage("no plot elements here", "no plot elements", 2);
            return;
        }
        this.model.dom.getController().setPlotElement(pe.get(0));
        this.dss.setValue(uri);
        this.dss.maybePlot(true);
    }
}

