/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.bookmarks.Util;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.jdesktop.layout.GroupLayout;

public class TcaElementDialog
extends JDialog {
    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";
    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";
    private JComboBox<String> addTicksFromComboBox;
    private JButton bookmarksButton;
    private JButton cancelButton;
    private JButton jButton1;
    private JLabel jLabel1;
    private JButton plotButton;
    private DataSetSelector primaryDataSetSelector;

    public TcaElementDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.primaryDataSetSelector.setPlotItButtonVisible(false);
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        m.addElement("Add from...");
        List<String> ss = DataSetURI.getSortedDiscoverableExtentions();
        for (String s : ss) {
            if (s.equals("file:")) continue;
            m.addElement(s);
        }
        this.addTicksFromComboBox.setModel(m);
        this.addTicksFromComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)TcaElementDialog.this.addTicksFromComboBox.getSelectedItem();
                if (s.startsWith(".")) {
                    String ext = s;
                    TcaElementDialog.this.addTicksFromComboBox.setSelectedIndex(0);
                    TcaElementDialog.this.primaryDataSetSelector.setValue("vap+" + ext.substring(1) + ":");
                    TcaElementDialog.this.primaryDataSetSelector.browseSourceType();
                }
            }
        });
        Util.loadRecent("tcaRecent", this.primaryDataSetSelector, this.getDefault());
    }

    private List<Bookmark> getDefault() {
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        result.add(new Bookmark.Item("vap+das2server:http://emfisis.physics.uiowa.edu/das/das2Server?dataset=rbsp/ephemerisA.dsdf&start_time=2012-12-29T00:00:00.000Z&end_time=2012-12-30T00:00:00.000Z&interval=60"));
        result.add(new Bookmark.Item("vap+das2server:http://emfisis.physics.uiowa.edu/das/das2Server?dataset=rbsp/ephemerisB.dsdf&start_time=2012-12-29T00:00:00.000Z&end_time=2012-12-30T00:00:00.000Z&interval=60"));
        return result;
    }

    private void initComponents() {
        this.primaryDataSetSelector = new DataSetSelector();
        this.plotButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.bookmarksButton = new JButton();
        this.jButton1 = new JButton();
        this.addTicksFromComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.plotButton.setText("Ok");
        this.plotButton.setToolTipText("");
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcaElementDialog.this.plotButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcaElementDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Use the dataset to add additional labels to the X-axis:");
        this.bookmarksButton.setText("Bookmarks...");
        this.bookmarksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcaElementDialog.this.bookmarksButtonActionPerformed(evt);
            }
        });
        this.jButton1.setText("Clear Additional Ticks");
        this.jButton1.setToolTipText("Remove the additional ticks.");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcaElementDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.addTicksFromComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bookmarksButton).addPreferredGap(0).add(this.addTicksFromComboBox, -2, 237, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButton1).addPreferredGap(0).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.plotButton)).add((Component)this.primaryDataSetSelector, -1, 685, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 685, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(11, 11, 11).add((Component)this.primaryDataSetSelector, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.plotButton).add((Component)this.cancelButton).add((Component)this.bookmarksButton).add((Component)this.jButton1).add(this.addTicksFromComboBox, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void plotButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(evt.getModifiers());
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void bookmarksButtonActionPerformed(ActionEvent evt) {
        BookmarksManager man = new BookmarksManager((Frame)SwingUtilities.getWindowAncestor(this), true, "Ephemeris Bookmarks");
        man.setHidePlotButtons(true);
        man.setPrefNode("tca", "autoplot.default.tca.bookmarks", "http://autoplot.org/data/tca.demos.xml");
        man.setVisible(true);
        Bookmark book = man.getSelectedBookmark();
        if (book != null && book instanceof Bookmark.Item) {
            this.primaryDataSetSelector.setValue(((Bookmark.Item)book).getUri());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(0);
        this.primaryDataSetSelector.setValue("");
        this.setVisible(false);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public DataSetSelector getPrimaryDataSetSelector() {
        return this.primaryDataSetSelector;
    }
}

