/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.autoplot.AppManager;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.RenderType;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomOps;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.jythonsupport.Util;
import org.autoplot.scriptconsole.ExitExceptionHandler;
import org.autoplot.state.StatePersistence;
import org.das2.DasApplication;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.MouseModule;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.util.DasPNGEncoder;
import org.das2.util.LoggerManager;
import org.das2.util.awt.PdfGraphicsOutput;
import org.das2.util.awt.SvgGraphicsOutput;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.python.core.Py;
import org.python.core.PyFunction;
import org.python.core.PyJavaInstance;

public class ScriptContext
extends PyJavaInstance {
    private static final Logger logger = LoggerManager.getLogger("autoplot");
    private static ApplicationModel model = null;
    private static Application dom = null;
    private static final Map<String, AutoplotUI> apps = new HashMap<String, AutoplotUI>();
    private static final Map<String, ApplicationModel> applets = new HashMap<String, ApplicationModel>();
    private static final Map<ApplicationModel, AutoplotUI> appLookup = new HashMap<ApplicationModel, AutoplotUI>();
    private static AutoplotUI view = null;
    private static AutoplotUI defaultApp = null;
    private static OutputStream out = System.out;

    private static void setUpHeadlessExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "runtime exception: " + e, e);
                if (e instanceof InconvertibleUnitsException) {
                    return;
                }
                model.getExceptionHandler().handleUncaught(e);
            }
        });
    }

    private static synchronized void maybeInitModel() {
        if (model == null) {
            model = new ApplicationModel();
            model.setExceptionHandler(new ExitExceptionHandler());
            ScriptContext.setUpHeadlessExceptionHandler();
            model.addDasPeersToAppAndWait();
            dom = model.getDocumentModel();
        }
        if (view != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (!view.isVisible()) {
                    view.setVisible(true);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!view.isVisible()) {
                            view.setVisible(true);
                        }
                    }
                });
            }
        }
    }

    public static synchronized void setApplication(AutoplotUI app) {
        ScriptContext.setApplicationModel(app.applicationModel);
        ScriptContext.setView(app);
    }

    public static synchronized void setDefaultApplication() {
        ScriptContext.setApplication(defaultApp);
    }

    public static synchronized void setWindow(ApplicationModel appm) {
        AutoplotUI app = appLookup.get(appm);
        view = app == null ? null : app;
        ScriptContext.setApplicationModel(appm);
    }

    public static synchronized AutoplotUI getApplication() {
        return view;
    }

    public static synchronized ApplicationModel getWindow() {
        return model;
    }

    public static synchronized AutoplotUI newApplication(String id) {
        AutoplotUI result = apps.get(id);
        if (result != null && !AppManager.getInstance().isRunningApplication(result)) {
            AutoplotUI app = apps.remove(id);
            appLookup.remove(app.applicationModel);
            result = null;
        }
        if (result == null) {
            result = view.newApplication();
            result.setApplicationName(id);
            apps.put(id, result);
            appLookup.put(result.applicationModel, result);
        }
        return result;
    }

    public static synchronized ApplicationModel newWindow(String id, int width, int height, int x, int y) {
        ApplicationModel result = ScriptContext.newWindow(id);
        Window window = SwingUtilities.getWindowAncestor(result.canvas);
        if (window != null) {
            Dimension windowDimension = window.getSize();
            Dimension canvasDimension = ScriptContext.model.canvas.getSize();
            if (Math.abs(windowDimension.width - canvasDimension.width) > 100 || Math.abs(windowDimension.height - canvasDimension.height) > 100) {
                window.setSize(width + 2, height + 29);
            } else {
                window.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
            }
            window.setLocation(x, y);
        } else {
            ScriptContext.model.canvas.setSize(width, height);
        }
        return result;
    }

    public static synchronized void setWindowLocation(int x, int y) {
        Window window = SwingUtilities.getWindowAncestor(ScriptContext.getWindow().getCanvas());
        if (window != null) {
            window.setLocation(x, y);
        }
    }

    public static synchronized ApplicationModel newDialogWindow(Window parent, String title) {
        final JDialog p = new JDialog(parent, title);
        ApplicationModel result = new ApplicationModel();
        result.addDasPeersToApp();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            p.getContentPane().add(result.canvas);
            p.pack();
            p.setVisible(true);
        }
        result.setResizeRequestListener(new ApplicationModel.ResizeRequestListener(){

            @Override
            public double resize(int width, int height) {
                if (p != null) {
                    Dimension windowDimension = p.getSize();
                    Dimension canvasDimension = model.canvas.getSize();
                    p.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
                }
                model.canvas.setSize(width, height);
                return 1.0;
            }
        });
        return result;
    }

    public static synchronized ApplicationModel newWindow(final String id) {
        ApplicationModel result = applets.get(id);
        if (result == null) {
            JFrame j;
            result = new ApplicationModel();
            result.addDasPeersToApp();
            result.setName(id);
            applets.put(id, result);
            if (!DasApplication.getDefaultApplication().isHeadless()) {
                j = new JFrame(id);
                j.setIconImage(AutoplotUtil.getAutoplotIcon());
                j.getContentPane().add(result.canvas);
                j.pack();
                j.setVisible(true);
                j.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        applets.remove(id);
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        applets.remove(id);
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }
                });
            } else {
                j = null;
            }
            result.setResizeRequestListener(new ApplicationModel.ResizeRequestListener(){

                @Override
                public double resize(int width, int height) {
                    if (j != null) {
                        Dimension windowDimension = j.getSize();
                        Dimension canvasDimension = model.canvas.getSize();
                        j.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
                    }
                    model.canvas.setSize(width, height);
                    return 1.0;
                }
            });
        }
        return result;
    }

    public static void setApplicationModel(ApplicationModel m) {
        model = m;
        dom = m.getDocumentModel();
    }

    protected static void _setDefaultApp(AutoplotUI app) {
        defaultApp = app;
        appLookup.put(app.applicationModel, app);
    }

    private static synchronized void maybeInitView() {
        ScriptContext.maybeInitModel();
        if (view == null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    view = new AutoplotUI(model);
                    view.setVisible(true);
                    defaultApp = view;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        view.setMessage("ready");
    }

    protected static void setView(AutoplotUI v) {
        view = v;
    }

    public static Window getViewWindow() {
        return view;
    }

    public static void _setOutputStream(OutputStream out) {
        ScriptContext.out = out;
    }

    public static void setCanvasSize(final int width, final int height) {
        ScriptContext.maybeInitModel();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                model.setCanvasSize(width, height);
                model.getDocumentModel().getCanvases(0).setSize(width, height);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Logger.getLogger(ScriptContext.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void setDataSourceURL(String surl) {
        model.setDataSourceURL(surl);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(String suri) {
        ScriptContext.maybeInitModel();
        if (view != null) {
            ScriptContext.view.dataSetSelector.setValue(suri);
        }
        model.resetDataSetSourceURL(suri, new NullProgressMonitor());
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(String surl1, String surl2) {
        ScriptContext.maybeInitModel();
        if (surl1.endsWith(".vap") || surl1.contains(".vap?")) {
            throw new IllegalArgumentException("cannot load vap here in two-argument plot");
        }
        DataSourceFilter dsf = model.getDocumentModel().getDataSourceFilters(0);
        List<PlotElement> pes = dom.getController().getPlotElementsFor(dsf);
        PlotElement pe = pes.size() > 0 ? pes.get(0) : null;
        Plot p = pe == null ? dom.getPlots(0) : dom.getController().getPlotFor(pe);
        dom.getController().doplot(p, pe, surl1, surl2);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(int chNum, String surl) {
        ScriptContext.maybeInitModel();
        model.setDataSet(chNum, null, surl);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(int chNum, String label, String surl) {
        ScriptContext.maybeInitModel();
        model.setDataSet(chNum, label, surl);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(QDataSet ds) {
        ScriptContext.plot(0, (String)null, ds);
    }

    public static void plot(QDataSet x, QDataSet y) {
        ScriptContext.plot(0, (String)null, x, y);
    }

    public static void plot(QDataSet x, QDataSet y, QDataSet z) {
        ScriptContext.plot(0, (String)null, x, y, z);
    }

    public static void plot(int chNum, QDataSet ds) {
        ScriptContext.plot(chNum, (String)null, ds);
    }

    public static void plot(int chNum, QDataSet x, QDataSet y) {
        ScriptContext.plot(chNum, (String)null, x, y);
    }

    public static void plot(int chNum, QDataSet x, QDataSet y, QDataSet z) {
        ScriptContext.plot(chNum, (String)null, x, y, z);
    }

    public static DasColorBar.Type makeColorTable(String name, QDataSet index, QDataSet rgb) {
        boolean implicitWarn = false;
        if (index == null) {
            index = Ops.indgen(rgb.length());
            implicitWarn = true;
        }
        int[] iindex = new int[index.length()];
        int[] red = new int[rgb.length()];
        int[] green = new int[rgb.length()];
        int[] blue = new int[rgb.length()];
        int bottom = 0;
        int top = 0;
        for (int i = 0; i < iindex.length; ++i) {
            iindex[i] = (int)Math.round(index.value(i));
            red[i] = (int)Math.round(rgb.value(i, 0));
            green[i] = (int)Math.round(rgb.value(i, 1));
            blue[i] = (int)Math.round(rgb.value(i, 2));
            top = Math.max(top, iindex[i]);
        }
        if (top > 254) {
            if (implicitWarn) {
                throw new IllegalArgumentException("no more than 254 colors.");
            }
            throw new IllegalArgumentException("the top index must be less than 254.");
        }
        int[] tt = DasColorBar.Type.makeColorTable(iindex, red, green, blue, top, bottom, top);
        return new DasColorBar.Type(name, tt);
    }

    private static MutablePropertyDataSet ensureMutable(QDataSet ds) {
        if (ds == null) {
            return null;
        }
        if (DataSetUtil.isQube(ds)) {
            if (ds instanceof MutablePropertyDataSet) {
                MutablePropertyDataSet mpds = (MutablePropertyDataSet)ds;
                if (mpds.isImmutable()) {
                    return DataSetOps.makePropertiesMutable(mpds);
                }
                return mpds;
            }
            return DataSetOps.makePropertiesMutable(ds);
        }
        if (ds instanceof MutablePropertyDataSet) {
            MutablePropertyDataSet mpds = (MutablePropertyDataSet)ds;
            if (mpds.isImmutable()) {
                return DataSetOps.makePropertiesMutable(mpds);
            }
            return mpds;
        }
        return DataSetOps.makePropertiesMutable(ds);
    }

    private static void ensureImmutable(QDataSet ... dss) {
        for (QDataSet ds : dss) {
            MutablePropertyDataSet mpds;
            if (ds == null || !(ds instanceof MutablePropertyDataSet) || (mpds = (MutablePropertyDataSet)ds).isImmutable()) continue;
            mpds.makeImmutable();
        }
    }

    public static void plot(int chNum, String label, QDataSet ds) {
        ScriptContext.maybeInitModel();
        MutablePropertyDataSet yds = ScriptContext.ensureMutable(ds);
        model.setDataSet(chNum, label, yds);
        ScriptContext.ensureImmutable(ds);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(int chNum, String label, QDataSet x, QDataSet y) {
        ScriptContext.maybeInitModel();
        MutablePropertyDataSet yds = ScriptContext.ensureMutable(y);
        QDataSet xds = x;
        if (xds != null) {
            yds.putProperty("DEPEND_0", xds);
        }
        model.setDataSet(chNum, label, yds);
        ScriptContext.ensureImmutable(x, y);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(int chNum, String label, QDataSet x, QDataSet y, String renderType) {
        ScriptContext.maybeInitModel();
        if (x == null && renderType == null) {
            model.setDataSet(chNum, label, y);
        } else {
            QDataSet xds = x;
            MutablePropertyDataSet yds = ScriptContext.ensureMutable(y);
            if (xds != null && yds != null) {
                yds.putProperty("DEPEND_0", xds);
            }
            if (yds != null && (xds != null || renderType != null)) {
                yds.putProperty("RENDER_TYPE", renderType);
            }
            model.setDataSet(chNum, label, yds);
        }
        ScriptContext.ensureImmutable(x, y);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z) {
        ScriptContext.maybeInitModel();
        QDataSet xds = x;
        if (z == null) {
            throw new IllegalArgumentException("z is null");
        }
        if (z.rank() == 1) {
            QDataSet zds = z;
            MutablePropertyDataSet yds = ScriptContext.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y is null");
            }
            yds.putProperty("DEPEND_0", xds);
            yds.putProperty("PLANE_0", zds);
            model.setDataSet(chNum, label, yds);
        } else {
            QDataSet yds = y;
            MutablePropertyDataSet zds = ScriptContext.ensureMutable(z);
            if (xds != null) {
                zds.putProperty("DEPEND_0", xds);
            }
            if (yds != null) {
                zds.putProperty("DEPEND_1", yds);
            }
            model.setDataSet(chNum, label, zds);
        }
        ScriptContext.ensureImmutable(x, y, z);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z, String renderType) {
        ScriptContext.maybeInitModel();
        QDataSet xds = x;
        MutablePropertyDataSet zds = ScriptContext.ensureMutable(z);
        if (zds == null) {
            MutablePropertyDataSet yds = ScriptContext.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y cannot be null if z is null");
            }
            yds.putProperty("RENDER_TYPE", renderType);
            yds.putProperty("DEPEND_0", xds);
            model.setDataSet(chNum, label, yds);
        } else if (zds.rank() == 1) {
            MutablePropertyDataSet yds = ScriptContext.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y cannot be null if z is null");
            }
            yds.putProperty("RENDER_TYPE", renderType);
            yds.putProperty("DEPEND_0", xds);
            yds.putProperty("PLANE_0", zds);
            model.setDataSet(chNum, label, yds);
        } else {
            QDataSet yds = y;
            zds.putProperty("RENDER_TYPE", renderType);
            if (x != null) {
                zds.putProperty("DEPEND_0", xds);
            }
            if (y != null) {
                zds.putProperty("DEPEND_1", yds);
            }
            model.setDataSet(chNum, label, zds);
        }
        ScriptContext.ensureImmutable(x, y, z);
        if (!SwingUtilities.isEventDispatchThread()) {
            model.waitUntilIdle();
        }
    }

    public static int addPlotElement(int chNum) {
        ScriptContext.maybeInitModel();
        DataSourceFilter dsf = dom.getDataSourceFilters(chNum);
        List<PlotElement> pes = dom.getController().getPlotElementsFor(dsf);
        if (pes.isEmpty()) {
            throw new IllegalArgumentException("nothing plotted that is listening to this channel number.");
        }
        String plotId = pes.get(0).getPlotId();
        Plot plot = (Plot)DomUtil.getElementById(dom, plotId);
        PlotElement pe = dom.getController().addPlotElement(plot, null, null);
        dsf = dom.getController().getDataSourceFilterFor(pe);
        int newChNum = -1;
        DataSourceFilter[] dsfs = dom.getDataSourceFilters();
        for (int i = 0; i < dsfs.length; ++i) {
            if (dsfs[i] != dsf) continue;
            newChNum = i;
            break;
        }
        return newChNum;
    }

    public static MouseModule addMouseModule(Plot plot, String label, final PyFunction listener) {
        DasPlot p = plot.getController().getDasPlot();
        BoxSelectorMouseModule mm = new BoxSelectorMouseModule(p, p.getXAxis(), p.getYAxis(), null, new BoxRenderer(p), label);
        BoxSelectionListener bsl = new BoxSelectionListener(){

            @Override
            public void boxSelected(BoxSelectionEvent e) {
                listener.__call__(Py.java2py((Object)e));
            }
        };
        mm.addBoxSelectionListener(bsl);
        p.getDasMouseInputAdapter().setPrimaryModule(mm);
        return mm;
    }

    public static void setStatus(String message) {
        dom.getController().setStatus(message);
    }

    public static void alert(String message) {
        String m = message;
        int messageType = 1;
        if (m.startsWith("warning:")) {
            m = m.substring(8).trim();
            messageType = 2;
        }
        JOptionPane.showMessageDialog(view, m, "Message", messageType);
        dom.getController().setStatus("warning: " + m);
    }

    public static void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(view, message);
    }

    public static void addTab(final String label, final JComponent c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ScriptContext.maybeInitView();
                int n = view.getTabs().getComponentCount();
                for (int i = 0; i < n; ++i) {
                    String titleAt = view.getTabs().getTitleAt(i);
                    if (!titleAt.equals(label) && !titleAt.equals("(" + label + ")")) continue;
                    view.getTabs().remove(i);
                    break;
                }
                if (c instanceof JScrollPane) {
                    view.getTabs().add(label, c);
                } else {
                    JScrollPane jsp = new JScrollPane();
                    jsp.getViewport().add(c);
                    view.getTabs().add(label, jsp);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public static void setRenderStyle(String name) {
        dom.getController().getPlotElement().setRenderType(RenderType.valueOf(name));
    }

    public static void peekAt(Object o) throws IOException {
        out.write(o.toString().getBytes());
    }

    private static String getLocalFilename(String filename) {
        if (filename.contains("/") || filename.contains("\\")) {
            URISplit split = URISplit.parse(filename);
            if (!split.scheme.equals("file")) {
                throw new IllegalArgumentException("cannot write to " + filename + " because it must be local file");
            }
            filename = split.file.substring(split.scheme.length() + 1);
            if (split.params != null) {
                filename = filename + "?" + split.params;
            }
            if (filename.startsWith("///")) {
                filename = filename.substring(2);
            }
            return filename;
        }
        String pwd = new File("").getAbsolutePath();
        return pwd + File.separator + filename;
    }

    public static void writeToPng(String filename) throws IOException {
        ScriptContext.setStatus("writing to " + filename);
        if (!filename.endsWith(".png") && !filename.endsWith(".PNG")) {
            filename = filename + ".png";
        }
        filename = ScriptContext.getLocalFilename(filename);
        ScriptContext.waitUntilIdle();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        ScriptContext.writeToPng(filename, width, height);
        File f = new File(filename);
        ScriptContext.setStatus("wrote to " + f.getAbsolutePath());
    }

    private static void maybeMakeParent(String filename) throws IOException {
        File file = new File(filename = ScriptContext.getLocalFilename(filename));
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("unable to mkdir " + filename);
        }
    }

    public static void writeToPng(String filename, int width, int height) throws IOException {
        filename = ScriptContext.getLocalFilename(filename);
        BufferedImage image = ScriptContext.model.canvas.getImage(width, height);
        Logger llogger = Logger.getLogger("autoplot.scriptcontext.writeToPng");
        llogger.log(Level.FINE, "writeToPng({0},{1},{2})->{3},{4} image.", new Object[]{filename, width, height, image.getWidth(), image.getHeight()});
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("Software", "Autoplot");
        meta.put("plotInfo", ScriptContext.model.canvas.getImageMetadata());
        ScriptContext.writeToPng(image, filename, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToPng(BufferedImage image, String filename, Map<String, String> metadata) throws IOException {
        if (!filename.endsWith(".png") && !filename.endsWith(".PNG")) {
            filename = filename + ".png";
        }
        filename = ScriptContext.getLocalFilename(filename);
        ScriptContext.waitUntilIdle();
        ScriptContext.maybeMakeParent(filename);
        FileOutputStream out1 = new FileOutputStream(filename);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        if (metadata != null) {
            for (Map.Entry<String, String> m : metadata.entrySet()) {
                encoder.addText(m.getKey(), m.getValue());
            }
        }
        try {
            encoder.write(image, out1);
        }
        catch (IOException ioe) {
            try {
                out1.close();
            }
            catch (IOException ioe2) {
                throw new RuntimeException(ioe2);
            }
        }
        finally {
            try {
                out1.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static void writeToPng(OutputStream out) throws IOException {
        ScriptContext.waitUntilIdle();
        DasCanvas c = model.getCanvas();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        BufferedImage image = c.getImage(width, height);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        encoder.addText("Software", "Autoplot");
        encoder.addText("plotInfo", c.getImageMetadata());
        encoder.write(image, out);
    }

    public static void writeToSvg(String filename) throws IOException {
        ScriptContext.setStatus("writing to " + filename);
        if (!filename.endsWith(".svg") && !filename.endsWith(".SVG")) {
            filename = filename + ".svg";
        }
        filename = ScriptContext.getLocalFilename(filename);
        ScriptContext.waitUntilIdle();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        model.getCanvas().setSize(width, height);
        model.getCanvas().validate();
        ScriptContext.waitUntilIdle();
        ScriptContext.maybeMakeParent(filename);
        model.getCanvas().writeToSVG(filename);
        ScriptContext.setStatus("wrote to " + filename);
    }

    public static void writeToSvg(OutputStream out) throws IOException {
        ScriptContext.waitUntilIdle();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        model.getCanvas().setSize(width, height);
        model.getCanvas().validate();
        ScriptContext.waitUntilIdle();
        model.getCanvas().writeToGraphicsOutput(out, new SvgGraphicsOutput());
    }

    public static void writeToPdf(String filename) throws IOException {
        ScriptContext.setStatus("writing to " + filename);
        if (!filename.endsWith(".pdf") && !filename.endsWith(".PDF")) {
            filename = filename + ".pdf";
        }
        filename = ScriptContext.getLocalFilename(filename);
        ScriptContext.waitUntilIdle();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        model.getCanvas().setSize(width, height);
        model.getCanvas().validate();
        ScriptContext.waitUntilIdle();
        ScriptContext.maybeMakeParent(filename);
        model.getCanvas().writeToPDF(filename);
        ScriptContext.setStatus("wrote to " + filename);
    }

    public static void writeToPdf(OutputStream out) throws IOException {
        ScriptContext.waitUntilIdle();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        model.getCanvas().setSize(width, height);
        model.getCanvas().validate();
        ScriptContext.waitUntilIdle();
        model.getCanvas().writeToGraphicsOutput(out, new PdfGraphicsOutput());
    }

    public static BufferedImage writeToBufferedImage(Application applicationIn) {
        ApplicationModel appmodel = new ApplicationModel();
        appmodel.addDasPeersToAppAndWait();
        appmodel.getDocumentModel().syncTo(applicationIn);
        int height = applicationIn.getCanvases(0).getHeight();
        int width = applicationIn.getCanvases(0).getWidth();
        BufferedImage image = appmodel.getCanvas().getImage(width, height);
        return image;
    }

    public static BufferedImage writeToBufferedImage() {
        ScriptContext.waitUntilIdle();
        int height = model.getDocumentModel().getCanvases(0).getHeight();
        int width = model.getDocumentModel().getCanvases(0).getWidth();
        BufferedImage image = model.getDocumentModel().getCanvases(0).getController().getDasCanvas().getImage(width, height);
        return image;
    }

    public static String[] getTimeRangesFor(String surl, String timeRange, String format) throws IOException, ParseException {
        return Util.getTimeRangesFor(surl, timeRange, format);
    }

    public static String[] generateTimeRanges(String spec, String srange) throws ParseException {
        return Util.generateTimeRanges(spec, srange);
    }

    public static String[] getCompletions(String file) throws Exception {
        return Util.getAllCompletions(file);
    }

    public static void sleep(int millis) {
        Util.sleep(millis);
    }

    public static void formatDataSet(QDataSet ds, String file) throws Exception {
        ScriptContext.formatDataSet(ds, file, new NullProgressMonitor());
    }

    public static void formatDataSet(QDataSet ds, String file, ProgressMonitor monitor) throws Exception {
        DataSourceFormat format;
        if (!file.startsWith("/") && !file.startsWith("vap+")) {
            String s;
            file = s = ScriptContext.getLocalFilename(file);
        }
        try {
            format = DataSetURI.getDataSourceFormat(DataSetURI.getURI(file));
        }
        catch (URISyntaxException ex) {
            URISplit split = URISplit.parse(file);
            URI uri = split.resourceUri;
            format = DataSetURI.getDataSourceFormat(uri);
        }
        if (format == null) {
            throw new IllegalArgumentException("no format for extension: " + file);
        }
        format.formatData(file, ds, monitor);
    }

    public static void setTitle(String title) {
        model.getDocumentModel().getController().getPlot().setTitle(title);
    }

    public static void createGui() {
        ScriptContext.maybeInitView();
    }

    public static ApplicationModel getApplicationModel() {
        ScriptContext.maybeInitModel();
        return model;
    }

    public static boolean isModelInitialized() {
        return model != null;
    }

    public static void bind(Object src, String srcProp, Object dst, String dstProp) {
        ScriptContext.bind(src, srcProp, dst, dstProp, null);
    }

    public static void bind(Object src, String srcProp, Object dst, String dstProp, Converter c) {
        if (DasApplication.hasAllPermission()) {
            if (src instanceof DomNode && dom.getController().getElementById(((DomNode)src).getId()) == src) {
                DomNode srcNode = (DomNode)src;
                dom.getController().bind(srcNode, srcProp, dst, dstProp, c);
            } else {
                BeanProperty srcbp = BeanProperty.create((String)srcProp);
                Object value = srcbp.getValue(src);
                if (value == null) {
                    System.err.println("warning: src property " + srcProp + " of " + src + " is null");
                }
                BeanProperty dstbp = BeanProperty.create((String)dstProp);
                dstbp.setValue(dst, value);
                dstbp.getValue(dst);
                AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)srcbp, (Object)dst, (Property)dstbp);
                if (c != null) {
                    b.setConverter(c);
                }
                b.bind();
            }
        } else {
            System.err.println("bindings disabled in applet environment");
        }
    }

    public static void unbind(DomNode src) {
        dom.getController().unbind(src);
    }

    public static void unbind(DomNode src, String srcProp, DomNode dst, String dstProp) {
        dom.getController().unbind(src, srcProp, dst, dstProp);
    }

    public static void bindGuiSafe(final Object src, final String srcProp, final Object dst, final String dstProp, final Converter c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ScriptContext.bind(src, srcProp, dst, dstProp, c);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static void dumpToQStream(QDataSet ds, OutputStream out, boolean ascii) throws IOException {
        try {
            SimpleStreamFormatter f = new SimpleStreamFormatter();
            f.format(ds, out, ascii);
        }
        catch (StreamException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public static void dumpToDas2Stream(QDataSet ds, boolean ascii) {
        try {
            ByteArrayOutputStream bufout = new ByteArrayOutputStream(10000);
            DataSet lds = DataSetAdapter.createLegacyDataSet(ds);
            if (ascii) {
                if (lds instanceof TableDataSet) {
                    TableUtil.dumpToAsciiStream((TableDataSet)lds, bufout);
                } else {
                    VectorUtil.dumpToAsciiStream((VectorDataSet)lds, bufout);
                }
            } else if (lds instanceof TableDataSet) {
                TableUtil.dumpToBinaryStream((TableDataSet)lds, bufout);
            } else {
                VectorUtil.dumpToBinaryStream((VectorDataSet)lds, bufout);
            }
            out.write(bufout.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dumpToDas2Stream(QDataSet ds, String file, boolean ascii) throws IOException {
        file = ScriptContext.getLocalFilename(file);
        FileOutputStream bufout = new FileOutputStream(file);
        DataSet lds = DataSetAdapter.createLegacyDataSet(ds);
        if (ascii) {
            if (lds instanceof TableDataSet) {
                TableUtil.dumpToAsciiStream((TableDataSet)lds, bufout);
            } else {
                VectorUtil.dumpToAsciiStream((VectorDataSet)lds, bufout);
            }
        } else if (lds instanceof TableDataSet) {
            TableUtil.dumpToBinaryStream((TableDataSet)lds, bufout);
        } else {
            VectorUtil.dumpToBinaryStream((VectorDataSet)lds, bufout);
        }
    }

    public static void mkdir(String dir) {
        if (!(dir = ScriptContext.getLocalFilename(dir)).endsWith("/")) {
            throw new IllegalArgumentException("folder name must end in /");
        }
        File f = new File(dir);
        if (!f.exists() && !f.mkdirs()) {
            throw new IllegalArgumentException("unable to make directory: " + f);
        }
    }

    public static Application getDocumentModel() {
        ScriptContext.maybeInitModel();
        return dom;
    }

    public static void waitUntilIdle() {
        if (view != null) {
            while (view.getDataSetSelector().isPendingChanges()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        model.waitUntilIdle();
    }

    public static void waitUntilIdle(String id) {
        logger.log(Level.INFO, "waitUntilIdle({0})", id);
        if (view != null) {
            while (view.getDataSetSelector().isPendingChanges()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ScriptContext.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        model.waitUntilIdle();
    }

    public static void save(String filename) throws IOException {
        ScriptContext.maybeInitModel();
        filename = ScriptContext.getLocalFilename(filename);
        if (!filename.endsWith(".vap")) {
            throw new IllegalArgumentException("filename must end in vap");
        }
        model.doSave(new File(filename));
    }

    public static void load(String filename) throws IOException {
        ScriptContext.plot(filename);
    }

    public static Application loadVap(String filename) throws IOException {
        try {
            File f = FileSystemUtil.doDownload(filename, new NullProgressMonitor());
            return (Application)StatePersistence.restoreState(f);
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            throw new IOException(ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static void fixLayout() {
        DomOps.newCanvasLayout(dom);
    }

    public static void setLayout(int nrows) {
        if (nrows < 1) {
            throw new IllegalArgumentException("must be one or more rows");
        }
        ScriptContext.setLayout(nrows, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLayout(int nrows, int ncolumns) {
        if (nrows < 1) {
            throw new IllegalArgumentException("must be one or more rows");
        }
        if (ncolumns < 1) {
            throw new IllegalArgumentException("must be one or more columns");
        }
        ScriptContext.reset();
        DasCanvas c = dom.getCanvases(0).getController().getDasCanvas();
        Lock canvasLock = c.mutatorLock();
        ChangesSupport.DomLock lock = dom.getController().mutatorLock();
        try {
            canvasLock.lock();
            lock.lock();
            Plot p = dom.getController().getPlot();
            dom.getController().addPlots(nrows, ncolumns, null);
            dom.getController().deletePlot(p);
        }
        finally {
            lock.unlock();
            canvasLock.unlock();
        }
        ScriptContext.waitUntilIdle();
    }

    public static List<Plot> addPlots(int nrows, int ncolumns, String dir) {
        if (nrows < 1) {
            throw new IllegalArgumentException("must be one or more rows");
        }
        if (ncolumns < 1) {
            throw new IllegalArgumentException("must be one or more columns");
        }
        Plot d = null;
        if (dir == null) {
            d = dom.getController().getPlot();
        }
        List<Plot> result = dom.getController().addPlots(nrows, ncolumns, dir);
        if (dir == null) {
            dom.getController().deletePlot(d);
        }
        if (result.size() > 0) {
            dom.getController().setPlot(result.get(0));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLayoutOverplot(int nplotElement) {
        if (nplotElement < 1) {
            throw new IllegalArgumentException("must be one or more plots");
        }
        ScriptContext.reset();
        DasCanvas c = dom.getCanvases(0).getController().getDasCanvas();
        Lock canvasLock = c.mutatorLock();
        ChangesSupport.DomLock lock = dom.getController().mutatorLock();
        try {
            canvasLock.lock();
            lock.lock();
            Plot p = dom.getController().getPlot();
            for (int i = 1; i < nplotElement; ++i) {
                dom.getController().addPlotElement(p, null);
            }
        }
        finally {
            lock.unlock();
            canvasLock.unlock();
        }
    }

    public static void reset() {
        ScriptContext.maybeInitModel();
        dom.getController().reset();
    }

    protected static void close() {
        model = null;
        view = null;
        out = null;
    }
}

