/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.util.TickleTimer;
import org.das2.components.DasProgressPanel;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.FileUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class ScreenshotsTool
extends EventQueue {
    private static final int MOUSE_WHEEL_UP = 1;
    private static final int MOUSE_WHEEL_DOWN = 2;
    private static final Logger logger = LoggerManager.getLogger("autoplot.screenshots");
    private boolean receivedEvents = false;
    long t0 = 0L;
    long timeBase = System.currentTimeMillis();
    private final ConcurrentLinkedQueue<ImageRecord> imageQueue = new ConcurrentLinkedQueue();
    private final Object imageQueueLock = new Object();
    Thread pngWriterThread;
    boolean pngWriterThreadRunning = false;
    boolean pngWriterThreadNotDone = false;
    int block = 0;
    File outLocationFolder;
    BufferedWriter logFile;
    TimeParser tp = TimeParser.create("$Y$m$d_$H$M$S_$(subsec,places=3)");
    TickleTimer tickleTimer;
    static BufferedImage pnt;
    static BufferedImage pnt_b1;
    static BufferedImage pnt_b2;
    static BufferedImage pnt_b3;
    static BufferedImage pnt_w1;
    static BufferedImage pnt_w2;
    static int button;
    static int ptrXOffset;
    static int ptrYOffset;
    int active = -1;
    private final Window parent;
    Rectangle bounds = null;
    int keyEscape = 0;

    private static void checkFolderContents(String text, JCheckBox deleteFilesCheckBox) {
        File f = new File(text);
        if (f.exists()) {
            File[] ff = f.listFiles();
            if (ff.length > 1) {
                deleteFilesCheckBox.setEnabled(true);
            } else {
                deleteFilesCheckBox.setEnabled(false);
                deleteFilesCheckBox.setSelected(false);
            }
        } else {
            deleteFilesCheckBox.setEnabled(false);
            deleteFilesCheckBox.setSelected(false);
        }
    }

    public static void start(Window parent) {
        Preferences prefs = AutoplotSettings.settings().getPreferences(ScreenshotsTool.class);
        String s = prefs.get("outputFolder", System.getProperty("user.home"));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.add((Component)new JLabel("<html>This will automatically take screenshots, recording them to a folder.<br><br>Hold Ctrl and press Shift twice to stop recording."), Float.valueOf(0.0f));
        JPanel folderPanel = new JPanel();
        folderPanel.setLayout(new FlowLayout());
        folderPanel.add(new JLabel("Output Folder:"));
        final JTextField tf = new JTextField(20);
        tf.setText(s);
        folderPanel.add(tf);
        folderPanel.add(new JButton(new AbstractAction("Pick", new ImageIcon(ScreenshotsTool.class.getResource("/org/autoplot/file.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser ch = new JFileChooser();
                ch.setFileSelectionMode(1);
                ch.setCurrentDirectory(new File(tf.getText()).getParentFile());
                ch.setSelectedFile(new File(tf.getText()));
                if (ch.showOpenDialog(tf) == 0) {
                    tf.setText(ch.getSelectedFile().toString());
                }
            }
        }));
        folderPanel.setAlignmentX(0.0f);
        p.add(folderPanel);
        final JCheckBox deleteFilesCheckBox = new JCheckBox("Delete contents before starting");
        deleteFilesCheckBox.setEnabled(false);
        deleteFilesCheckBox.setAlignmentX(0.0f);
        ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
            }
        });
        tf.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
            }
        });
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ScreenshotsTool.checkFolderContents(tf.getText(), deleteFilesCheckBox);
            }
        });
        p.add(deleteFilesCheckBox);
        int r = JOptionPane.showConfirmDialog(parent, p, "Record Screenshots", 2);
        if (r == 0) {
            File[] ff;
            File f = new File(tf.getText());
            if (f.exists() && (ff = f.listFiles()) != null && ff.length > 1 && deleteFilesCheckBox.isSelected() && !FileUtil.deleteFileTree(f)) {
                JOptionPane.showMessageDialog(parent, "Unable to delete files");
            }
            try {
                prefs.put("outputFolder", tf.getText());
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(new ScreenshotsTool(parent, tf.getText()));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public ScreenshotsTool(Window parent, String outLocationFolder) throws IOException {
        this(parent, outLocationFolder, false);
    }

    public ScreenshotsTool(Window parent, String outLocationFolder, boolean clearFolder) throws IOException {
        this.outLocationFolder = new File(outLocationFolder);
        boolean fail = false;
        if (!this.outLocationFolder.exists()) {
            boolean bl = fail = !this.outLocationFolder.mkdirs();
        }
        if (fail) {
            throw new IOException("output folder cannot be created");
        }
        File[] ff = this.outLocationFolder.listFiles();
        if (ff != null && ff.length > 1) {
            if (clearFolder) {
                for (File f : ff) {
                    if (f.delete()) continue;
                    throw new IllegalArgumentException("unable to delete file: " + f);
                }
            } else {
                throw new IOException("output folder must be empty");
            }
        }
        this.logFile = new BufferedWriter(new FileWriter(new File(this.outLocationFolder, this.tp.format(TimeUtil.now(), null) + ".txt")));
        this.parent = parent;
        this.active = ScreenshotsTool.getActiveDisplay(parent);
        this.bounds = null;
        this.tickleTimer = new TickleTimer(300L, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AWTEvent update = ScreenshotsTool.this.peekEvent(1200);
                if (update == null) {
                    long t1 = System.currentTimeMillis();
                    Rectangle r = ScreenshotsTool.this.doTakePicture(ScreenshotsTool.this.filenameFor(t1, 99999), t1);
                    ScreenshotsTool.this.bounds = ScreenshotsTool.this.bounds == null ? r : ScreenshotsTool.this.bounds.union(r);
                } else if (ScreenshotsTool.this.canReject(update)) {
                    long t1 = System.currentTimeMillis();
                    Rectangle r = ScreenshotsTool.this.doTakePicture(ScreenshotsTool.this.filenameFor(t1, 99999), t1);
                    ScreenshotsTool.this.bounds = ScreenshotsTool.this.bounds == null ? r : ScreenshotsTool.this.bounds.union(r);
                }
            }
        });
        this.pngWriterThreadRunning = true;
        this.pngWriterThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object record;
                    logger.log(Level.FINE, "starting imageRecorderThread");
                    while (ScreenshotsTool.this.pngWriterThreadRunning || !ScreenshotsTool.this.imageQueue.isEmpty()) {
                        logger.log(Level.FINE, "imageRecorderThread...");
                        while (ScreenshotsTool.this.pngWriterThreadRunning && ScreenshotsTool.this.imageQueue.isEmpty()) {
                            Object object = ScreenshotsTool.this.imageQueueLock;
                            synchronized (object) {
                                if (ScreenshotsTool.this.pngWriterThreadRunning && ScreenshotsTool.this.imageQueue.isEmpty()) {
                                    ScreenshotsTool.this.imageQueueLock.wait();
                                }
                            }
                        }
                        while (!ScreenshotsTool.this.imageQueue.isEmpty()) {
                            logger.log(Level.FINER, "imageQueue length={0}", ScreenshotsTool.this.imageQueue.size());
                            record = (ImageRecord)ScreenshotsTool.this.imageQueue.remove();
                            logger.log(Level.FINE, "imageRecorder writing {0}", ((ImageRecord)record).filename);
                            try {
                                if (!((ImageRecord)record).filename.createNewFile()) {
                                    logger.log(Level.FINE, "file already exists: {0}", ((ImageRecord)record).filename);
                                } else {
                                    ImageIO.write((RenderedImage)((ImageRecord)record).image, "png", ((ImageRecord)record).filename);
                                }
                            }
                            catch (IOException ex) {
                                logger.log(Level.WARNING, ex.getMessage(), ex);
                            }
                            logger.log(Level.FINE, "formatted file in {0}ms", System.currentTimeMillis() - ScreenshotsTool.this.t0);
                        }
                    }
                    logger.fine("sleep for a second to make sure the last image is done writing.");
                    Thread.sleep(1000L);
                    record = ScreenshotsTool.this.imageQueueLock;
                    synchronized (record) {
                        ScreenshotsTool.this.pngWriterThreadNotDone = false;
                    }
                }
                catch (InterruptedException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        });
        this.pngWriterThread.start();
    }

    private static int getActiveDisplay(Window parent) {
        int active = -1;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice target = parent.getGraphicsConfiguration().getDevice();
        for (int i = 0; i < gs.length; ++i) {
            if (gs[i] != target) continue;
            active = i;
        }
        logger.log(Level.FINE, "active display is #{0}", active);
        return active;
    }

    private static Rectangle getScreenBounds(int active) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int i = active;
        Rectangle b = gs[i].getDefaultConfiguration().getBounds();
        return b;
    }

    static Rectangle getMyBounds(Rectangle b) {
        Window[] windows;
        Frame[] frames;
        Rectangle r = null;
        for (Frame frame : frames = Frame.getFrames()) {
            if (!frame.isVisible()) continue;
            Rectangle rect = frame.getBounds();
            r = r == null ? rect : r.union(rect);
        }
        for (Window window : windows = Window.getWindows()) {
            if (!window.isVisible()) continue;
            Rectangle rect = window.getBounds();
            r = r == null ? rect : r.union(rect);
        }
        if (r == null) {
            throw new IllegalArgumentException("unable to find rectangle");
        }
        r = r.intersection(b);
        r.width = Math.max(0, r.width);
        r.height = Math.max(0, r.height);
        r.translate(-b.x, -b.y);
        return r;
    }

    private static Rectangle getActiveBackground(List<Rectangle> active) {
        Window[] windows;
        Frame[] frames;
        long t0 = System.currentTimeMillis();
        Rectangle r = null;
        boolean containsPointer = false;
        for (Frame frame : frames = Frame.getFrames()) {
            if (!frame.isVisible() || frame.getExtendedState() == 1) continue;
            Rectangle rect = frame.getBounds();
            logger.log(Level.FINER, "showing {0} {1}", new Object[]{rect, frame.getTitle()});
            if (r == null) {
                r = rect;
            } else {
                r.add(rect);
            }
            active.add(rect);
        }
        for (Window window : windows = Window.getWindows()) {
            if (!window.isVisible() || !window.isShowing()) continue;
            Rectangle rect = window.getBounds();
            logger.log(Level.FINER, "showing {0} {1}", new Object[]{rect, window.getType()});
            if (r == null) {
                r = rect;
            } else {
                r.add(rect);
            }
            active.add(rect);
        }
        logger.log(Level.FINE, "getActiveBackground in {0}ms", System.currentTimeMillis() - t0);
        return r;
    }

    private static boolean filterBackground(Graphics2D g, Rectangle b, Point p) {
        Window[] windows;
        Frame[] frames;
        long t0 = System.currentTimeMillis();
        Color c = new Color(255, 255, 255, 255);
        g.setColor(c);
        Rectangle r = new Rectangle(0, 0, b.width, b.height);
        Area s = new Area(r);
        boolean containsPointer = false;
        for (Frame frame : frames = Frame.getFrames()) {
            if (!frame.isVisible() || frame.getExtendedState() == 1) continue;
            Rectangle rect = frame.getBounds();
            logger.log(Level.FINER, "showing {0} {1}", new Object[]{rect, frame.getTitle()});
            if (rect.contains(p)) {
                containsPointer = true;
            }
            rect.translate(-b.x, -b.y);
            s.subtract(new Area(rect));
        }
        for (Window window : windows = Window.getWindows()) {
            if (!window.isVisible() || !window.isShowing()) continue;
            Rectangle rect = window.getBounds();
            logger.log(Level.FINER, "showing {0} {1}", new Object[]{rect, window.getType()});
            if (rect.contains(p)) {
                containsPointer = true;
            }
            rect.translate(-b.x, -b.y);
            s.subtract(new Area(rect));
        }
        g.fill(s);
        logger.log(Level.FINE, "filterBackground in {0}ms", System.currentTimeMillis() - t0);
        return containsPointer;
    }

    public static Rectangle getTrim(File root, ProgressMonitor monitor) throws IOException {
        if (!root.canRead()) {
            throw new IllegalArgumentException("cannot read root: " + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root should be directory: " + root);
        }
        File[] ff = root.listFiles();
        if (ff == null) {
            throw new IllegalArgumentException("directory cannot be read: " + root);
        }
        Rectangle result = null;
        int c = ff.length;
        int i = 1;
        monitor.setTaskSize(c);
        monitor.setProgressMessage("find bounds for set");
        for (File f : ff) {
            logger.log(Level.FINE, "getTrim {0}", f.getName());
            monitor.setTaskProgress(i);
            if (f.toString().endsWith(".png")) {
                try {
                    BufferedImage im = ImageIO.read(f);
                    Rectangle r1 = ScreenshotsTool.getTrim(im);
                    result = result == null ? r1 : result.union(r1);
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("failed to read " + f.toString(), ex);
                }
            }
            ++i;
        }
        return result;
    }

    public static Rectangle getTrim(BufferedImage source) {
        int baseColor = source.getRGB(0, 0);
        int width = source.getWidth();
        int height = source.getHeight();
        int topY = Integer.MAX_VALUE;
        int topX = Integer.MAX_VALUE;
        int bottomY = -1;
        int bottomX = -1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (baseColor == source.getRGB(x, y)) continue;
                if (x < topX) {
                    topX = x;
                }
                if (y < topY) {
                    topY = y;
                }
                if (x > bottomX) {
                    bottomX = x;
                }
                if (y <= bottomY) continue;
                bottomY = y;
            }
        }
        return new Rectangle(topX, topY, ++bottomX - topX, ++bottomY - topY);
    }

    public static BufferedImage trim(BufferedImage image) {
        Rectangle r = ScreenshotsTool.getTrim(image);
        return ScreenshotsTool.trim(image, r);
    }

    public static BufferedImage trim(BufferedImage image, Rectangle r) {
        return image.getSubimage(r.x, r.y, r.width, r.height);
    }

    public static void trimAll(File dir) throws IOException {
        ScreenshotsTool.trimAll(dir, null, new NullProgressMonitor());
    }

    public static void trimAll(File dir, Rectangle r, ProgressMonitor monitor) throws IOException {
        if (!dir.exists()) {
            throw new IllegalArgumentException("directory does not exist: " + dir);
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("directory cannot be read: " + dir);
        }
        File[] ff = dir.listFiles();
        if (ff == null) {
            throw new IllegalArgumentException("directory cannot be read: " + dir);
        }
        monitor.started();
        if (r == null) {
            r = ScreenshotsTool.getTrim(dir, monitor);
        }
        monitor.setProgressMessage("trim images");
        monitor.setTaskSize(ff.length);
        int i = 0;
        for (File f : ff) {
            logger.log(Level.FINER, "trim {0}", f);
            monitor.setTaskProgress(++i);
            if (!f.toString().endsWith(".png")) continue;
            BufferedImage im = ImageIO.read(f);
            im = ScreenshotsTool.trim(im, r);
            ImageIO.write((RenderedImage)im, "png", f);
        }
        monitor.finished();
    }

    public static BufferedImage getScreenShot() {
        Window w = ScriptContext.getViewWindow();
        int active = ScreenshotsTool.getActiveDisplay(w);
        return ScreenshotsTool.getScreenShot(active, 0, true);
    }

    public static BufferedImage getScreenShotNoPointer() {
        Window w = ScriptContext.getViewWindow();
        int active = ScreenshotsTool.getActiveDisplay(w);
        return ScreenshotsTool.getScreenShot(active, 0, false);
    }

    public static BufferedImage getScreenShot(int active) {
        return ScreenshotsTool.getScreenShot(active, 0, true);
    }

    private static BufferedImage getScreenShot(int active, int buttons, boolean includePointer) {
        BufferedImage screenshot;
        long t0 = System.currentTimeMillis();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int i = active;
        PointerInfo info = MouseInfo.getPointerInfo();
        Point mousePointerLocation = info.getLocation();
        Rectangle bounds = gs[i].getDefaultConfiguration().getBounds();
        Rectangle b = new Rectangle(bounds);
        ArrayList<Rectangle> activeRects = new ArrayList<Rectangle>();
        Rectangle appRect = ScreenshotsTool.getActiveBackground(activeRects);
        boolean screenHasPointer = info.getDevice() == gs[i];
        boolean appContainsPointer = appRect.contains(mousePointerLocation);
        try {
            long t1 = System.currentTimeMillis();
            logger.log(Level.FINER, "getting screenshot from screen {0}.", i);
            screenshot = new Robot(gs[i]).createScreenCapture(bounds);
            logger.log(Level.FINER, "got screenshot from screen {0} in {1}ms.", new Object[]{i, System.currentTimeMillis() - t1});
            boolean allBlack = true;
            if (bounds.x > 0) {
                int lastX = bounds.width;
                int lastY = bounds.height;
                block2: for (int ii = 0; ii < lastX && allBlack; ++ii) {
                    for (int jj = 0; jj < lastY; ++jj) {
                        if (screenshot.getRGB(ii, jj) == 0) continue;
                        allBlack = false;
                        continue block2;
                    }
                }
                if (allBlack) {
                    if (gs.length == 2) {
                        screenshot = new Robot(gs[1 - i]).createScreenCapture(bounds);
                    } else {
                        bounds.translate(-bounds.x, -bounds.y);
                        screenshot = new Robot(gs[i]).createScreenCapture(bounds);
                    }
                }
            }
        }
        catch (AWTException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            screenshot = new BufferedImage(gs[i].getDisplayMode().getWidth(), gs[i].getDisplayMode().getHeight(), 2);
        }
        logger.log(Level.FINER, "got screenshot at {0}ms", System.currentTimeMillis() - t0);
        ScreenshotsTool.filterBackground((Graphics2D)screenshot.getGraphics(), b, mousePointerLocation);
        if (includePointer && screenHasPointer && appContainsPointer) {
            BufferedImage pointer;
            if ((button & 0x400) == 1024) {
                pointer = pnt_b1;
            } else if ((button & 0x800) == 2048) {
                pointer = pnt_b2;
            } else if ((button & 0x1000) == 4096) {
                pointer = pnt_b3;
            } else if ((button & 1) == 1) {
                pointer = pnt_w1;
                button = 0;
            } else if ((button & 2) == 2) {
                pointer = pnt_w2;
                button = 0;
            } else {
                pointer = pnt;
            }
            logger.log(Level.FINER, "pointer identified at {0}ms", System.currentTimeMillis() - t0);
            int pntrX = mousePointerLocation.x - b.x - ptrXOffset;
            int pntrY = mousePointerLocation.y - b.y - ptrYOffset;
            screenshot.getGraphics().drawImage(pointer, pntrX, pntrY, null);
            logger.log(Level.FINER, "pointer drawn at {0}ms", System.currentTimeMillis() - t0);
        }
        logger.log(Level.FINE, "got screenshot in {0}ms", System.currentTimeMillis() - t0);
        return screenshot;
    }

    private String filenameFor(long t1, int id) {
        double us2000 = ((double)t1 - 9.466848E11) * 1000.0;
        return this.tp.format(Units.us2000.createDatum(us2000)) + "_" + String.format("%05d", id) + ".png";
    }

    public void takePicture(int id) {
        long t1 = System.currentTimeMillis();
        this.doTakePicture(this.filenameFor(t1, id), t1);
    }

    public void takePicture(int id, String caption) {
        long t1 = System.currentTimeMillis();
        String file = this.filenameFor(t1, id);
        this.doTakePicture(file, t1, false);
        String reviewer = System.getProperty("user.name");
        String time = TimeParser.create("$Y-$m-$dT$H:$M:$SZ").format(TimeUtil.now());
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<qualityControlRecord xmlns=\"http://autoplot.org/data/schema/pngwalkQC\">\n    <currentStatus>OK</currentStatus>\n" + String.format("    <modifiedDate>%s</modifiedDate>\n", time) + String.format("    <imageURI>%s</imageURI>\n", file) + String.format("    <reviewComment date=\"%s\" reviewer=\"%s\" status=\"OK\">%s</reviewComment>\n", time, reviewer, caption) + "</qualityControlRecord>";
        File f = new File(this.outLocationFolder, file + ".ok");
        try (FileWriter fo = new FileWriter(f);){
            fo.write(s);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void takePicture(int id, String caption, Component c, Point p, int buttons) {
        long t1 = System.currentTimeMillis();
        String filename = this.filenameFor(t1, id);
        if (p == null) {
            p = c.getLocation();
            p.translate(6, 2 * c.getHeight() / 3);
        } else {
            p = p.getLocation();
        }
        SwingUtilities.convertPointToScreen(p, c);
        this.t0 = t1;
        File file = new File(this.outLocationFolder, filename);
        BufferedImage im = ScreenshotsTool.getScreenShot(this.active, 0, false);
        BufferedImage pointer = (buttons & 0x400) == 1024 ? pnt_b1 : ((buttons & 0x800) == 2048 ? pnt_b2 : ((buttons & 0x1000) == 4096 ? pnt_b3 : ((buttons & 1) == 1 ? pnt_w1 : ((buttons & 2) == 2 ? pnt_w2 : pnt))));
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle b = ScreenshotsTool.getScreenBounds(this.active);
        Rectangle r = ScreenshotsTool.getMyBounds(b);
        this.bounds = this.bounds == null ? r : this.bounds.union(r);
        Rectangle bounds1 = gs[this.active].getDefaultConfiguration().getBounds();
        im.getGraphics().drawImage(pointer, p.x - bounds1.x - ptrXOffset, p.y - bounds1.y - ptrYOffset, null);
        try {
            if (!file.createNewFile()) {
                logger.log(Level.WARNING, "failed to create new file {0}", file);
            } else {
                ImageIO.write((RenderedImage)im, "png", file);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.t0 = System.currentTimeMillis();
        String reviewer = System.getProperty("user.name");
        String time = TimeParser.create("$Y-$m-$dT$H:$M:$SZ").format(TimeUtil.now());
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<qualityControlRecord xmlns=\"http://autoplot.org/data/schema/pngwalkQC\">\n    <currentStatus>OK</currentStatus>\n" + String.format("    <modifiedDate>%s</modifiedDate>\n", time) + String.format("    <imageURI>%s</imageURI>\n", file) + String.format("    <reviewComment date=\"%s\" reviewer=\"%s\" status=\"OK\">%s</reviewComment>\n", time, reviewer, caption) + "</qualityControlRecord>";
        File f = new File(this.outLocationFolder, file + ".ok");
        try (FileWriter fo = new FileWriter(f);){
            fo.write(s);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private Rectangle doTakePicture(String filename, long t1) {
        return this.doTakePicture(filename, t1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle doTakePicture(String filename, long t1, boolean includePointer) {
        this.t0 = t1;
        File file = new File(this.outLocationFolder, filename);
        BufferedImage im = ScreenshotsTool.getScreenShot(this.active, button, includePointer);
        Rectangle b = ScreenshotsTool.getScreenBounds(this.active);
        Rectangle myBounds = ScreenshotsTool.getMyBounds(b);
        ImageRecord imr = new ImageRecord(im, file);
        Object object = this.imageQueueLock;
        synchronized (object) {
            this.imageQueue.add(imr);
            this.imageQueueLock.notifyAll();
        }
        this.t0 = System.currentTimeMillis();
        return myBounds;
    }

    private boolean canReject(AWTEvent theEvent) {
        boolean reject = true;
        String ps = ((InvocationEvent)theEvent).paramString();
        if (this.peekEvent(1200) == null) {
            if (ps.contains("ComponentWorkRequest")) {
                reject = false;
            } else if (ps.contains("ProcessingRunnable")) {
                reject = false;
            }
        }
        return reject;
    }

    private static void setButton(int b) {
        button = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestFinish(boolean trimAll) {
        if (this.receivedEvents) {
            this.pop();
        }
        this.pngWriterThreadRunning = false;
        try {
            while (this.pngWriterThreadNotDone) {
                Object object = this.imageQueueLock;
                synchronized (object) {
                    if (this.pngWriterThreadNotDone) {
                        this.imageQueueLock.wait();
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        if (!trimAll) return;
        try {
            ScreenshotsTool.trimAll(this.outLocationFolder, this.bounds, new NullProgressMonitor());
            return;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispatchEvent(AWTEvent theEvent) {
        this.receivedEvents = true;
        super.dispatchEvent(theEvent);
        long t1 = System.currentTimeMillis();
        long dt = t1 - this.timeBase;
        boolean reject = false;
        List<Integer> skip = Arrays.asList(1200, 503, 506, 501, 502, 504, 505, 507, 101, 1005, 400, 401, 402);
        if (skip.contains(theEvent.getID())) {
            reject = true;
            if (theEvent.getID() == 1200) {
                reject = this.canReject(theEvent);
            }
        }
        reject = reject || t1 - this.t0 < 200L;
        try {
            this.logFile.write(String.format(Locale.US, "%09.3f %1d %5d %s\n", (double)dt / 1000.0, reject ? 0 : 1, theEvent.getID(), theEvent.getClass().getName()));
            this.logFile.flush();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (theEvent instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)theEvent;
            if (me.getModifiersEx() != 0) {
                if ((me.getModifiersEx() & 0x400) == 1024) {
                    ScreenshotsTool.setButton(1024);
                } else if ((me.getModifiersEx() & 0x800) == 2048) {
                    ScreenshotsTool.setButton(2048);
                } else if ((me.getModifiersEx() & 0x1000) == 4096) {
                    ScreenshotsTool.setButton(4096);
                }
                reject = false;
            } else if (theEvent instanceof MouseWheelEvent) {
                MouseWheelEvent mwe = (MouseWheelEvent)theEvent;
                button = mwe.getWheelRotation() < 0 ? 1 : 2;
                reject = false;
            } else {
                button = 0;
                reject = true;
            }
        }
        if (!reject) {
            Rectangle r = this.doTakePicture(this.filenameFor(t1, theEvent.getID()), t1);
            this.bounds = this.bounds == null ? r : this.bounds.union(r);
        }
        if (theEvent.getID() == 503 || theEvent.getID() == 400 || theEvent.getID() == 401 || theEvent.getID() == 402) {
            this.tickleTimer.tickle(String.valueOf(theEvent.getID()));
        }
        if (theEvent.getID() == 401 && theEvent instanceof KeyEvent) {
            if (((KeyEvent)theEvent).getKeyCode() == 17) {
                this.keyEscape = 2;
            } else if (((KeyEvent)theEvent).getKeyCode() == 16) {
                --this.keyEscape;
                if (this.keyEscape == 0) {
                    this.pop();
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            ScreenshotsTool.this.finishUp();
                        }
                    };
                    new Thread(run).start();
                }
            }
        } else if (theEvent.getID() == 402 && theEvent instanceof KeyEvent && ((KeyEvent)theEvent).getKeyCode() != 16) {
            this.keyEscape = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishUp() {
        this.pngWriterThreadRunning = false;
        try {
            while (this.pngWriterThreadNotDone) {
                Object object = this.imageQueueLock;
                synchronized (object) {
                    if (this.pngWriterThreadNotDone) {
                        this.imageQueueLock.wait();
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        String[] ss = this.outLocationFolder.list();
        if (ss == null) {
            throw new IllegalStateException("unable to list " + this.outLocationFolder);
        }
        int count = ss.length;
        p.add((Component)new JLabel("<html>Screenshots have been recorded to " + this.outLocationFolder + ".<br>Operation should now be normal.<br><br>Enter Pngwalk?"), "Center");
        JCheckBox cb = new JCheckBox(String.format("first trim %d images", count));
        p.add((Component)cb, "South");
        if (0 == AutoplotUtil.showConfirmDialog(this.parent, p, "Record Screenshots", 0)) {
            if (cb.isSelected()) {
                try {
                    DasProgressPanel monitor = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(cb), "trimming images...");
                    ScreenshotsTool.trimAll(this.outLocationFolder, this.bounds, monitor);
                }
                catch (IOException monitor) {
                    // empty catch block
                }
            }
            PngWalkTool tool = PngWalkTool.start("file:" + this.outLocationFolder + "/*.png", null);
            if (PngWalkTool.isQualityControlEnabled()) return;
            tool.startQC();
            return;
        }
        if (!cb.isSelected()) return;
        try {
            DasProgressPanel monitor = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(cb), "trimming images...");
            ScreenshotsTool.trimAll(this.outLocationFolder, this.bounds, monitor);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        button = 0;
        try {
            pnt = ImageIO.read(ScreenshotsTool.class.getResource("/resources/pointer.png"));
            pnt_b1 = ImageIO.read(ScreenshotsTool.class.getResource("/resources/pointer_b1.png"));
            pnt_b2 = ImageIO.read(ScreenshotsTool.class.getResource("/resources/pointer_b2.png"));
            pnt_b3 = ImageIO.read(ScreenshotsTool.class.getResource("/resources/pointer_b3.png"));
            pnt_w1 = ImageIO.read(ScreenshotsTool.class.getResource("/resources/pointer_w1.png"));
            pnt_w2 = ImageIO.read(ScreenshotsTool.class.getResource("/resources/pointer_w2.png"));
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        ptrXOffset = 7;
        ptrYOffset = 3;
    }

    private static class ImageRecord {
        BufferedImage image;
        File filename;

        ImageRecord(BufferedImage image, File filename) {
            this.image = image;
            this.filename = filename;
        }
    }
}

