/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.autoplot.ApplicationModel;
import org.autoplot.JythonUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.das2.components.DasProgressPanel;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.python.util.InteractiveInterpreter;

public class RunScriptPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger("autoplot.jython");
    EditorTextPane textArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel scriptFilename;
    private JPanel scriptPanel;
    private JCheckBox toolsCB;

    public RunScriptPanel() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(12);
        this.textArea = new EditorTextPane();
        this.scriptPanel.add(this.textArea);
        this.textArea.setEditable(false);
    }

    public EditorTextPane getTextArea() {
        return this.textArea;
    }

    public static void runScript(ApplicationModel model, File ff, ProgressMonitor mon) {
        try {
            FileInputStream in = new FileInputStream(ff);
            StringBuilder buf = new StringBuilder();
            try (BufferedReader read = new BufferedReader(new InputStreamReader(in));){
                String line = read.readLine();
                while (line != null) {
                    buf.append(line).append("\n");
                    line = read.readLine();
                }
            }
            if (buf.length() <= 0) {
                throw new IllegalArgumentException("file was empty: " + ff);
            }
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
            interp.set("dom", (Object)model.getDocumentModel());
            interp.set("monitor", (Object)mon);
            interp.exec(JythonRefactory.fixImports(buf.toString()));
            mon.finished();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public JCheckBox getToolsCB() {
        return this.toolsCB;
    }

    protected void loadFile(final File ff) throws IOException {
        final String src = EditorTextPane.loadFileToString(ff);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    Document d = RunScriptPanel.this.getTextArea().getDocument();
                    d.remove(0, d.getLength());
                    d.insertString(0, src, null);
                    if (ff.getCanonicalPath().startsWith(new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools").getCanonicalPath())) {
                        RunScriptPanel.this.toolsCB.setEnabled(false);
                    }
                    RunScriptPanel.this.scriptFilename.setText(ff.toString());
                }
                catch (IOException | BadLocationException exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    protected void loadFileSoon(final Window window, final String script) throws IOException {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    File ff = DataSetURI.getFile(DataSetURI.getURI(script), (ProgressMonitor)DasProgressPanel.createFramed(window, "downloading script"));
                    RunScriptPanel.this.loadFile(ff);
                }
                catch (URISyntaxException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    try {
                        logger.log(Level.SEVERE, null, ex);
                        Document d = RunScriptPanel.this.getTextArea().getDocument();
                        d.remove(0, d.getLength());
                        d.insertString(0, "unable to load script", null);
                        RunScriptPanel.this.scriptFilename.setText("unable to load script");
                    }
                    catch (BadLocationException ex1) {
                        Logger.getLogger(RunScriptPanel.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                }
            }
        };
        new Thread(run, "loadScriptAsynchronously").start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.toolsCB = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.scriptPanel = new JPanel();
        this.scriptFilename = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1.setText("Run the script:");
        this.toolsCB.setText("Install in tools folder and menu");
        this.scriptPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.scriptPanel);
        this.scriptFilename.setText("<html><i>script filename ");
        this.jLabel2.setText("Make sure the script does not contain malicious code.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 409, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.scriptFilename, -1, 409, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.toolsCB)).add((Component)this.jLabel2, -1, 409, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(3, 3, 3).add((Component)this.scriptFilename, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 283, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.toolsCB).add(11, 11, 11).add((Component)this.jLabel2).addContainerGap()));
    }
}

