/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class ReplaceFilePanel
extends JPanel {
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextField1;

    public ReplaceFilePanel() {
        this.initComponents();
    }

    public void setCurrentFile(String file) {
        this.jLabel2.setText(file);
        this.jTextField1.setText(file);
        this.checkLocal();
    }

    public String getSelectedFile() {
        return this.jTextField1.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel1.setText("Replace references to the file:");
        this.jLabel2.setText("jLabel2");
        this.jLabel3.setText("With the new file name:");
        this.jTextField1.setText("jTextField1");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ReplaceFilePanel.this.jTextField1KeyTyped(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/file.png")));
        this.jButton1.setToolTipText("Pick file");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceFilePanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 470, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel3, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton1)).addGap(0, 174, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String sfile = this.jLabel2.getText();
        if (sfile.startsWith("file://")) {
            sfile = sfile.substring(7);
        } else if (sfile.startsWith("file:")) {
            sfile = sfile.substring(5);
        }
        int iext = sfile.lastIndexOf(46);
        final String ext = iext != -1 ? sfile.substring(iext).toLowerCase() : null;
        File current = new File(sfile);
        if (!current.exists()) {
            current = current.getParentFile();
        }
        JFileChooser choose = new JFileChooser(current);
        if (ext != null) {
            choose.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String sf = f.getName();
                    return sf.toLowerCase().endsWith(ext);
                }

                @Override
                public String getDescription() {
                    return ext + " files";
                }
            });
        }
        if (choose.showSaveDialog(this) == 0) {
            this.jTextField1.setText("file://" + choose.getSelectedFile().getPath());
        }
    }

    private void checkLocal() {
        String s = this.jTextField1.getText();
        if (s.startsWith("file:") || s.startsWith("/") || s.startsWith("\\") || s.length() > 2 && s.charAt(1) == ':') {
            this.jButton1.setEnabled(true);
        } else {
            this.jButton1.setEnabled(false);
        }
    }

    private void jTextField1KeyTyped(KeyEvent evt) {
        this.checkLocal();
    }
}

