/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.PitchAngleDistributionRenderer;
import org.das2.graph.PolarPlotRenderer;
import org.das2.graph.RGBImageRenderer;
import org.das2.graph.TickCurveRenderer;
import org.das2.graph.VectorPlotRenderer;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.examples.Schemes;

public enum RenderType {
    spectrogram,
    nnSpectrogram,
    hugeScatter,
    series,
    scatter,
    colorScatter,
    stairSteps,
    fillToZero,
    digital,
    image,
    pitchAngleDistribution,
    polar,
    eventsBar,
    stackedHistogram,
    vectorPlot,
    bounds,
    internal,
    orbitPlot,
    contour;


    public static boolean acceptsData(RenderType rt, QDataSet ds) {
        if (null == rt) {
            return true;
        }
        switch (rt) {
            case spectrogram: 
            case nnSpectrogram: {
                if (SemanticOps.isTableDataSet(ds)) {
                    return true;
                }
                if (Schemes.isXYZScatter(ds)) {
                    return true;
                }
                return Schemes.isLegacyXYZScatter(ds);
            }
            case hugeScatter: {
                if (ds.rank() == 2) {
                    if (SemanticOps.isBundle(ds)) {
                        for (int i = 0; i < ds.length(0); ++i) {
                            QDataSet ds1 = DataSetOps.unbundle(ds, i);
                            if (UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(ds1))) continue;
                            return false;
                        }
                        return true;
                    }
                    return SemanticOps.isRank2Waveform(ds);
                }
                if (ds.rank() == 1) {
                    Units u = SemanticOps.getUnits(ds);
                    return UnitsUtil.isIntervalOrRatioMeasurement(u);
                }
                return false;
            }
            case series: 
            case scatter: 
            case stairSteps: 
            case fillToZero: {
                if (ds.rank() == 1) {
                    Units u = SemanticOps.getUnits(ds);
                    return UnitsUtil.isIntervalOrRatioMeasurement(u);
                }
                if (ds.rank() == 2) {
                    if (ds.length() == 0) {
                        return true;
                    }
                    if (SemanticOps.isBundle(ds)) {
                        return true;
                    }
                    return true;
                }
                return ds.rank() == 3;
            }
            case colorScatter: {
                if (ds.rank() == 2) {
                    if (SemanticOps.isBundle(ds)) {
                        for (int i = 0; i < ds.length(0); ++i) {
                            QDataSet ds1 = DataSetOps.unbundle(ds, i);
                            if (UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(ds1))) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (ds.rank() == 1) {
                    return ds.property("PLANE_0") != null;
                }
                return false;
            }
            case digital: {
                if (SemanticOps.isBundle(ds)) {
                    for (int i = 0; i < ds.length(0); ++i) {
                        QDataSet ds1 = DataSetOps.unbundle(ds, i);
                        if (UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(ds1))) continue;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            case image: {
                return RGBImageRenderer.acceptsData(ds);
            }
            case pitchAngleDistribution: {
                return PitchAngleDistributionRenderer.acceptsData(ds);
            }
            case polar: {
                return PolarPlotRenderer.acceptsData(ds);
            }
            case eventsBar: {
                return ds.rank() == 2 || ds.rank() == 1;
            }
            case vectorPlot: {
                return VectorPlotRenderer.acceptsData(ds);
            }
            case orbitPlot: {
                return TickCurveRenderer.acceptsData(ds);
            }
            case contour: {
                return ds.rank() == 2;
            }
            case stackedHistogram: {
                return ds.rank() == 2;
            }
        }
        return true;
    }
}

