/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.GuiSupport;
import org.autoplot.dom.Application;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.PlotElement;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.components.DatumEditor;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.graph.GraphUtil;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class PlotStylePanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger("autoplot.gui");
    private static final int ICON_SIZE = 16;
    private static final Color[] fores = new Color[]{Color.BLACK, Color.WHITE, Color.WHITE};
    private static final Color[] backs = new Color[]{Color.WHITE, Color.BLACK, Color.BLUE.darker()};
    public static final String STYLEPANEL_HELP_ID = "stylePanel";
    ApplicationModel applicationModel;
    EnumerationEditor psymEditor;
    EnumerationEditor lineEditor;
    EnumerationEditor edit;
    EnumerationEditor rebin;
    ColorEditor colorEditor;
    ColorEditor fillColorEditor;
    DatumEditor referenceEditor;
    BindingGroup elementBindingContext;
    PlotElement currentElement;
    Application dom;
    private StylePanel currentEditorPanel;
    private boolean initializing = true;
    private transient PropertyChangeListener renderTypeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            PlotStylePanel.this.doElementBindings();
        }
    };
    private transient PropertyChangeListener colorListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PlotStylePanel.this.checkColors()) {
                PlotStylePanel.this.dom.getController().setStatus("warning: Background and foreground colors are the same");
            }
        }
    };
    private JButton backgroundColorButton;
    private JCheckBox fittedCB;
    private JLabel fontLabel;
    private JComboBox foreBackColorsList;
    private JButton foregroundColorButton;
    private JLabel heightLabel;
    private JFormattedTextField heightTextField;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JSplitPane jSplitPane2;
    private JCheckBox majorTicksCheckBox;
    private JCheckBox minorGridCheckBox;
    private JButton pickFontButton;
    private JPanel plotPanel;
    private JLabel sizeLabel;
    private JPanel stylePanel;
    private JComboBox unitsCB;
    private JLabel widthLabel;
    private JFormattedTextField widthTextField;

    public PlotStylePanel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.dom = applicationModel.getDocumentModel();
        this.dom.getController().addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PlotStylePanel.this.doElementBindings();
            }
        });
        this.initComponents();
        this.validate();
        Runnable run = new Runnable(){

            public String toString() {
                return "initPlotStyleBindings";
            }

            @Override
            public void run() {
                PlotStylePanel.this.doOptionsBindings();
                PlotStylePanel.this.doElementBindings();
                String ff = PlotStylePanel.this.dom.getController().getCanvas().getFont();
                PlotStylePanel.this.fontLabel.setText(ff);
                DasCanvas c = PlotStylePanel.this.dom.getController().getDasCanvas();
                int index = 3;
                for (int i = 0; i < fores.length; ++i) {
                    if (!fores[i].equals(c.getForeground()) || !backs[i].equals(c.getBackground())) continue;
                    index = i;
                }
                PlotStylePanel.this.foreBackColorsList.setSelectedIndex(index);
            }
        };
        run.run();
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this.plotPanel, STYLEPANEL_HELP_ID);
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, STYLEPANEL_HELP_ID);
        this.initializing = false;
    }

    private synchronized void doOptionsBindings() {
        BindingGroup bc = new BindingGroup();
        AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"drawGrid"), (Object)this.majorTicksCheckBox, (Property)BeanProperty.create((String)"selected"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"drawMinorGrid"), (Object)this.minorGridCheckBox, (Property)BeanProperty.create((String)"selected"));
        bc.addBinding((Binding)b);
        Converter colorIconConverter = new Converter(){

            public Object convertForward(Object s) {
                return GraphUtil.colorIcon((Color)s, 16, 16);
            }

            public Object convertReverse(Object t) {
                Image image = ((ImageIcon)t).getImage();
                int rgb = ((BufferedImage)image).getRGB(8, 8);
                return new Color(rgb);
            }
        };
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"foreground"), (Object)this.foregroundColorButton, (Property)BeanProperty.create((String)"icon"));
        b.setConverter(colorIconConverter);
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getOptions(), (Property)BeanProperty.create((String)"background"), (Object)this.backgroundColorButton, (Property)BeanProperty.create((String)"icon"));
        b.setConverter(colorIconConverter);
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"font"), (Object)this.fontLabel, (Property)BeanProperty.create((String)"text"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"fitted"), (Object)this.fittedCB, (Property)BeanProperty.create((String)"selected"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"height"), (Object)this.heightTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        bc.addBinding((Binding)b);
        b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dom.getCanvases(0), (Property)BeanProperty.create((String)"width"), (Object)this.widthTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        bc.addBinding((Binding)b);
        bc.bind();
        this.dom.getCanvases(0).getController().getDasCanvas().addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PlotStylePanel.this.updateSize();
            }
        });
        this.updateSize();
    }

    private synchronized void doElementBindings() {
        PlotElement element;
        if (this.currentElement != null) {
            this.currentElement.getStyle().removePropertyChangeListener("color", this.colorListener);
            this.currentElement.removePropertyChangeListener("renderType", this.renderTypeListener);
        }
        if ((element = this.dom.getController().getPlotElement()) == null) {
            return;
        }
        element.addPropertyChangeListener("renderType", this.renderTypeListener);
        element.getStyle().addPropertyChangeListener("color", this.colorListener);
        Runnable run = new Runnable(){

            public String toString() {
                return "doElementBindingsRunnable";
            }

            @Override
            public void run() {
                logger.log(Level.FINE, "doElementBindingsRunnable (bug1356)");
                StylePanel editorPanel = GuiSupport.getStylePanel(element.getRenderType());
                if (PlotStylePanel.this.currentEditorPanel == null || PlotStylePanel.this.currentElement != element || PlotStylePanel.this.currentEditorPanel.getClass() != editorPanel.getClass()) {
                    editorPanel.doElementBindings(element);
                    if (PlotStylePanel.this.currentEditorPanel != null) {
                        PlotStylePanel.this.currentEditorPanel.releaseElementBindings();
                    }
                    PlotStylePanel.this.currentEditorPanel = editorPanel;
                    if (PlotStylePanel.this.stylePanel.getComponentCount() == 1) {
                        PlotStylePanel.this.stylePanel.remove(PlotStylePanel.this.stylePanel.getComponent(0));
                    }
                    PlotStylePanel.this.stylePanel.add((Component)((JPanel)((Object)editorPanel)), "Center");
                    PlotStylePanel.this.currentElement = element;
                }
                PlotStylePanel.this.repaint();
                PlotStylePanel.this.validate();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private static boolean closeColors(Color cA, Color cB) {
        if (cA.equals(cB)) {
            return true;
        }
        float[] colorA = new float[]{cA.getRed(), cA.getGreen(), cA.getBlue()};
        float[] colorB = new float[]{cB.getRed(), cB.getGreen(), cB.getBlue()};
        double dist = Math.sqrt(Math.pow(colorA[0] - colorB[0], 2.0) + Math.pow(colorA[1] - colorB[1], 2.0) + Math.pow(colorA[2] - colorB[2], 2.0));
        return dist < 5.0;
    }

    private boolean checkColors() {
        Color back = this.dom.getOptions().getBackground();
        Color fore = this.dom.getOptions().getForeground();
        Color color = this.dom.getOptions().getColor();
        if (PlotStylePanel.closeColors(fore, back)) {
            fore = back.getRed() < 128 ? Color.WHITE : Color.BLACK;
            this.dom.getOptions().setForeground(fore);
        }
        if (PlotStylePanel.closeColors(color, back)) {
            color = back.getRed() < 128 ? Color.WHITE : Color.BLACK;
            this.dom.getOptions().setColor(color);
        }
        List<PlotElement> pe = Arrays.asList(this.dom.getPlotElements());
        for (PlotElement p : pe) {
            if (!PlotStylePanel.closeColors(p.getStyle().getColor(), back)) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.stylePanel = new JPanel();
        this.plotPanel = new JPanel();
        this.majorTicksCheckBox = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.minorGridCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.foreBackColorsList = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.foregroundColorButton = new JButton();
        this.backgroundColorButton = new JButton();
        this.fontLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.pickFontButton = new JButton();
        this.widthLabel = new JLabel();
        this.widthTextField = new JFormattedTextField();
        this.heightTextField = new JFormattedTextField();
        this.heightLabel = new JLabel();
        this.jLabel7 = new JLabel();
        this.fittedCB = new JCheckBox();
        this.unitsCB = new JComboBox();
        this.sizeLabel = new JLabel();
        this.setPreferredSize(new Dimension(688, 300));
        this.jSplitPane2.setLastDividerLocation(300);
        this.stylePanel.setMinimumSize(new Dimension(300, 300));
        this.stylePanel.setLayout(new BorderLayout());
        this.jSplitPane2.setLeftComponent(this.stylePanel);
        this.plotPanel.setBorder(BorderFactory.createTitledBorder("Canvas [?]"));
        this.majorTicksCheckBox.setText("major ticks");
        this.majorTicksCheckBox.setToolTipText("Draw grid lines at major ticks ");
        this.jLabel12.setText("Grid:");
        this.jLabel12.setToolTipText("Draw grid lines at major and minor ticks");
        this.minorGridCheckBox.setText("minor ticks");
        this.minorGridCheckBox.setToolTipText("Draw grid lines at minor ticks ");
        this.jLabel1.setText("Fore/Back Colors:");
        this.jLabel1.setToolTipText("Set foreground and background colors");
        this.foreBackColorsList.setModel(new DefaultComboBoxModel<String>(new String[]{"black on white", "white on black", "white on blue", "custom"}));
        this.foreBackColorsList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.foreBackColorsListActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Background:");
        this.jLabel3.setToolTipText("Pick background color");
        this.jLabel2.setText("Foreground:");
        this.jLabel2.setToolTipText("Pick foreground color");
        this.foregroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.foregroundColorButtonActionPerformed(evt);
            }
        });
        this.backgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.backgroundColorButtonActionPerformed(evt);
            }
        });
        this.fontLabel.setText("jLabel5");
        this.jLabel4.setText("Canvas Font:");
        this.jLabel4.setToolTipText("Pick the font for the canvas");
        this.pickFontButton.setText("Pick");
        this.pickFontButton.setToolTipText("Pick canvas font");
        this.pickFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.pickFontButtonActionPerformed(evt);
            }
        });
        this.widthLabel.setText("Width (px):");
        this.widthLabel.setToolTipText("Canvas width in pixels");
        this.widthLabel.setEnabled(false);
        this.widthTextField.setText("100");
        this.widthTextField.setToolTipText("width of fixed size canvas in pixels, and the units \"inch\" or cm\" may be used.");
        this.widthTextField.setEnabled(false);
        this.widthTextField.setFocusLostBehavior(0);
        this.widthTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.widthTextFieldActionPerformed(evt);
            }
        });
        this.heightTextField.setText("100");
        this.heightTextField.setToolTipText("height of fixed size canvas in pixels, and the units inch or cm may be used.");
        this.heightTextField.setEnabled(false);
        this.heightTextField.setFocusLostBehavior(0);
        this.heightTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.heightTextFieldActionPerformed(evt);
            }
        });
        this.heightLabel.setText("Height (px):");
        this.heightLabel.setToolTipText("Canvas height in pixels");
        this.heightLabel.setEnabled(false);
        this.jLabel7.setText("Canvas Size:");
        this.jLabel7.setToolTipText("Control canvas size, allowing it to adjust or specifying width and height");
        this.fittedCB.setText("Adjust to Fit into Application");
        this.fittedCB.setToolTipText("When selected, the canvas is resized to fit into the application.");
        this.fittedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.fittedCBActionPerformed(evt);
            }
        });
        this.unitsCB.setModel(new DefaultComboBoxModel<String>(new String[]{"in pixels:", "in inches:", "in cm:"}));
        this.unitsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlotStylePanel.this.unitsCBActionPerformed(evt);
            }
        });
        this.sizeLabel.setText("jLabel5");
        GroupLayout plotPanelLayout = new GroupLayout((Container)this.plotPanel);
        this.plotPanel.setLayout((LayoutManager)plotPanelLayout);
        plotPanelLayout.setHorizontalGroup((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)plotPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(2).add(1, (GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.fontLabel, -2, 191, -2).addPreferredGap(0, 46, Short.MAX_VALUE).add((Component)this.pickFontButton)).add(1, (GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.fittedCB, -1, 252, Short.MAX_VALUE)).add(1, (GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel12).addPreferredGap(0).add((Component)this.majorTicksCheckBox).addPreferredGap(0).add((Component)this.minorGridCheckBox)).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.foregroundColorButton, -2, 30, -2)).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.backgroundColorButton, -2, 28, -2)).add((Component)this.foreBackColorsList, -2, 173, -2)))).add(0, 0, Short.MAX_VALUE)).add(1, (GroupLayout.Group)plotPanelLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((Component)this.widthLabel).add((Component)this.heightLabel)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1, false).add((Component)this.heightTextField, -1, 63, Short.MAX_VALUE).add((Component)this.widthTextField)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((Component)this.unitsCB, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((Component)this.sizeLabel, -1, -1, Short.MAX_VALUE)))).add(12, 12, 12)));
        plotPanelLayout.linkSize(new Component[]{this.backgroundColorButton, this.foregroundColorButton}, 1);
        plotPanelLayout.linkSize(new Component[]{this.heightTextField, this.widthTextField}, 1);
        plotPanelLayout.setVerticalGroup((GroupLayout.Group)plotPanelLayout.createParallelGroup(1).add((GroupLayout.Group)plotPanelLayout.createSequentialGroup().add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.majorTicksCheckBox).add((Component)this.jLabel12).add((Component)this.minorGridCheckBox)).add(18, 18, 18).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.foreBackColorsList, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.backgroundColorButton, -2, 23, -2).add((Component)this.foregroundColorButton, -2, 23, -2)).addPreferredGap(1).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.fontLabel).add((Component)this.pickFontButton)).add(18, 18, 18).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.fittedCB)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2).add((Component)this.unitsCB, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotPanelLayout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2).add((Component)this.sizeLabel)).addContainerGap(35, Short.MAX_VALUE)));
        this.jSplitPane2.setRightComponent(this.plotPanel);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane2, -1, 688, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane2));
    }

    private void foreBackColorsListActionPerformed(ActionEvent evt) {
        int i = this.foreBackColorsList.getSelectedIndex();
        if (this.initializing) {
            return;
        }
        if (i < fores.length) {
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon(fores[i], 16, 16));
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon(backs[i], 16, 16));
            List<PlotElement> pe = Arrays.asList(this.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.dom.getCanvases(0).getController().getDasCanvas().getForeground())) continue;
                p.getStyle().setColor(fores[i]);
            }
            this.dom.getOptions().setForeground(fores[i]);
            this.dom.getOptions().setColor(fores[i]);
            this.dom.getOptions().setBackground(backs[i]);
        }
        if (this.checkColors()) {
            this.dom.getController().setStatus("warning: Background and foreground colors are the same");
        }
    }

    private void foregroundColorButtonActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Foreground Color", this.foregroundColorButton.getBackground());
        if (c != null) {
            this.foreBackColorsList.setSelectedIndex(fores.length);
            List<PlotElement> pe = Arrays.asList(this.dom.getPlotElements());
            for (PlotElement p : pe) {
                if (!p.getStyle().getColor().equals(this.dom.getOptions().getForeground())) continue;
                p.getStyle().setColor(c);
            }
            this.foregroundColorButton.setIcon(GraphUtil.colorIcon(c, 16, 16));
            this.dom.getCanvases(0).getController().getDasCanvas().setForeground(c);
            this.dom.getOptions().setForeground(c);
            this.dom.getOptions().setColor(c);
            if (this.checkColors()) {
                this.dom.getController().setStatus("warning: Background and foreground colors are the same");
            }
        }
    }

    private void backgroundColorButtonActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Background Color", this.backgroundColorButton.getBackground());
        if (c != null) {
            this.foreBackColorsList.setSelectedIndex(fores.length);
            this.backgroundColorButton.setIcon(GraphUtil.colorIcon(c, 16, 16));
            this.dom.getOptions().setBackground(c);
            if (this.checkColors()) {
                this.dom.getController().setStatus("warning: Background and foreground colors are the same");
            }
        }
    }

    private void pickFontButtonActionPerformed(ActionEvent evt) {
        Font f = GuiSupport.pickFont((JFrame)SwingUtilities.getWindowAncestor(this), this.applicationModel);
        if (f != null) {
            this.fontLabel.setText(DomUtil.encodeFont(f));
        }
    }

    private void fittedCBActionPerformed(ActionEvent evt) {
        boolean s = !this.fittedCB.isSelected();
        this.widthTextField.setEnabled(s);
        this.heightTextField.setEnabled(s);
        this.widthLabel.setEnabled(s);
        this.heightLabel.setEnabled(s);
    }

    private void updateSize() {
        int wpixels = this.dom.getCanvases((int)0).getController().getDasCanvas().getPreferredSize().width;
        int hpixels = this.dom.getCanvases((int)0).getController().getDasCanvas().getPreferredSize().height;
        switch (this.unitsCB.getSelectedIndex()) {
            case 0: {
                this.sizeLabel.setText(String.format("w=%d by h=%d pixels", wpixels, hpixels));
                break;
            }
            case 1: {
                this.sizeLabel.setText(String.format(Locale.US, "w=%.2f by h=%.2f inch", (double)wpixels / 72.0, (double)hpixels / 72.0));
                break;
            }
            default: {
                this.sizeLabel.setText(String.format(Locale.US, "w=%.1f by h=%.1f cm", (double)(wpixels / 72) * 2.54, (double)(hpixels / 72) * 2.54));
            }
        }
    }

    private void widthTextFieldActionPerformed(ActionEvent evt) {
        String s = this.widthTextField.getText();
        try {
            this.dom.getCanvases(0).getController().getDasCanvas().setPreferredWidth((int)Units.typographicPoints.parse(s).value());
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.widthTextField.setText(String.valueOf(this.dom.getCanvases((int)0).getController().getDasCanvas().getPreferredSize().width));
    }

    private void heightTextFieldActionPerformed(ActionEvent evt) {
        String s = this.heightTextField.getText();
        try {
            this.dom.getCanvases(0).getController().getDasCanvas().setPreferredHeight((int)Units.typographicPoints.parse(s).value());
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.heightTextField.setText(String.valueOf(this.dom.getCanvases((int)0).getController().getDasCanvas().getPreferredSize().height));
    }

    private void unitsCBActionPerformed(ActionEvent evt) {
        this.updateSize();
    }

    public static interface StylePanel {
        public void doElementBindings(PlotElement var1);

        public void releaseElementBindings();
    }
}

