/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.InputVerifier;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.jythonsupport.Util;
import org.autoplot.util.TickleTimer;
import org.das2.qds.QDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.qds.filters.FiltersChainPanel;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class OperationsPanel
extends JPanel {
    private static final Logger logger = org.das2.datum.LoggerManager.getLogger("autoplot.gui");
    JTextField operatorsTextField;
    transient MouseWheelListener sliceIndexListener = null;
    private long lastIncrUp = 0L;
    private int incrUpCount = 0;
    TickleTimer tt = new TickleTimer(100L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (OperationsPanel.this.incrUpCount != 0) {
                OperationsPanel.this.doIncrUpOrDown(OperationsPanel.this.incrUpCount);
                OperationsPanel.this.incrUpCount = 0;
                OperationsPanel.this.lastIncrUp = System.currentTimeMillis();
            }
        }
    });
    TickleTimer operationsHistoryTimer = new TickleTimer(500L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    });
    private String filter = "";
    public static final String PROP_FILTER = "filter";
    private QDataSet dataSet = null;
    public static final String PROP_DATASET = "dataSet";
    private Boolean adjusting = false;
    public static final String PROP_ADJUSTING = "adjusting";
    private JLabel dataSetLabel;
    private JButton editComponentPanel;
    private FiltersChainPanel filtersChainPanel;
    private JLabel operationsLabel;
    private RecentComboBox operatorsComboBox;
    private BindingGroup bindingGroup;

    public OperationsPanel() {
        this.initComponents();
        this.operatorsComboBox.setPreferenceNode("operations");
        this.filtersChainPanel.setAddSubtractButtons(false);
        this.operatorsTextField = (JTextField)this.operatorsComboBox.getEditor().getEditorComponent();
        this.filtersChainPanel.addPropertyChangeListener(PROP_FILTER, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OperationsPanel.this.setFilter(OperationsPanel.this.filtersChainPanel.getFilter());
            }
        });
        this.operatorsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OperationsPanel.this.filtersChainPanel.validateFilter(OperationsPanel.this.operatorsTextField.getText())) {
                    OperationsPanel.this.filtersChainPanel.setFilter(OperationsPanel.this.operatorsTextField.getText());
                }
            }
        });
        this.operatorsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (OperationsPanel.this.filtersChainPanel.validateFilter(OperationsPanel.this.operatorsTextField.getText())) {
                    OperationsPanel.this.filtersChainPanel.setFilter(OperationsPanel.this.operatorsTextField.getText());
                }
            }
        });
        this.setUpOperationsListeners();
        this.setUpIncr();
    }

    private void setUpIncr() {
        if (this.sliceIndexListener == null) {
            this.sliceIndexListener = new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    OperationsPanel.this.doIncrUpOrDown(-1 * e.getWheelRotation());
                }
            };
            this.operatorsTextField.addMouseWheelListener(this.sliceIndexListener);
        }
        this.operatorsTextField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "INCREMENT_UP");
        this.operatorsTextField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "INCREMENT_DOWN");
        ActionMap am = this.operatorsTextField.getActionMap();
        am.put("INCREMENT_UP", new AbstractAction("incr_up"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                OperationsPanel.this.incrUpCount++;
                if (System.currentTimeMillis() - OperationsPanel.this.lastIncrUp > 300L) {
                    OperationsPanel.this.doIncrUpOrDown(OperationsPanel.this.incrUpCount);
                    OperationsPanel.this.incrUpCount = 0;
                    OperationsPanel.this.lastIncrUp = System.currentTimeMillis();
                } else {
                    OperationsPanel.this.tt.tickle("incr");
                }
            }
        });
        am.put("INCREMENT_DOWN", new AbstractAction("incr_down"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                OperationsPanel.this.incrUpCount--;
                if (System.currentTimeMillis() - OperationsPanel.this.lastIncrUp > 300L) {
                    OperationsPanel.this.doIncrUpOrDown(OperationsPanel.this.incrUpCount);
                    OperationsPanel.this.incrUpCount = 0;
                    OperationsPanel.this.lastIncrUp = System.currentTimeMillis();
                } else {
                    OperationsPanel.this.tt.tickle("incr");
                }
            }
        });
    }

    private static String doAdjust(String s, int cp, int add) {
        int i1;
        int i0;
        for (i0 = cp; i0 >= 0 && !Character.isDigit(s.charAt(i0)); --i0) {
        }
        while (i0 >= 0 && Character.isDigit(s.charAt(i0))) {
            --i0;
        }
        ++i0;
        for (i1 = cp; i1 < s.length() && Character.isDigit(s.charAt(i1)); ++i1) {
        }
        try {
            int ch = Integer.parseInt(s.substring(i0, i1));
            if ((ch += add) < 0) {
                ch = 0;
            }
            return s.substring(0, i0) + ch + s.substring(i1);
        }
        catch (NumberFormatException e) {
            return s;
        }
    }

    private void doIncrUpOrDown(int amount) {
        String s;
        final String olds = s = this.operatorsTextField.getText();
        final int cp = this.operatorsTextField.getCaretPosition();
        String match = ".*\\|slice\\d\\(\\d*";
        String match2 = ".*\\|slices\\(([\\:\\'\\d]+,)*\\d*";
        if (cp < s.length()) {
            Matcher m = Pattern.compile(match).matcher(s.substring(0, cp));
            if (m.matches()) {
                s = OperationsPanel.doAdjust(s, cp, amount);
            } else {
                Matcher m2 = Pattern.compile(match2).matcher(s.substring(0, cp));
                if (m2.matches()) {
                    s = OperationsPanel.doAdjust(s, cp, amount);
                }
            }
        } else {
            return;
        }
        final String news = s;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!olds.equals(news)) {
                        if (OperationsPanel.this.filtersChainPanel.validateFilter(news)) {
                            OperationsPanel.this.filtersChainPanel.setFilter(news);
                            if (OperationsPanel.this.dataSet != null) {
                                OperationsPanel.this.filtersChainPanel.resetInput(OperationsPanel.this.dataSet);
                                OperationsPanel.this.filtersChainPanel.setFilter(news);
                            }
                            OperationsPanel.this.operatorsTextField.setText(news);
                            OperationsPanel.this.operatorsTextField.setCaretPosition(cp);
                        } else {
                            String s = OperationsPanel.this.filtersChainPanel.getFilter();
                            OperationsPanel.this.operatorsTextField.setText(s);
                            OperationsPanel.this.operatorsTextField.setCaretPosition(cp);
                        }
                    }
                    OperationsPanel.this.componentChanged();
                    OperationsPanel.this.setFilter(OperationsPanel.this.filtersChainPanel.getFilter());
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    OperationsPanel.this.operatorsTextField.setText(olds);
                    OperationsPanel.this.operatorsTextField.setCaretPosition(cp);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void resetFiltersChain() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String newf;
                String fcpf = OperationsPanel.this.filtersChainPanel.getFilter();
                if (!fcpf.equals(newf = OperationsPanel.this.operatorsTextField.getText())) {
                    OperationsPanel.this.filtersChainPanel.setFilter(newf);
                    if (OperationsPanel.this.dataSet != null) {
                        OperationsPanel.this.filtersChainPanel.resetInput(OperationsPanel.this.dataSet);
                        OperationsPanel.this.filtersChainPanel.setFilter(newf);
                    } else {
                        OperationsPanel.this.filtersChainPanel.setInput(null);
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void resetFiltersChainDataSet(final QDataSet ds) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String filter = OperationsPanel.this.filtersChainPanel.getFilter();
                OperationsPanel.this.filtersChainPanel.setFilter("");
                OperationsPanel.this.filtersChainPanel.resetInput(ds);
                OperationsPanel.this.filtersChainPanel.setFilter(filter);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void componentChanged() {
        if (this.adjusting.booleanValue()) {
            return;
        }
        this.resetFiltersChain();
        this.operationsHistoryTimer.tickle();
    }

    private void setUpOperationsListeners() {
        ((JTextField)this.operatorsComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!OperationsPanel.this.adjusting.booleanValue()) {
                    OperationsPanel.this.componentChanged();
                } else {
                    logger.fine("Unexpected update that cannot be performed because we are adjusting.");
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.operatorsComboBox.setVerifier(new InputVerifier(){

            @Override
            public boolean verify(String value) {
                return value.trim().length() > 0 && value.length() < 70;
            }
        });
        this.operatorsComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LoggerManager.logGuiEvent(evt);
                OperationsPanel.this.setAdjusting(false);
                OperationsPanel.this.componentChanged();
            }

            @Override
            public void focusGained(FocusEvent evt) {
                LoggerManager.logGuiEvent(evt);
                OperationsPanel.this.setAdjusting(true);
            }
        });
        this.operatorsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                OperationsPanel.this.setAdjusting(false);
                OperationsPanel.this.componentChanged();
                OperationsPanel.this.setAdjusting(OperationsPanel.this.operatorsComboBox.getEditor().getEditorComponent().hasFocus());
            }
        });
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.filtersChainPanel = new FiltersChainPanel();
        this.operatorsComboBox = new RecentComboBox();
        this.editComponentPanel = new JButton();
        this.operationsLabel = new JLabel();
        this.dataSetLabel = new JLabel();
        this.filtersChainPanel.setName("filtersChainPanel");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${enabled}"), (Object)this.filtersChainPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.filtersChainPanel.setLayout(new BoxLayout(this.filtersChainPanel, 2));
        this.operatorsComboBox.setName("operatorsComboBox");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${enabled}"), (Object)this.operatorsComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.operatorsComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OperationsPanel.this.operatorsComboBoxFocusLost(evt);
            }
        });
        this.operatorsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationsPanel.this.operatorsComboBoxActionPerformed(evt);
            }
        });
        this.editComponentPanel.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/resources/pipeMag2.png")));
        this.editComponentPanel.setToolTipText("Open filters editor");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${enabled}"), (Object)this.editComponentPanel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.editComponentPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OperationsPanel.this.editComponentPanelActionPerformed(evt);
            }
        });
        this.operationsLabel.setText("Operations:");
        this.operationsLabel.setToolTipText("Process string that specifies component to plot, or how a data set's dimensionality should be reduced before display.");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${enabled}"), (Object)this.operationsLabel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.dataSetLabel.setFont(this.dataSetLabel.getFont().deriveFont((float)this.dataSetLabel.getFont().getSize() - 4.0f));
        this.dataSetLabel.setText("(dataset will go here)");
        this.dataSetLabel.setName("inputDataSetLabel");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${enabled}"), (Object)this.dataSetLabel, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.operationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.operatorsComboBox, -1, -1, Short.MAX_VALUE)).addComponent(this.dataSetLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editComponentPanel)).addComponent(this.filtersChainPanel, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dataSetLabel).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editComponentPanel).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.operationsLabel).addComponent(this.operatorsComboBox, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filtersChainPanel, -1, 247, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void operatorsComboBoxActionPerformed(ActionEvent evt) {
        logger.log(Level.FINE, "operatorsComboBox: {0}", this.operatorsComboBox.getSelectedItem());
        this.doEnter();
    }

    private void doEnter() {
        String news = this.operatorsTextField.getText();
        int cp = this.operatorsTextField.getCaretPosition();
        if (this.filtersChainPanel.validateFilter(news)) {
            this.filtersChainPanel.setFilter(news);
            if (this.dataSet != null) {
                this.filtersChainPanel.resetInput(this.dataSet);
                this.filtersChainPanel.setFilter(news);
            }
            this.operatorsTextField.setText(news);
            this.operatorsTextField.setCaretPosition(cp);
        } else {
            String s = this.filtersChainPanel.getFilter();
            this.operatorsTextField.setText(s);
            this.operatorsTextField.setCaretPosition(cp);
        }
    }

    private void editComponentPanelActionPerformed(ActionEvent evt) {
        int ret;
        LoggerManager.logGuiEvent(evt);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html><em>Add filters to apply to the data before plotting.<br> "), "North");
        FiltersChainPanel p = new FiltersChainPanel();
        Dimension d = new Dimension(480, 320);
        panel.setPreferredSize(d);
        panel.setMinimumSize(d);
        panel.add((Component)p, "Center");
        p.setFilter(this.operatorsTextField.getText());
        QDataSet inputDs = this.dataSet;
        if (inputDs != null) {
            p.setInput(inputDs);
            p.setFilter(this.operatorsTextField.getText());
        }
        if ((ret = AutoplotUtil.showConfirmDialog(this, panel, "Edit Filters", 2)) == 0) {
            String newFilter = p.getFilter();
            this.operatorsTextField.setText(newFilter);
            this.setFilter(newFilter);
            this.operatorsComboBox.setSelectedItem(newFilter);
            this.operatorsComboBox.addToRecent(newFilter);
        }
    }

    private void operatorsComboBoxFocusLost(FocusEvent evt) {
        this.doEnter();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(final String filter) {
        String oldFilter = this.filter;
        this.filter = filter;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                QDataSet oldDataSet = OperationsPanel.this.filtersChainPanel.getInput();
                String oldFilter = OperationsPanel.this.filtersChainPanel.getFilter();
                if (oldFilter != null && oldFilter.equals(filter) && oldDataSet != null && oldDataSet.equals(OperationsPanel.this.dataSet)) {
                    if (!filter.equals(OperationsPanel.this.operatorsTextField.getText())) {
                        try {
                            int carot = OperationsPanel.this.operatorsTextField.getCaretPosition();
                            OperationsPanel.this.operatorsTextField.setText(filter);
                            OperationsPanel.this.operatorsTextField.setCaretPosition(Math.min(filter.length(), carot));
                        }
                        catch (IllegalStateException ex) {
                            logger.fine("looks like someone else is editing the operators text field already, returning.");
                        }
                    }
                    return;
                }
                OperationsPanel.this.filtersChainPanel.setFilter(filter);
                OperationsPanel.this.filtersChainPanel.resetInput(OperationsPanel.this.dataSet);
                if (!oldFilter.equals(filter) || !filter.equals(OperationsPanel.this.operatorsTextField.getText())) {
                    try {
                        int carot = OperationsPanel.this.operatorsTextField.getCaretPosition();
                        OperationsPanel.this.operatorsTextField.setText(filter);
                        OperationsPanel.this.operatorsTextField.setCaretPosition(Math.min(filter.length(), carot));
                    }
                    catch (IllegalStateException ex) {
                        logger.fine("looks like someone else is editing the operators text field already, returning.");
                    }
                }
            }
        };
        if (!oldFilter.equals(filter)) {
            this.firePropertyChange(PROP_FILTER, oldFilter, filter);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public QDataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(QDataSet dataSet) {
        QDataSet oldDataSet = this.dataSet;
        this.dataSet = dataSet;
        this.dataSetLabel.setText(dataSet == null ? "None" : String.valueOf(dataSet));
        if (dataSet == null) {
            this.dataSetLabel.setToolTipText("The data set has not been set");
        } else {
            this.dataSetLabel.setToolTipText(null);
        }
        this.filtersChainPanel.setInput(dataSet);
        this.firePropertyChange(PROP_DATASET, oldDataSet, dataSet);
    }

    public Boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(Boolean adjusting) {
        Boolean oldAdjusting = this.adjusting;
        this.adjusting = adjusting;
        this.firePropertyChange(PROP_ADJUSTING, oldAdjusting, adjusting);
    }

    private static void mainEvt() throws Exception {
        OperationsPanel p = new OperationsPanel();
        QDataSet ds = Schemes.simpleSpectrogramTimeSeries();
        Util.getDataSet("http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hydra/hyd_h0/$Y/po_h0_hyd_$Y$m$d_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX&timerange=2000-01-09");
        p.setDataSet(ds);
        p.addPropertyChangeListener(PROP_FILTER, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println("New Value: " + evt.getNewValue());
            }
        });
        JPanel testPanel = new JPanel();
        testPanel.setLayout(new BorderLayout());
        testPanel.add((Component)p, "Center");
        JTextField tf = new JTextField("");
        testPanel.add((Component)tf, "South");
        BindingGroup bg = new BindingGroup();
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)tf, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"), (Object)p, (Property)BeanProperty.create((String)PROP_FILTER));
        bg.addBinding((Binding)binding);
        bg.bind();
        if (0 == JOptionPane.showConfirmDialog(null, testPanel, "Test Panel", 2)) {
            System.err.println(p.getFilter());
        }
    }

    public static void main(String[] args) throws Exception {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    OperationsPanel.mainEvt();
                }
                catch (Exception ex) {
                    Logger.getLogger(OperationsPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        SwingUtilities.invokeAndWait(run);
    }

    public FiltersChainPanel getFiltersChainPanel() {
        return this.filtersChainPanel;
    }

    public void setExpertMode(boolean expert) {
        this.operatorsTextField.setEditable(expert);
    }
}

