/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.ApplicationModel;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementController;
import org.autoplot.help.AutoplotHelpSystem;
import org.autoplot.metatree.NameValueTreeModel;
import org.das2.datum.DatumUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.util.AutoHistogram;
import org.das2.qds.util.PropertiesTreeModel;
import org.das2.util.CombinedTreeModel;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class MetadataPanel
extends JPanel {
    ApplicationModel applicationModel;
    Application dom;
    CombinedTreeModel tree;
    TreeModel dsTree;
    TreeModel componentDataSetTree = null;
    DataSourceFilter bindToDataSourceFilter = null;
    PlotElement bindToPlotElement = null;
    private QDataSet dsTreeDs;
    private NameValueTreeModel statsTree;
    Thread updateComponentDataSetThread = null;
    Thread updateStatisticsThread = null;
    private static final Logger logger = LoggerManager.getLogger("gui.metadata");
    transient PropertyChangeListener propertiesListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rawProperties")) {
                MetadataPanel.this.updateProperties();
            }
        }
    };
    transient PropertyChangeListener fillListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("fillDataSet")) {
                MetadataPanel.this.updateStatistics();
            }
        }
    };
    transient PropertyChangeListener componentListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dataSet")) {
                MetadataPanel.this.updateComponentDataSet();
            }
        }
    };
    boolean statisticsDirty;
    private JMenuItem copyMenuItem;
    private JMenuItem copyValueMenuItem;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JTree metaDataTree;

    public MetadataPanel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.dom = applicationModel.getDocumentModel();
        this.initComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MetadataPanel.this.metaDataTree.setModel(null);
            }
        });
        this.dom.getController().addPropertyChangeListener("dataSourceFilter", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MetadataPanel.this.bindToDataSourceFilter(MetadataPanel.this.dom.getController().getDataSourceFilter());
            }
        });
        this.dom.getController().addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MetadataPanel.this.bindToPlotElement(MetadataPanel.this.dom.getController().getPlotElement());
            }
        });
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        if (dsf != null) {
            this.bindToDataSourceFilter(dsf);
        }
        this.updateProperties();
        this.updateStatistics();
        this.updateComponentDataSet();
        this.bindToPlotElement(this.dom.getController().getPlotElement());
        MouseListener popupTrigger = this.createPopupTrigger();
        this.metaDataTree.addMouseListener(popupTrigger);
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "metadataPanel");
        Timer t = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MetadataPanel.this.isShowing()) {
                    if (MetadataPanel.this.updateComponentDataSetThread != null) {
                        logger.fine("updating component");
                        MetadataPanel.this.updateComponentDataSetThread.start();
                        MetadataPanel.this.updateComponentDataSetThread = null;
                    }
                    if (MetadataPanel.this.updateStatisticsThread != null) {
                        logger.fine("updating statistics");
                        MetadataPanel.this.updateStatisticsThread.start();
                        MetadataPanel.this.updateStatisticsThread = null;
                    }
                }
            }
        });
        t.setRepeats(true);
        t.start();
    }

    private MouseListener createPopupTrigger() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = MetadataPanel.this.jPopupMenu1) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = MetadataPanel.this.jPopupMenu1) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    private void bindToDataSourceFilter(DataSourceFilter dsf) {
        if (this.bindToDataSourceFilter != null) {
            DataSourceController dsc = this.bindToDataSourceFilter.getController();
            dsc.removePropertyChangeListener(this.propertiesListener);
            dsc.removePropertyChangeListener(this.fillListener);
        }
        if (dsf != null) {
            dsf.getController().addPropertyChangeListener("rawProperties", this.propertiesListener);
            dsf.getController().addPropertyChangeListener("fillDataSet", this.fillListener);
        }
        this.bindToDataSourceFilter = dsf;
        this.updateProperties();
        this.updateStatistics();
    }

    private void bindToPlotElement(PlotElement pe) {
        if (this.bindToPlotElement != null) {
            PlotElementController pec = this.bindToPlotElement.getController();
            pec.removePropertyChangeListener(this.componentListener);
        }
        if (pe != null) {
            pe.getController().addPropertyChangeListener("dataSet", this.componentListener);
        }
        this.bindToPlotElement = pe;
        this.updateComponentDataSet();
    }

    private void updateProperties() {
        try {
            DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
            DataSourceController dsfc = null;
            DataSource dataSource = null;
            if (dsf != null) {
                dsfc = dsf.getController();
                dataSource = dsfc.getDataSource();
            }
            if (dsfc == null) {
                String label = "(data source controller is null)";
                this.tree = new CombinedTreeModel(label);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MetadataPanel.this.metaDataTree.setModel(MetadataPanel.this.tree);
                    }
                });
            } else if (dataSource != null) {
                NameValueTreeModel dsrcMeta;
                this.tree = new CombinedTreeModel("" + dataSource.getURI());
                Map<String, Object> meta = dsfc.getRawProperties();
                MetadataModel model = dataSource.getMetadataModel();
                String root = "Metadata";
                if (model != null && !model.getLabel().equals("")) {
                    root = root + "(" + model.getLabel() + ")";
                }
                if ((dsrcMeta = NameValueTreeModel.create(root, meta)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MetadataPanel.this.tree.mountTree(dsrcMeta, 10);
                            MetadataPanel.this.metaDataTree.setModel(MetadataPanel.this.tree);
                        }
                    });
                }
            } else {
                String label = "(no data source)";
                if (dsfc.getDataSet() != null) {
                    label = "dataset";
                }
                this.tree = new CombinedTreeModel(label);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MetadataPanel.this.metaDataTree.setModel(MetadataPanel.this.tree);
                    }
                });
            }
        }
        catch (Exception e) {
            this.tree = new CombinedTreeModel("Exception: " + e);
            this.applicationModel.getExceptionHandler().handle(e);
        }
    }

    private void updateComponentDataSet() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                MetadataPanel.this.updateComponentDataSetPropertiesView();
            }
        };
        this.updateComponentDataSetThread = new Thread(run, "updateComponentDataSet");
    }

    private void updateStatistics() {
        this.statisticsDirty = true;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (MetadataPanel.this.statisticsDirty) {
                    MetadataPanel.this.updateStatisticsImmediately();
                    MetadataPanel.this.updateDataSetPropertiesView();
                    MetadataPanel.this.updateComponentDataSetPropertiesView();
                }
            }
        };
        this.updateStatisticsThread = new Thread(run, "updateStats");
    }

    private synchronized void updateDataSetPropertiesView() {
        TreeModel unmount;
        assert (!EventQueue.isDispatchThread());
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        QDataSet ds = dsf.getController().getDataSet();
        if (ds == null) {
            unmount = this.dsTree;
            this.dsTree = NameValueTreeModel.create("Dataset", Collections.singletonMap("dataset", "(no dataset)"));
            this.dsTreeDs = null;
        } else if (ds != this.dsTreeDs) {
            unmount = this.dsTree;
            this.dsTree = new PropertiesTreeModel("Dataset= ", ds, 20);
            this.dsTreeDs = ds;
        } else {
            unmount = null;
        }
        this.updateComponentDataSetPropertiesView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (unmount != null) {
                    MetadataPanel.this.tree.unmountTree(unmount);
                }
                MetadataPanel.this.tree.mountTree(MetadataPanel.this.dsTree, 30);
            }
        });
    }

    private synchronized void updateComponentDataSetPropertiesView() {
        TreeModel unmount;
        assert (!EventQueue.isDispatchThread());
        PlotElement pe = this.dom.getController().getPlotElement();
        if (pe == null) {
            unmount = this.componentDataSetTree;
            this.componentDataSetTree = NameValueTreeModel.create("Processed Dataset", Collections.singletonMap("dataset", "(no dataset)"));
        } else {
            QDataSet ds = pe.getController().getDataSet();
            if (ds == null) {
                unmount = this.componentDataSetTree;
                this.componentDataSetTree = NameValueTreeModel.create("Processed Dataset", Collections.singletonMap("dataset", "(no dataset)"));
            } else {
                unmount = this.componentDataSetTree;
                this.componentDataSetTree = ds != this.dsTreeDs ? new PropertiesTreeModel("Processed Dataset= ", ds, 20) : NameValueTreeModel.create("Processed Dataset contains no additional processing", Collections.singletonMap("dataset", "(no additional processing)"));
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (unmount != null) {
                    MetadataPanel.this.tree.unmountTree(unmount);
                }
                MetadataPanel.this.tree.mountTree(MetadataPanel.this.componentDataSetTree, 40);
            }
        });
    }

    private QDataSet getCadenceJoin(QDataSet ds) {
        JoinDataSet cadence = new JoinDataSet(1);
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet dep0 = (QDataSet)ds.slice(0).property("DEPEND_0");
            if (dep0 == null) {
                cadence.join(DataSetUtil.asDataSet(1.0));
                continue;
            }
            if (dep0.property("CADENCE") == null) continue;
            cadence.join((QDataSet)dep0.property("CADENCE"));
        }
        return cadence;
    }

    private synchronized void updateStatisticsImmediately() {
        assert (!EventQueue.isDispatchThread());
        final NameValueTreeModel unmount = this.statsTree;
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilter();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        QDataSet ds = dsf.getController().getDataSet();
        if (ds == null) {
            map.put("dataset", "(no dataset)");
        } else {
            QDataSet dep0;
            QDataSet hist = dsf.getController().getHistogram();
            map.put("Histogram", hist);
            if (hist != null) {
                RankZeroDataSet moments = AutoHistogram.moments(hist);
                long validCount = (Long)moments.property("validCount");
                long invalidCount = (Long)moments.property("invalidCount");
                map.put("# invalid", "" + invalidCount + " of " + String.valueOf(validCount + invalidCount));
                String s = validCount > 0L ? String.valueOf(moments) : "";
                map.put("Mean", s);
                s = validCount > 1L && moments.property("stddev") != null ? String.valueOf(DatumUtil.asOrderOneUnits(DataSetUtil.asDatum((QDataSet)moments.property("stddev")))) : "";
                map.put("Std Dev", s);
                QDataSet range = AutoHistogram.simpleRange(hist);
                map.put("min", range.slice(0));
                map.put("max", range.slice(1));
            }
            QDataSet cadence = (dep0 = (QDataSet)ds.property("DEPEND_0")) == null ? (SemanticOps.isJoin(ds) ? this.getCadenceJoin(ds) : DataSetUtil.asDataSet(1.0)) : (QDataSet)dep0.property("CADENCE");
            if (cadence != null) {
                map.put("Cadence", cadence);
            } else {
                map.put("Cadence", "null");
            }
        }
        this.statsTree = NameValueTreeModel.create("Statistics", map);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (unmount != null) {
                    MetadataPanel.this.tree.unmountTree(unmount);
                }
                MetadataPanel.this.tree.mountTree(MetadataPanel.this.statsTree, 20);
            }
        });
        this.statisticsDirty = false;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.copyMenuItem = new JMenuItem();
        this.copyValueMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.metaDataTree = new JTree();
        this.copyMenuItem.setText("copy");
        this.copyMenuItem.setToolTipText("Copy item to system clip board");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataPanel.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.copyMenuItem);
        this.copyValueMenuItem.setText("copy value");
        this.copyValueMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MetadataPanel.this.copyValueMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.copyValueMenuItem);
        this.jScrollPane1.setViewportView(this.metaDataTree);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 285, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 254, Short.MAX_VALUE));
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        TreePath tp = this.metaDataTree.getSelectionPath();
        StringSelection stringSelection = new StringSelection(tp.getLastPathComponent().toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    private void copyValueMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        TreePath tp = this.metaDataTree.getSelectionPath();
        String s = tp.getLastPathComponent().toString();
        int i = s.indexOf(61);
        if (i > -1) {
            s = s.substring(i + 1);
        }
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }
}

