/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.autoplot.AddPlotsDialog;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.BindToHiddenDialog;
import org.autoplot.GuiSupport;
import org.autoplot.PlotStylePanel;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.dom.Application;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomOps;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementController;
import org.autoplot.dom.PlotElementStyle;
import org.autoplot.dom.Row;
import org.autoplot.help.AutoplotHelpSystem;
import org.autoplot.util.CanvasLayoutPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class LayoutPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger("autoplot.gui.layout");
    private Plot draggingPlot = null;
    private Point dragInitialClick = null;
    private Point dragLocation = null;
    private Application dom;
    private ApplicationModel applicationModel;
    private Map<Component, JPopupMenu> contextMenus = null;
    private Action removeBindingsAction = new AbstractAction("Remove Bindings"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent(e);
            Plot domPlot = LayoutPanel.this.dom.getController().getPlot();
            List<PlotElement> elements = LayoutPanel.this.dom.getController().getPlotElementsFor(domPlot);
            for (PlotElement element : elements) {
                LayoutPanel.this.dom.getController().unbind(element);
            }
            LayoutPanel.this.dom.getController().unbind(domPlot);
        }
    };
    private Action deletePlotAction = new AbstractAction("Delete Plot"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent(e);
            List<Object> os = LayoutPanel.this.canvasLayoutPanel1.getSelectedComponents();
            for (Object o : os) {
                if (LayoutPanel.this.dom.getPlots().length > 1) {
                    Plot domPlot = null;
                    if (o instanceof Component) {
                        domPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)o);
                    }
                    if (domPlot == null) continue;
                    List<PlotElement> plotElements = LayoutPanel.this.dom.getController().getPlotElementsFor(domPlot);
                    for (PlotElement pan : plotElements) {
                        if (LayoutPanel.this.dom.getPlotElements().length > 1) {
                            LayoutPanel.this.dom.getController().deletePlotElement(pan);
                            continue;
                        }
                        LayoutPanel.this.dom.getController().setStatus("warning: the last plot element may not be deleted");
                    }
                    LayoutPanel.this.dom.getController().deletePlot(domPlot);
                    continue;
                }
                LayoutPanel.this.dom.getController().setStatus("warning: last plot may not be deleted");
            }
        }
    };
    private Action addPlotsAction = new AbstractAction("Add Plots..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent(e);
            AddPlotsDialog dia = new AddPlotsDialog();
            dia.getNumberOfColumnsSpinner().setModel(new SpinnerNumberModel(1, 1, 6, 1));
            dia.getNumberOfRowsSpinner().setModel(new SpinnerNumberModel(1, 1, 6, 1));
            if (0 == JOptionPane.showConfirmDialog(LayoutPanel.this.plotElementListComponent, dia, "Add Plots", 2, -1, new ImageIcon(AutoplotUtil.getAutoplotIcon()))) {
                int nr = (Integer)dia.getNumberOfRowsSpinner().getValue();
                int nc = (Integer)dia.getNumberOfColumnsSpinner().getValue();
                if (nr > 6 || nc > 6) {
                    JOptionPane.showMessageDialog(LayoutPanel.this, "No more than 6 rows or columns can be added at once.");
                } else {
                    Plot p = LayoutPanel.this.dom.getController().getPlot();
                    LayoutPanel.this.dom.getController().addPlots(nr, nc, dia.getDirection());
                    if (dia.getDirection() == null) {
                        LayoutPanel.this.dom.getController().deletePlot(p);
                    }
                }
            }
        }
    };
    private transient ListSelectionListener plotElementSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LayoutPanel.this.plotElementListComponent.getValueIsAdjusting()) {
                return;
            }
            if (LayoutPanel.this.plotElementListComponent.getSelectedValuesList().size() == 1 && !LayoutPanel.this.dom.getController().isValueAdjusting()) {
                Object o = LayoutPanel.this.plotElementListComponent.getSelectedValue();
                if (!(o instanceof PlotElement)) {
                    System.err.println("expected plotElements in panelListComponent, returning");
                    return;
                }
                PlotElement pe = (PlotElement)o;
                Plot plot = LayoutPanel.this.dom.getController().getPlotFor(pe);
                if (plot != null) {
                    LayoutPanel.this.dom.getController().setPlot(plot);
                    LayoutPanel.this.dom.getController().setPlotElement(pe);
                } else {
                    logger.fine("plot not found for plotElement");
                }
            }
        }
    };
    private transient PropertyChangeListener plotElementsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updatePlotElementList();
        }
    };
    private transient PropertyChangeListener bindingsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updateBindingList();
        }
    };
    private transient PropertyChangeListener dataSourceListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.dataSourceList.repaint();
        }
    };
    private transient PropertyChangeListener dataSourcesListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutPanel.this.updateDataSourceList();
            DataSourceFilter[] old = (DataSourceFilter[])evt.getOldValue();
            DataSourceFilter[] nww = (DataSourceFilter[])evt.getNewValue();
            List<DataSourceFilter> oldList = Arrays.asList(old);
            for (DataSourceFilter dsf : nww) {
                if (oldList.contains(dsf)) continue;
                dsf.addPropertyChangeListener("uri", LayoutPanel.this.dataSourceListener);
                dsf.getController().addPropertyChangeListener("tsb", LayoutPanel.this.dataSourceListener);
            }
            List<DataSourceFilter> newList = Arrays.asList(nww);
            for (DataSourceFilter dsf : old) {
                if (newList.contains(dsf)) continue;
                dsf.removePropertyChangeListener("uri", LayoutPanel.this.dataSourceListener);
                dsf.getController().removePropertyChangeListener("tsb", LayoutPanel.this.dataSourceListener);
            }
        }
    };
    private transient PropertyChangeListener plotListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Plot plot = LayoutPanel.this.dom.getController().getPlot();
            if (plot == null) {
                return;
            }
            List<PlotElement> p = LayoutPanel.this.dom.getController().getPlotElementsFor(plot);
            List<PlotElement> allElements = Arrays.asList(LayoutPanel.this.dom.getPlotElements());
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < p.size(); ++i) {
                if (!p.get(i).isActive()) continue;
                indices.add(allElements.indexOf(p.get(i)));
            }
            final int[] iindices = new int[indices.size()];
            for (int i = 0; i < indices.size(); ++i) {
                iindices[i] = (Integer)indices.get(i);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    logger.finer("enter plotListener");
                    LayoutPanel.this.plotElementListComponent.setSelectedIndices(iindices);
                    LayoutPanel.this.updateSelected();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    };
    private transient PropertyChangeListener plotElementListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PlotElement p = LayoutPanel.this.dom.getController().getPlotElement();
            List<PlotElement> allElements = Arrays.asList(LayoutPanel.this.dom.getPlotElements());
            final int index = allElements.indexOf(p);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    LayoutPanel.this.plotElementListComponent.setSelectedIndex(index);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    };
    private ListCellRenderer myListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Renderer rend;
            PlotElementController cont;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PlotElement val = (PlotElement)value;
            if (val != null && (cont = val.getController()) != null && (rend = val.getController().getRenderer()) != null) {
                Icon icon = rend.getListIcon();
                label.setIcon(icon);
                rend.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        LayoutPanel.this.plotElementListComponent.repaint();
                    }
                });
            }
            return label;
        }
    };
    private JMenuItem addHiddenMenuItem;
    private JMenuItem addPlotsBelowMenuItem;
    private JButton addPlotsButton;
    private JMenuItem biggerMI;
    private JPopupMenu bindingActionsMenu;
    private JList bindingListComponent;
    private CanvasLayoutPanel canvasLayoutPanel1;
    private JPopupMenu dataSourceActionsMenu;
    private JList<String> dataSourceList;
    private JMenuItem deleteBindingsMenuItem;
    private JMenuItem deleteMenuItem;
    private JButton deletePlotButton;
    private JMenuItem editMenuItem;
    private JButton fixLayoutButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JTable jTable1;
    private JPopupMenu plotActionsMenu;
    private JList plotElementListComponent;
    private JMenu plotMenu;
    private JMenu plotsMenu;
    private JMenuItem propertiesMenuItem;
    private JMenuItem removeBindingsMenuItem;
    private JButton sameHeightButton;
    private JMenuItem sameSizeMI;
    private JLabel selectedPlotLabel;
    private JButton shorterButton;
    private JMenu sizeMenu;
    private JMenuItem smallerMI;
    private JMenuItem swapMenuItem;
    private JButton tallerButton;

    public LayoutPanel() {
        this.initComponents();
        this.canvasLayoutPanel1.addPropertyChangeListener("component", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String selectText;
                Plot plot = LayoutPanel.this.dom.getController().getPlotFor((Component)LayoutPanel.this.canvasLayoutPanel1.getComponent());
                List<Object> p = LayoutPanel.this.canvasLayoutPanel1.getSelectedComponents();
                if (plot != null) {
                    LayoutPanel.this.dom.getController().setPlot(plot);
                    LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(p);
                }
                LayoutPanel.this.tallerButton.setEnabled(plot != null);
                LayoutPanel.this.shorterButton.setEnabled(plot != null);
                LayoutPanel.this.addPlotsButton.setEnabled(plot != null);
                LayoutPanel.this.addPlotsButton.setEnabled(plot != null);
                int count = LayoutPanel.this.getSelectedPlots().size();
                LayoutPanel.this.sameHeightButton.setEnabled(count > 1);
                switch (count) {
                    case 1: {
                        if (plot != null) {
                            selectText = plot.getId();
                            break;
                        }
                        selectText = "";
                        break;
                    }
                    default: {
                        selectText = String.format("%d plots selected", count);
                    }
                }
                LayoutPanel.this.selectedPlotLabel.setText(selectText);
            }
        });
        this.plotElementListComponent.addListSelectionListener(this.plotElementSelectionListener);
        this.canvasLayoutPanel1.addPropertyChangeListener("selectedComponents", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String selectText;
                List<Plot> selectedPlots = LayoutPanel.this.getSelectedPlots();
                int count = selectedPlots.size();
                LayoutPanel.this.sameHeightButton.setEnabled(count > 1);
                switch (count) {
                    case 1: {
                        if (selectedPlots.get(0) != null) {
                            selectText = selectedPlots.get(0).getId();
                            break;
                        }
                        selectText = "";
                        break;
                    }
                    default: {
                        selectText = String.format("%d plots selected", count);
                    }
                }
                LayoutPanel.this.selectedPlotLabel.setText(selectText);
            }
        });
        this.createPopupMenus();
        MouseListener popupTrigger = this.createPopupTrigger();
        this.canvasLayoutPanel1.addMouseListener(popupTrigger);
        this.canvasLayoutPanel1.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Object s;
                if (LayoutPanel.this.draggingPlot == null && LayoutPanel.this.dragInitialClick == null) {
                    Object s2 = LayoutPanel.this.canvasLayoutPanel1.getCanvasComponentAt(e.getX(), e.getY());
                    if (s2 instanceof Component) {
                        LayoutPanel.this.draggingPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)s2);
                        LayoutPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        LayoutPanel.this.dom.getController().setStatus("swap " + LayoutPanel.this.draggingPlot + ", drop to swap positions.");
                    } else {
                        LayoutPanel.this.dragInitialClick = e.getPoint();
                        LayoutPanel.this.dom.getController().setStatus("select plots by drawing a box.");
                    }
                    LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(null);
                } else if (LayoutPanel.this.dragInitialClick != null) {
                    LayoutPanel.this.dragLocation = e.getPoint();
                    Rectangle rect = new Rectangle(LayoutPanel.this.dragInitialClick);
                    rect.add(e.getPoint());
                    LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(rect);
                    LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(rect);
                    int count = LayoutPanel.this.getSelectedPlots().size();
                    LayoutPanel.this.sameHeightButton.setEnabled(count > 1);
                } else if (LayoutPanel.this.draggingPlot != null && (s = LayoutPanel.this.canvasLayoutPanel1.getCanvasComponentAt(e.getX(), e.getY())) instanceof Component) {
                    Plot targetPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)s);
                    if (targetPlot != null && targetPlot != LayoutPanel.this.draggingPlot) {
                        LayoutPanel.this.dom.getController().setStatus("swap " + LayoutPanel.this.draggingPlot + " and " + targetPlot);
                    } else {
                        LayoutPanel.this.dom.getController().setStatus("swap " + LayoutPanel.this.draggingPlot + ", drop to swap positions.");
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.plotElementListComponent.addMouseListener(popupTrigger);
        this.dataSourceList.addMouseListener(popupTrigger);
        this.bindingListComponent.addMouseListener(popupTrigger);
        AutoplotHelpSystem.getHelpSystem().registerHelpID(this, "layoutPanel");
    }

    private MouseListener createPopupTrigger() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = (JPopupMenu)LayoutPanel.this.contextMenus.get(e.getComponent())) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(null);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = (JPopupMenu)LayoutPanel.this.contextMenus.get(e.getComponent())) != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
                if (LayoutPanel.this.draggingPlot != null) {
                    Plot targetPlot;
                    Object s = LayoutPanel.this.canvasLayoutPanel1.getCanvasComponentAt(e.getX(), e.getY());
                    if (s instanceof Component && (targetPlot = LayoutPanel.this.dom.getController().getPlotFor((Component)s)) != null) {
                        DomOps.swapPosition(LayoutPanel.this.draggingPlot, targetPlot);
                        if (LayoutPanel.this.dom.getOptions().isAutolayout()) {
                            DomOps.newCanvasLayout(LayoutPanel.this.dom);
                        }
                        LayoutPanel.this.dom.getController().setStatus("swapped " + LayoutPanel.this.draggingPlot + " and " + targetPlot);
                    }
                    LayoutPanel.this.setCursor(null);
                    LayoutPanel.this.draggingPlot = null;
                }
                if (LayoutPanel.this.dragInitialClick != null) {
                    Rectangle rect = new Rectangle(LayoutPanel.this.dragInitialClick);
                    rect.add(e.getPoint());
                    LayoutPanel.this.canvasLayoutPanel1.setSelectedComponents(rect);
                    LayoutPanel.this.dragInitialClick = null;
                }
                LayoutPanel.this.canvasLayoutPanel1.setRectangleSelect(null);
            }
        };
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    private synchronized void createPopupMenus() {
        this.contextMenus = new HashMap<Component, JPopupMenu>();
        this.contextMenus.put(this.canvasLayoutPanel1, this.plotActionsMenu);
        this.contextMenus.put(this.dataSourceList, this.dataSourceActionsMenu);
        JPopupMenu plotElementContextMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Edit Plot Element Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyEditor edit;
                LoggerManager.logGuiEvent(e);
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                PlotElement p = (PlotElement)LayoutPanel.this.plotElementListComponent.getSelectedValue();
                switch (os.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        edit = new PropertyEditor(p);
                        break;
                    }
                    default: {
                        Object[] peers = new PlotElement[os.size()];
                        os.toArray(peers);
                        edit = PropertyEditor.createPeersEditor(p, peers);
                    }
                }
                edit.showDialog(LayoutPanel.this);
            }
        });
        item.setToolTipText("edit the plot element or elements");
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Edit Plot Element Style Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                PlotElement p = (PlotElement)LayoutPanel.this.plotElementListComponent.getSelectedValue();
                if (os.size() == 1) {
                    LoggerManager.logGuiEvent(e);
                    PlotStylePanel.StylePanel editorPanel = GuiSupport.getStylePanel(p.getRenderType());
                    editorPanel.doElementBindings(p);
                    AutoplotUtil.showMessageDialog(LayoutPanel.this, editorPanel, (Object)((Object)p.getRenderType()) + " Style", 0);
                } else if (os.size() > 1) {
                    Object[] peers = new PlotElementStyle[os.size()];
                    for (int i = 0; i < os.size(); ++i) {
                        peers[i] = ((PlotElement)os.get(i)).getStyle();
                    }
                    PropertyEditor edit = PropertyEditor.createPeersEditor(p.getStyle(), peers);
                    edit.showDialog(LayoutPanel.this);
                }
            }
        });
        item.setToolTipText("edit the style of plot element or elements");
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot Element"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                for (Object o : os) {
                    PlotElement element = (PlotElement)o;
                    LayoutPanel.this.dom.getController().deletePlotElement(element);
                }
            }
        });
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Move Plot Element Above Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ArrayList<PlotElement> pes = new ArrayList<PlotElement>();
                List os = LayoutPanel.this.plotElementListComponent.getSelectedValuesList();
                for (Object o : os) {
                    PlotElement element = (PlotElement)o;
                    pes.add(element);
                }
                for (PlotElement pe : pes) {
                    Plot p = LayoutPanel.this.dom.getController().getPlotFor(pe);
                    p.getController().toTop(pe);
                }
            }
        });
        plotElementContextMenu.add(item);
        item = new JMenuItem(new AbstractAction("Blur Focus"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                LayoutPanel.this.dom.getController().setPlotElement(null);
                LayoutPanel.this.plotElementListComponent.setSelectedIndices(new int[0]);
            }
        });
        plotElementContextMenu.add(item);
        this.contextMenus.put(this.plotElementListComponent, plotElementContextMenu);
        this.contextMenus.put(this.bindingListComponent, this.bindingActionsMenu);
    }

    private void updateSelected() {
        int[] iindices = this.plotElementListComponent.getSelectedIndices();
        PlotElement[] peles = this.dom.getPlotElements();
        ArrayList<Object> selected = new ArrayList<Object>();
        DasPlot dasPlot = null;
        Plot plot = this.dom.getController().getPlot();
        if (plot != null) {
            dasPlot = plot.getController().getDasPlot();
            selected.add(dasPlot);
            ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>();
            for (int i = 0; i < iindices.length; ++i) {
                try {
                    PlotElementController pec = peles[iindices[i]].getController();
                    selected.add(pec.getRenderer());
                    dsfs.add((DataSourceFilter)DomUtil.getElementById(this.dom, pec.getPlotElement().getDataSourceFilterId()));
                    if (dsfs.size() <= 0) continue;
                    this.dataSourceList.setSelectedValue(dsfs.get(0), true);
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    System.err.println("harmless indexOutOfBoundsException needs to be fixed sometime");
                }
            }
        }
        this.updateDataSourceList();
        this.canvasLayoutPanel1.setSelectedComponents(selected);
        this.canvasLayoutPanel1.setComponent(dasPlot);
        this.deletePlotAction.setEnabled(true);
        this.tallerButton.setEnabled(true);
        this.shorterButton.setEnabled(true);
        this.sameHeightButton.setEnabled(true);
    }

    public void setApplication(Application app) {
        this.dom = app;
        this.updatePlotElementList();
        this.updateBindingList();
        this.updateDataSourceList();
        this.canvasLayoutPanel1.setContainer(app.getController().getDasCanvas());
        this.canvasLayoutPanel1.addComponentType(DasPlot.class, Color.BLUE);
        app.getController().bind(app.getOptions(), "background", this.canvasLayoutPanel1, "background");
        app.addPropertyChangeListener("plotElements", this.plotElementsListener);
        app.addPropertyChangeListener("bindings", this.bindingsListener);
        app.addPropertyChangeListener("dataSourceFilters", this.dataSourcesListener);
        app.getController().addPropertyChangeListener("plot", this.plotListener);
        app.getController().addPropertyChangeListener("plotElement", this.plotElementListener);
        for (DataSourceFilter dsf : this.dom.getDataSourceFilters()) {
            dsf.addPropertyChangeListener("uri", this.dataSourceListener);
            dsf.getController().addPropertyChangeListener("tsb", this.dataSourceListener);
        }
    }

    private void updatePlotElementListImmediately() {
        final Object[] foo = this.dom.getPlotElements();
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return foo.length;
            }

            @Override
            public Object getElementAt(int index) {
                return foo[index];
            }
        };
        this.plotElementListComponent.setModel(elementsList);
        this.plotElementListComponent.setCellRenderer(this.myListCellRenderer);
    }

    private void updatePlotElementList() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LayoutPanel.this.updatePlotElementListImmediately();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private static List getSublist(List list, Comparator c, Object equalTo) {
        ArrayList result = new ArrayList(list.size());
        for (Object o : list) {
            if (c.compare(o, equalTo) != 0) continue;
            result.add(o);
        }
        return result;
    }

    private void updateBindingList() {
        final ArrayList<BindingModel> bindingList = new ArrayList<BindingModel>(Arrays.asList(this.dom.getBindings()));
        List rm = LayoutPanel.getSublist(bindingList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((BindingModel)o1).getDstProperty().equals("colortable") ? 0 : 1;
            }
        }, null);
        bindingList.removeAll(rm);
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return bindingList.size();
            }

            @Override
            public Object getElementAt(int index) {
                return bindingList.get(index);
            }
        };
        this.bindingListComponent.setModel(elementsList);
        this.bindingListComponent.repaint();
    }

    private void updateDataSourceList() {
        final ArrayList<DataSourceFilter> list = new ArrayList<DataSourceFilter>(Arrays.asList(this.dom.getDataSourceFilters()));
        AbstractListModel elementsList = new AbstractListModel(){

            @Override
            public int getSize() {
                return list.size();
            }

            @Override
            public Object getElementAt(int index) {
                return list.get(index);
            }
        };
        this.dataSourceList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                DataSourceFilter dsf = (DataSourceFilter)value;
                if (dsf.getController().getTsb() != null) {
                    l.setIcon(new ImageIcon(LayoutPanel.class.getResource("/resources/blue.gif")));
                    l.setToolTipText("<html>" + dsf.getUri() + "<br>Data source provides Time Series Browsing");
                } else {
                    l.setIcon(new ImageIcon(LayoutPanel.class.getResource("/org/autoplot/resources/idle-icon.png")));
                    if (dsf.getUri().length() == 0) {
                        l.setToolTipText(null);
                    } else {
                        l.setToolTipText("<html>" + dsf.getUri());
                    }
                }
                return l;
            }
        });
        this.dataSourceList.setModel(elementsList);
        this.dataSourceList.repaint();
    }

    public List<Plot> getSelectedPlots() {
        Plot domPlot;
        List<Object> os = this.canvasLayoutPanel1.getSelectedComponents();
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Object o : os) {
            if (this.dom.getPlots().length <= 1) continue;
            Plot domPlot2 = null;
            if (o instanceof Component) {
                domPlot2 = this.dom.getController().getPlotFor((Component)o);
            }
            if (domPlot2 == null) continue;
            result.add(domPlot2);
        }
        Object o = this.canvasLayoutPanel1.getComponent();
        if (o instanceof Component && (domPlot = this.dom.getController().getPlotFor((Component)o)) != null) {
            result.remove(domPlot);
            result.add(0, domPlot);
        }
        return result;
    }

    private void initComponents() {
        this.plotActionsMenu = new JPopupMenu();
        this.plotMenu = new JMenu();
        this.propertiesMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem(this.deletePlotAction);
        this.addPlotsBelowMenuItem = new JMenuItem(this.addPlotsAction);
        this.removeBindingsMenuItem = new JMenuItem(this.removeBindingsAction);
        this.plotsMenu = new JMenu();
        this.sizeMenu = new JMenu();
        this.biggerMI = new JMenuItem();
        this.smallerMI = new JMenuItem();
        this.sameSizeMI = new JMenuItem();
        this.swapMenuItem = new JMenuItem();
        this.addHiddenMenuItem = new JMenuItem();
        this.bindingActionsMenu = new JPopupMenu();
        this.deleteBindingsMenuItem = new JMenuItem();
        this.jScrollPane3 = new JScrollPane();
        this.jTable1 = new JTable();
        this.dataSourceActionsMenu = new JPopupMenu();
        this.editMenuItem = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jSplitPane3 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.plotElementListComponent = new JList();
        this.jPanel4 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.dataSourceList = new JList();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.canvasLayoutPanel1 = new CanvasLayoutPanel();
        this.tallerButton = new JButton();
        this.shorterButton = new JButton();
        this.sameHeightButton = new JButton();
        this.addPlotsButton = new JButton();
        this.fixLayoutButton = new JButton();
        this.deletePlotButton = new JButton();
        this.selectedPlotLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.bindingListComponent = new JList();
        this.plotMenu.setText("Plot");
        this.propertiesMenuItem.setText("Properties...");
        this.propertiesMenuItem.setToolTipText("edit plot properties");
        this.propertiesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.propertiesMenuItemActionPerformed(evt);
            }
        });
        this.plotMenu.add(this.propertiesMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.plotMenu.add(this.deleteMenuItem);
        this.addPlotsBelowMenuItem.setText("Add Plots...");
        this.addPlotsBelowMenuItem.setToolTipText("Add a grid of plots below or above the selected plot");
        this.addPlotsBelowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.addPlotsBelowMenuItemActionPerformed(evt);
            }
        });
        this.plotMenu.add(this.addPlotsBelowMenuItem);
        this.removeBindingsMenuItem.setText("Remove Bindings");
        this.removeBindingsMenuItem.setToolTipText("Remove bindings to other parts of the application");
        this.plotMenu.add(this.removeBindingsMenuItem);
        this.plotActionsMenu.add(this.plotMenu);
        this.plotsMenu.setText("Canvas");
        this.sizeMenu.setText("Plot Size");
        this.sizeMenu.setToolTipText("Adjust the selected plots' size");
        this.biggerMI.setText("Taller");
        this.biggerMI.setToolTipText("Make the selected plots 25% taller relative to others");
        this.biggerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.biggerMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.biggerMI);
        this.smallerMI.setText("Shorter");
        this.smallerMI.setToolTipText("Make the selected plots 25% shorter relative to others");
        this.smallerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.smallerMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.smallerMI);
        this.sameSizeMI.setText("Same Height");
        this.sameSizeMI.setToolTipText("Make the selected plots have the same height");
        this.sameSizeMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.sameSizeMIActionPerformed(evt);
            }
        });
        this.sizeMenu.add(this.sameSizeMI);
        this.plotsMenu.add(this.sizeMenu);
        this.swapMenuItem.setText("Swap Position");
        this.swapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.swapMenuItemActionPerformed(evt);
            }
        });
        this.plotsMenu.add(this.swapMenuItem);
        this.addHiddenMenuItem.setText("Add Hidden Plot...");
        this.addHiddenMenuItem.setToolTipText("Add hidden plot for this plot/plots to bind plots together.\n");
        this.addHiddenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.addHiddenMenuItemActionPerformed(evt);
            }
        });
        this.plotsMenu.add(this.addHiddenMenuItem);
        this.plotActionsMenu.add(this.plotsMenu);
        this.bindingActionsMenu.setToolTipText("Binding actions");
        this.deleteBindingsMenuItem.setText("Delete Selected Bindings");
        this.deleteBindingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.deleteBindingsMenuItemActionPerformed(evt);
            }
        });
        this.bindingActionsMenu.add(this.deleteBindingsMenuItem);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.jTable1);
        this.editMenuItem.setText("Edit");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.editMenuItemActionPerformed(evt);
            }
        });
        this.dataSourceActionsMenu.add(this.editMenuItem);
        this.jSplitPane1.setDividerLocation(330);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Plot Elements [?]"));
        this.jPanel2.setToolTipText("List of plot elements (renderings of data) on the canvas");
        this.jSplitPane3.setDividerLocation(370);
        this.jSplitPane3.setOrientation(0);
        this.plotElementListComponent.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.plotElementListComponent.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LayoutPanel.this.plotElementListComponentValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.plotElementListComponent);
        this.jSplitPane3.setTopComponent(this.jScrollPane1);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Data Sources"));
        this.dataSourceList.setFont(this.dataSourceList.getFont().deriveFont((float)this.dataSourceList.getFont().getSize() - 2.0f));
        this.dataSourceList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.dataSourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LayoutPanel.this.dataSourceListValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.dataSourceList);
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jScrollPane4, -1, 343, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane4, -1, 63, Short.MAX_VALUE));
        this.jSplitPane3.setRightComponent(this.jPanel4);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jSplitPane3));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jSplitPane3, -1, 461, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jSplitPane2.setDividerLocation(370);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plots [?]"));
        this.jPanel1.setToolTipText("<html>Layout of plots on the canvas<br>Click for help");
        this.jPanel1.setMinimumSize(new Dimension(230, 230));
        this.canvasLayoutPanel1.setText("canvasLayoutPanel1");
        this.tallerButton.setText("Taller");
        this.tallerButton.setToolTipText("Make the selected plots taller");
        this.tallerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.tallerButtonActionPerformed(evt);
            }
        });
        this.shorterButton.setText("Shorter");
        this.shorterButton.setToolTipText("Make the selected plots shorter");
        this.shorterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.shorterButtonActionPerformed(evt);
            }
        });
        this.sameHeightButton.setText("Same Height");
        this.sameHeightButton.setToolTipText("Make the selected plots the same height");
        this.sameHeightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.sameHeightButtonActionPerformed(evt);
            }
        });
        this.addPlotsButton.setAction(this.addPlotsAction);
        this.addPlotsButton.setText("Add Plots...");
        this.addPlotsButton.setToolTipText("Add plots around the focus plot");
        this.fixLayoutButton.setText("Fix Layout");
        this.fixLayoutButton.setToolTipText("Remove gaps and overlaps in vertical stack of plots");
        this.fixLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.fixLayoutButtonActionPerformed(evt);
            }
        });
        this.deletePlotButton.setAction(this.deletePlotAction);
        this.deletePlotButton.setText("Delete Plots");
        this.deletePlotButton.setToolTipText("Delete the selected plot(s)");
        this.deletePlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutPanel.this.deletePlotButtonActionPerformed(evt);
            }
        });
        this.selectedPlotLabel.setFont(this.selectedPlotLabel.getFont().deriveFont((float)this.selectedPlotLabel.getFont().getSize() - 2.0f));
        this.selectedPlotLabel.setText(" ");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.tallerButton, -1, -1, Short.MAX_VALUE).add((Component)this.shorterButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.sameHeightButton, -2, 1, Short.MAX_VALUE).add((Component)this.fixLayoutButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.addPlotsButton, -1, -1, Short.MAX_VALUE).add((Component)this.deletePlotButton, -2, 1, Short.MAX_VALUE)).add(8, 8, 8)).add((Component)this.canvasLayoutPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.selectedPlotLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.canvasLayoutPanel1, -1, 266, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.selectedPlotLabel).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.tallerButton).add((Component)this.addPlotsButton).add((Component)this.sameHeightButton)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.fixLayoutButton).add((Component)this.shorterButton).add((Component)this.deletePlotButton))));
        this.jSplitPane2.setTopComponent(this.jPanel1);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Bindings [?]"));
        this.jPanel3.setToolTipText("List of connections between DOM properties");
        this.bindingListComponent.setFont(this.bindingListComponent.getFont().deriveFont((float)this.bindingListComponent.getFont().getSize() - 2.0f));
        this.bindingListComponent.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.bindingListComponent);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 329, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (Component)this.jScrollPane2, -1, 82, Short.MAX_VALUE));
        this.jSplitPane2.setRightComponent(this.jPanel3);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1, -1, 718, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1));
    }

    private void propertiesMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        DasPlot component = (DasPlot)this.canvasLayoutPanel1.getComponent();
        Plot domPlot = this.dom.getController().getPlotFor(component);
        if (domPlot == null) {
            this.dom.getController().setStatus("warning: nothing selected");
            return;
        }
        List<Object> components = this.canvasLayoutPanel1.getSelectedComponents();
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (int i = 0; i < components.size(); ++i) {
            if (!(components.get(i) instanceof Component)) continue;
            plots.add(this.dom.getController().getPlotFor((Component)components.get(i)));
        }
        if (plots.size() > 1) {
            PropertyEditor edit = PropertyEditor.createPeersEditor(domPlot, plots.toArray());
            edit.showDialog(this);
        } else {
            PropertyEditor edit = new PropertyEditor(domPlot);
            edit.showDialog(this);
        }
    }

    private void swapMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        List<Plot> plots = this.getSelectedPlots();
        if (plots.size() == 2) {
            DomOps.swapPosition(plots.get(0), plots.get(1));
            if (this.dom.getOptions().isAutolayout()) {
                DomOps.newCanvasLayout(this.dom);
            }
            this.dom.getController().setStatus("swapped " + plots.get(0) + " and " + plots.get(1));
        } else {
            this.dom.getController().setStatus("warning: select two plots");
        }
    }

    private void addPlotsBelowMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHiddenMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        BindToHiddenDialog dia = new BindToHiddenDialog();
        int op = JOptionPane.showConfirmDialog(this, dia, "Add hidden plot for binding", 2, -1);
        if (op == 0) {
            String lock = "Add hidden plot";
            List<Plot> plots = this.getSelectedPlots();
            if (plots.isEmpty()) {
                return;
            }
            this.dom.getController().registerPendingChange(this, "Add hidden plot");
            try {
                Object range;
                this.dom.getController().performingChange(this, "Add hidden plot");
                Column col = DomOps.getOrCreateSelectedColumn(this.dom, this.getSelectedPlots(), true);
                Row row = DomOps.getOrCreateSelectedRow(this.dom, this.getSelectedPlots(), true);
                Plot p = this.dom.getController().addPlot(row, col);
                PlotElement pe = this.dom.getController().addPlotElement(p, null);
                pe.setActive(false);
                p.setVisible(false);
                p.getXaxis().setVisible(false);
                p.getYaxis().setVisible(false);
                Plot[] bottomTopPlots = DomOps.bottomAndTopMostPlot(this.dom, plots);
                if (dia.getCondenseColorBarsCB().isSelected()) {
                    p.getZaxis().setVisible(true);
                    for (Plot p1 : plots) {
                        p1.getZaxis().setVisible(false);
                    }
                    p.getZaxis().setVisible(true);
                } else {
                    p.getZaxis().setVisible(false);
                }
                if (dia.getxAxisCB().isSelected()) {
                    range = this.getSelectedPlots().get(0).getXaxis().getRange();
                    boolean log = this.getSelectedPlots().get(0).getXaxis().isLog();
                    for (Plot p1 : this.getSelectedPlots()) {
                        range = DatumRangeUtil.union((DatumRange)range, p1.getXaxis().getRange());
                        log = log && p1.getXaxis().isLog();
                    }
                    for (Plot p1 : this.getSelectedPlots()) {
                        BindingModel check;
                        p.getXaxis().setRange((DatumRange)range);
                        if (!log) {
                            p1.getXaxis().setLog(log);
                        }
                        if ((check = this.dom.getController().findBinding(this.dom, "timeRange", p1.getXaxis(), "range")) != null) {
                            this.dom.getController().bind(this.dom, "timeRange", p.getXaxis(), "range");
                        } else {
                            this.dom.getController().bind(p.getXaxis(), "range", p1.getXaxis(), "range");
                        }
                        p.getXaxis().setLog(log);
                        this.dom.getController().bind(p.getXaxis(), "log", p1.getXaxis(), "log");
                    }
                }
                if (dia.getyAxisCB().isSelected()) {
                    range = this.getSelectedPlots().get(0).getYaxis().getRange();
                    boolean log = this.getSelectedPlots().get(0).getYaxis().isLog();
                    for (Plot p1 : this.getSelectedPlots()) {
                        range = DatumRangeUtil.union((DatumRange)range, p1.getYaxis().getRange());
                        log = log && p1.getYaxis().isLog();
                    }
                    for (Plot p1 : this.getSelectedPlots()) {
                        p.getYaxis().setRange((DatumRange)range);
                        if (!log) {
                            p1.getYaxis().setLog(log);
                        }
                        this.dom.getController().bind(p.getYaxis(), "range", p1.getYaxis(), "range");
                        p.getYaxis().setLog(log);
                        this.dom.getController().bind(p.getYaxis(), "log", p1.getYaxis(), "log");
                    }
                }
                if (dia.getzAxisCB().isSelected()) {
                    range = this.getSelectedPlots().get(0).getZaxis().getRange();
                    boolean log = this.getSelectedPlots().get(0).getZaxis().isLog();
                    for (Plot p1 : this.getSelectedPlots()) {
                        range = DatumRangeUtil.union((DatumRange)range, p1.getZaxis().getRange());
                        log = log && p1.getZaxis().isLog();
                    }
                    for (Plot p1 : this.getSelectedPlots()) {
                        p.getZaxis().setRange((DatumRange)range);
                        if (!log) {
                            p1.getZaxis().setLog(log);
                        }
                        this.dom.getController().bind(p.getZaxis(), "range", p1.getZaxis(), "range");
                        p.getZaxis().setLog(log);
                        this.dom.getController().bind(p.getZaxis(), "log", p1.getZaxis(), "log");
                    }
                }
                if (dia.getCondenseColorBarsCB().isSelected()) {
                    for (Plot p1 : this.getSelectedPlots()) {
                        this.dom.getController().bind(p, "colortable", p1, "colortable");
                    }
                }
                if (dia.getCondenseXAxisLabelsCB().isSelected()) {
                    String t = plots.get(0).getTitle();
                    for (Plot p1 : this.getSelectedPlots()) {
                        p1.getXaxis().setDrawTickLabels(false);
                        p1.getXaxis().setLabel("");
                        p1.setTitle("");
                        Row r = this.dom.getCanvases(0).getController().getRowFor(p1);
                        r.setTop(r.getTop().replaceAll("(.*)\\+([\\d\\.]+)em(.*)", "$1+0.5em"));
                        r.setBottom(r.getBottom().replaceAll("(.*)\\-([\\d\\.]+)em", "$1-0.5em"));
                    }
                    bottomTopPlots[1].setTitle(t);
                    bottomTopPlots[0].getXaxis().setDrawTickLabels(true);
                    row.setTop(row.getTop().replaceAll("(.*)\\+([\\d\\.]+)em(.*)", "$1+0.5em"));
                    row.setBottom(row.getBottom().replaceAll("(.*)\\-([\\d\\.]+)em", "$1-0.5em"));
                }
            }
            finally {
                this.dom.getController().changePerformed(this, "Add hidden plot");
            }
        }
    }

    private void deleteBindingsMenuItemActionPerformed(ActionEvent evt) {
        Object[] bindings;
        LoggerManager.logGuiEvent(evt);
        for (Object o : bindings = this.bindingListComponent.getSelectedValues()) {
            BindingModel b = (BindingModel)o;
            this.dom.getController().deleteBinding(b);
        }
    }

    private void plotElementListComponentValueChanged(ListSelectionEvent evt) {
        logger.log(Level.FINE, "panelListComponentValueChanged {0}", evt.getValueIsAdjusting());
        if (!evt.getValueIsAdjusting()) {
            this.updateSelected();
        }
    }

    private void fixLayout(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        DomOps.newCanvasLayout(this.dom);
    }

    private void biggerMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        for (Row r : rows) {
            try {
                double[] d1 = DasDevicePosition.parseLayoutStr(r.getTop());
                double[] d2 = DasDevicePosition.parseLayoutStr(r.getBottom());
                d2[0] = d1[0] + (d2[0] - d1[0]) * 1.25;
                r.setBottom(DasDevicePosition.formatFormatStr(d2));
            }
            catch (ParseException ex) {
                logger.info("ParseException ignored");
            }
        }
        if (this.dom.getOptions().isAutolayout()) {
            DomOps.newCanvasLayout(this.dom);
        }
    }

    private void sameSizeMIActionPerformed(ActionEvent evt) {
        double[] d2;
        double[] d1;
        LoggerManager.logGuiEvent(evt);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        double size = 0.0;
        double emMaxTop = 0.0;
        double emMaxBottom = 0.0;
        int n = 0;
        for (Row r : rows) {
            try {
                d1 = DasDevicePosition.parseLayoutStr(r.getTop());
                d2 = DasDevicePosition.parseLayoutStr(r.getBottom());
                size += d2[0] - d1[0];
                emMaxBottom = Math.max(emMaxBottom, d2[1]);
                emMaxTop = Math.max(emMaxTop, d2[1]);
                ++n;
            }
            catch (ParseException ex) {
                logger.info("ParseException ignored");
            }
        }
        size /= (double)n;
        for (Row r : rows) {
            try {
                d1 = DasDevicePosition.parseLayoutStr(r.getTop());
                d2 = DasDevicePosition.parseLayoutStr(r.getBottom());
                d2[0] = d1[0] + size;
                d2[1] = emMaxBottom;
                d1[1] = emMaxTop;
                r.setBottom(DasDevicePosition.formatFormatStr(d2));
                r.setTop(DasDevicePosition.formatFormatStr(d1));
            }
            catch (ParseException parseException) {}
        }
        if (this.dom.getOptions().isAutolayout()) {
            DomOps.newCanvasLayout(this.dom);
        }
    }

    private void smallerMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Plot p1 : this.getSelectedPlots()) {
            Row row;
            if (!p1.isVisible() || rows.contains(row = p1.getController().getRow())) continue;
            rows.add(row);
        }
        for (Row r : rows) {
            try {
                double[] d1 = DasDevicePosition.parseLayoutStr(r.getTop());
                double[] d2 = DasDevicePosition.parseLayoutStr(r.getBottom());
                d2[0] = d1[0] + (d2[0] - d1[0]) * 0.8;
                r.setBottom(DasDevicePosition.formatFormatStr(d2));
            }
            catch (ParseException ex) {
                logger.info("ParseException ignored");
            }
        }
        if (this.dom.getOptions().isAutolayout()) {
            DomOps.newCanvasLayout(this.dom);
        }
    }

    private void deletePlotButtonActionPerformed(ActionEvent evt) {
    }

    private void sameHeightButtonActionPerformed(ActionEvent evt) {
        this.sameSizeMIActionPerformed(evt);
    }

    private void shorterButtonActionPerformed(ActionEvent evt) {
        this.smallerMIActionPerformed(evt);
    }

    private void tallerButtonActionPerformed(ActionEvent evt) {
        this.biggerMIActionPerformed(evt);
    }

    private void fixLayoutButtonActionPerformed(ActionEvent evt) {
        this.fixLayout(evt);
    }

    private void dataSourceListValueChanged(ListSelectionEvent evt) {
        String s = this.dataSourceList.getSelectedValue();
        if (s instanceof DataSourceFilter) {
            this.dom.getController().setDataSourceFilter((DataSourceFilter)((Object)s));
            this.dom.getController().setFocusUri(((DataSourceFilter)((Object)s)).getUri());
            List<PlotElement> pes = DomUtil.getPlotElementsFor(this.dom, (DataSourceFilter)((Object)s));
            if (pes.size() > 0 && !pes.contains((PlotElement)this.plotElementListComponent.getSelectedValue())) {
                this.dom.getController().setPlotElement(pes.get(0));
            }
        }
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        String s = this.dataSourceList.getSelectedValue();
        if (s instanceof DataSourceFilter) {
            this.dom.getController().setDataSourceFilter((DataSourceFilter)((Object)s));
            this.dom.getController().setFocusUri(((DataSourceFilter)((Object)s)).getUri());
            String uri = ((DataSourceFilter)((Object)s)).getUri();
            if (uri.startsWith("vap+internal:")) {
                GuiSupport.editPlotElement(this.applicationModel, this);
            } else {
                JPanel parent = new JPanel();
                parent.setLayout(new BorderLayout());
                DataSourceEditorPanel p = DataSourceEditorPanelUtil.getDataSourceEditorPanel(parent, uri);
                if (0 == AutoplotUtil.showConfirmDialog(this, parent, "Edit " + ((DataSourceFilter)((Object)s)).getId(), 2)) {
                    uri = p.getURI();
                    ((DataSourceFilter)((Object)s)).setUri(uri);
                }
            }
        }
    }
}

