/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.autoplot.ApplicationModel;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.CanvasController;
import org.autoplot.layout.LayoutUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.util.LoggerManager;

public class LayoutListener
implements PropertyChangeListener {
    ApplicationModel model;
    Timer t;
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");
    public static final String PENDING_CHANGE_AUTOLAYOUT = "autolayout";

    public LayoutListener(ApplicationModel model) {
        this.model = model;
    }

    public void listenTo(DasPlot plot) {
        plot.addPropertyChangeListener("title", this);
        plot.getXAxis().addPropertyChangeListener("bounds", this);
        plot.getYAxis().addPropertyChangeListener("bounds", this);
        plot.addPropertyChangeListener("legendPosition", this);
    }

    public void listenTo(DasAxis colorbar) {
        colorbar.addPropertyChangeListener("visible", this);
        colorbar.addPropertyChangeListener("bounds", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Canvas canvas = this.model.dom.getController().getCanvas();
        final CanvasController cc = canvas.getController();
        final DasCanvas dasCanvas = cc.getDasCanvas();
        if (this.model.dom.getOptions().isAutolayout() && dasCanvas.getWidth() > 0) {
            logger.log(Level.FINE, "property change: {0}", evt.getPropertyName());
            if (evt.getSource() instanceof Component && ((Component)evt.getSource()).isVisible()) {
                if (this.t == null) {
                    logger.fine("create timer ");
                    this.t = new Timer(100, new ActionListener(){

                        @Override
                        public synchronized void actionPerformed(ActionEvent e) {
                            if (LayoutListener.this.model.dom.getOptions().isAutolayout()) {
                                logger.fine("do autolayout");
                                ApplicationController applicationController = LayoutListener.this.model.getDocumentModel().getController();
                                cc.performingChange(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                dasCanvas.performingChange(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                LayoutUtil.autolayout(dasCanvas, applicationController.getRow(), applicationController.getColumn());
                                dasCanvas.changePerformed(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                cc.changePerformed(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                            } else {
                                dasCanvas.performingChange(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                dasCanvas.changePerformed(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                cc.performingChange(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                                cc.changePerformed(LayoutListener.this, LayoutListener.PENDING_CHANGE_AUTOLAYOUT);
                            }
                        }
                    });
                    this.t.setRepeats(false);
                }
                cc.registerPendingChange(this, PENDING_CHANGE_AUTOLAYOUT);
                dasCanvas.registerPendingChange(this, PENDING_CHANGE_AUTOLAYOUT);
                this.t.restart();
            }
        }
    }
}

