/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import external.AnnotationCommand;
import external.PlotCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.DatasetCommand;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.Util;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.jythonsupport.ui.ScriptPanelSupport;
import org.autoplot.scriptconsole.JythonScriptPanel;
import org.autoplot.scriptconsole.MakeToolPanel;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonUtil {
    private static final Logger logger = LoggerManager.getLogger("autoplot.jython");
    private static final HashMap<String, String> okayed = new HashMap();

    public static InteractiveInterpreter createInterpreter(boolean appContext, boolean sandbox) throws IOException {
        InteractiveInterpreter interp = org.autoplot.jythonsupport.JythonUtil.createInterpreter(sandbox);
        if (Util.isLegacyImports() && appContext) {
            try (InputStream in = JythonUtil.class.getResource("/appContextImports2017.py").openStream();){
                interp.execfile(in, "/appContextImports2017.py");
            }
        }
        interp.set("monitor", (Object)new NullProgressMonitor());
        interp.set("plotx", (PyObject)new PlotCommand());
        interp.set("plot", (PyObject)new PlotCommand());
        interp.set("dataset", (PyObject)new DatasetCommand());
        interp.set("annotation", (PyObject)new AnnotationCommand());
        return interp;
    }

    public static InteractiveInterpreter createInterpreter(boolean appContext, boolean sandbox, Application dom, ProgressMonitor mon) throws IOException {
        InteractiveInterpreter interp = JythonUtil.createInterpreter(appContext, sandbox);
        if (dom != null) {
            interp.set("dom", (Object)dom);
        }
        if (mon != null) {
            interp.set("monitor", (Object)mon);
        } else {
            interp.set("monitor", (Object)new NullProgressMonitor());
        }
        return interp;
    }

    protected static void runScript(ApplicationModel model, String script, String[] argv, String pwd) throws IOException {
        logger.entering("org.autoplot.JythonUtil", "runScript {0}", script);
        URL url = DataSetURI.getURL(script);
        try (InputStream in = url.openStream();){
            JythonUtil.runScript(model, in, script, argv, pwd);
        }
        logger.exiting("org.autoplot.JythonUtil", "runScript {0}", script);
    }

    protected static void runScript(ApplicationModel model, InputStream in, String name, String[] argv, String pwd) throws IOException {
        if (argv == null) {
            argv = new String[]{""};
        }
        PySystemState.initialize((Properties)PySystemState.getBaseProperties(), null, (String[])argv);
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, model.getDocumentModel(), new NullProgressMonitor());
        if (pwd != null) {
            pwd = URISplit.format(URISplit.parse(pwd));
            interp.exec("PWD='" + pwd + "'");
        }
        interp.exec("import autoplot2017 as autoplot");
        int iargv = 0;
        for (String s : argv) {
            int ieq = s.indexOf(61);
            if (ieq > 0) {
                String snam = s.substring(0, ieq).trim();
                if (DataSourceUtil.isJavaIdentifier(snam)) {
                    String sval = s.substring(ieq + 1).trim();
                    interp.exec("autoplot.params['" + snam + "']='" + sval + "'");
                    continue;
                }
                if (snam.startsWith("-")) {
                    System.err.println("\n!!! Script arguments should not start with -, they should be name=value");
                }
                System.err.println("bad parameter: " + snam);
                continue;
            }
            if (iargv >= 0) {
                interp.exec("autoplot.params['arg_" + iargv + "']='" + s + "'");
                ++iargv;
                continue;
            }
            ++iargv;
        }
        if (name == null) {
            interp.execfile(JythonRefactory.fixImports(in));
        } else {
            interp.execfile(JythonRefactory.fixImports(in), name);
        }
    }

    public static void invokeScriptSoon(URL url) throws IOException {
        JythonUtil.invokeScriptSoon(url, null, (ProgressMonitor)new NullProgressMonitor());
    }

    public static void invokeScriptSoon(URI uri) throws IOException {
        JythonUtil.invokeScriptSoon(uri, null, (ProgressMonitor)new NullProgressMonitor());
    }

    public static void invokeScriptSoon(URL url, Application dom, ProgressMonitor mon) throws IOException {
        JythonUtil.invokeScriptSoon(url, dom, new HashMap<String, String>(), false, false, mon);
    }

    public static void invokeScriptSoon(URI uri, Application dom, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        JythonUtil.invokeScriptSoon(split.resourceUri, dom, params, false, false, mon);
    }

    private static boolean isScriptOkayed(String filename, String contents) {
        String okayedContents = okayed.get(filename);
        return contents.equals(okayedContents);
    }

    public static int showScriptDialog(Component parent, Map<String, Object> env, File file, Map<String, String> fparams, boolean makeTool, URI resourceUri) throws IOException {
        if (!EventQueue.isDispatchThread()) {
            System.err.println("*** called from off of event thread!!!");
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        ParametersFormPanel fpf = new ParametersFormPanel();
        ParametersFormPanel.FormData fd = fpf.doVariables(env, file, fparams, p);
        if (fd.count == 0 && !makeTool) {
            return 0;
        }
        JPanel scriptPanel = new JPanel(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        EditorTextPane textArea = new EditorTextPane();
        String theScript = EditorTextPane.loadFileToString(file);
        try {
            textArea.loadFile(file);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        ScriptPanelSupport support = new ScriptPanelSupport(textArea);
        support.setReadOnly();
        JScrollPane script = new JScrollPane(textArea);
        script.setMinimumSize(new Dimension(640, 380));
        script.setPreferredSize(new Dimension(640, 380));
        scriptPanel.add((Component)script, "Center");
        scriptPanel.add((Component)new JLabel("<html>Run the script:<br>" + file), "North");
        MakeToolPanel makeToolPanel = new MakeToolPanel();
        if (makeTool) {
            scriptPanel.add((Component)makeToolPanel, "South");
        }
        tp.add((Component)scriptPanel, "script");
        JScrollPane params = new JScrollPane(p);
        params.setMinimumSize(new Dimension(640, 480));
        tp.add((Component)params, "params");
        if (makeTool) {
            if (JythonUtil.isScriptOkayed(file.toString(), theScript)) {
                tp.setSelectedIndex(1);
                p.add(Box.createGlue());
                JLabel l = new JLabel("You have run this script before.");
                l.setAlignmentX(0.0f);
                p.add(l);
            } else {
                tp.setSelectedIndex(0);
            }
        } else {
            tp.setSelectedIndex(1);
        }
        int result = AutoplotUtil.showConfirmDialog2(parent, tp, "Run Script " + file.getName(), 2);
        if (result == 0) {
            fd = fpf.getFormData();
            ParametersFormPanel.resetVariables(fd, fparams);
            if (makeTool && makeToolPanel.isInstall()) {
                Window w = ScriptContext.getViewWindow();
                if (w instanceof AutoplotUI) {
                    ((AutoplotUI)w).installTool(file, resourceUri);
                    ((AutoplotUI)w).reloadTools();
                } else {
                    throw new RuntimeException("Unable to install");
                }
            }
            okayed.put(file.toString(), theScript);
        }
        return result;
    }

    public static int invokeScriptSoon(URL url, Application dom, Map<String, String> params, boolean askParams, boolean makeTool, ProgressMonitor mon1) throws IOException {
        return JythonUtil.invokeScriptSoon(url, dom, params, askParams, makeTool, null, mon1);
    }

    public static int invokeScriptSoon(URI uri, Application dom, Map<String, String> vars, boolean askParams, boolean makeTool, ProgressMonitor mon1) throws IOException {
        return JythonUtil.invokeScriptSoon(uri, dom, vars, askParams, makeTool, null, mon1);
    }

    public static int invokeScriptSoon(URL url, Application dom, Map<String, String> params, boolean askParams, boolean makeTool, JythonScriptPanel scriptPanel, ProgressMonitor mon1) throws IOException {
        try {
            URI uri = url.toURI();
            return JythonUtil.invokeScriptSoon(uri, dom, params, askParams, makeTool, scriptPanel, mon1);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static int invokeScriptSoon(URI uri, Application dom, Map<String, String> params, boolean askParams, boolean makeTool, JythonScriptPanel scriptPanel, ProgressMonitor mon1) throws IOException {
        if (EventQueue.isDispatchThread()) {
            System.err.println("THIS IS THE EVENT THREAD!");
        }
        File file = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
        return JythonUtil.invokeScriptSoon(uri, file, dom, params, askParams, makeTool, scriptPanel, mon1);
    }

    public static int invokeScriptSoon(final URI uri, final File file, final Application dom, Map<String, String> params, boolean askParams, final boolean makeTool, final JythonScriptPanel scriptPanel, ProgressMonitor mon1) throws IOException {
        ParametersFormPanel.FormData fd;
        final ProgressMonitor mon = mon1 == null ? new NullProgressMonitor() : mon1;
        final Map<String, String> fparams = params == null ? new HashMap<String, String>() : params;
        ParametersFormPanel pfp = new ParametersFormPanel();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("dom", dom);
        URISplit split = URISplit.parse(uri);
        env.put("PWD", split.path);
        int response = 0;
        if (askParams) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("dom", dom);
            args.put("PWD", split.path);
            JPanel paramPanel = new JPanel();
            fd = pfp.doVariables(env, file, params, paramPanel);
            response = JythonUtil.showScriptDialog(dom.getController().getDasCanvas(), args, file, fparams, makeTool, uri);
        } else {
            fd = pfp.doVariables(env, file, params, null);
        }
        if (response == 0) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false, dom, mon);
                        logger.log(Level.FINE, "invokeScriptSoon({0})", uri);
                        for (Map.Entry p : fparams.entrySet()) {
                            try {
                                fd.implement((PythonInterpreter)interp, (String)p.getKey(), (String)p.getValue());
                            }
                            catch (ParseException ex) {
                                logger.log(Level.WARNING, null, ex);
                            }
                        }
                        URISplit split = URISplit.parse(uri);
                        interp.set("dom", (Object)dom);
                        interp.set("PWD", (Object)split.path);
                        if (scriptPanel != null) {
                            if (!scriptPanel.isDirty() && makeTool) {
                                scriptPanel.loadFile(file);
                            }
                            scriptPanel.setRunningScript(file);
                        }
                        try (FileInputStream in = new FileInputStream(file);){
                            interp.execfile(JythonRefactory.fixImports(in), uri.toString());
                        }
                        catch (PyException ex) {
                            if (scriptPanel != null) {
                                try {
                                    scriptPanel.getAnnotationsSupport().annotateError(ex, 0);
                                }
                                catch (BadLocationException ex1) {
                                    logger.log(Level.SEVERE, null, ex1);
                                }
                            }
                            throw ex;
                        }
                        finally {
                            if (!mon.isFinished()) {
                                mon.finished();
                            }
                            if (scriptPanel != null) {
                                scriptPanel.setRunningScript(null);
                            }
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            RequestProcessor.invokeLater(run);
        }
        return response;
    }
}

