/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.state.StatePersistence;
import org.das2.components.DasProgressPanel;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class ImportVapDialog
extends JPanel {
    List<String> dataSets;
    List<JCheckBox> sels;
    public JPanel dataSetsPanel;
    public JLabel jLabel1;

    public ImportVapDialog() {
        this.initComponents();
    }

    public int showDialog(Component parent) {
        return AutoplotUtil.showConfirmDialog(parent, this.sels.toArray(), "Import URIs", 2);
    }

    public void setVap(String vap) throws IOException {
        DasProgressPanel mon = DasProgressPanel.createFramed("loading vap");
        File f = DataSetURI.getFile(DataSetURI.getResourceURI(vap), (ProgressMonitor)mon);
        Application app = (Application)StatePersistence.restoreState(f);
        DataSourceFilter[] dsfs = app.getDataSourceFilters();
        this.dataSets = new ArrayList<String>();
        this.sels = new ArrayList<JCheckBox>();
        for (DataSourceFilter dsf : dsfs) {
            if (dsf.getUri().startsWith("vap+internal")) continue;
            String s = dsf.getUri();
            int i = s.lastIndexOf(47);
            JCheckBox mi = i == -1 ? new JCheckBox("<html>" + s + "</html>") : new JCheckBox("<html>" + s.substring(0, i + 1) + "<br>" + s.substring(i + 1) + "</html>");
            this.sels.add(mi);
            this.dataSets.add(s);
        }
    }

    public List<String> getSelectedURIs() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.sels.size(); ++i) {
            if (!this.sels.get(i).isSelected()) continue;
            result.add(this.dataSets.get(i));
        }
        return result;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataSetsPanel = new JPanel();
        this.jLabel1.setText("Import Datasets:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.dataSetsPanel, -1, 541, Short.MAX_VALUE).add((Component)this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.dataSetsPanel, -1, 609, Short.MAX_VALUE).addContainerGap()));
    }
}

