/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.autoplot.AddAnnotationDialog;
import org.autoplot.AddPlotElementDialog;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.ExportDataBundle;
import org.autoplot.ExportDataPanel;
import org.autoplot.ImportBookmarksGui;
import org.autoplot.ImportVapDialog;
import org.autoplot.PdfOptionsPanel;
import org.autoplot.PlotStylePanel;
import org.autoplot.RenderType;
import org.autoplot.ScriptContext;
import org.autoplot.TcaElementDialog;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Connector;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.OptionsPrefsController;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.layout.LayoutConstants;
import org.autoplot.renderer.BoundsStylePanel;
import org.autoplot.renderer.ColorScatterStylePanel;
import org.autoplot.renderer.ContourStylePanel;
import org.autoplot.renderer.DigitalStylePanel;
import org.autoplot.renderer.EventsStylePanel;
import org.autoplot.renderer.HugeScatterStylePanel;
import org.autoplot.renderer.ImageStylePanel;
import org.autoplot.renderer.InternalStylePanel;
import org.autoplot.renderer.OrbitStylePanel;
import org.autoplot.renderer.PitchAngleDistributionStylePanel;
import org.autoplot.renderer.SeriesStylePanel;
import org.autoplot.renderer.SpectrogramStylePanel;
import org.autoplot.renderer.StackedHistogramStylePanel;
import org.autoplot.state.StatePersistence;
import org.autoplot.transferrable.ImageSelection;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.MouseModule;
import org.das2.event.PointSlopeDragRenderer;
import org.das2.graph.BorderType;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.system.RequestProcessor;
import org.das2.util.Entities;
import org.das2.util.LoggerManager;
import org.das2.util.awt.PdfGraphicsOutput;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.SAXException;

public class GuiSupport {
    private static final Logger logger = LoggerManager.getLogger("autoplot.guisupport");
    AutoplotUI parent;
    private static File currentFile;

    public GuiSupport(AutoplotUI parent) {
        this.parent = parent;
    }

    public void doPasteDataSetURL() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        if (contents == null) {
            logger.fine("contents was null");
            return;
        }
        boolean hasTransferableText = contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        String result = null;
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        if (result != null) {
            this.parent.dataSetSelector.setValue(result);
        }
    }

    public void doCopyDataSetURL() {
        StringSelection stringSelection = new StringSelection(DataSetURI.toUri(this.parent.dataSetSelector.getValue()).toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    public void doCopyDataSetImage() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ImageSelection imageSelection = new ImageSelection();
                DasCanvas c = GuiSupport.this.parent.applicationModel.canvas;
                BufferedImage i = c.getImage(c.getWidth(), c.getHeight());
                imageSelection.setImage(i);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(imageSelection, new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                });
            }
        };
        new Thread(run, "CopyDataSetToClipboardThread").start();
    }

    public static Frame getFrameForComponent(Component parent) {
        if (!(parent instanceof Frame)) {
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return null;
    }

    public static PlotStylePanel.StylePanel getStylePanel(RenderType renderType) {
        JPanel editorPanel;
        if (null == renderType) {
            SeriesStylePanel editorPanel2 = new SeriesStylePanel();
            return editorPanel2;
        }
        switch (renderType) {
            case spectrogram: 
            case nnSpectrogram: {
                editorPanel = new SpectrogramStylePanel();
                break;
            }
            case pitchAngleDistribution: {
                editorPanel = new PitchAngleDistributionStylePanel();
                break;
            }
            case polar: {
                editorPanel = new ColorScatterStylePanel();
                break;
            }
            case hugeScatter: {
                editorPanel = new HugeScatterStylePanel();
                break;
            }
            case colorScatter: {
                editorPanel = new ColorScatterStylePanel();
                break;
            }
            case contour: {
                editorPanel = new ContourStylePanel();
                break;
            }
            case internal: {
                editorPanel = new InternalStylePanel();
                break;
            }
            case bounds: {
                editorPanel = new BoundsStylePanel();
                break;
            }
            case digital: {
                editorPanel = new DigitalStylePanel();
                break;
            }
            case orbitPlot: {
                editorPanel = new OrbitStylePanel();
                break;
            }
            case eventsBar: {
                editorPanel = new EventsStylePanel();
                break;
            }
            case stackedHistogram: {
                editorPanel = new StackedHistogramStylePanel();
                break;
            }
            case image: {
                editorPanel = new ImageStylePanel();
                break;
            }
            default: {
                editorPanel = new SeriesStylePanel();
            }
        }
        return editorPanel;
    }

    public static void editPlotElement(ApplicationModel applicationModel, Component parent) {
        Application dom = applicationModel.dom;
        AddPlotElementDialog dia = new AddPlotElementDialog(GuiSupport.getFrameForComponent(parent), true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String suri = dom.getController().getFocusUri();
        GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, suri);
        dia.setTitle("Editing Plot Element");
        WindowManager.getInstance().showModalDialog(dia);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    private static void setAddPlotElementUris(ApplicationModel applicationModel, Application dom, AddPlotElementDialog dia, String suri) {
        Pattern hasKidsPattern = Pattern.compile("vap\\+internal\\:(data_\\d+)(,(data_\\d+))?+(,(data_\\d+))?+");
        Matcher m = hasKidsPattern.matcher(suri);
        dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        if (m.matches()) {
            int[] groups;
            int depCount = m.group(5) != null ? 2 : (m.group(3) != null ? 1 : (m.group(1) != null ? 0 : -1));
            dia.setDepCount(depCount);
            DataSetSelector[] selectors = new DataSetSelector[]{dia.getPrimaryDataSetSelector(), dia.getSecondaryDataSetSelector(), dia.getTertiaryDataSetSelector()};
            switch (depCount) {
                case 2: {
                    groups = new int[]{5, 1, 3};
                    break;
                }
                case 1: {
                    groups = new int[]{3, 1};
                    break;
                }
                default: {
                    groups = new int[]{1};
                }
            }
            for (int i = 0; i < groups.length; ++i) {
                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, m.group(groups[i]));
                if (dsf == null) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                if (dsf.getUri().length() == 0) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                if (dsf.getUri().startsWith("vap+internal:")) {
                    selectors[i].setValue(m.group(groups[i]));
                    continue;
                }
                selectors[i].setValue(dsf.getUri());
                dia.setFilter(i, dsf.getFilters());
            }
        } else {
            dia.getPrimaryDataSetSelector().setValue(suri);
        }
    }

    void addPlotElement(String title) {
        ApplicationModel applicationModel = this.parent.applicationModel;
        DataSetSelector dataSetSelector = this.parent.dataSetSelector;
        Application dom = applicationModel.dom;
        AddPlotElementDialog dia = new AddPlotElementDialog((Frame)this.parent, true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String val = dataSetSelector.getValue();
        if (val.startsWith("vap+internal:")) {
            GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, val);
        } else {
            dia.getPrimaryDataSetSelector().setValue(val);
            dia.getSecondaryDataSetSelector().setValue(val);
            dia.getTertiaryDataSetSelector().setValue(val);
            dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        }
        if (title == null) {
            title = "Adding Plot Element";
        }
        dia.setTitle(title);
        WindowManager.getInstance().showModalDialog(dia);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    void addPlotElementFromBookmark(String title, String furi) {
        DatumRange dr;
        DataSourceFactory factory = null;
        try {
            factory = DataSetURI.getDataSourceFactory(DataSetURI.getURI(furi), new NullProgressMonitor());
        }
        catch (IOException | IllegalArgumentException | URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        assert (factory != null);
        TimeSeriesBrowse tsb = factory.getCapability(TimeSeriesBrowse.class);
        DatumRange uriRange = null;
        if (tsb != null) {
            try {
                tsb.setURI(furi);
                uriRange = tsb.getTimeRange();
            }
            catch (ParseException ex) {
                Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Application dom = this.parent.getDocumentModel();
        String uri = furi;
        if (dom.getTimeRange() != Application.DEFAULT_TIME_RANGE && !dom.getTimeRange().equals(uriRange) && (dr = DataSetSelector.pickTimeRange((Component)this.parent, Arrays.asList(dom.getTimeRange(), uriRange), Arrays.asList("Current", "URI"))) != uriRange) {
            try {
                uri = DataSourceUtil.setTimeRange(uri, dom.getTimeRange(), new NullProgressMonitor());
            }
            catch (IOException | URISyntaxException | ParseException ex) {
                Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ApplicationModel applicationModel = this.parent.applicationModel;
        AddPlotElementDialog dia = new AddPlotElementDialog((Frame)this.parent, true);
        dia.getPrimaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getSecondaryDataSetSelector().setTimeRange(dom.getTimeRange());
        dia.getTertiaryDataSetSelector().setTimeRange(dom.getTimeRange());
        String val = uri;
        if (val.startsWith("vap+internal:")) {
            GuiSupport.setAddPlotElementUris(applicationModel, dom, dia, val);
        } else {
            dia.getPrimaryDataSetSelector().setValue(val);
            dia.getSecondaryDataSetSelector().setValue(val);
            dia.getTertiaryDataSetSelector().setValue(val);
            dia.getPrimaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getSecondaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
            dia.getTertiaryDataSetSelector().setRecent(AutoplotUtil.getUrls(applicationModel.getRecent()));
        }
        if (title == null) {
            title = "Adding Plot Element";
        }
        dia.setTitle(title);
        WindowManager.getInstance().showModalDialog(dia);
        if (dia.isCancelled()) {
            return;
        }
        GuiSupport.handleAddElementDialog(dia, dom, applicationModel);
    }

    private void doDumpData(QDataSet fds, DataSourceFilter dsf, PlotElement pe, DataSourceFormat format, String uriOut, String dscontrol) throws IOException {
        logger.log(Level.FINE, "exporting data to {0} using format {1}", new Object[]{uriOut, format});
        DasProgressPanel mon = null;
        try {
            QDataSet ds = fds;
            if (dsf.getController().getTsb() != null) {
                DataSource dss = dsf.getController().getDataSource();
                if (dss == null) {
                    logger.fine("looks like a TSB is used, but the data is not a time series, don't reload");
                } else {
                    dsf.getController().getTsb().setTimeResolution(null);
                    mon = DasProgressPanel.createFramed(this.parent, "reloading timeseries at native resolution");
                    ds = dss.getDataSet(mon);
                    if (mon.isCancelled()) {
                        this.parent.setStatus("export data cancelled");
                        return;
                    }
                    if (!mon.isFinished()) {
                        mon.finished();
                    }
                }
            }
            mon = DasProgressPanel.createFramed(this.parent, "formatting data");
            switch (dscontrol) {
                case "plotElementTrim": {
                    DasPlot p = pe.getController().getDasPlot();
                    DatumRange xbounds = p.getXAxis().getDatumRange();
                    QDataSet dsout = pe.getController().getDataSet();
                    long t0 = System.currentTimeMillis();
                    if (SemanticOps.isRank2Waveform(dsout)) {
                        dsout = DataSetOps.flattenWaveform(dsout);
                    }
                    dsout = SemanticOps.trim(dsout, xbounds, null);
                    format.formatData(uriOut, dsout, mon);
                    logger.log(Level.FINE, "format in {0} millis", System.currentTimeMillis() - t0);
                    break;
                }
                case "plotElement": {
                    long t0 = System.currentTimeMillis();
                    QDataSet dsout = pe.getController().getDataSet();
                    format.formatData(uriOut, dsout, mon);
                    logger.log(Level.FINE, "format in {0} millis", System.currentTimeMillis() - t0);
                    break;
                }
                default: {
                    long t0 = System.currentTimeMillis();
                    format.formatData(uriOut, ds, mon);
                    logger.log(Level.FINE, "format in {0} millis", System.currentTimeMillis() - t0);
                    break;
                }
            }
            this.parent.setStatus("Wrote " + DataSourceUtil.unescape(uriOut));
        }
        catch (IllegalArgumentException ex) {
            this.parent.applicationModel.getExceptionHandler().handle(ex);
            logger.log(Level.FINE, " ..caused exception: {0} using format {1}", new Object[]{uriOut, format});
            logger.log(Level.SEVERE, "exception " + uriOut, ex);
        }
        catch (RuntimeException ex) {
            this.parent.applicationModel.getExceptionHandler().handleUncaught(ex);
            logger.log(Level.FINE, " ..caused exception: {0} using format {1}", new Object[]{uriOut, format});
            logger.log(Level.SEVERE, "exception " + uriOut, ex);
        }
        catch (Exception ex) {
            this.parent.applicationModel.getExceptionHandler().handle(ex);
            logger.log(Level.FINE, " ..caused exception: {0} using format {1}", new Object[]{uriOut, format});
            logger.log(Level.SEVERE, "exception " + uriOut, ex);
        }
        if (mon != null && !mon.isFinished()) {
            mon.finished();
        }
    }

    Action getDumpDataAction(final Application dom) {
        return new AbstractAction("Export Data..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ExportDataPanel edp = new ExportDataPanel();
                edp.setDataSet(dom);
                final PlotElement pe = dom.getController().getPlotElement();
                final DataSourceFilter dsf = dom.getController().getDataSourceFilterFor(pe);
                QDataSet ds = dsf.getController().getDataSet();
                if (ds == null) {
                    JOptionPane.showMessageDialog(GuiSupport.this.parent, "No Data to Export.");
                    return;
                }
                List<String> exts = DataSourceRegistry.getInstance().getFormatterExtensions();
                Collections.sort(exts);
                edp.getFormatDL().setModel(new DefaultComboBoxModel<Object>(exts.toArray()));
                edp.getFormatDL().setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        String ext = String.valueOf(value);
                        DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                        Component parent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        if (parent instanceof JLabel && format != null) {
                            ((JLabel)parent).setText(value.toString() + " " + format.getDescription());
                        }
                        return parent;
                    }
                });
                Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
                String currentFileString = prefs.get("ExportDataCurrentFile", "");
                String currentExtString = prefs.get("ExportDataCurrentExt", ".txt");
                if (!currentExtString.equals("")) {
                    edp.getFormatDL().setSelectedItem(currentExtString);
                }
                if (!currentFileString.equals("")) {
                    URISplit split = URISplit.parse(currentFileString);
                    edp.getFilenameTF().setText(split.file);
                    edp.getFormatDL().setSelectedItem("." + split.ext);
                    if (currentFileString.contains("/") && (currentFileString.startsWith("file:") || currentFileString.startsWith("/"))) {
                        edp.setFile(currentFileString);
                        if (split.params != null && edp.getDataSourceFormatEditorPanel() != null) {
                            edp.getDataSourceFormatEditorPanel().setURI(currentFileString);
                        }
                    }
                }
                if (dsf.getController().getTsb() != null) {
                    edp.setTsb(true);
                }
                if (AutoplotUtil.showConfirmDialog2(GuiSupport.this.parent, edp, "Export Data", 2) == 0) {
                    try {
                        String formatControl;
                        String file;
                        String name = edp.getFilenameTF().getText();
                        String ext = edp.getExtension();
                        try {
                            file = edp.getFilename();
                        }
                        catch (IllegalArgumentException ex) {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, ex.getMessage());
                            return;
                        }
                        if (ext == null) {
                            ext = "";
                        }
                        URISplit split = URISplit.parse(file);
                        DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                        if (format == null) {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, "No formatter for extension: " + ext);
                            return;
                        }
                        String s = URISplit.format(split);
                        final DataSourceFormat formata = DataSetURI.getDataSourceFormat(new URI(s));
                        DataSourceFormatEditorPanel opts = edp.getDataSourceFormatEditorPanel();
                        if (opts != null) {
                            URISplit splitopts = URISplit.parse(opts.getURI());
                            if (splitopts.params != null && splitopts.params.length() == 0) {
                                splitopts.params = null;
                            }
                            URISplit splits = URISplit.parse(s);
                            splitopts.file = splits.file;
                            s = URISplit.format(splitopts);
                            name = DataSourceUtil.unescape(s);
                        }
                        prefs.put("ExportDataCurrentFile", name);
                        prefs.put("ExportDataCurrentExt", ext);
                        final QDataSet fds = ds;
                        final String uriOut = s;
                        if (edp.isFormatPlotElement()) {
                            formatControl = "plotElement";
                        } else if (edp.isFormatPlotElementAndTrim()) {
                            formatControl = "plotElementTrim";
                        } else if (edp.isOriginalData()) {
                            formatControl = "dataSourceFilter";
                        } else {
                            JOptionPane.showMessageDialog(GuiSupport.this.parent, "Selected data cannot be exported to this format " + ext);
                            return;
                        }
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GuiSupport.this.doDumpData(fds, dsf, pe, formata, uriOut, formatControl);
                                }
                                catch (IOException ex) {
                                    GuiSupport.this.parent.applicationModel.getExceptionHandler().handle(ex);
                                }
                            }
                        };
                        new Thread(run).start();
                    }
                    catch (HeadlessException | IllegalArgumentException | URISyntaxException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handle(ex);
                    }
                    catch (RuntimeException ex) {
                        GuiSupport.this.parent.applicationModel.getExceptionHandler().handleUncaught(ex);
                    }
                }
            }
        };
    }

    Action getDumpAllDataAction(final Application dom) {
        return new AbstractAction("Export All Data..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ExportDataBundle edw = new ExportDataBundle();
                ArrayList<String> uris = new ArrayList<String>();
                for (DataSourceFilter dsf : dom.getDataSourceFilters()) {
                    uris.add(dsf.getUri());
                }
                edw.setUris(uris.toArray(new String[uris.size()]));
                if (JOptionPane.showConfirmDialog(GuiSupport.this.parent, edw, "export all", 2) == 0) {
                    try {
                        ScriptContext.formatDataSet(edw.getDataSet(), edw.getUri());
                        GuiSupport.this.parent.setStatus("Wrote " + DataSourceUtil.unescape(edw.getUri()));
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
    }

    public Action createNewDOMAction() {
        return new AbstractAction("Reset Window..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg;
                int result;
                LoggerManager.logGuiEvent(e);
                if (GuiSupport.this.parent.stateSupport.isDirty() && ((result = JOptionPane.showConfirmDialog(GuiSupport.this.parent, msg = "The application has been modified.  Do you want to save your changes?", "Application Modified", 1, -1)) == 0 ? (result = GuiSupport.this.parent.stateSupport.saveAs()) == 1 : result == 2 || result == -1)) {
                    return;
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        GuiSupport.this.parent.dom.getController().reset();
                        GuiSupport.this.parent.undoRedoSupport.resetHistory();
                        GuiSupport.this.parent.applicationModel.setVapFile(null);
                        GuiSupport.this.parent.stateSupport.close();
                        GuiSupport.this.parent.tickleTimer.tickle();
                    }
                };
                new Thread(run).start();
            }
        };
    }

    ApplicationModel newApplication() {
        final ApplicationModel model = new ApplicationModel();
        model.setExceptionHandler(this.parent.applicationModel.getExceptionHandler());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                model.addDasPeersToApp();
                model.dom.getOptions().setDataVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isDataVisible());
                model.dom.getOptions().setLayoutVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isLayoutVisible());
                AutoplotUI view = new AutoplotUI(model);
                view.setLocationRelativeTo(GuiSupport.this.parent);
                view.setDefaultCloseOperation(2);
                Point p = view.getLocation();
                p.translate(20, 20);
                view.setLocation(p);
                view.setVisible(true);
                OptionsPrefsController opc = new OptionsPrefsController(model.dom.getOptions());
                opc.loadPreferencesWithEvents();
                view.setMessage("ready");
                AutoplotUI.checkStatusLoop(view);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return model;
    }

    ApplicationModel cloneApplication() {
        final ApplicationModel model = new ApplicationModel();
        model.setExceptionHandler(this.parent.applicationModel.getExceptionHandler());
        Runnable run = new Runnable(){

            @Override
            public void run() {
                model.addDasPeersToApp();
                model.dom.getOptions().setDataVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isDataVisible());
                model.dom.getOptions().setLayoutVisible(GuiSupport.this.parent.applicationModel.dom.getOptions().isLayoutVisible());
                AutoplotUI view = new AutoplotUI(model);
                view.setLocationRelativeTo(GuiSupport.this.parent);
                view.setDefaultCloseOperation(2);
                Point p = view.getLocation();
                p.translate(20, 20);
                view.setLocation(p);
                view.setVisible(true);
                OptionsPrefsController opc = new OptionsPrefsController(model.dom.getOptions());
                opc.loadPreferencesWithEvents();
                view.setMessage("ready");
                AutoplotUI.checkStatusLoop(view);
                Canvas size = GuiSupport.this.parent.applicationModel.dom.getCanvases(0);
                view.resizeForCanvasSize(size.getWidth(), size.getHeight());
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (InterruptedException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        model.dom.syncTo(this.parent.applicationModel.dom);
        return model;
    }

    public Action createNewApplicationAction() {
        return new AbstractAction("New Window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.this.newApplication();
            }
        };
    }

    public Action createCloneApplicationAction() {
        return new AbstractAction("Clone to New Window"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.this.cloneApplication();
            }
        };
    }

    private static Map<String, RenderType> getRenderTypeForString() {
        LinkedHashMap<String, RenderType> tt = new LinkedHashMap<String, RenderType>();
        tt.put("Scatter", RenderType.scatter);
        tt.put("Color Scatter", RenderType.colorScatter);
        tt.put("Series", RenderType.series);
        tt.put("Stair Steps", RenderType.stairSteps);
        tt.put("Fill To Zero", RenderType.fillToZero);
        tt.put("Huge Scatter", RenderType.hugeScatter);
        tt.put("Spectrogram", RenderType.spectrogram);
        tt.put("Nearest Neighbor Spectrogram", RenderType.nnSpectrogram);
        tt.put("Digital", RenderType.digital);
        tt.put("Events Bar", RenderType.eventsBar);
        tt.put("Image", RenderType.image);
        tt.put("Pitch Angle Distribution", RenderType.pitchAngleDistribution);
        tt.put("Orbit Plot", RenderType.orbitPlot);
        tt.put("Contour Plot", RenderType.contour);
        tt.put("Stacked Histogram", RenderType.stackedHistogram);
        return tt;
    }

    public static JMenu createEZAccessMenu(final Plot plot) {
        JMenu result = new JMenu("Plot Style");
        result.setName(plot.getId() + "_ezaccessmenu");
        Map<String, RenderType> tt = GuiSupport.getRenderTypeForString();
        Iterator<Map.Entry<String, RenderType>> iterator = tt.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RenderType> ee;
            final Map.Entry<String, RenderType> fee = ee = iterator.next();
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(new AbstractAction(fee.getKey()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    PlotElement pe = plot.getController().getApplication().getController().getPlotElement();
                    pe.setRenderType((RenderType)((Object)fee.getValue()));
                }
            });
            result.add(mi);
        }
        return result;
    }

    protected void addKeyBindings(JPanel thisPanel) {
        thisPanel.getActionMap().put("UNDO", this.parent.undoRedoSupport.getUndoAction());
        thisPanel.getActionMap().put("REDO", this.parent.undoRedoSupport.getRedoAction());
        thisPanel.getActionMap().put("RESET_ZOOM", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.this.parent.applicationModel.resetZoom();
            }
        });
        thisPanel.getActionMap().put("INCREASE_FONT_SIZE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.this.parent.applicationModel.increaseFontSize();
            }
        });
        thisPanel.getActionMap().put("DECREASE_FONT_SIZE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.this.parent.applicationModel.decreaseFontSize();
            }
        });
        thisPanel.getActionMap().put("NEXT_PLOT_ELEMENT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Application dom = GuiSupport.this.parent.dom;
                PlotElement p = dom.getController().getPlotElement();
                int idx = Arrays.asList(dom.getPlotElements()).indexOf(p);
                if (idx == -1) {
                    idx = 0;
                }
                if (++idx == dom.getPlotElements().length) {
                    idx = 0;
                }
                dom.getController().setPlotElement(dom.getPlotElements(idx));
            }
        });
        thisPanel.getActionMap().put("PREV_PLOT_ELEMENT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Application dom = GuiSupport.this.parent.dom;
                PlotElement p = dom.getController().getPlotElement();
                int idx = Arrays.asList(dom.getPlotElements()).indexOf(p);
                if (idx == -1) {
                    idx = 0;
                }
                if (--idx == -1) {
                    idx = dom.getPlotElements().length - 1;
                }
                dom.getController().setPlotElement(dom.getPlotElements(idx));
            }
        });
        thisPanel.getActionMap().put("SAVE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.this.parent.stateSupport.createSaveAction().actionPerformed(e);
            }
        });
        thisPanel.getActionMap().put("RELOAD_ALL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                RequestProcessor.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoplotUtil.reloadAll(GuiSupport.this.parent.dom);
                    }
                });
            }
        });
        ComponentInputMap map = new ComponentInputMap(thisPanel);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ((InputMap)map).put(KeyStroke.getKeyStroke(90, tk.getMenuShortcutKeyMask()), "UNDO");
        ((InputMap)map).put(KeyStroke.getKeyStroke(89, tk.getMenuShortcutKeyMask()), "REDO");
        ((InputMap)map).put(KeyStroke.getKeyStroke(82, tk.getMenuShortcutKeyMask()), "RESET_ZOOM");
        ((InputMap)map).put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "DECREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(521, tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(61, 0x40 | tk.getMenuShortcutKeyMask()), "INCREASE_FONT_SIZE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(9, 128), "NEXT_PLOT_ELEMENT");
        ((InputMap)map).put(KeyStroke.getKeyStroke(9, 192), "PREV_PLOT_ELEMENT");
        ((InputMap)map).put(KeyStroke.getKeyStroke(83, tk.getMenuShortcutKeyMask()), "SAVE");
        ((InputMap)map).put(KeyStroke.getKeyStroke(76, tk.getMenuShortcutKeyMask()), "RELOAD_ALL");
        thisPanel.setInputMap(2, map);
    }

    protected void exportRecent(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.toString();
                if (s == null) {
                    return false;
                }
                return f.isDirectory() || s.endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "bookmarks files (*.xml)";
            }
        });
        int r = chooser.showSaveDialog(c);
        if (r == 0) {
            try {
                File f = chooser.getSelectedFile();
                if (!f.toString().endsWith(".xml")) {
                    f = new File(f.toString() + ".xml");
                }
                try (FileOutputStream out = new FileOutputStream(f);){
                    Bookmark.formatBooks(out, this.parent.applicationModel.getRecent());
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private static FileFilter getFileNameExtensionFilter(final String description, final String ext) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.toString();
                if (s == null) {
                    return false;
                }
                return f.isDirectory() || s.endsWith(ext);
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static Action getPrintAction(final Application app, final Component parent, final String ext) {
        return new AbstractAction("Print as " + ext.toUpperCase()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfOptionsPanel decor;
                LoggerManager.logGuiEvent(e);
                final DasCanvas canvas = app.getController().getDasCanvas();
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Print to " + ext.toUpperCase());
                fileChooser.setFileFilter(GuiSupport.getFileNameExtensionFilter(ext + " files", ext));
                Preferences prefs = AutoplotSettings.settings().getPreferences(DasCanvas.class);
                String savedir = prefs.get("savedir", null);
                if (savedir != null) {
                    fileChooser.setCurrentDirectory(new File(savedir));
                }
                if (currentFile != null) {
                    if (currentFile.toString().endsWith("." + ext)) {
                        fileChooser.setSelectedFile(currentFile);
                    } else {
                        fileChooser.setSelectedFile(new File(currentFile.toString() + "." + ext));
                    }
                }
                if (ext.equals("pdf")) {
                    decor = new PdfOptionsPanel();
                    fileChooser.setAccessory(decor);
                } else {
                    decor = null;
                }
                int choice = fileChooser.showSaveDialog(parent);
                if (choice == 0) {
                    String fname = fileChooser.getSelectedFile().toString();
                    if (!fname.toLowerCase().endsWith("." + ext)) {
                        fname = fname + "." + ext;
                    }
                    final String ffname = fname;
                    prefs.put("savedir", new File(ffname).getParent());
                    currentFile = new File(ffname.substring(0, ffname.length() - 4));
                    Runnable run = new Runnable(){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public void run() {
                            try {
                                var1_1 = ext;
                                var2_3 = -1;
                                switch (var1_1.hashCode()) {
                                    case 111145: {
                                        if (!var1_1.equals("png")) break;
                                        var2_3 = 0;
                                        break;
                                    }
                                    case 110834: {
                                        if (!var1_1.equals("pdf")) break;
                                        var2_3 = 1;
                                        break;
                                    }
                                    case 114276: {
                                        if (!var1_1.equals("svg")) break;
                                        var2_3 = 2;
                                    }
                                }
                                switch (var2_3) {
                                    case 0: {
                                        canvas.writeToPng(ffname);
                                        break;
                                    }
                                    case 1: {
                                        out = new FileOutputStream(ffname);
                                        var4_5 = null;
                                        go = new PdfGraphicsOutput();
                                        pdecor = (PdfOptionsPanel)decor;
                                        go.setGraphicsShapes(pdecor.fontsAsShapesCB.isSelected());
                                        go.setOutputStream(out);
                                        if (pdecor.manualWidthCB.isSelected()) {
                                            mant = Double.parseDouble(pdecor.widthTF.getText());
                                            var10_13 = units = (String)pdecor.unitsComboBox.getSelectedItem();
                                            var11_15 = -1;
                                            switch (var10_13.hashCode()) {
                                                case -1184266632: {
                                                    if (!var10_13.equals("inches")) break;
                                                    var11_15 = 0;
                                                    break;
                                                }
                                                case 789503243: {
                                                    if (!var10_13.equals("centimeters")) break;
                                                    var11_15 = 1;
                                                }
                                            }
                                            switch (var11_15) {
                                                case 0: {
                                                    mant *= 72.0;
                                                    break;
                                                }
                                                case 1: {
                                                    mant = mant * 72.0 / 2.54;
                                                    break;
                                                }
                                                default: {
                                                    throw new IllegalArgumentException("implementation error: " + units);
                                                }
                                            }
                                            ppi = (int)((double)(canvas.getWidth() * 72) / mant);
                                            go.setPixelsPerInch(ppi);
                                            go.setSize(canvas.getWidth(), canvas.getHeight());
                                        } else if (pdecor.getPixelsPerInch().length() > 0) {
                                            ppi = Integer.parseInt(pdecor.getPixelsPerInch());
                                            go.setPixelsPerInch(ppi);
                                            go.setSize(canvas.getWidth(), canvas.getHeight());
                                        } else {
                                            go.setSize(canvas.getWidth(), canvas.getHeight());
                                        }
                                        go.start();
                                        canvas.print(go.getGraphics());
                                        go.finish();
                                        if (out == null) break;
                                        if (var4_5 == null) ** GOTO lbl70
                                        try {
                                            out.close();
                                        }
                                        catch (Throwable var5_7) {
                                            var4_5.addSuppressed(var5_7);
                                        }
                                        break;
lbl70:
                                        // 1 sources

                                        out.close();
                                        break;
                                        catch (Throwable var5_8) {
                                            try {
                                                var4_5 = var5_8;
                                                throw var5_8;
                                            }
                                            catch (Throwable var12_16) {
                                                if (out != null) {
                                                    if (var4_5 != null) {
                                                        try {
                                                            out.close();
                                                        }
                                                        catch (Throwable var13_17) {
                                                            var4_5.addSuppressed(var13_17);
                                                        }
                                                    } else {
                                                        out.close();
                                                    }
                                                }
                                                throw var12_16;
                                            }
                                        }
                                    }
                                    case 2: {
                                        canvas.writeToSVG(ffname);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("implementation error: " + ext);
                                    }
                                }
                                app.getController().setStatus("wrote to " + ffname);
                            }
                            catch (IOException ioe) {
                                DasApplication.getDefaultApplication().getExceptionHandler().handle(ioe);
                            }
                        }
                    };
                    new Thread(run, "writePrint").start();
                }
            }
        };
    }

    private static void mergeVap(Application dom, Plot plot, PlotElement pelement, String vap) {
        try {
            ImportVapDialog d = new ImportVapDialog();
            if (vap.contains("?")) {
                int i = vap.indexOf(63);
                vap = vap.substring(0, i);
            }
            d.setVap(vap);
            if (d.showDialog(SwingUtilities.getWindowAncestor(dom.getController().getDasCanvas())) == 0) {
                String lock = "merging vaps";
                dom.getController().registerPendingChange(d, lock);
                dom.getController().performingChange(d, lock);
                List<String> uris = d.getSelectedURIs();
                for (String uri : uris) {
                    dom.getController().doplot(plot, pelement, uri);
                    pelement = null;
                }
                dom.getController().changePerformed(d, lock);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBookmarks(String bookmarksFile) {
        ImportBookmarksGui gui = new ImportBookmarksGui();
        gui.getBookmarksFilename().setText(bookmarksFile + " ?");
        gui.getRemote().setSelected(true);
        int r = JOptionPane.showConfirmDialog(this.parent, gui, "Import bookmarks file", 2);
        if (r == 0) {
            InputStream in = null;
            try {
                DasProgressPanel mon = DasProgressPanel.createFramed("importing bookmarks");
                if (gui.getRemote().isSelected()) {
                    this.parent.getBookmarksManager().getModel().addRemoteBookmarks(bookmarksFile);
                    this.parent.getBookmarksManager().reload();
                } else {
                    in = DataSetURI.getInputStream(DataSetURI.getURIValid(bookmarksFile), (ProgressMonitor)mon);
                    ByteArrayOutputStream boas = new ByteArrayOutputStream();
                    WritableByteChannel dest = Channels.newChannel(boas);
                    ReadableByteChannel src = Channels.newChannel(in);
                    DataSourceUtil.transfer(src, dest);
                    String sin = new String(boas.toByteArray());
                    List<Bookmark> books = Bookmark.parseBookmarks(sin);
                    this.parent.getBookmarksManager().getModel().importList(books);
                }
                this.parent.setMessage("imported bookmarks file " + bookmarksFile);
            }
            catch (BookmarksException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.parent.applicationModel.showMessage("Semantic Error parsing " + bookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (SAXException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.parent.applicationModel.showMessage("XML Error parsing " + bookmarksFile + "\n" + ex.getMessage(), "Error in import bookmarks", 2);
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (FileNotFoundException ex) {
                this.parent.applicationModel.showMessage("File not found: " + bookmarksFile, "Error in import bookmarks", 2);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.parent.applicationModel.showMessage("I/O Error with " + bookmarksFile, "Error in import bookmarks", 2);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    private static void handleAddElementDialog(final AddPlotElementDialog dia, final Application dom, final ApplicationModel applicationModel) {
        String[] filters;
        String[] uris;
        Plot plot = null;
        PlotElement pelement = null;
        int modifiers = dia.getModifiers();
        if ((modifiers & 2) == 2 && (modifiers & 1) == 1) {
            plot = dom.getController().addPlot(LayoutConstants.ABOVE);
            pelement = null;
        } else if ((modifiers & 2) == 2) {
            plot = null;
            pelement = null;
        } else if ((modifiers & 1) == 1) {
            plot = dom.getController().getPlot();
        } else {
            pelement = dom.getController().getPlotElement();
        }
        final Plot lplot = plot;
        final PlotElement lpelement = pelement;
        switch (dia.getDepCount()) {
            case 0: {
                uris = new String[]{dia.getPrimaryDataSetSelector().getValue()};
                filters = new String[]{dia.getPrimaryFilters()};
                break;
            }
            case 1: {
                uris = new String[]{dia.getSecondaryDataSetSelector().getValue(), dia.getPrimaryDataSetSelector().getValue()};
                filters = new String[]{dia.getSecondaryFilters(), dia.getPrimaryFilters()};
                break;
            }
            case 2: {
                uris = new String[]{dia.getSecondaryDataSetSelector().getValue(), dia.getTertiaryDataSetSelector().getValue(), dia.getPrimaryDataSetSelector().getValue()};
                filters = new String[]{dia.getSecondaryFilters(), dia.getTertiaryFilters(), dia.getPrimaryFilters()};
                break;
            }
            default: {
                throw new IllegalArgumentException("this can't happen");
            }
        }
        int depCount = dia.getDepCount();
        String lock = "plotWithSlice";
        dom.getController().registerPendingChange(dom, "plotWithSlice");
        try {
            switch (depCount) {
                case 0: {
                    String val = uris[0];
                    if (val.endsWith(".vap")) {
                        GuiSupport.mergeVap(dom, lplot, lpelement, val);
                        break;
                    }
                    final String lval = val;
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                String uri = lval;
                                DataSourceFactory factory = DataSetURI.getDataSourceFactory(DataSetURI.getURI(uri), new NullProgressMonitor());
                                if (factory == null) {
                                    if (uri.startsWith("vap+internal:")) {
                                        DataSourceFilter dsf = dom.getController().addDataSourceFilter();
                                        dsf.setUri(uri);
                                        dom.getController().addPlotElement(lplot, dsf);
                                        return;
                                    }
                                    throw new IllegalArgumentException("unable to resolve URI: " + uri);
                                }
                                ArrayList<String> problems = new ArrayList<String>();
                                while (factory.reject(uri, problems, new NullProgressMonitor())) {
                                    String val;
                                    dia.setTitle("Add Plot, URI was rejected...");
                                    dia.setMessagesLabelText("The URI was rejected.  Verify that it is correct using the inspect button (right).");
                                    WindowManager.getInstance().showModalDialog(dia);
                                    if (dia.isCancelled()) {
                                        return;
                                    }
                                    uri = val = dia.getPrimaryDataSetSelector().getValue();
                                }
                                PlotElement pelement = dom.getController().doplot(lplot, lpelement, lval);
                                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pelement.getDataSourceFilterId());
                                if (dia.getPrimaryFilters().length() > 0) {
                                    dsf.setFilters(dia.getPrimaryFilters());
                                }
                            }
                            catch (IOException | URISyntaxException ex) {
                                applicationModel.showMessage(ex.getMessage(), "Illegal Argument", 0);
                            }
                            finally {
                                dom.getController().changePerformed(dom, "plotWithSlice");
                            }
                        }
                    };
                    run.run();
                    break;
                }
                case 1: {
                    applicationModel.addRecent(uris[0]);
                    applicationModel.addRecent(uris[1]);
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                dom.getController().performingChange(dom, "plotWithSlice");
                                PlotElement pele = dom.getController().doplot(lplot, lpelement, uris[0], uris[1]);
                                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pele.getDataSourceFilterId());
                                List<DataSourceFilter> dsfs = DomUtil.getParentsFor(dom, dsf.getUri());
                                if (dsfs.size() == 2 && dsfs.get(0) != null && dsfs.get(1) != null) {
                                    if (filters[0].length() > 0) {
                                        dsfs.get(0).setFilters(filters[0]);
                                    }
                                    if (filters[1].length() > 0) {
                                        dsfs.get(1).setFilters(filters[1]);
                                    }
                                }
                                dom.getController().setFocusUri(dom.getController().getDataSourceFilterFor(pele).getUri());
                            }
                            finally {
                                dom.getController().changePerformed(dom, "plotWithSlice");
                            }
                        }
                    };
                    new Thread(run).start();
                    break;
                }
                case 2: {
                    applicationModel.addRecent(uris[0]);
                    applicationModel.addRecent(uris[1]);
                    applicationModel.addRecent(uris[2]);
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                dom.getController().performingChange(dom, "plotWithSlice");
                                PlotElement pele = dom.getController().doplot(lplot, lpelement, uris[0], uris[1], uris[2]);
                                DataSourceFilter dsf = (DataSourceFilter)DomUtil.getElementById(dom, pele.getDataSourceFilterId());
                                List<DataSourceFilter> dsfs = DomUtil.getParentsFor(dom, dsf.getUri());
                                if (dsfs.size() == 3 && dsfs.get(0) != null && dsfs.get(1) != null && dsfs.get(2) != null) {
                                    if (filters[0].length() > 0) {
                                        dsfs.get(0).setFilters(filters[0]);
                                    }
                                    if (filters[1].length() > 0) {
                                        dsfs.get(1).setFilters(filters[1]);
                                    }
                                    if (filters[2].length() > 0) {
                                        dsfs.get(2).setFilters(filters[2]);
                                    }
                                }
                                dom.getController().setFocusUri(dom.getController().getDataSourceFilterFor(pele).getUri());
                            }
                            finally {
                                dom.getController().changePerformed(dom, "plotWithSlice");
                            }
                        }
                    };
                    new Thread(run).start();
                    break;
                }
                case -1: {
                    break;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            applicationModel.showMessage(ex.getMessage(), "Illegal Argument", 0);
        }
    }

    private static void bindToPlotPeer(ApplicationController controller, Plot dstPlot, Plot plot, Axis axis, String[] props) throws IllegalArgumentException {
        Axis targetAxis;
        if (plot.getXaxis() == axis) {
            targetAxis = dstPlot.getXaxis();
        } else if (plot.getYaxis() == axis) {
            targetAxis = dstPlot.getYaxis();
        } else if (plot.getZaxis() == axis) {
            targetAxis = dstPlot.getZaxis();
        } else {
            throw new IllegalArgumentException("this axis and plot don't go together");
        }
        if (props == null) {
            axis.setLog(targetAxis.isLog());
            axis.setRange(targetAxis.getRange());
            props = new String[]{"log", "range"};
        }
        for (String p : props) {
            controller.bind(targetAxis, p, axis, p);
        }
    }

    protected static void addAxisContextMenuItems(final ApplicationController controller, DasPlot dasPlot, PlotController plotController, final Plot plot, final Axis axis) {
        final DasAxis dasAxis = axis.getController().getDasAxis();
        DasMouseInputAdapter mouseAdapter = dasAxis.getDasMouseInputAdapter();
        ArrayList<JMenuItem> expertMenuItems = new ArrayList<JMenuItem>();
        mouseAdapter.removeMenuItem("Properties");
        JMenuItem item = new JMenuItem(new AbstractAction("Axis Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PropertyEditor pp = new PropertyEditor(axis);
                pp.showDialog(dasAxis.getCanvas());
            }
        });
        mouseAdapter.addMenuItem(item);
        expertMenuItems.add(item);
        mouseAdapter.addMenuItem(new JSeparator());
        item = new JMenuItem(new AbstractAction("Reset Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (plot.getZaxis() == axis) {
                    AutoplotUtil.resetZoomZ(controller.getApplication(), plot);
                } else if (axis == plot.getXaxis()) {
                    AutoplotUtil.resetZoomX(controller.getApplication(), plot);
                } else {
                    AutoplotUtil.resetZoomY(controller.getApplication(), plot);
                }
            }
        });
        mouseAdapter.addMenuItem(item);
        if (axis == plot.getXaxis()) {
            JMenu addPlotMenu = new JMenu("Add Plot");
            mouseAdapter.addMenuItem(addPlotMenu);
            item = new JMenuItem(new AbstractAction("Bound Plot Below"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    controller.copyPlot(plot, true, false, true);
                }
            });
            item.setToolTipText("add a new plot below.  The plot's x axis will be bound to this plot's x axis");
            addPlotMenu.add(item);
            expertMenuItems.add(addPlotMenu);
        }
        JMenu bindingMenu = new JMenu("Binding");
        mouseAdapter.addMenuItem(bindingMenu);
        if (axis == plot.getXaxis()) {
            item = new JMenuItem(new AbstractAction("Add Binding to Application Time Range"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    DatumRange dr = controller.getApplication().getTimeRange();
                    if (dr == Application.DEFAULT_TIME_RANGE) {
                        controller.getApplication().setTimeRange(dr.next());
                        controller.getApplication().setTimeRange(dr.next().previous());
                    }
                    controller.bind(controller.getApplication(), "timeRange", axis, "range");
                }
            });
            bindingMenu.add(item);
        }
        item = new JMenuItem(new AbstractAction("Bind Range to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Range to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Range to Plot to the Right"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getNextPlotHoriz(plot, LayoutConstants.RIGHT);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot to the right");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Range to Plot to the Left"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getNextPlotHoriz(plot, LayoutConstants.LEFT);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot to the left");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, null);
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Scale to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, new String[]{"log", "scale"});
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Scale to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    GuiSupport.bindToPlotPeer(controller, dstPlot, plot, axis, new String[]{"log", "scale"});
                }
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Scale to Opposite Axis"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                controller.bind(plot.getXaxis(), "log", plot.getYaxis(), "log");
                controller.bind(plot.getXaxis(), "scale", plot.getYaxis(), "scale");
            }
        });
        bindingMenu.add(item);
        item = new JMenuItem(new AbstractAction("Remove Bindings"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                BindingModel[] bms = controller.getBindingsFor(axis);
                controller.unbind(axis);
                controller.setStatus("removed " + bms.length + " bindings");
            }
        });
        item.setToolTipText("remove any plot and plot element property bindings");
        bindingMenu.add(item);
        expertMenuItems.add(bindingMenu);
        JMenu connectorMenu = new JMenu("Connector");
        mouseAdapter.addMenuItem(connectorMenu);
        item = new JMenuItem(new AbstractAction("Add Connector to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot above");
                } else {
                    controller.addConnector(dstPlot, plot);
                }
            }
        });
        connectorMenu.add(item);
        item = new JMenuItem(new AbstractAction("Add Connector to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    controller.setStatus("warning: no plot below");
                } else {
                    controller.addConnector(plot, dstPlot);
                }
            }
        });
        connectorMenu.add(item);
        item = new JMenuItem(new AbstractAction("Delete Connectors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Application dom = plot.getController().getApplication();
                for (Connector c : DomUtil.asArrayList(dom.getConnectors())) {
                    if (!c.getPlotA().equals(plot.getId()) && !c.getPlotB().equals(plot.getId())) continue;
                    dom.getController().deleteConnector(c);
                }
                dom.getController().getCanvas().getController().getDasCanvas().repaint();
            }
        });
        connectorMenu.add(item);
        expertMenuItems.add(connectorMenu);
        if (axis.getController().getDasAxis().isHorizontal()) {
            item = new JMenuItem(new AbstractAction("Add Additional Ticks from..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String nuri;
                    LoggerManager.logGuiEvent(e);
                    String uri = plot.getTicksURI();
                    if (uri.startsWith("class:org.autoplot.tca.UriTcaSource:")) {
                        uri = uri.substring("class:org.autoplot.tca.UriTcaSource:".length());
                    }
                    if (UnitsUtil.isTimeLocation(axis.getController().getDasAxis().getDatumRange().getUnits()) && (nuri = DataSetURI.resetUriTsbTime(uri, axis.getController().getDasAxis().getDatumRange())) != null && !nuri.equals(uri)) {
                        uri = nuri;
                    }
                    TcaElementDialog dia = new TcaElementDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(controller.getDasCanvas().getParent())), true);
                    dia.getPrimaryDataSetSelector().setValue(uri);
                    dia.getPrimaryDataSetSelector().setTimeRange(axis.getController().getDasAxis().getDatumRange());
                    dia.setTitle("Add additional ticks");
                    dia.setVisible(true);
                    if (dia.isCancelled()) {
                        return;
                    }
                    uri = dia.getPrimaryDataSetSelector().getValue();
                    if (uri.length() == 0) {
                        plot.setTicksURI("");
                    } else {
                        plot.setTicksURI(uri);
                    }
                }
            });
            mouseAdapter.addMenuItem(item);
            expertMenuItems.add(item);
        }
        item = new JMenuItem(new AbstractAction("Reset axis units to..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Units u = dasAxis.getUnits();
                Units[] uu = u.getConvertibleUnits();
                JFrame p = (JFrame)SwingUtilities.getWindowAncestor(controller.getDasCanvas().getParent());
                if (uu.length < 1) {
                    JOptionPane.showMessageDialog(p, "No conversions found from \"" + u + "\"");
                } else {
                    JPanel p1 = new JPanel();
                    p1.setLayout(new BoxLayout(p1, 1));
                    p1.setAlignmentY(0.0f);
                    p1.setAlignmentX(0.0f);
                    JLabel l = new JLabel("Axis units are \"" + u + "\"");
                    l.setAlignmentX(0.0f);
                    p1.add(l);
                    l = new JLabel("Reset axis units to:");
                    l.setAlignmentX(0.0f);
                    p1.add(l);
                    JComboBox<Units> cb = new JComboBox<Units>(uu);
                    cb.setAlignmentX(0.0f);
                    p1.add(cb);
                    if (0 == JOptionPane.showConfirmDialog(p, p1, "Reset axis units", 2)) {
                        Units nu = (Units)cb.getSelectedItem();
                        axis.getController().resetAxisUnits(nu);
                    }
                }
            }
        });
        mouseAdapter.addMenuItem(item);
        expertMenuItems.add(item);
        ArrayList<JMenuItem> expertMenuItemsList = new ArrayList<JMenuItem>(Arrays.asList(plotController.getExpertMenuItems()));
        expertMenuItemsList.addAll(expertMenuItems);
        plotController.setExpertMenuItems(expertMenuItemsList.toArray(new JMenuItem[expertMenuItemsList.size()]));
    }

    public static void pasteClipboardIntoPlot(Component app, ApplicationController controller, Plot newP) throws HeadlessException {
        try {
            int i;
            String s;
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clpbrd.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                s = (String)clpbrd.getData(DataFlavor.stringFlavor);
                if (!s.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<vap")) {
                    JOptionPane.showMessageDialog(app, "Use \"Edit Plot\"->\"Copy Plot to Clipboard\"");
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(app, "Use \"Edit Plot\"->\"Copy Plot to Clipboard\"");
                return;
            }
            List<PlotElement> pes = controller.getPlotElementsFor(newP);
            for (PlotElement pe : pes) {
                controller.deletePlotElement(pe);
            }
            Application state = (Application)StatePersistence.restoreState(new ByteArrayInputStream(s.getBytes()));
            Plot p = state.getPlots(0);
            newP.syncTo(p, Arrays.asList("id", "rowId", "columnId"));
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put(p.getId(), newP.getId());
            for (i = 0; i < state.getDataSourceFilters().length; ++i) {
                DataSourceFilter newDsf = controller.addDataSourceFilter();
                DataSourceFilter stateDsf = state.getDataSourceFilters(i);
                if (!stateDsf.getUri().startsWith("vap+internal:")) {
                    newDsf.syncTo(state.getDataSourceFilters(i), Collections.singletonList("id"));
                    state.setDataSourceFilters(i, null);
                }
                nameMap.put(stateDsf.getId(), newDsf.getId());
            }
            for (i = 0; i < state.getDataSourceFilters().length; ++i) {
                DataSourceFilter stateDsf = state.getDataSourceFilters(i);
                if (stateDsf == null) continue;
                String uri = stateDsf.getUri();
                String[] children = uri.substring(13).split(",");
                StringBuilder sb = new StringBuilder("vap+internal:");
                for (int j = 0; j < children.length; ++j) {
                    if (j > 0) {
                        sb.append(",");
                    }
                    sb.append((String)nameMap.get(children[j]));
                }
                stateDsf.setUri(sb.toString());
                DataSourceFilter newDsf = (DataSourceFilter)DomUtil.getElementById(controller.getApplication(), (String)nameMap.get(stateDsf.getId()));
                newDsf.syncTo(stateDsf, Collections.singletonList("id"));
            }
            Application theApp = controller.getApplication();
            for (int i2 = 0; i2 < state.getPlotElements().length; ++i2) {
                PlotElement pe1 = state.getPlotElements(i2);
                DataSourceFilter dsf1 = (DataSourceFilter)DomUtil.getElementById(theApp, (String)nameMap.get(pe1.getDataSourceFilterId()));
                Plot plot1 = (Plot)DomUtil.getElementById(theApp, (String)nameMap.get(pe1.getPlotId()));
                PlotElement pe = controller.addPlotElement(plot1, dsf1);
                pe.syncTo(pe1, Arrays.asList("id", "plotId", "dataSourceFilterId"));
                if (i2 == 0) {
                    plot1.setAutoBinding(true);
                    plot1.getController().setAutoBinding(true);
                }
                pe.setPlotDefaults(pe1.getPlotDefaults());
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logger.getLogger(GuiSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static void addPlotContextMenuItems(final AutoplotUI app, final ApplicationController controller, final DasPlot plot, final PlotController plotController, final Plot domPlot) {
        plot.getDasMouseInputAdapter().addMouseModule(new MouseModule(plot, new PointSlopeDragRenderer(plot, plot.getXAxis(), plot.getYAxis()), "Slope"));
        plot.getDasMouseInputAdapter().removeMenuItem("Dump Data");
        plot.getDasMouseInputAdapter().removeMenuItem("Properties");
        ArrayList<JMenuItem> expertMenuItems = new ArrayList<JMenuItem>();
        JMenuItem mi = new JMenuItem(new AbstractAction("Plot Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PropertyEditor pp = new PropertyEditor(domPlot);
                JDialog d = pp.getDialog(plot.getCanvas());
                WindowManager.getInstance().recallWindowSizePosition(d);
                d.setVisible(true);
                WindowManager.getInstance().recordWindowSizePosition(d);
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem(mi);
        expertMenuItems.add(mi);
        mi = new JMenuItem(new AbstractAction("Plot Element Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement p = controller.getPlotElement();
                PropertyEditor pp = new PropertyEditor(p);
                JDialog d = pp.getDialog(plot.getCanvas());
                WindowManager.getInstance().recallWindowSizePosition(d);
                d.setVisible(true);
                WindowManager.getInstance().recordWindowSizePosition(d);
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem(mi);
        expertMenuItems.add(mi);
        JMenuItem panelPropsMenuItem = new JMenuItem(new AbstractAction("Plot Element Style Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement p = controller.getPlotElement();
                PlotStylePanel.StylePanel editorPanel = GuiSupport.getStylePanel(p.getRenderType());
                editorPanel.doElementBindings(p);
                AutoplotUtil.showMessageDialog(app, editorPanel, (Object)((Object)p.getRenderType()) + " Style", 0);
            }
        });
        plotController.setPlotElementPropsMenuItem(panelPropsMenuItem);
        plot.getDasMouseInputAdapter().addMenuItem(panelPropsMenuItem);
        expertMenuItems.add(panelPropsMenuItem);
        plot.getDasMouseInputAdapter().addMenuItem(new JSeparator());
        final JMenu ezMenu = GuiSupport.createEZAccessMenu(domPlot);
        ezMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                PlotElement pe = app.dom.getController().getPlotElement();
                if (pe == null) {
                    return;
                }
                QDataSet ds = pe.getController().getDataSet();
                Map tt = GuiSupport.getRenderTypeForString();
                for (int i = 0; i < ezMenu.getItemCount(); ++i) {
                    if (!(ezMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    JCheckBoxMenuItem mi = (JCheckBoxMenuItem)ezMenu.getItem(i);
                    RenderType rt = (RenderType)((Object)tt.get(mi.getText()));
                    if (rt.equals((Object)pe.getRenderType())) {
                        mi.setSelected(true);
                    } else {
                        mi.setSelected(false);
                    }
                    if (pe.getController().getParentPlotElement() != null) {
                        ds = pe.getController().getParentPlotElement().getController().getDataSet();
                        if (ds == null || RenderType.acceptsData(rt, ds)) {
                            mi.setEnabled(true);
                            continue;
                        }
                        mi.setEnabled(false);
                        continue;
                    }
                    if (ds == null || RenderType.acceptsData(rt, ds)) {
                        mi.setEnabled(true);
                        continue;
                    }
                    mi.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        plot.getDasMouseInputAdapter().addMenuItem(ezMenu);
        expertMenuItems.add(ezMenu);
        JMenu addPlotMenu = new JMenu("Add Plot");
        plot.getDasMouseInputAdapter().addMenuItem(addPlotMenu);
        JMenuItem item = new JMenuItem(new AbstractAction("Copy Plot Elements Down"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        Plot newPlot = controller.copyPlotAndPlotElements(domPlot, null, false, false);
                        Application dom = domPlot.getController().getApplication();
                        List<BindingModel> bms = dom.getController().findBindings(dom, "timeRange", domPlot.getXaxis(), "range");
                        if (bms.size() > 0 && UnitsUtil.isTimeLocation(newPlot.getXaxis().getRange().getUnits())) {
                            controller.bind(controller.getApplication(), "timeRange", newPlot.getXaxis(), "range");
                        }
                    }
                };
                new Thread(run, "copyPlotElementsDown").start();
            }
        });
        item.setToolTipText("make a new plot below, and copy the plot elements into it.  New plot is bound by the x axis.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Paste Plot From Clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot newP = controller.addPlot(domPlot, LayoutConstants.BELOW);
                GuiSupport.pasteClipboardIntoPlot(app, controller, newP);
            }
        });
        item.setToolTipText("Paste the plot in the system clipboard.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Add Inset Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.addPlot("50%,100%-2em", "2em,50%");
            }
        });
        item.setToolTipText("Add a plot at an arbitrary position.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Context Overview"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        domPlot.getController().contextOverview();
                    }
                };
                new Thread(run, "contextOverview").start();
            }
        });
        item.setToolTipText("make a new plot, and copy the plot elements into it.  The plot is not bound,\nand a connector is drawn between the two.  The panel uris are bound as well.");
        addPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("New Location (URI)..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        app.dom.getController().setPlot(domPlot);
                        app.support.addPlotElement("New Location (URI)");
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
        item.setToolTipText("change URI or add plot");
        addPlotMenu.add(item);
        expertMenuItems.add(addPlotMenu);
        JMenu editPlotMenu = new JMenu("Edit Plot");
        plot.getDasMouseInputAdapter().addMenuItem(editPlotMenu);
        controller.fillEditPlotMenu(editPlotMenu, domPlot);
        expertMenuItems.add(editPlotMenu);
        JMenu panelMenu = new JMenu("Edit Plot Element");
        plot.getDasMouseInputAdapter().addMenuItem(panelMenu);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Move to Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement pelement = controller.getPlotElement();
                Plot plot = controller.getPlotFor(pelement);
                Plot dstPlot = controller.getPlotAbove(plot);
                if (dstPlot == null) {
                    dstPlot = controller.addPlot(LayoutConstants.ABOVE);
                    pelement.setPlotId(dstPlot.getId());
                } else {
                    pelement.setPlotId(dstPlot.getId());
                }
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Insert New Plot Above"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement pelement = controller.getPlotElement();
                Plot dstPlot = controller.addPlot(LayoutConstants.ABOVE);
                pelement.setPlotId(dstPlot.getId());
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Insert New Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement pelement = controller.getPlotElement();
                Plot dstPlot = controller.addPlot(LayoutConstants.BELOW);
                pelement.setPlotId(dstPlot.getId());
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(panelMenu);
        item = new JMenuItem(new AbstractAction("Move to Plot Below"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement pelement = controller.getPlotElement();
                Plot plot = controller.getPlotFor(pelement);
                Plot dstPlot = controller.getPlotBelow(plot);
                if (dstPlot == null) {
                    dstPlot = controller.addPlot(LayoutConstants.BELOW);
                    pelement.setPlotId(dstPlot.getId());
                    controller.bind(plot.getXaxis(), "range", dstPlot.getXaxis(), "range");
                } else {
                    pelement.setPlotId(dstPlot.getId());
                }
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        item = new JMenuItem(new AbstractAction("Delete Plot Element"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement pelement = controller.getPlotElement();
                if (controller.getApplication().getPlotElements().length < 2) {
                    DataSourceFilter dsf = controller.getDataSourceFilterFor(controller.getApplication().getPlotElements(0));
                    dsf.setUri("");
                    pelement.setLegendLabelAutomatically("");
                    pelement.setActive(true);
                    return;
                }
                controller.deletePlotElement(pelement);
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        item = new JMenuItem(new AbstractAction("Move Plot Element Below Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PlotElement pelement = controller.getPlotElement();
                Plot p = pelement.getController().getApplication().getController().getPlotFor(pelement);
                p.getController().toBottom(pelement);
            }
        });
        panelMenu.add(item);
        expertMenuItems.add(item);
        JMenuItem editDataMenu = new JMenuItem(new AbstractAction("Edit Data Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                GuiSupport.editPlotElement(controller.getApplicationModel(), plot);
            }
        });
        expertMenuItems.add(editDataMenu);
        plot.getDasMouseInputAdapter().addMenuItem(editDataMenu);
        plot.getDasMouseInputAdapter().addMenuItem(new JSeparator());
        plot.getDasMouseInputAdapter().addMenuItem(new JMenuItem(new AbstractAction("Reset Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                plotController.resetZoom(true, true, true);
            }
        }));
        plot.getDasMouseInputAdapter().addMenuItem(new JMenuItem(new AbstractAction("Add Annotation..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                AddAnnotationDialog dia = new AddAnnotationDialog();
                dia.setPointAtX(plot.getXAxis().invTransform(plot.getDasMouseInputAdapter().getMousePressPositionOnCanvas().x));
                dia.setPointAtY(plot.getYAxis().invTransform(plot.getDasMouseInputAdapter().getMousePressPositionOnCanvas().y));
                if (0 == AutoplotUtil.showConfirmDialog(app, dia, "Add Annotation", 2)) {
                    Annotation ann = controller.addAnnotation(domPlot, dia.getText());
                    dia.configure(ann);
                    ann.setAnchorOffset("1em,1em");
                    ann.setBorderType(BorderType.ROUNDED_RECTANGLE);
                    ann.setFontSize("1.4em");
                }
            }
        }));
        plot.getDasMouseInputAdapter().addMenuItem(new JSeparator());
        plotController.setExpertMenuItems(expertMenuItems.toArray(new JMenuItem[expertMenuItems.size()]));
        plot.getDasMouseInputAdapter().setMenuLabel(domPlot.getId());
    }

    protected void doInspectVap() {
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotSettings.class);
        String currentDirectory = prefs.get("last_open_vap_folder", prefs.get("last_open_folder", new File(System.getProperty("user.home")).toString()));
        String lcurrentFile = prefs.get("last_open_vap_file", "");
        JFileChooser chooser = new JFileChooser(currentDirectory);
        if (lcurrentFile.length() > 0) {
            chooser.setSelectedFile(new File(lcurrentFile));
        }
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.toString();
                if (s == null) {
                    return false;
                }
                return s.endsWith(".vap") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "*.vap";
            }
        };
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (0 == chooser.showOpenDialog(this.parent)) {
            try {
                final File f = chooser.getSelectedFile();
                prefs.put("last_open_vap_folder", f.getParent());
                prefs.put("last_open_vap_file", f.toString());
                final Application vap = (Application)StatePersistence.restoreState(f);
                PropertyEditor edit = new PropertyEditor(vap);
                edit.addSaveAction(new AbstractAction("Save"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        try {
                            StatePersistence.saveState(f, vap);
                        }
                        catch (IOException ex) {
                            JOptionPane.showConfirmDialog(GuiSupport.this.parent, "Unable to save to file: " + f);
                        }
                    }
                });
                edit.showDialog(this.parent);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                JOptionPane.showMessageDialog(this.parent, "File does not appear to well-formatted .vap file");
            }
        }
    }

    public static Font pickFont(Frame parent, ApplicationModel app) {
        JFontChooser chooser = new JFontChooser(parent);
        String sci = Entities.decodeEntities("2 &times; 10E7  &aacute;");
        String greek = Entities.decodeEntities("Greek Symbols: &Alpha; &Beta; &Delta; &alpha; &beta; &delta; &pi; &rho; &omega;");
        String math = Entities.decodeEntities("Math Symbols: &sum; &plusmn;");
        chooser.setExampleText("Electron Differential Energy Flux\n2001-01-10 12:00\nExtended ASCII: " + sci + "\n" + greek + "\n" + math);
        chooser.setFontCheck(new JFontChooser.FontCheck(){

            @Override
            public String checkFont(Font c) {
                String font = PdfGraphicsOutput.ttfFromNameInteractive(c);
                if (font == "PleaseWait") {
                    return "Checking which fonts are embeddable...";
                }
                if (font != null) {
                    return "PDF okay";
                }
                return "Can not be embedded in PDF";
            }
        });
        chooser.setFont(app.getCanvas().getBaseFont());
        chooser.setLocationRelativeTo(parent);
        if (chooser.showDialog() == 0) {
            return GuiSupport.setFont(app, chooser.getFont());
        }
        return null;
    }

    public static Font setFont(ApplicationModel app, Font nf) {
        app.getCanvas().setBaseFont(nf);
        Font f = app.getCanvas().getFont();
        app.getDocumentModel().getOptions().setCanvasFont(DomUtil.encodeFont(f));
        return f;
    }

    public static void raiseApplicationWindow(Frame frame) {
        frame.setVisible(true);
        int state = frame.getExtendedState();
        frame.setExtendedState(state &= 0xFFFFFFFE);
        frame.setAlwaysOnTop(true);
        frame.toFront();
        frame.requestFocus();
        frame.setAlwaysOnTop(false);
    }

    public static MouseAdapter createExamplesPopup(final JTextField tf, final String[] labels, final String[] tooltips) {
        return new MouseAdapter(){

            private JMenuItem createMenuItem(final JTextField componentTextField, final String insert, String doc) {
                JMenuItem result = new JMenuItem(new AbstractAction(insert){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        String v = componentTextField.getText();
                        int i = componentTextField.getCaretPosition();
                        componentTextField.setText(v.substring(0, i) + insert + v.substring(i));
                    }
                });
                if (doc != null) {
                    result.setToolTipText(doc);
                }
                return result;
            }

            void showPopup(MouseEvent ev) {
                JPopupMenu processMenu = new JPopupMenu();
                for (int i = 0; i < labels.length; ++i) {
                    processMenu.add(this.createMenuItem(tf, labels[i], tooltips == null ? null : tooltips[i]));
                }
                processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }
        };
    }
}

