/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.URISplit;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;

public class ExportDataFormatPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger("autoplot.export");
    private QDataSet dataSet = null;
    public static final String PROP_DATASET = "dataSet";
    DataSourceFormatEditorPanel editorPanel = null;
    private JButton additionalOptionsButton;
    private JButton chooseFileB;
    private JTextField filenameTF;
    private JComboBox formatDL;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public ExportDataFormatPanel() {
        this.initComponents();
    }

    public QDataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(QDataSet dataset) {
        QDataSet oldDataset = this.dataSet;
        this.dataSet = dataset;
        List<String> exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        Collections.sort(exts);
        ArrayList<String> newExts = new ArrayList<String>(exts.size());
        for (String s : exts) {
            DataSourceFormat dsf = DataSourceRegistry.getInstance().getFormatByExt(s);
            if (!dsf.canFormat(dataset)) continue;
            newExts.add(s);
        }
        exts = newExts;
        this.formatDL.setModel(new DefaultComboBoxModel<Object>(exts.toArray()));
        this.formatDL.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String ext = String.valueOf(value);
                DataSourceFormat format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                Component parent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (parent instanceof JLabel && format != null) {
                    ((JLabel)parent).setText(value.toString() + " " + format.getDescription());
                }
                return parent;
            }
        });
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
        String currentFileString = prefs.get("ExportDataCurrentFile", "");
        String currentExtString = prefs.get("ExportDataCurrentExt", ".txt");
        if (!currentExtString.equals("") && exts.contains(currentExtString)) {
            this.formatDL.setSelectedItem(currentExtString);
        }
        if (!currentFileString.equals("")) {
            URISplit split = URISplit.parse(currentFileString);
            this.filenameTF.setText(split.file);
            this.formatDL.setSelectedItem("." + split.ext);
            if (currentFileString.contains("/")) {
                this.setFile(currentFileString);
                if (split.params != null && this.editorPanel != null) {
                    this.editorPanel.setURI(currentFileString);
                }
            }
        }
        this.firePropertyChange(PROP_DATASET, oldDataset, dataset);
    }

    public String getURI() {
        URISplit split = this.editorPanel != null ? URISplit.parse(this.editorPanel.getURI()) : URISplit.parse(this.filenameTF.getText());
        split.file = this.filenameTF.getText();
        String ext = this.formatDL.getSelectedItem().toString();
        if (!split.file.endsWith(ext)) {
            split.file = split.file + ext;
        }
        String result = URISplit.format(split);
        Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
        prefs.put("ExportDataCurrentFile", result);
        prefs.put("ExportDataCurrentExt", ext);
        return result;
    }

    private void setFile(String currentFileString) {
        URISplit split = URISplit.parse(currentFileString);
        this.filenameTF.setText(split.file);
        this.formatDLActionPerformed(null);
        if (this.editorPanel != null && currentFileString.startsWith("file:")) {
            this.editorPanel.setURI(currentFileString);
        }
        try {
            this.updateEditorPanel(split.ext, true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.filenameTF = new JTextField();
        this.chooseFileB = new JButton();
        this.additionalOptionsButton = new JButton();
        this.jLabel2 = new JLabel();
        this.formatDL = new JComboBox();
        this.jLabel3 = new JLabel();
        this.filenameTF.setText("data");
        this.chooseFileB.setText("Select...");
        this.chooseFileB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataFormatPanel.this.chooseFileBActionPerformed(evt);
            }
        });
        this.additionalOptionsButton.setText("Additional options for output format...");
        this.additionalOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataFormatPanel.this.additionalOptionsButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Select Output Format:");
        this.formatDL.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.formatDL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExportDataFormatPanel.this.formatDLItemStateChanged(evt);
            }
        });
        this.formatDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataFormatPanel.this.formatDLActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Filename:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.formatDL, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.filenameTF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseFileB)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.additionalOptionsButton).addComponent(this.jLabel2)).addGap(0, 151, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatDL, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filenameTF, -2, -1, -2).addComponent(this.chooseFileB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.additionalOptionsButton)));
    }

    private void chooseFileBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        JFileChooser chooser = new JFileChooser();
        List<String> exts = DataSourceRegistry.getInstance().getFormatterExtensions();
        FileFilter deflt = null;
        Iterator<String> iterator = exts.iterator();
        while (iterator.hasNext()) {
            String ext;
            final String ex = ext = iterator.next();
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.toString() == null) {
                        return false;
                    }
                    return f.toString().endsWith(ex) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "*" + ex;
                }
            };
            if (ext.equals(".qds")) {
                deflt = ff;
            }
            chooser.addChoosableFileFilter(ff);
        }
        chooser.setFileFilter(deflt);
        String deft = this.filenameTF.getText();
        try {
            URL url = new URL(URISplit.parse((String)deft).file);
            chooser.setSelectedFile(new File(url.getFile()));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, null, e);
        }
        int r = chooser.showSaveDialog(this);
        if (r == 0) {
            DataSourceFormat format;
            String s = chooser.getSelectedFile().toString();
            String ext = DataSetURI.getExt(s);
            if (ext == null) {
                ext = "";
            }
            if ((format = DataSourceRegistry.getInstance().getFormatByExt(ext)) == null) {
                if (chooser.getFileFilter().getDescription().startsWith("*.")) {
                    ext = chooser.getFileFilter().getDescription().substring(1);
                    format = DataSourceRegistry.getInstance().getFormatByExt(ext);
                    if (format == null) {
                        JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                        return;
                    }
                    s = s + ext;
                } else {
                    JOptionPane.showMessageDialog(this, "No formatter for extension: " + ext);
                    return;
                }
            }
            this.filenameTF.setText(s);
            this.formatDL.setSelectedItem("." + ext);
        }
    }

    private void updateEditorPanel(String ss, boolean updateProcessing) {
        Object oeditorPanel = DataSourceRegistry.getInstance().getDataSourceFormatEditorByExt(ss);
        if (oeditorPanel != null) {
            String t;
            if (oeditorPanel instanceof String) {
                this.editorPanel = (DataSourceFormatEditorPanel)DataSourceRegistry.getInstanceFromClassName((String)oeditorPanel);
                if (this.editorPanel == null) {
                    throw new IllegalArgumentException("unable to create instance: " + oeditorPanel);
                }
            } else {
                this.editorPanel = (DataSourceFormatEditorPanel)oeditorPanel;
            }
            if ((t = this.filenameTF.getText()).contains("/") && t.startsWith("file:")) {
                this.editorPanel.setURI(t);
            }
        } else {
            this.editorPanel = null;
        }
        if (updateProcessing) {
            this.additionalOptionsButton.setEnabled(this.editorPanel != null);
        }
    }

    private void additionalOptionsButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        JPanel j = this.editorPanel.getPanel();
        AutoplotUtil.showConfirmDialog(this, j, "Additional Options", 2);
    }

    private void formatDLItemStateChanged(ItemEvent evt) {
        String s;
        String ss = (String)evt.getItem();
        if (evt.getStateChange() == 2 && (s = this.filenameTF.getText()).endsWith(ss)) {
            this.filenameTF.setText(s.substring(0, s.length() - ss.length()));
        }
        this.updateEditorPanel(ss, evt.getStateChange() == 1);
    }

    private void formatDLActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        String ff = this.filenameTF.getText();
        if (!ff.endsWith((String)this.formatDL.getSelectedItem())) {
            int ii;
            int ii2 = ff.lastIndexOf(47);
            if (ii2 == -1) {
                ii2 = 0;
            }
            if ((ii = ff.lastIndexOf(46)) > -1 && ii > ii2) {
                this.filenameTF.setText(ff.substring(0, ii) + this.formatDL.getSelectedItem());
            }
        }
    }
}

