/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import org.autoplot.AutoplotUI;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.Util;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.TimeRangeToolEventsList;
import org.autoplot.datasource.WindowManager;
import org.das2.datum.LoggerManager;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.xml.sax.SAXException;

public class EventsListToolUtil {
    private static final Logger logger = LoggerManager.getLogger("autoplot.events");
    private static final WeakHashMap<AutoplotUI, JDialog> instances = new WeakHashMap();
    private static final WeakHashMap<AutoplotUI, TimeRangeToolEventsList> instances2 = new WeakHashMap();

    public static void deflts(DataSetSelector sel) {
        String sdeft = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<bookmark-list version=\"1.1\">\n    <bookmark>\n        <title>RBSP-A EMFISIS Waveform Events</title>\n        <uri>http://emfisis.physics.uiowa.edu/events/rbsp-a/burst/rbsp-a_burst_times_$Y$m$d.txt?eventListColumn=field3&amp;column=field0&amp;timerange=2013-03-03</uri>\n    </bookmark>\n    <bookmark>\n        <title>RBSP-B EMFISIS Waveform Events</title>\n        <uri>http://emfisis.physics.uiowa.edu/events/rbsp-b/burst/rbsp-b_burst_times_$Y$m$d.txt?eventListColumn=field3&amp;column=field0&amp;timerange=2013-03-03</uri>\n    </bookmark>\n</bookmark-list>";
        List<Bookmark> deft = null;
        try {
            deft = Bookmark.parseBookmarks("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<bookmark-list version=\"1.1\">\n    <bookmark>\n        <title>RBSP-A EMFISIS Waveform Events</title>\n        <uri>http://emfisis.physics.uiowa.edu/events/rbsp-a/burst/rbsp-a_burst_times_$Y$m$d.txt?eventListColumn=field3&amp;column=field0&amp;timerange=2013-03-03</uri>\n    </bookmark>\n    <bookmark>\n        <title>RBSP-B EMFISIS Waveform Events</title>\n        <uri>http://emfisis.physics.uiowa.edu/events/rbsp-b/burst/rbsp-b_burst_times_$Y$m$d.txt?eventListColumn=field3&amp;column=field0&amp;timerange=2013-03-03</uri>\n    </bookmark>\n</bookmark-list>");
        }
        catch (BookmarksException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        Util.loadRecent("eventsRecent", sel, deft);
    }

    public static void show(AutoplotUI t) {
        String uri;
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalArgumentException("must be called from the event thread");
        }
        JDialog dialog = instances.get(t);
        if (dialog == null) {
            EventsListToolUtil.getEventsList(t);
            dialog = instances.get(t);
        }
        if ((uri = t.getDocumentModel().getEventsListUri()) != null && uri.length() > 0) {
            instances2.get(t).getDataSetSelector().setValue(uri);
            instances2.get(t).getDataSetSelector().maybePlot(0);
        }
        dialog.setVisible(true);
    }

    public static void setEventsListURI(AutoplotUI t, String uri) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalArgumentException("must be called from the event thread");
        }
        JDialog dialog = instances.get(t);
        if (dialog == null) {
            EventsListToolUtil.getEventsList(t);
        }
        instances2.get(t).getDataSetSelector().setValue(uri);
        instances2.get(t).getDataSetSelector().maybePlot(0);
    }

    public static TimeRangeToolEventsList getEventsList(final AutoplotUI t) {
        JDialog dialog = instances.get(t);
        if (dialog == null) {
            final JDialog d = new JDialog((Frame)t, "Events List");
            d.setName("eventsListTool");
            d.setModal(false);
            final TimeRangeToolEventsList ll = new TimeRangeToolEventsList();
            ll.addDataRangeSelectionListener(new DataRangeSelectionListener(){

                @Override
                public void dataRangeSelected(DataRangeSelectionEvent e) {
                    t.applicationModel.dom.setTimeRange(e.getDatumRange());
                }
            });
            ll.getDataSetSelector().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    t.getDocumentModel().setEventsListUri(ll.getDataSetSelector().getValue());
                }
            });
            EventsListToolUtil.deflts(ll.getDataSetSelector());
            ll.getDataSetSelector().setValue("");
            d.setDefaultCloseOperation(1);
            d.getContentPane().add(ll);
            d.pack();
            d.setLocationRelativeTo(t);
            d.setResizable(true);
            WindowManager.getInstance().recallWindowSizePosition(d);
            d.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    WindowManager.getInstance().recordWindowSizePosition(d);
                }
            });
            instances.put(t, d);
            instances2.put(t, ll);
        }
        return instances2.get(t);
    }
}

