/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.autoplot.AppManager;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.scriptconsole.GuiExceptionHandler;
import org.das2.DasApplication;
import org.das2.datum.LoggerManager;
import org.das2.util.AboutUtil;

public final class EventThreadResponseMonitor {
    private static final Logger logger = LoggerManager.getLogger("autoplot.splash");
    private long lastPost;
    private long response;
    private Thread eventQueue;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private static final int TEST_CLEAR_EVENT_QUEUE_PERIOD_MILLIS = 300;
    private static final int WARN_LEVEL_MILLIS = 500;
    private static final int ERROR_LEVEL_MILLIS = 10000;
    private static final int WATCH_INTERVAL_MILLIS = 1000;
    ScheduledThreadPoolExecutor exec;
    AWTEvent currentEvent = null;
    String reportedEventId = "";
    boolean pleasePostEvent = true;

    public EventThreadResponseMonitor() {
        this.lastPost = System.currentTimeMillis();
    }

    public void start() {
        logger.info("Starting EventThreadResponseMonitor.");
        logger.log(Level.INFO, "Warnings will be written to {0}", new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "log"));
        this.exec = new ScheduledThreadPoolExecutor(1);
        this.exec.scheduleAtFixedRate(this.maybeCreateEventThreadRunnable(), 4000L, 300L, TimeUnit.MILLISECONDS);
        this.exec.scheduleAtFixedRate(this.checkEventThreadRunnable(), 4000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void addToMap(String key, Object value) {
        this.map.put(key, value);
    }

    public static synchronized String dumpPendingEvents() {
        StringBuilder buf = new StringBuilder();
        LinkedList<AWTEvent> queue = new LinkedList<AWTEvent>();
        EventQueue instance = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (instance.peekEvent() != null) {
            buf.append("---------------------------------------------------------------\n");
        }
        while (instance.peekEvent() != null) {
            AWTEvent evt;
            try {
                evt = instance.getNextEvent();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            buf.append(evt).append("\n");
            queue.add(evt);
        }
        if (instance.peekEvent() != null) {
            buf.append("-----e--n--d-----------------------------------------------------");
        }
        while (queue.size() > 0) {
            instance.postEvent((AWTEvent)queue.remove());
        }
        return buf.toString();
    }

    private Runnable maybeCreateEventThreadRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventThreadResponseMonitor eventThreadResponseMonitor = EventThreadResponseMonitor.this;
                synchronized (eventThreadResponseMonitor) {
                    if (EventThreadResponseMonitor.this.pleasePostEvent) {
                        EventThreadResponseMonitor.this.pleasePostEvent = false;
                        EventThreadResponseMonitor.this.lastPost = System.currentTimeMillis();
                        SwingUtilities.invokeLater(EventThreadResponseMonitor.this.responseRunnable(""));
                    }
                }
            }
        };
    }

    private Runnable responseRunnable(final String pending) {
        return new Runnable(){

            @Override
            public void run() {
                EventThreadResponseMonitor.this.response = System.currentTimeMillis();
                long levelms = EventThreadResponseMonitor.this.response - EventThreadResponseMonitor.this.lastPost;
                EventThreadResponseMonitor.this.eventQueue = Thread.currentThread();
                if (levelms > 500L) {
                    logger.log(Level.FINE, "CURRENT EVENT QUEUE CLEAR TIME: {0} sec\n", levelms / 1000L);
                    if (pending != null) {
                        logger.log(Level.FINE, "events pending:\n");
                        logger.log(Level.FINE, pending);
                    }
                }
                EventThreadResponseMonitor.this.pleasePostEvent = true;
                logger.log(Level.FINER, "eventQueue clear time: {0}", levelms);
            }
        };
    }

    private Runnable checkEventThreadRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EventQueue instance = Toolkit.getDefaultToolkit().getSystemEventQueue();
                AWTEvent test = instance.peekEvent();
                if (EventThreadResponseMonitor.this.currentEvent != null && test == EventThreadResponseMonitor.this.currentEvent) {
                    boolean hungProcess;
                    logger.log(Level.FINE, "====  long job to process ====");
                    logger.log(Level.FINE, test.toString());
                    logger.log(Level.FINE, "====  end, long job to process ====");
                    String eventId = test.toString();
                    boolean bl = hungProcess = System.currentTimeMillis() - EventThreadResponseMonitor.this.lastPost > 10000L;
                    if (hungProcess && !eventId.equals(EventThreadResponseMonitor.this.reportedEventId)) {
                        logger.log(Level.INFO, "PATHOLOGICAL EVENT QUEUE CLEAR TIME, WRITING REPORT TO autoplot_data/log/...\n");
                        Date now = new Date();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
                        String timeStamp = sdf.format(now);
                        if (!DasApplication.hasAllPermission()) {
                            return;
                        }
                        String id = System.getProperty("user.name");
                        EventThreadResponseMonitor.this.map.put("USER_ID", id);
                        try {
                            List<String> bis = AboutUtil.getBuildInfos();
                            EventThreadResponseMonitor.this.map.put("build_info", bis);
                        }
                        catch (IOException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                        int appCount = AppManager.getInstance().getApplicationCount();
                        EventThreadResponseMonitor.this.map.put("APP_COUNT", appCount);
                        String s = GuiExceptionHandler.formatReport(EventThreadResponseMonitor.this.map, false, "Autoplot detected hang");
                        int hash = EventThreadResponseMonitor.this.eventQueue == null ? 1 : GuiExceptionHandler.hashCode(EventThreadResponseMonitor.this.eventQueue.getStackTrace());
                        String fname = String.format("hang_%010d_%s_%s.xml", hash, timeStamp, id.replaceAll(" ", "_"));
                        File logdir = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "log");
                        if (!logdir.exists() && !logdir.mkdirs()) {
                            return;
                        }
                        File f = new File(logdir, fname);
                        try (PrintWriter out = null;){
                            out = new PrintWriter(new FileOutputStream(f));
                            out.write(s);
                        }
                        EventThreadResponseMonitor.this.reportedEventId = eventId;
                        EventThreadResponseMonitor.this.currentEvent = null;
                    }
                }
                EventThreadResponseMonitor.this.currentEvent = test;
            }
        };
    }

    public static void main(String[] args) {
        new EventThreadResponseMonitor().start();
    }
}

