/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.autoplot.AutoplotUtil;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.jythonsupport.ui.Util;
import org.das2.components.DasProgressPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class BatchMaster
extends JPanel {
    private final Logger logger = LoggerManager.getLogger("jython.batchmaster");
    private Application dom;
    private String pwd;
    private JButton cancelButton;
    private DataSetSelector dataSetSelector1;
    private JButton generateButton1;
    private JButton generateButton2;
    private JButton goButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList<String> jList2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JMenuItem loadUriMenuItem;
    private JLabel messageLabel;
    private JComboBox<String> param1NameCB;
    private JTextArea param1Values;
    private JComboBox<String> param2NameCB;
    private JTextArea param2Values;
    private JComboBox<String> timeFormatComboBox;
    private JComboBox<String> timeRangeComboBox;
    private JPanel timeRangesPanel;
    private JCheckBox writeCheckBox;
    private JComboBox<String> writeFilenameCB;
    private BindingGroup bindingGroup;

    public BatchMaster(final Application dom) {
        this.initComponents();
        this.generateButton1.setEnabled(false);
        this.dom = dom;
        this.dataSetSelector1.registerBrowseTrigger("(.*)\\.jy(\\?.*)?", new AbstractAction("Review Script"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                String s = BatchMaster.this.dataSetSelector1.getValue();
                try {
                    URISplit split = URISplit.parse(s);
                    LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
                    HashMap<String, Object> env = new HashMap<String, Object>();
                    env.put("dom", dom);
                    env.put("PWD", split.path);
                    File scriptFile = DataSetURI.getFile(s, (ProgressMonitor)new NullProgressMonitor());
                    if (0 == JythonUtil.showScriptDialog(BatchMaster.this, env, scriptFile, args, this.enabled, split.resourceUri)) {
                        split.params = URISplit.formatParams(args);
                        BatchMaster.this.dataSetSelector1.setValue(URISplit.format(split));
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        this.dataSetSelector1.registerActionTrigger("(.*)\\.jy(\\?.*)?", new AbstractAction("Review Script"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                try {
                    String scriptName = BatchMaster.this.dataSetSelector1.getValue();
                    URISplit split = URISplit.parse(scriptName);
                    if (!split.file.endsWith(".jy")) {
                        JOptionPane.showMessageDialog(BatchMaster.this, "script must end in .jy: " + scriptName);
                        return;
                    }
                    BatchMaster.this.pwd = split.path;
                    HashMap<String, Object> env = new HashMap<String, Object>();
                    DasProgressPanel monitor = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(BatchMaster.this), "download script");
                    File scriptFile = DataSetURI.getFile(split.file, (ProgressMonitor)monitor);
                    String script = BatchMaster.this.readScript(scriptFile);
                    Map<String, JythonUtil.Param> parms = Util.getParams(env, script, URISplit.parseParams(split.params), new NullProgressMonitor());
                    String[] items = new String[parms.size() + 1];
                    int i = 0;
                    items[0] = "";
                    for (Map.Entry<String, JythonUtil.Param> p : parms.entrySet()) {
                        items[i + 1] = p.getKey();
                        ++i;
                    }
                    DefaultComboBoxModel<String> m1 = new DefaultComboBoxModel<String>(Arrays.copyOfRange(items, 1, items.length));
                    BatchMaster.this.param1NameCB.setModel(m1);
                    BatchMaster.this.generateButton1.setEnabled(items.length > 1);
                    DefaultComboBoxModel<String> m2 = new DefaultComboBoxModel<String>(items);
                    BatchMaster.this.param2NameCB.setModel(m2);
                }
                catch (IOException ex) {
                    Logger.getLogger(BatchMaster.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.dataSetSelector1.setPromptText("Enter the name of a Jython script");
        this.dataSetSelector1.setRecent(Collections.singletonList("http://autoplot.org/data/script/examples/parameters.jy"));
        if (dom.getController() != null) {
            Map<String, String> recentJy = dom.getController().getApplicationModel().getRecent("*.jy", 20);
            ArrayList<String> recentUris = new ArrayList<String>(recentJy.size());
            for (Map.Entry<String, String> recentItem : recentJy.entrySet()) {
                recentUris.add(recentItem.getKey());
            }
            this.dataSetSelector1.setRecent(recentUris);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.loadUriMenuItem = new JMenuItem();
        this.timeRangesPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.timeRangeComboBox = new JComboBox();
        this.timeFormatComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItem2 = new JMenuItem();
        this.goButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.param1Values = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.param2Values = new JTextArea();
        this.dataSetSelector1 = new DataSetSelector();
        this.messageLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.param1NameCB = new JComboBox();
        this.param2NameCB = new JComboBox();
        this.cancelButton = new JButton();
        this.generateButton1 = new JButton();
        this.generateButton2 = new JButton();
        this.writeCheckBox = new JCheckBox();
        this.writeFilenameCB = new JComboBox();
        this.jList2.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.jMenuItem1.setText("Generate...");
        this.jMenuItem1.setToolTipText("Generate items for list");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.loadUriMenuItem.setText("Load Events File...");
        this.loadUriMenuItem.setToolTipText("Load a list of time ranges from an events file.");
        this.loadUriMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.loadUriMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.loadUriMenuItem);
        this.jLabel2.setText("Time Range:");
        this.timeRangeComboBox.setEditable(true);
        this.timeRangeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Jun 2000", "2000", "2000-01-01/03-01", "2000-2016"}));
        this.timeFormatComboBox.setEditable(true);
        this.timeFormatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"$Y-$m-$d", "$Y", "$Y-$(m,span=3)", "$Y-$m", "$Y_$j", "$Y-$m-$dT$H/PT1H", "$Y-$m-$dT$H$M/PT1M", "$Y-$m-$dT$H$M$S/PT1S", " "}));
        this.jLabel3.setText("Time Format:");
        GroupLayout timeRangesPanelLayout = new GroupLayout(this.timeRangesPanel);
        this.timeRangesPanel.setLayout(timeRangesPanelLayout);
        timeRangesPanelLayout.setHorizontalGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeRangesPanelLayout.createSequentialGroup().addGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeRangeComboBox, 0, -1, Short.MAX_VALUE).addGroup(timeRangesPanelLayout.createSequentialGroup().addGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.timeFormatComboBox, GroupLayout.Alignment.TRAILING, 0, 220, Short.MAX_VALUE)).addContainerGap()));
        timeRangesPanelLayout.setVerticalGroup(timeRangesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeRangesPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeRangeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeFormatComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jMenuItem2.setText("Generate...");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItem2);
        this.goButton.setText("Go!");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.goButtonActionPerformed(evt);
            }
        });
        this.param1Values.setColumns(20);
        this.param1Values.setRows(5);
        this.param1Values.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BatchMaster.this.param1ValuesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BatchMaster.this.param1ValuesMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                BatchMaster.this.param1ValuesMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.param1Values);
        this.param2Values.setColumns(20);
        this.param2Values.setRows(5);
        this.param2Values.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BatchMaster.this.param2ValuesMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BatchMaster.this.param2ValuesMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                BatchMaster.this.param2ValuesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.param2Values);
        this.messageLabel.setText("Load up those parameters and hit Go!");
        this.jLabel1.setText("<html>This tool generates inputs for scripts, running through a series of inputs.  First load the script with the green \"play\" button, then specify the parameter name and values to assign, and optionally a second parameter.  Each value of the second parameter is run for each value of the first.  Use the inspect button to set values for any other parameters. Right-click within the values areas to generate values.");
        this.jLabel1.setVerticalAlignment(1);
        this.param1NameCB.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        this.param1NameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BatchMaster.this.param1NameCBItemStateChanged(evt);
            }
        });
        this.param2NameCB.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        this.param2NameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BatchMaster.this.param2NameCBItemStateChanged(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.cancelButtonActionPerformed(evt);
            }
        });
        this.generateButton1.setText("Generate...");
        this.generateButton1.setToolTipText("Generate items for list");
        this.generateButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.generateButton1ActionPerformed(evt);
            }
        });
        this.generateButton2.setText("Generate...");
        this.generateButton2.setToolTipText("Generate items for list");
        this.generateButton2.setEnabled(false);
        this.generateButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchMaster.this.generateButton2ActionPerformed(evt);
            }
        });
        this.writeCheckBox.setText("Write:");
        this.writeCheckBox.setToolTipText("After each iteration, write the file, where $x is replaced");
        this.writeFilenameCB.setEditable(true);
        this.writeFilenameCB.setModel(new DefaultComboBoxModel<String>(new String[]{"/tmp/ap/$x.png", "/tmp/ap/$x_$x.png", "/tmp/ap/$x.pdf", "/tmp/ap/$x_$x.pdf", " "}));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.writeCheckBox, (Property)ELProperty.create((String)"${selected}"), this.writeFilenameCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(544, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goButton, -2, 62, -2)).addComponent(this.dataSetSelector1, GroupLayout.Alignment.TRAILING, -1, 682, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(layout.createSequentialGroup().addComponent(this.param1NameCB, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateButton1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.param2NameCB, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateButton2)))).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel, -2, 401, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.writeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.writeFilenameCB, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.generateButton1, this.generateButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataSetSelector1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.param1NameCB, -2, -1, -2).addComponent(this.param2NameCB, -2, -1, -2).addComponent(this.generateButton1).addComponent(this.generateButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 228, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageLabel).addComponent(this.writeCheckBox).addComponent(this.writeFilenameCB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.goButton).addComponent(this.cancelButton)).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        if (!this.goButton.isEnabled()) {
            return;
        }
        this.goButton.setEnabled(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    BatchMaster.this.doIt();
                }
                catch (IOException ex) {
                    BatchMaster.this.messageLabel.setText(ex.getMessage());
                }
            }
        };
        new Thread(run).start();
    }

    private void param1ValuesMouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void param1ValuesMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void param1ValuesMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param1NameCB, this.param1Values);
    }

    private void param2ValuesMouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param2NameCB, this.param2Values);
    }

    private void param2ValuesMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void param2ValuesMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu2.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (!(w instanceof JDialog)) {
            this.logger.warning("untested code might leave hidden windows...");
        }
        w.setVisible(false);
    }

    private void loadUriMenuItemActionPerformed(ActionEvent evt) {
        DataSetSelector eventsDataSetSelector = new DataSetSelector();
        ArrayList<Bookmark> deft = new ArrayList<Bookmark>();
        deft.add(new Bookmark.Item("http://autoplot.org/autoplot/data/event/simpleEvent.txt"));
        org.autoplot.bookmarks.Util.loadRecent("eventsRecent", eventsDataSetSelector, deft);
        if (0 == AutoplotUtil.showConfirmDialog(this, eventsDataSetSelector, "Load Events", 2)) {
            try {
                QDataSet ds = org.autoplot.jythonsupport.Util.getDataSet(eventsDataSetSelector.getValue());
                ds = Ops.createEvents(ds);
                Units tu = (Units)((QDataSet)ds.property("BUNDLE_1")).property("UNITS", 0);
                StringBuilder ss = new StringBuilder();
                for (int i = 0; i < ds.length(); ++i) {
                    QDataSet tr = ds.slice(i).trim(0, 2);
                    tr = Ops.putProperty(tr, "UNITS", (Object)tu);
                    ss.append(DataSetUtil.asDatumRange(tr).toString()).append("\n");
                }
                this.param1Values.setText(ss.toString());
            }
            catch (Exception ex) {
                Logger.getLogger(BatchMaster.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void generateButton2ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param2NameCB, this.param2Values);
    }

    private void generateButton1ActionPerformed(ActionEvent evt) {
        this.doGenerate(this.param1NameCB, this.param1Values);
    }

    private void param1NameCBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.generateButton1.setEnabled(this.param1NameCB.getSelectedItem().toString().trim().length() > 0);
        }
    }

    private void param2NameCBItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.generateButton2.setEnabled(this.param2NameCB.getSelectedItem().toString().trim().length() > 0);
        }
    }

    private void doGenerate(JComboBox cb, JTextArea ta) {
        if (cb.getSelectedItem() == null) {
            return;
        }
        String p = cb.getSelectedItem().toString();
        if ((p = p.trim()).length() > 0) {
            try {
                String label;
                JPanel panel;
                JythonUtil.Param pd = this.getParamDescription(p);
                if (pd == null) {
                    return;
                }
                String[] ss = null;
                if (pd.type == 'T') {
                    try {
                        if (AutoplotUtil.showConfirmDialog(this, this.timeRangesPanel, "Generate Time Ranges", 2) == 0) {
                            ss = ScriptContext.generateTimeRanges(this.timeFormatComboBox.getSelectedItem().toString(), this.timeRangeComboBox.getSelectedItem().toString());
                        }
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(BatchMaster.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (pd.enums != null) {
                    panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    label = pd.label;
                    if (pd.doc != null) {
                        label = "<html>" + label + ", <i>" + pd.doc + "</i>";
                    }
                    panel.add(new JLabel(label));
                    for (int i = 0; i < pd.enums.size(); ++i) {
                        JCheckBox checkBox = new JCheckBox(pd.enums.get(i).toString());
                        checkBox.setSelected(true);
                        panel.add(checkBox);
                    }
                    AbstractAction a = new AbstractAction("clear all"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Component c : panel.getComponents()) {
                                if (!(c instanceof JCheckBox)) continue;
                                ((JCheckBox)c).setSelected(false);
                            }
                        }
                    };
                    panel.add(new JButton(a));
                    JScrollPane scrollPane = new JScrollPane(panel);
                    scrollPane.setPreferredSize(new Dimension(300, 400));
                    scrollPane.setMaximumSize(new Dimension(300, 400));
                    scrollPane.getVerticalScrollBar().setUnitIncrement(panel.getFont().getSize());
                    if (AutoplotUtil.showConfirmDialog(this, scrollPane, "Select from Values", 2) == 0) {
                        ArrayList<String> theList = new ArrayList<String>();
                        for (Component c : panel.getComponents()) {
                            if (!(c instanceof JCheckBox) || !((JCheckBox)c).isSelected()) continue;
                            theList.add(((JCheckBox)c).getText());
                        }
                        ss = theList.toArray(new String[theList.size()]);
                    }
                } else if (pd.type == 'F') {
                    boolean isInt;
                    panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    label = pd.label;
                    if (pd.doc != null) {
                        label = "<html>" + label + ", <i>" + pd.doc + "</i>";
                    }
                    panel.add(new JLabel(label));
                    JTextField min = new JTextField("");
                    JTextField max = new JTextField("");
                    JTextField step = new JTextField("");
                    min.setText(String.valueOf(pd.deft));
                    if (pd.deft instanceof Integer) {
                        max.setText(String.valueOf((Integer)pd.deft + 4));
                        step.setText("1");
                        isInt = true;
                    } else {
                        max.setText(String.valueOf(((Number)pd.deft).doubleValue() + 10.0));
                        step.setText("0.1");
                        isInt = false;
                    }
                    panel.add(new JLabel("Minimum: "));
                    panel.add(min);
                    panel.add(new JLabel("Maximum: "));
                    panel.add(max);
                    panel.add(new JLabel("Step Size: "));
                    panel.add(step);
                    while (AutoplotUtil.showConfirmDialog(this, panel, "Select range", 2) == 0) {
                        ArrayList<String> theList = new ArrayList<String>();
                        double dmin = Double.parseDouble(min.getText());
                        double dmax = Double.parseDouble(max.getText());
                        double dstep = Double.parseDouble(step.getText());
                        if (dstep <= 0.0 || dmax < dmin) continue;
                        int ni = (int)Math.round((dmax - dmin) / dstep) + 1;
                        int digits = (int)Math.floor(Math.log10(dstep));
                        double dfac = 1.0;
                        String spec = digits < 0 ? "%." + -digits + "f" : "%.0f";
                        for (int i = 0; i < ni; ++i) {
                            double x = (dmin + dstep * (double)i) * dfac;
                            theList.add(isInt ? String.valueOf((int)Math.round(x)) : String.format(spec, x));
                        }
                        ss = theList.toArray(new String[theList.size()]);
                        break;
                    }
                } else if (pd.type == 'R') {
                    String deft = String.valueOf(pd.deft);
                    File f = null;
                    try {
                        URISplit split = URISplit.parse(deft);
                        if (split.path.startsWith("file:")) {
                            f = new File(split.path.substring(5));
                        }
                    }
                    catch (IllegalArgumentException split) {
                        // empty catch block
                    }
                    String lastItem = ta.getText().trim();
                    if (lastItem.length() > 0) {
                        int i = lastItem.lastIndexOf("\n");
                        lastItem = lastItem.substring(i + 1);
                        f = new File(lastItem.substring(5));
                    }
                    JFileChooser cf = new JFileChooser();
                    if (f != null) {
                        cf.setCurrentDirectory(f);
                    }
                    cf.setMultiSelectionEnabled(true);
                    if (cf.showOpenDialog(this) == 0) {
                        File[] ff = cf.getSelectedFiles();
                        ss = new String[ff.length];
                        for (int i = 0; i < ff.length; ++i) {
                            ss[i] = "file:" + ff[i].toString();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Parameter type doesn't support type.");
                    return;
                }
                if (ss != null) {
                    StringBuilder b = new StringBuilder();
                    for (String s : ss) {
                        b.append(s).append("\n");
                    }
                    ta.setText(b.toString());
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "bad parameter name");
            }
        }
    }

    private JythonUtil.Param getParamDescription(String name) throws IOException {
        String scriptName = this.dataSetSelector1.getValue();
        URISplit split = URISplit.parse(scriptName);
        if (!split.file.endsWith(".jy")) {
            JOptionPane.showMessageDialog(this, "script must end in .jy: " + scriptName);
            return null;
        }
        this.pwd = split.path;
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        HashMap<String, Object> env = new HashMap<String, Object>();
        File scriptFile = DataSetURI.getFile(split.file, (ProgressMonitor)new NullProgressMonitor());
        String script = this.readScript(scriptFile);
        env.put("dom", this.dom);
        Map<String, JythonUtil.Param> parms = Util.getParams(env, script, params, new NullProgressMonitor());
        JythonUtil.Param p = parms.get(name);
        return p;
    }

    private void setParam(InteractiveInterpreter interp, JythonUtil.Param paramDescription, String paramName, String f1) throws IOException {
        if (paramDescription == null) {
            throw new IllegalArgumentException("expected to see parameter description!");
        }
        switch (paramDescription.type) {
            case 'R': 
            case 'U': {
                URI uri;
                try {
                    URISplit split = URISplit.parse(f1);
                    uri = split.path == null ? new URI(this.pwd + f1) : new URI(f1);
                }
                catch (URISyntaxException ex) {
                    throw new IOException(ex);
                }
                interp.set("_apuri", (Object)uri);
                interp.exec("autoplot2017.params['" + paramName + "']=_apuri");
                break;
            }
            case 'A': {
                interp.exec("autoplot2017.params['" + paramName + "']='" + f1 + "'");
                break;
            }
            case 'T': {
                try {
                    DatumRange timeRange = DatumRangeUtil.parseTimeRange(f1);
                    interp.set("_apdr", (Object)timeRange);
                    interp.exec("autoplot2017.params['" + paramName + "']=_apdr");
                }
                catch (ParseException ex) {
                    Logger.getLogger(BatchMaster.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                interp.exec("autoplot2017.params['" + paramName + "']=" + f1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScript(File f) throws FileNotFoundException, IOException {
        StringBuilder build = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String line = r.readLine();
            while (line != null) {
                build.append(line).append("\n");
                line = r.readLine();
            }
        }
        return build.toString();
    }

    private void doWrite(String f1, String f2) throws IOException {
        if (this.writeCheckBox.isSelected()) {
            String template = this.writeFilenameCB.getSelectedItem().toString();
            String[] ss = template.split("\\$x", -2);
            StringBuilder f = new StringBuilder(ss[0]);
            if (ss.length > 1) {
                f.append(f1).append(ss[1]);
            }
            if (ss.length > 2) {
                f.append(f2.trim()).append(ss[2]);
            }
            for (int i = 3; i < ss.length; ++i) {
                f.append(ss[i]);
            }
            String s = f.toString();
            if (s.endsWith(".png")) {
                ScriptContext.writeToPng(s);
            } else if (s.endsWith(".pdf")) {
                ScriptContext.writeToPdf(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt() throws IOException {
        DasProgressPanel monitor = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(this), "Run Batch");
        try {
            String template;
            String scriptName = this.dataSetSelector1.getValue();
            URISplit split = URISplit.parse(scriptName);
            this.pwd = split.path;
            if (!split.file.endsWith(".jy")) {
                JOptionPane.showMessageDialog(this, "script must end in .jy: " + scriptName);
                return;
            }
            String[] ff1 = this.param1Values.getText().split("\n");
            monitor.setTaskSize(ff1.length);
            monitor.started();
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("dom", this.dom);
            File scriptFile = DataSetURI.getFile(split.file, monitor.getSubtaskMonitor("download script"));
            String script = this.readScript(scriptFile);
            Map<String, JythonUtil.Param> parms = Util.getParams(env, script, params, new NullProgressMonitor());
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
            interp.exec(JythonRefactory.fixImports("import autoplot"));
            ParametersFormPanel pfp = new ParametersFormPanel();
            pfp.doVariables(env, scriptFile, params, null);
            for (Map.Entry ent : params.entrySet()) {
                try {
                    pfp.getFormData().implement((PythonInterpreter)interp, (String)ent.getKey(), (String)ent.getValue());
                }
                catch (ParseException ex) {
                    this.logger.log(Level.SEVERE, null, ex);
                }
            }
            if (this.writeCheckBox.isSelected() && !(template = this.writeFilenameCB.getSelectedItem().toString()).endsWith(".pdf") && !template.endsWith(".png")) {
                AutoplotUtil.showConfirmDialog(this, "write template must end in .pdf or .png", "Write Template Error", 0);
                return;
            }
            monitor.setTaskSize(ff1.length);
            int i1 = 0;
            for (String f1 : ff1) {
                try {
                    monitor.setProgressMessage(f1);
                    if (monitor.isCancelled()) {
                        break;
                    }
                    monitor.setTaskProgress(monitor.getTaskProgress() + 1L);
                    if (f1.trim().length() == 0) continue;
                    interp.set("monitor", (Object)new NullProgressMonitor());
                    interp.set("dom", (Object)this.dom);
                    interp.set("PWD", (Object)split.path);
                    String paramName = this.param1NameCB.getSelectedItem().toString();
                    if (!parms.containsKey(paramName) && paramName.trim().length() == 0) {
                        throw new IllegalArgumentException("param1Name not set");
                    }
                    this.setParam(interp, parms.get(paramName), paramName, f1);
                    if (this.param2NameCB.getSelectedItem().toString().trim().length() == 0) {
                        interp.execfile(JythonRefactory.fixImports(new FileInputStream(scriptFile)), scriptFile.getName());
                        if (this.writeCheckBox.isSelected()) {
                            this.doWrite(f1, "");
                        }
                    } else {
                        String[] ff2 = this.param2Values.getText().split("\n");
                        int i2 = 0;
                        for (String f2 : ff2) {
                            if (f2.trim().length() == 0) continue;
                            paramName = this.param2NameCB.getSelectedItem().toString();
                            this.setParam(interp, parms.get(paramName), paramName, f2);
                            interp.execfile(JythonRefactory.fixImports(new FileInputStream(scriptFile)), scriptFile.getName());
                            i2 = i2 + f2.length() + 1;
                            if (!this.writeCheckBox.isSelected()) continue;
                            this.doWrite(f1, f2);
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BatchMaster.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (Exception ex) {
                    Logger.getLogger(BatchMaster.class.getName()).log(Level.SEVERE, null, ex);
                }
                i1 = i1 + f1.length() + 1;
            }
        }
        finally {
            monitor.finished();
            this.goButton.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        JDialog dia = new JDialog();
        dia.setResizable(true);
        BatchMaster mmm = new BatchMaster(new Application());
        dia.setContentPane(mmm);
        mmm.param1NameCB.setSelectedItem("ie");
        mmm.dataSetSelector1.setValue("/home/jbf/ct/autoplot/script/demos/paramTypes.jy");
        mmm.param1Values.setText("1\n2\n3\n");
        dia.pack();
        dia.setVisible(true);
    }
}

