/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import com.cottagesystems.jdiskhog.JDiskHogPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.CSH;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultEditorKit;
import javax.xml.parsers.ParserConfigurationException;
import org.autoplot.APSplash;
import org.autoplot.AddSampListener;
import org.autoplot.AggregateUrisDialog;
import org.autoplot.AppManager;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.AxisPanel;
import org.autoplot.BatchMaster;
import org.autoplot.CanvasSizePanel;
import org.autoplot.DataPanel;
import org.autoplot.EventThreadResponseMonitor;
import org.autoplot.EventsListToolUtil;
import org.autoplot.FontAndColorsDialog;
import org.autoplot.GettingStartedPanel;
import org.autoplot.GuiSupport;
import org.autoplot.LayoutListener;
import org.autoplot.LayoutPanel;
import org.autoplot.MetadataPanel;
import org.autoplot.MoveCacheDialog;
import org.autoplot.OptionsDialog;
import org.autoplot.PersistentStateSupport;
import org.autoplot.PlotStylePanel;
import org.autoplot.RecentUrisDialog;
import org.autoplot.RunScriptPanel;
import org.autoplot.ScriptContext;
import org.autoplot.UriDropTargetListener;
import org.autoplot.UriTimeRangeToggleButton;
import org.autoplot.Util;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.bookmarks.BookmarksManagerModel;
import org.autoplot.bookmarks.DelayMenu;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetSelectorSupport;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.datasource.SourceTypesBrowser;
import org.autoplot.datasource.TimeRangeEditor;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomOps;
import org.autoplot.dom.OptionsPrefsController;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.help.AutoplotHelpSystem;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.ui.DataMashUp;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.layout.LayoutConstants;
import org.autoplot.pngwalk.CreatePngWalk;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.scriptconsole.GuiExceptionHandler;
import org.autoplot.scriptconsole.JythonScriptPanel;
import org.autoplot.scriptconsole.LogConsole;
import org.autoplot.server.RequestHandler;
import org.autoplot.server.RequestListener;
import org.autoplot.state.UndoRedoSupport;
import org.autoplot.util.TickleTimer;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.components.TearoffTabbedPane;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dasml.DOMBuilder;
import org.das2.dasml.SerializeUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.qds.DataSetAnnotations;
import org.das2.qds.QDataSet;
import org.das2.qds.filters.AddFilterDialog;
import org.das2.qds.filters.FiltersChainPanel;
import org.das2.system.RequestProcessor;
import org.das2.util.AboutUtil;
import org.das2.util.ArgumentList;
import org.das2.util.ExceptionHandler;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class AutoplotUI
extends JFrame {
    private static final String TAB_SCRIPT = "script";
    private static final String TAB_CONSOLE = "console";
    final String TAB_TOOLTIP_CANVAS = "<html>Canvas tab contains the plot and plot elements.<br>Click on plot elements to select.<br>%s</html>";
    final String TAB_TOOLTIP_AXES = "<html>Adjust selected plot axes.<br>%s<html>";
    final String TAB_TOOLTIP_LOGCONSOLE = "<html>Log console displays log messages and stdout/stderr.<br>%s</html>";
    final String TAB_TOOLTIP_STYLE = "<html>Adjust selected plot element's colors, shapes, and other style settings.<br>%s</html>";
    final String TAB_TOOLTIP_LAYOUT = "<html>Inspect the canvas layout and property bindings, and<br>provides access to all plot elements.<br>%s</html>";
    final String TAB_TOOLTIP_DATA = "<html>Specify valid ranges and apply additional operations to data.<br>%s</html>";
    final String TAB_TOOLTIP_METADATA = "<html>Inspect selected element's metadata and data statistics.<br>%s</html>";
    final String TAB_TOOLTIP_SCRIPT = "<html>Editor panel for Jython scripts and data sources.<br>%s</html>";
    final String TABS_TOOLTIP = "Right-click or drag to undock.";
    public static final String CARD_DATA_SET_SELECTOR = "dataCard";
    public static final String CARD_TIME_RANGE_SELECTOR = "timeCard";
    TearoffTabbedPane tabs;
    transient ApplicationModel applicationModel;
    Application dom;
    transient PersistentStateSupport stateSupport;
    final transient UndoRedoSupport undoRedoSupport;
    TickleTimer tickleTimer;
    transient GuiSupport support;
    transient LayoutListener autoLayout;
    private boolean dsSelectTimerangeBound = false;
    String pendingVap = null;
    private String initialBookmarksUrl = null;
    String applicationName = "";
    transient PersistentStateSupport.SerializationStrategy serStrategy = new PersistentStateSupport.SerializationStrategy(){

        @Override
        public Element serialize(Document document, ProgressMonitor monitor) {
            DOMBuilder builder = new DOMBuilder(AutoplotUI.this.applicationModel);
            Element element = builder.serialize(document, DasProgressPanel.createFramed("Serializing Application"));
            return element;
        }

        @Override
        public void deserialize(Document document, ProgressMonitor monitor) {
            Element element = document.getDocumentElement();
            SerializeUtil.processElement(element, AutoplotUI.this.applicationModel);
        }
    };
    private static final Logger logger = LoggerManager.getLogger("autoplot.gui");
    private JythonScriptPanel scriptPanel;
    private DataPanel dataPanel;
    private LayoutPanel layoutPanel;
    private JScrollPane layoutPanel1;
    private LogConsole logConsole;
    private JScrollPane logConsolePanel;
    private JPanel jythonScriptPanel;
    private transient RequestListener rlistener;
    private JDialog fontAndColorsDialog = null;
    private BookmarksManager bookmarksManager = null;
    private BookmarksManager toolsManager = null;
    private AutoplotHelpSystem helpSystem;
    private transient UriDropTargetListener dropListener;
    private static final String RESOURCES = "/org/autoplot/resources/";
    public static final Icon WARNING_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/warning-icon.png"));
    public static final Icon ERROR_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/error-icon.png"));
    public static final Icon BUSY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/spinner.gif"));
    public static final Icon BUSY_OPAQUE_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/spinner_16.gif"));
    public static final Icon READY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/indProgress0.png"));
    public static final Icon IDLE_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/idle-icon.png"));
    public static final String READY_MESSAGE = "ready";
    private static final String PENDING_CHANGE_PLOTURI = "plotUri";
    private static final String PENDING_CHANGE_INITIAL_URI = "initialUri";
    private TimeRangeEditor timeRangeEditor;
    private List<JComponent> expertMenuItems = new ArrayList<JComponent>();
    private JMenu expertMenu;
    private transient Timer apbusy = new Timer("apbusy", true);
    JMenu addDataFromMenu = null;
    private String editorCard = "dataCard";
    public static final String PROP_EDITORCARD = "editorCard";
    private transient PropertyChangeListener optionsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            switch (ev.getPropertyName()) {
                case "layoutVisible": {
                    if (Boolean.TRUE.equals(ev.getNewValue())) {
                        int idx;
                        if (AutoplotUI.this.layoutPanel == null) {
                            AutoplotUI.this.layoutPanel = new LayoutPanel();
                            AutoplotUI.this.layoutPanel.setApplication(AutoplotUI.this.dom);
                            AutoplotUI.this.layoutPanel.setApplicationModel(AutoplotUI.this.applicationModel);
                        }
                        if ((idx = AutoplotUI.this.tabs.indexOfTab("style")) == -1) {
                            idx = AutoplotUI.this.tabs.getTabCount();
                        }
                        JScrollPane jsp = new JScrollPane();
                        jsp.setViewportView(AutoplotUI.this.layoutPanel);
                        AutoplotUI.this.tabs.insertTab("layout", null, jsp, String.format("<html>Inspect the canvas layout and property bindings, and<br>provides access to all plot elements.<br>%s</html>", "Right-click or drag to undock."), idx + 1);
                        break;
                    }
                    if (AutoplotUI.this.layoutPanel == null) break;
                    AutoplotUI.this.tabs.remove(AutoplotUI.this.layoutPanel.getParent().getParent());
                    break;
                }
                case "dataVisible": {
                    if (Boolean.TRUE.equals(ev.getNewValue())) {
                        int idx;
                        if (AutoplotUI.this.dataPanel == null) {
                            AutoplotUI.this.dataPanel = new DataPanel(AutoplotUI.this);
                        }
                        if ((idx = AutoplotUI.this.tabs.indexOfTab("metadata")) == -1) {
                            idx = AutoplotUI.this.tabs.getTabCount();
                        }
                        JScrollPane jsp = new JScrollPane();
                        jsp.setViewportView(AutoplotUI.this.dataPanel);
                        AutoplotUI.this.tabs.insertTab("data", null, jsp, String.format("<html>Specify valid ranges and apply additional operations to data.<br>%s</html>", "Right-click or drag to undock."), idx);
                        break;
                    }
                    if (AutoplotUI.this.dataPanel == null) break;
                    AutoplotUI.this.tabs.remove(AutoplotUI.this.dataPanel.getParent().getParent());
                    break;
                }
                case "useTimeRangeEditor": {
                    if (Boolean.TRUE.equals(ev.getNewValue())) {
                        AutoplotUI.this.setEditorCard(AutoplotUI.CARD_TIME_RANGE_SELECTOR);
                        break;
                    }
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_DATA_SET_SELECTOR);
                    break;
                }
                default: {
                    logger.log(Level.FINER, "option requires no action: {0}", ev.getPropertyName());
                }
            }
        }
    };
    Icon currentIcon;
    String currentIconTooltip;
    private transient Runnable updateIconRunnable = new Runnable(){

        @Override
        public void run() {
            AutoplotUI.this.statusLabel.setToolTipText(AutoplotUI.this.currentIconTooltip);
            if (AutoplotUI.this.statusLabel.getIcon() != WARNING_ICON) {
                AutoplotUI.this.statusLabel.setIcon(AutoplotUI.this.currentIcon);
            }
        }
    };
    private JMenuItem aboutAutoplotMenuItem;
    private JMenuItem aboutDas2MenuItem;
    private JMenuItem additionalOptionsMI;
    private ButtonGroup addressBarButtonGroup;
    private JMenu addressBarMenu;
    private JSeparator aggSeparator;
    private JMenuItem aggregateMenuItem;
    private JCheckBoxMenuItem autoLabellingCheckBoxMenuItem;
    private JCheckBoxMenuItem autoLayoutCheckBoxMenuItem;
    private JMenu autoMenu;
    private JCheckBoxMenuItem autoRangingCheckBoxMenuItem;
    private JMenuItem autoplotHelpMenuItem;
    private JMenuItem autoplotHomepageButton;
    private JMenu bookmarksMenu;
    private JMenu cacheMenu;
    private JMenuItem canvasSizeMenuItem;
    private JMenuItem copyDataSetURLMenuItem;
    private JMenuItem copyImageMenuItem;
    private JMenuItem createPngWalkMenuItem;
    private JSeparator createPngWalkSeparator;
    private JCheckBoxMenuItem dataPanelCheckBoxMenuItem;
    protected DataSetSelector dataSetSelector;
    private JRadioButtonMenuItem dataSetSelectorMenuItem;
    private JMenuItem decodeURLItem;
    private JCheckBoxMenuItem doyCB;
    private JCheckBoxMenuItem drawAntiAliasMenuItem;
    private JCheckBoxMenuItem drawGridCheckBox;
    private JMenuItem editDomMenuItem;
    private JSeparator editDomSeparator;
    private JMenu editMenu;
    private JMenuItem editOptions;
    private JMenu enableFeatureMenu;
    private JMenuItem exceptionReport;
    private JMenu fileMenu;
    private JMenuItem filtersMenuItem;
    private JMenuItem fixLayoutMenuItem;
    private JMenuItem fontsAndColorsMenuItem;
    private JMenuItem gettingStartedMenuItem;
    private JMenu helpMenu;
    private JMenuItem inspectVapFileMenuItem;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JSeparator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JCheckBoxMenuItem layoutPanelCheckBoxMenuItem;
    private JCheckBoxMenuItem logConsoleMenuItem;
    private JMenuItem manageFilesystemsMI;
    private JMenuItem mashDataMenuItem;
    private JCheckBoxMenuItem nnCb;
    private JMenu optionsMenu;
    private JCheckBoxMenuItem overRenderingMenuItem;
    private JMenuItem pasteDataSetURLMenuItem;
    private JMenu plotStyleMenu;
    private JMenuItem pngWalkMenuItem;
    private JMenuItem redoMenuItem;
    private JCheckBoxMenuItem referenceCacheCheckBoxMenuItem;
    private JMenuItem reloadAllMenuItem;
    private JMenu renderingOptionsMenu;
    private JMenuItem replaceFileMenuItem;
    private JMenuItem resetFontMI;
    private JMenuItem resetMemoryCachesMI;
    private JMenuItem resetXMenuItem;
    private JMenuItem resetYMenuItem;
    private JMenuItem resetZMenuItem;
    private JMenu resetZoomMenu;
    private JMenuItem resetZoomMenuItem;
    private JMenuItem runBatchMenuItem;
    private JCheckBoxMenuItem scriptPanelMenuItem;
    private JMenuItem searchToolTipsMenuItem;
    private JCheckBoxMenuItem serverCheckBoxMenuItem;
    private JCheckBoxMenuItem specialEffectsMenuItem;
    private JLabel statusLabel;
    private JTextField statusTextField;
    private JPanel tabbedPanelContainer;
    private JCheckBoxMenuItem textAntiAlias;
    private JMenu textSizeMenu;
    private JPanel timeRangePanel;
    private JRadioButtonMenuItem timeRangeSelectorMenuItem;
    private JMenu toolsMenu;
    private JPopupMenu.Separator toolsUserSep;
    private JMenuItem undoMenuItem;
    private JMenu undoMultipleMenu;
    private UriTimeRangeToggleButton uriTimeRangeToggleButton1;
    private JMenu viewMenu;
    private JCheckBoxMenuItem workOfflineCheckBoxMenuItem;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;
    private BindingGroup bindingGroup;

    void setApplicationName(String id) {
        this.applicationName = id;
    }

    public AutoplotUI(ApplicationModel model) {
        this.setIconImage(AutoplotUtil.getAutoplotIcon());
        APSplash.checkTime("init 0");
        File toolsDir = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools");
        File booksDir = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks");
        if (!toolsDir.exists() && !toolsDir.mkdirs()) {
            logger.log(Level.WARNING, "unable to make directory: {0}", toolsDir);
        }
        if (!booksDir.exists() && !booksDir.mkdirs()) {
            logger.log(Level.WARNING, "unable to make directory: {0}", booksDir);
        }
        if (System.getProperty("noCheckCertificate", "true").equals("true")) {
            logger.fine("disabling HTTP certificate checks.");
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (NoSuchAlgorithmException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            catch (KeyManagementException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        AutoplotHelpSystem.initialize(this.getRootPane());
        this.helpSystem = AutoplotHelpSystem.getHelpSystem();
        DasApplication.getDefaultApplication().setMainFrame(this);
        if (DasApplication.getDefaultApplication().isHeadless()) {
            model.setExceptionHandler(DasApplication.getDefaultApplication().getExceptionHandler());
        } else {
            model.setExceptionHandler(new GuiExceptionHandler());
        }
        this.applicationModel = model;
        this.dom = model.getDocumentModel();
        if (!ScriptContext.isModelInitialized()) {
            ScriptContext.setApplicationModel(model);
            ScriptContext.setView(this);
            ScriptContext._setDefaultApp(this);
        }
        model.setResizeRequestListener(new ApplicationModel.ResizeRequestListener(){

            @Override
            public double resize(int w, int h) {
                return AutoplotUI.this.resizeForCanvasSize(w, h);
            }
        });
        APSplash.checkTime("init 10");
        this.support = new GuiSupport(this);
        this.applicationModel = model;
        this.undoRedoSupport = new UndoRedoSupport(this.applicationModel);
        this.undoRedoSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoplotUI.this.refreshUndoRedoLabel();
                    }
                });
            }
        });
        this.applicationModel.addPropertyChangeListener("vapFile", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        this.undoRedoSupport.addPropertyChangeListener("depth", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        APSplash.checkTime("init 20");
        FileSystem.settings().addPropertyChangeListener("offline", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        if (model.getExceptionHandler() instanceof GuiExceptionHandler) {
            ((GuiExceptionHandler)model.getExceptionHandler()).setUndoRedoSupport(this.undoRedoSupport);
        }
        this.initComponents();
        this.referenceCacheCheckBoxMenuItem.setSelected(System.getProperty("enableReferenceCache", "true").equals("true"));
        this.expertMenuItems.add(this.editDomMenuItem);
        this.expertMenuItems.add(this.editDomSeparator);
        this.expertMenuItems.add(this.inspectVapFileMenuItem);
        this.expertMenuItems.add(this.renderingOptionsMenu);
        this.expertMenuItems.add(this.enableFeatureMenu);
        this.expertMenuItems.add(this.autoMenu);
        this.expertMenuItems.add(this.pngWalkMenuItem);
        this.expertMenuItems.add(this.createPngWalkMenuItem);
        this.expertMenuItems.add(this.createPngWalkSeparator);
        this.expertMenuItems.add(this.aggSeparator);
        this.expertMenuItems.add(this.aggregateMenuItem);
        this.expertMenuItems.add(this.decodeURLItem);
        this.jMenuBar1.add(Box.createHorizontalGlue());
        this.expertMenu = new JMenu("Expert");
        JMenuItem mi = new JMenuItem(new AbstractAction("Basic Mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                AutoplotUI.this.setExpertMode(false);
            }
        });
        mi.setToolTipText("Basic mode allows for browsing products composed by data providers");
        this.expertMenu.add(mi);
        mi = new JMenuItem(new AbstractAction("Expert Mode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                AutoplotUI.this.setExpertMode(true);
            }
        });
        mi.setToolTipText("Expert allows composing new products and scripting");
        this.expertMenu.add(mi);
        this.expertMenu.setToolTipText("<html>Toggle between expert and basic mode.<br>Basic mode allows for browsing products composed by data providers<br>Expert allows composing new products and scripting");
        this.jMenuBar1.add(this.expertMenu);
        KeyChain.getDefault().setParentGUI(this);
        APSplash.checkTime("init 25");
        this.timeRangeEditor = new TimeRangeEditor();
        Dimension d = this.timeRangeEditor.getMinimumSize();
        this.timeRangePanel.add((Component)this.timeRangeEditor, CARD_TIME_RANGE_SELECTOR);
        this.timeRangeEditor.setMinimumSize(d);
        this.timeRangePanel.setMinimumSize(d);
        this.timeRangeEditor.setDataSetSelectorPeer(this.dataSetSelector);
        this.timeRangeEditor.setAlternatePeer("Switch to Data Set Selector", CARD_DATA_SET_SELECTOR);
        this.dataSetSelector.setAlternatePeer("Switch to Time Range Editor", CARD_TIME_RANGE_SELECTOR);
        this.dataSetSelector.setCardSelected(true);
        this.timeRangeEditor.addPropertyChangeListener("cardSelected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_TIME_RANGE_SELECTOR);
                    AutoplotUI.this.dataSetSelector.setCardSelected(false);
                } else {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_DATA_SET_SELECTOR);
                    AutoplotUI.this.dataSetSelector.setCardSelected(true);
                }
            }
        });
        this.dataSetSelector.addPropertyChangeListener("cardSelected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_DATA_SET_SELECTOR);
                    AutoplotUI.this.timeRangeEditor.setCardSelected(false);
                } else {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_TIME_RANGE_SELECTOR);
                    AutoplotUI.this.timeRangeEditor.setCardSelected(true);
                }
            }
        });
        this.uriTimeRangeToggleButton1.addPropertyChangeListener("position", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue().equals(1)) {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_DATA_SET_SELECTOR);
                    AutoplotUI.this.timeRangeEditor.setCardSelected(false);
                } else {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_TIME_RANGE_SELECTOR);
                    AutoplotUI.this.timeRangeEditor.setCardSelected(true);
                }
            }
        });
        this.timeRangeEditor.setNoOneListeningRange(Application.DEFAULT_TIME_RANGE);
        this.timeRangeEditor.setRange(Application.DEFAULT_TIME_RANGE);
        this.dom.getController().addPropertyChangeListener("focusUri", this.timeRangeEditor.getUriFocusListener());
        this.statusTextField.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.statusTextField.setOpaque(false);
        this.statusLabel.setIcon(IDLE_ICON);
        this.support.addKeyBindings((JPanel)this.getContentPane());
        APSplash.checkTime("init 30");
        this.dataSetSelector.setMonitorFactory(this.dom.getController().getMonitorFactory());
        this.dataSetSelector.registerBrowseTrigger("vap\\+internal:(.*)", new AbstractAction("internal"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                GuiSupport.editPlotElement(AutoplotUI.this.applicationModel, AutoplotUI.this);
            }
        });
        this.dataSetSelector.registerActionTrigger("bookmarks:(.*)", new AbstractAction("bookmarks"){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        String bookmarksFile = AutoplotUI.this.dataSetSelector.getValue().substring("bookmarks:".length());
                        if (bookmarksFile.endsWith("/") || bookmarksFile.endsWith(".")) {
                            DataSetSelector source = (DataSetSelector)ev.getSource();
                            source.showFileSystemCompletions(true, false, "[^\\s]+[^\\s]+(\\.(?i)(xml)|(xml\\.gz))$");
                        } else {
                            while (AutoplotUI.this.getBookmarksManager() == null || AutoplotUI.this.getBookmarksManager().getModel() == null || AutoplotUI.this.getBookmarksManager().getModel().getList() == null) {
                                logger.fine("waiting for bookmarks manager to be initialized");
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                                }
                            }
                            if (!AutoplotUI.this.getBookmarksManager().haveRemoteBookmark(bookmarksFile)) {
                                AutoplotUI.this.support.importBookmarks(bookmarksFile);
                                AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                            } else {
                                AutoplotUI.this.setStatus("remote bookmarks file is already imported");
                            }
                        }
                    }
                };
                new Thread(run, "bookmarksUri").start();
            }
        });
        this.dataSetSelector.registerBrowseTrigger("bookmarks:(.*)", new AbstractAction("bookmarks"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                DataSetSelector source = (DataSetSelector)ev.getSource();
                source.showFileSystemCompletions(false, true, "[^\\s]+(\\.(?i)(xml)|(xml\\.gz))$");
            }
        });
        this.dataSetSelector.registerActionTrigger("pngwalk:(.*)", new AbstractAction("pngwalk"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                String pngwalk = AutoplotUI.this.dataSetSelector.getValue().substring("pngwalk:".length());
                if (pngwalk.endsWith("/") || pngwalk.endsWith(".")) {
                    DataSetSelector source = (DataSetSelector)ev.getSource();
                    source.showFileSystemCompletions(true, false, "[^\\s]+(\\.(?i)(jpg|png|gif))$");
                } else {
                    PngWalkTool.start(pngwalk, AutoplotUI.this);
                    AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                }
            }
        });
        this.dataSetSelector.registerBrowseTrigger("pngwalk:(.*)", new AbstractAction("pngwalk"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                DataSetSelector source = (DataSetSelector)ev.getSource();
                source.showFileSystemCompletions(true, false, "[^\\s]+(\\.(?i)(jpg|png|gif))$");
            }
        });
        this.dataSetSelector.registerActionTrigger("(.*)\\.pngwalk", new AbstractAction("pngwalk"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                String pngwalk = AutoplotUI.this.dataSetSelector.getValue();
                PngWalkTool.start(pngwalk, AutoplotUI.this);
            }
        });
        this.dataSetSelector.registerActionTrigger(".*(\\*).*\\.(png|jpg|gif)", new AbstractAction("pngwalk"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                String pngwalk = AutoplotUI.this.dataSetSelector.getValue();
                PngWalkTool.start(pngwalk, AutoplotUI.this);
            }
        });
        this.dataSetSelector.registerActionTrigger("http.*/hapi(/info\\?.*)?", new AbstractAction("hapiServer"){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                String id;
                LoggerManager.logGuiEvent(ev);
                String value = AutoplotUI.this.dataSetSelector.getValue();
                Pattern p = Pattern.compile("(http.*/hapi)(/info\\?id=(.*))?");
                Matcher m = p.matcher(value);
                final String newValue = m.matches() ? ((id = m.group(3)) != null ? "vap+hapi:" + m.group(1) + "?id=" + m.group(3) : "vap+hapi:" + m.group(1)) : "vap+hapi:";
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        AutoplotUI.this.dataSetSelector.setValue(newValue);
                        AutoplotUI.this.dataSetSelector.maybePlot(ev.getModifiers());
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
        this.dataSetSelector.registerBrowseTrigger("http.*/hapi(/info\\?.*)?", new AbstractAction("hapiServer"){

            @Override
            public void actionPerformed(final ActionEvent ev) {
                String id;
                LoggerManager.logGuiEvent(ev);
                String value = AutoplotUI.this.dataSetSelector.getValue();
                Pattern p = Pattern.compile("(http.*/hapi)(/info\\?id=(.*))?");
                Matcher m = p.matcher(value);
                final String newValue = m.matches() ? ((id = m.group(3)) != null ? "vap+hapi:" + m.group(1) + "?id=" + m.group(3) : "vap+hapi:" + m.group(1)) : "vap+hapi:";
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        AutoplotUI.this.dataSetSelector.setValue(newValue);
                        AutoplotUI.this.dataSetSelector.maybePlot(ev.getModifiers());
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        });
        this.dataSetSelector.registerActionTrigger("(.*)\\.jy(\\?.*)?", new AbstractAction(TAB_SCRIPT){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ScriptContext.getViewWindow() == AutoplotUI.this) {
                    LoggerManager.logGuiEvent(ev);
                    AutoplotUI.this.runScript(AutoplotUI.this.dataSetSelector.getValue());
                } else {
                    LoggerManager.logGuiEvent(ev);
                    if (0 == JOptionPane.showConfirmDialog(AutoplotUI.this, "Scripts can only be run from the main window.  Make this the main window?", "Reset Main Window", 0)) {
                        ScriptContext.setApplication(AutoplotUI.this);
                    }
                    AutoplotUI.this.runScript(AutoplotUI.this.dataSetSelector.getValue());
                }
                AutoplotUI.this.dom.getController().setFocusUri("");
            }
        });
        this.dataSetSelector.registerBrowseTrigger("(.*)\\.jy(\\?.*)?", new AbstractAction(TAB_SCRIPT){

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ScriptContext.getViewWindow() == AutoplotUI.this) {
                    LoggerManager.logGuiEvent(ev);
                    s = AutoplotUI.this.dataSetSelector.getValue();
                    i = AutoplotUI.this.dataSetSelector.getEditor().getCaretPosition();
                    if (i == 0 || s.substring(i - 1).contains("/")) {
                        AutoplotUI.this.dataSetSelector.showCompletions();
                        return;
                    }
                    try {
                        split = URISplit.parse(s);
                        args = URISplit.parseParams(split.params);
                        if (0 != org.autoplot.JythonUtil.invokeScriptSoon(split.resourceUri, AutoplotUI.this.dom, args, true, true, AutoplotUI.access$400(AutoplotUI.this), (ProgressMonitor)new NullProgressMonitor())) ** GOTO lbl26
                        split.params = URISplit.formatParams(args);
                        if (split.params.trim().length() == 0) {
                            split.params = null;
                        }
                        history = URISplit.format(split);
                        AutoplotUI.this.dataSetSelector.setValue(history);
                        AutoplotUI.this.applicationModel.addRecent(history);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    LoggerManager.logGuiEvent(ev);
                    if (0 == JOptionPane.showConfirmDialog(AutoplotUI.this, "Scripts can only be run from the main window.  Make this the main window?", "Reset Main Window", 0)) {
                        ScriptContext.setApplicationModel(AutoplotUI.this.applicationModel);
                        ScriptContext.setView(AutoplotUI.this);
                    }
                    AutoplotUI.access$300(AutoplotUI.this, AutoplotUI.this.dataSetSelector.getValue());
                }
lbl26:
                // 3 sources

                AutoplotUI.this.dom.getController().setFocusUri("");
            }
        });
        this.dataSetSelector.registerActionTrigger("script:(.*)", new AbstractAction(TAB_SCRIPT){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                String script = AutoplotUI.this.dataSetSelector.getValue().substring("script:".length());
                if (!(script.endsWith(".jy") || script.endsWith(".JY") || script.endsWith(".py") || script.endsWith(".PY"))) {
                    DataSetSelector source = (DataSetSelector)ev.getSource();
                    source.showFileSystemCompletions(false, true, "[^\\s]+\\.jy");
                } else {
                    AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                    AutoplotUI.this.runScript(script);
                }
                AutoplotUI.this.dom.getController().setFocusUri("");
            }
        });
        this.dataSetSelector.registerBrowseTrigger("script:(.*)", new AbstractAction(TAB_SCRIPT){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                DataSetSelector source = (DataSetSelector)ev.getSource();
                String s = source.getValue();
                if (s.endsWith(".jy")) {
                    try {
                        org.autoplot.JythonUtil.invokeScriptSoon(DataSetURI.getResourceURI(s), AutoplotUI.this.dom, new HashMap<String, String>(), true, true, AutoplotUI.this.scriptPanel, (ProgressMonitor)new NullProgressMonitor());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    source.showFileSystemCompletions(false, true, "[^\\s]+\\.jy");
                }
                AutoplotUI.this.dom.getController().setFocusUri("");
            }
        });
        this.dataSetSelector.registerBrowseTrigger("vapfile:(.*)", new AbstractAction("vapfile"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                DataSetSelector source = (DataSetSelector)ev.getSource();
                source.showFileSystemCompletions(false, true, "[^\\s]+(\\.(?i)(vap)|(vap\\.gz))$");
            }
        });
        this.dataSetSelector.registerActionTrigger("vapfile:(.*)", new AbstractAction("vapfile"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                String vapfile = AutoplotUI.this.dataSetSelector.getValue().substring(8);
                URISplit split = URISplit.parse(vapfile);
                if (!(vapfile.endsWith(".xml") || split.params != null && split.params.length() != 0)) {
                    DataSetSelector source = (DataSetSelector)ev.getSource();
                    source.showFileSystemCompletions(false, true, "[^\\s]+\\.jy");
                } else {
                    AutoplotUI.this.applicationModel.addRecent(AutoplotUI.this.dataSetSelector.getValue());
                    InputStream in = null;
                    try {
                        in = vapfile.startsWith("http:") || vapfile.startsWith("https:") ? new URL(vapfile).openStream() : DataSetURI.getInputStream(DataSetURI.toUri(vapfile), (ProgressMonitor)new NullProgressMonitor());
                        AutoplotUI.this.applicationModel.doOpenVap(in, null);
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(AutoplotUI.this, "Unable to load: \n" + vapfile + "\n" + ex);
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException ex2) {
                            logger.log(Level.WARNING, null, ex2);
                        }
                    }
                }
                AutoplotUI.this.dom.getController().setFocusUri("");
            }
        });
        this.dataSetSelector.registerBrowseTrigger(".*\\.vap(\\?.*)?", new AbstractAction("vap file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String surl = AutoplotUI.this.dataSetSelector.getValue();
                URISplit split = URISplit.parse(surl);
                if (split.path.startsWith("file:")) {
                    String result = DataSetSelectorSupport.browseLocalVap(AutoplotUI.this.dataSetSelector, surl);
                    if (result != null) {
                        AutoplotUI.this.dataSetSelector.setValue(result);
                        AutoplotUI.this.dataSetSelector.maybePlot(false);
                    }
                } else {
                    JOptionPane.showMessageDialog(AutoplotUI.this, "Unable to inspect .vap files");
                }
                AutoplotUI.this.setCursor(Cursor.getDefaultCursor());
                AutoplotUI.this.dom.getController().setFocusUri("");
            }
        });
        URISplit.setOtherSchemes(Arrays.asList(TAB_SCRIPT, "pngwalk", "bookmarks", "vapfile"));
        APSplash.checkTime("init 40");
        final ApplicationController appController = this.applicationModel.getDocumentModel().getController();
        appController.addDas2PeerChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PlotController plotController = (PlotController)e.getNewValue();
                ApplicationController controller = plotController.getApplication().getController();
                GuiSupport.addPlotContextMenuItems(AutoplotUI.this, controller, plotController.getDasPlot(), plotController, plotController.getPlot());
                GuiSupport.addAxisContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot(), plotController.getPlot().getXaxis());
                GuiSupport.addAxisContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot(), plotController.getPlot().getYaxis());
                GuiSupport.addAxisContextMenuItems(controller, plotController.getDasPlot(), plotController, plotController.getPlot(), plotController.getPlot().getZaxis());
            }
        });
        appController.addPropertyChangeListener("focusUri", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AutoplotUI.this.pendingVap == null) {
                            AutoplotUI.this.dataSetSelector.setValue(appController.getFocusUri());
                        }
                    }
                });
            }
        });
        this.dataSetSelector.setValue(this.dom.getController().getFocusUri());
        appController.addPropertyChangeListener("status", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.setStatus(appController.getStatus());
            }
        });
        this.applicationModel.getCanvas().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                logger.fine("focus to canvas");
                if (AutoplotUI.this.stateSupport.getCurrentFile() != null) {
                    AutoplotUI.this.dataSetSelector.setValue(AutoplotUI.this.stateSupport.getCurrentFile());
                }
                super.focusGained(e);
            }
        });
        APSplash.checkTime("init 50");
        this.setIconImage(AutoplotUtil.getAutoplotIcon());
        APSplash.checkTime("init 50.5");
        this.updateFrameTitle();
        this.stateSupport = AutoplotUI.getPersistentStateSupport(this, this.applicationModel);
        this.fillFileMenu();
        APSplash.checkTime("init 52.999");
        this.fillInitialBookmarksMenu();
        APSplash.checkTime("init 53");
        AppManager.getInstance().addApplication(this);
        this.addWindowListener(AppManager.getInstance().getWindowListener(this, new AbstractAction("close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (AutoplotUI.this == ScriptContext.getViewWindow()) {
                    ScriptContext.close();
                }
                Preferences prefs = AutoplotSettings.settings().getPreferences(ApplicationModel.class);
                long x = AutoplotUI.this.getLocation().x;
                long y = AutoplotUI.this.getLocation().y;
                logger.log(Level.FINE, "saving last location {0} {1}", new Object[]{x, y});
                prefs.putInt("locationx", AutoplotUI.this.getLocation().x);
                prefs.putInt("locationy", AutoplotUI.this.getLocation().y);
                prefs.putInt("locationscreenwidth", Toolkit.getDefaultToolkit().getScreenSize().width);
            }
        }));
        this.applicationModel.addPropertyChangeListener("vapFile", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AutoplotUI.this.stateSupport.setCurrentFile((String)e.getNewValue());
            }
        });
        this.applicationModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "recent": {
                        final List<Bookmark> recent = AutoplotUI.this.applicationModel.getRecent();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                org.autoplot.bookmarks.Util.setRecent(AutoplotUI.this.dataSetSelector, recent);
                            }
                        });
                        break;
                    }
                    case "bookmarks": {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AutoplotUI.this.updateBookmarks();
                            }
                        });
                        break;
                    }
                    default: {
                        logger.finer("no action needed near line 940: " + evt.getPropertyName());
                    }
                }
            }
        });
        this.autoLayout = new LayoutListener(model);
        APSplash.checkTime("init 55");
        APSplash.checkTime("init 60");
        this.dataSetSelector.addPropertyChangeListener("message", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AutoplotUI.this.setStatus(AutoplotUI.this.dataSetSelector.getMessage());
            }
        });
        this.tabs = new TearoffTabbedPane();
        this.applicationModel.getCanvas().setFitted(true);
        JScrollPane scrollPane = new JScrollPane(this.applicationModel.getCanvas());
        scrollPane.getViewport().setBackground(new JLabel().getBackground());
        this.tabs.insertTab("canvas", null, scrollPane, String.format("<html>Canvas tab contains the plot and plot elements.<br>Click on plot elements to select.<br>%s</html>", "Right-click or drag to undock."), 0);
        this.tabs.validate();
        this.tabbedPanelContainer.add((Component)this.tabs, "Center");
        this.tabs.requestFocus();
        APSplash.checkTime("init 70");
        ApplicationModel fmodel = model;
        this.addAxes().run();
        APSplash.checkTime("init 72");
        this.addStyle().run();
        APSplash.checkTime("init 75");
        this.addFeatures(fmodel);
        APSplash.checkTime("init 77");
        ArrayList<String> uris = new ArrayList<String>();
        List<Bookmark> recent = this.applicationModel.getRecent();
        APSplash.checkTime("init 80");
        for (Bookmark b : recent) {
            uris.add(((Bookmark.Item)b).getUri());
        }
        this.dataSetSelector.setRecent(uris);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.updateBookmarks();
                AutoplotUI.this.dataSetSelector.setPromptText("Enter data location or select a bookmark");
            }
        };
        this.invokeLater(1000, true, run);
        APSplash.checkTime("init 90");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.addTools();
            }
        });
        this.addBindings();
        this.pack();
        this.dom.getOptions().addPropertyChangeListener(this.optionsListener);
        APSplash.checkTime("init 100");
        APSplash.checkTime("init 110");
        run = new Runnable(){

            public String toString() {
                return "addInitializePython";
            }

            @Override
            public void run() {
                try {
                    org.autoplot.JythonUtil.createInterpreter(true, false);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        };
        this.invokeLater(10000, false, run);
    }

    private Runnable addAxes() {
        return new Runnable(){

            @Override
            public void run() {
                APSplash.checkTime("addAxes in");
                final JScrollPane sp = new JScrollPane();
                AutoplotUI.this.tabs.insertTab("axes", null, sp, String.format("<html>Adjust selected plot axes.<br>%s<html>", "Right-click or drag to undock."), 1);
                AutoplotUI.this.invokeLater(2500, true, new Runnable(){

                    public String toString() {
                        return "addAxesRunnable";
                    }

                    @Override
                    public void run() {
                        APSplash.checkTime("addAxes1 in");
                        final AxisPanel c = new AxisPanel(AutoplotUI.this.applicationModel);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                sp.setViewportView(c);
                            }
                        });
                        APSplash.checkTime("addAxes1 out");
                    }
                });
                APSplash.checkTime("addAxes out");
            }
        };
    }

    private Runnable addStyle() {
        return new Runnable(){

            @Override
            public void run() {
                APSplash.checkTime("addStyle in");
                final JScrollPane sp = new JScrollPane();
                try {
                    AutoplotUI.loadMyColors();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                AutoplotUI.this.tabs.insertTab("style", null, sp, String.format("<html>Adjust selected plot element's colors, shapes, and other style settings.<br>%s</html>", "Right-click or drag to undock."), 2);
                AutoplotUI.this.invokeLater(2500, true, new Runnable(){

                    public String toString() {
                        return "addStyle";
                    }

                    @Override
                    public void run() {
                        APSplash.checkTime("addStyle1 in");
                        final PlotStylePanel c = new PlotStylePanel(AutoplotUI.this.applicationModel);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                sp.setViewportView(c);
                            }
                        });
                        APSplash.checkTime("addStyle1 out");
                    }
                });
                APSplash.checkTime("addStyle out");
            }
        };
    }

    private static void loadMyColors() throws IOException {
        File f = new File(new File(AutoplotSettings.settings().resolveProperty("autoplotData")), "config");
        if (f.exists()) {
            if ((f = new File(f, "colors.txt")).exists() && f.canRead()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(f));){
                    String line = reader.readLine();
                    while (line != null) {
                        try {
                            String[] ss;
                            int i = line.indexOf(35);
                            if (i > -1) {
                                line = line.substring(0, i);
                            }
                            if ((ss = line.trim().split("\\s+")).length != 1 || ss[0].length() != 0) {
                                if (ss.length == 1) {
                                    ColorEditor.addColor(Color.decode(ss[0]), ss[0]);
                                } else if (ss.length == 2) {
                                    ColorEditor.addColor(Color.decode(ss[0]), ss[1]);
                                } else if (ss.length >= 4) {
                                    for (int j = 4; j < ss.length; ++j) {
                                        ss[3] = ss[3] + " " + ss[j];
                                    }
                                    if (ss[3].startsWith("\"") && ss[3].endsWith("\"")) {
                                        ss[3] = ss[3].substring(1, ss[3].length() - 1);
                                    }
                                    if (ss[0].endsWith("%")) {
                                        int rr = 255 * Integer.parseInt(ss[0].substring(0, ss[0].length() - 1)) / 100;
                                        int gg = 255 * Integer.parseInt(ss[1].substring(0, ss[1].length() - 1)) / 100;
                                        int bb = 255 * Integer.parseInt(ss[2].substring(0, ss[2].length() - 1)) / 100;
                                        ColorEditor.addColor(new Color(rr, gg, bb), ss[3]);
                                    } else {
                                        ColorEditor.addColor(new Color(Integer.parseInt(ss[0]), Integer.parseInt(ss[1]), Integer.parseInt(ss[2])), ss[3]);
                                    }
                                }
                            }
                        }
                        catch (NumberFormatException ex) {
                            logger.log(Level.WARNING, "unable to parse color: {0}", line);
                        }
                        line = reader.readLine();
                    }
                }
            }
            try (BufferedWriter write = new BufferedWriter(new FileWriter(f));){
                write.append("# red green blue colorName\n");
                write.append("# 255 255 255 white\n");
                write.append("# 100% 100% 100% white\n");
                write.append("# 0x8B0000 DarkRed\n");
                write.close();
            }
        }
    }

    private static List<String> cleanMessages(List<String> messages) {
        messages = new ArrayList<String>(messages);
        LinkedList<String> result = new LinkedList<String>(messages);
        for (String s : messages) {
            if (s == null) {
                System.err.println("here null in cleanMessages");
                continue;
            }
            if (!s.equals("Delete Plot")) continue;
            result.remove("Delete Plot Element");
        }
        return result;
    }

    private JPanel getFeaturePanelPlaceHolder(String label) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel(String.format("<html><i>%s not initialized</i></html>", label)), "North");
        p.setMinimumSize(new Dimension(640, 480));
        p.setPreferredSize(p.getMinimumSize());
        return p;
    }

    private void addFeatures(final ApplicationModel model) {
        JScrollPane fdataPane;
        JScrollPane flayoutPane;
        if (model.getDocumentModel().getOptions().isLayoutVisible()) {
            flayoutPane = new JScrollPane();
            flayoutPane.setViewportView(this.getFeaturePanelPlaceHolder("layout"));
            this.tabs.insertTab("layout", null, flayoutPane, String.format("<html>Inspect the canvas layout and property bindings, and<br>provides access to all plot elements.<br>%s</html>", "Right-click or drag to undock."), this.tabs.getTabCount());
        } else {
            flayoutPane = null;
        }
        this.layoutPanel1 = flayoutPane;
        if (model.getDocumentModel().getOptions().isDataVisible()) {
            fdataPane = new JScrollPane();
            fdataPane.setViewportView(this.getFeaturePanelPlaceHolder("data"));
            this.tabs.insertTab("data", null, fdataPane, String.format("<html>Specify valid ranges and apply additional operations to data.<br>%s</html>", "Right-click or drag to undock."), this.tabs.getTabCount());
        } else {
            fdataPane = null;
        }
        final JScrollPane fmetadataPane = new JScrollPane();
        fmetadataPane.setViewportView(this.getFeaturePanelPlaceHolder("metadata"));
        this.tabs.insertTab("metadata", null, fmetadataPane, String.format("<html>Inspect selected element's metadata and data statistics.<br>%s</html>", "Right-click or drag to undock."), this.tabs.getTabCount());
        this.invokeLater(2230, true, new Runnable(){

            public String toString() {
                return "addLayout";
            }

            @Override
            public void run() {
                APSplash.checkTime("init 249");
                if (flayoutPane != null) {
                    final LayoutPanel lui = new LayoutPanel();
                    AutoplotUI.this.layoutPanel = lui;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            flayoutPane.setViewportView(lui);
                        }
                    });
                    lui.setApplication(AutoplotUI.this.dom);
                    lui.setApplicationModel(AutoplotUI.this.applicationModel);
                    APSplash.checkTime("init 250");
                }
            }
        });
        this.invokeLater(2350, true, new Runnable(){

            public String toString() {
                return "addDataPanel";
            }

            @Override
            public void run() {
                APSplash.checkTime("init 259");
                if (fdataPane != null) {
                    final DataPanel dp = new DataPanel(AutoplotUI.this);
                    AutoplotUI.this.dataPanel = dp;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            fdataPane.setViewportView(dp);
                        }
                    });
                    APSplash.checkTime("init 260");
                }
            }
        });
        this.invokeLater(2470, true, new Runnable(){

            public String toString() {
                return "addMetadataPanel";
            }

            @Override
            public void run() {
                APSplash.checkTime("init 269");
                final MetadataPanel mdp = new MetadataPanel(AutoplotUI.this.applicationModel);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        fmetadataPane.setViewportView(mdp);
                    }
                });
                APSplash.checkTime("init 270");
            }
        });
        if (model.getDocumentModel().getOptions().isScriptVisible()) {
            final DataSetSelector fdataSetSelector = this.dataSetSelector;
            this.jythonScriptPanel = new JPanel(new BorderLayout());
            this.jythonScriptPanel.setMinimumSize(new Dimension(640, 480));
            this.jythonScriptPanel.setPreferredSize(new Dimension(640, 480));
            this.tabs.addTab(TAB_SCRIPT, null, this.jythonScriptPanel, String.format("<html>Editor panel for Jython scripts and data sources.<br>%s</html>", "Right-click or drag to undock."));
            this.invokeLater(4000, true, new Runnable(){

                public String toString() {
                    return "addScriptPanel";
                }

                @Override
                public void run() {
                    AutoplotUI.this.scriptPanel = new JythonScriptPanel(AutoplotUI.this, fdataSetSelector);
                    AutoplotUI.this.jythonScriptPanel.add((Component)AutoplotUI.this.scriptPanel, "Center");
                    AutoplotUI.this.scriptPanelMenuItem.setSelected(true);
                    ExceptionHandler h = model.getExceptionHandler();
                    if (h != null && h instanceof GuiExceptionHandler) {
                        ((GuiExceptionHandler)h).setScriptPanel(AutoplotUI.this.scriptPanel);
                    }
                }
            });
        }
        if (model.getDocumentModel().getOptions().isLogConsoleVisible()) {
            this.logConsolePanel = new JScrollPane();
            this.logConsolePanel.setViewportView(this.getFeaturePanelPlaceHolder(TAB_CONSOLE));
            this.tabs.addTab(TAB_CONSOLE, null, this.logConsolePanel, String.format("<html>Log console displays log messages and stdout/stderr.<br>%s</html>", "Right-click or drag to undock."));
            this.invokeLater(4020, true, new Runnable(){

                public String toString() {
                    return "addLogConsole";
                }

                @Override
                public void run() {
                    AutoplotUI.this.initLogConsole();
                    AutoplotUI.this.logConsolePanel.setViewportView(AutoplotUI.this.logConsole);
                }
            });
        }
        this.tickleTimer = new TickleTimer(300L, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (AutoplotUI.this.dom.getController().isValueAdjusting()) {
                    AutoplotUI.this.tickleTimer.tickle("app value was adjusting");
                    return;
                }
                LinkedHashMap<Object, Object> changes = new LinkedHashMap<Object, Object>();
                AutoplotUI.this.dom.getController().pendingChanges(changes);
                if (changes.size() > 0) {
                    AutoplotUI.this.tickleTimer.tickle("app had pending changes");
                    return;
                }
                List messages = AutoplotUI.this.tickleTimer.getMessages();
                if (messages.size() > 1) {
                    if ((messages = AutoplotUI.cleanMessages(messages)).size() == 1) {
                        AutoplotUI.this.undoRedoSupport.pushState(evt, (String)messages.get(0));
                    } else {
                        AutoplotUI.this.undoRedoSupport.pushState(evt, String.format("%d changes", messages.size()));
                    }
                } else if (messages.size() == 1) {
                    if (((String)messages.get(0)).contains(" from ")) {
                        AutoplotUI.this.undoRedoSupport.pushState(evt);
                    } else {
                        AutoplotUI.this.undoRedoSupport.pushState(evt, (String)messages.get(0));
                    }
                } else {
                    logger.fine("tickleTimer contained no messages.");
                }
                AutoplotUI.this.stateSupport.markDirty();
                if (AutoplotUI.this.pendingVap != null) {
                    model.addRecent(AutoplotUI.this.pendingVap);
                    AutoplotUI.this.dataSetSelector.setValue(AutoplotUI.this.pendingVap);
                    AutoplotUI.this.pendingVap = null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoplotUI.this.refreshUndoRedoLabel();
                    }
                });
            }
        });
        this.applicationModel.dom.getController().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AutoplotUI.this.dom.getController().isValueAdjusting()) {
                    return;
                }
                logger.log(Level.FINER, "state change: {0}", evt);
                if (!(AutoplotUI.this.stateSupport.isOpening() || AutoplotUI.this.stateSupport.isSaving() || AutoplotUI.this.applicationModel.isRestoringState())) {
                    if (evt.getActionCommand().startsWith("label: ")) {
                        AutoplotUI.this.tickleTimer.tickle(evt.getActionCommand().substring("label: ".length()));
                    } else {
                        AutoplotUI.this.tickleTimer.tickle(evt.getActionCommand() + " from " + evt.getSource());
                    }
                }
            }
        });
        this.applicationModel.dom.getController().addPropertyChangeListener("plotElement", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String current;
                if (evt.getNewValue() == null && (current = AutoplotUI.this.stateSupport.getCurrentFile()) != null) {
                    AutoplotUI.this.dataSetSelector.setValue(current.toString());
                }
            }
        });
        this.applicationModel.dom.getController().addPropertyChangeListener("dataSourceFilter", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DataSourceFilter dsf = (DataSourceFilter)evt.getNewValue();
                if (dsf == null) {
                    AutoplotUI.this.dataSetSelector.setValue("");
                } else {
                    String uri = dsf.getUri();
                    if (uri != null) {
                        if (AutoplotUI.this.pendingVap == null) {
                            AutoplotUI.this.dataSetSelector.setValue(uri);
                        }
                    } else {
                        AutoplotUI.this.dataSetSelector.setValue("");
                    }
                }
            }
        });
        System.err.println("ready in just a few seconds...");
        this.setMessage("ready in just a few seconds...");
    }

    protected void refreshUndoRedoLabel() {
        assert (EventQueue.isDispatchThread());
        String t = this.undoRedoSupport.getUndoLabel();
        this.undoMenuItem.setEnabled(t != null);
        this.undoMenuItem.setText(t == null ? "Undo" : t);
        this.undoMenuItem.setToolTipText(t == null ? "" : this.undoRedoSupport.getUndoDescription());
        String tt = this.undoRedoSupport.getRedoLabel();
        this.redoMenuItem.setEnabled(tt != null);
        this.redoMenuItem.setText(tt == null ? "Redo" : tt);
        this.redoMenuItem.setToolTipText(tt == null ? "" : this.undoRedoSupport.getRedoDescription());
        this.undoRedoSupport.refreshUndoMultipleMenu(this.undoMultipleMenu);
    }

    public TearoffTabbedPane getTabs() {
        return this.tabs;
    }

    private void bind(BindingGroup bc, Object src, String srcProperty, Object dst, String dstProperty) {
        BeanProperty dstbp;
        BeanProperty srcbp = BeanProperty.create((String)srcProperty);
        if (!srcbp.isReadable(src)) {
            System.err.println("not readable: " + srcProperty + " of " + src);
        }
        if (!(dstbp = BeanProperty.create((String)dstProperty)).isReadable(dst)) {
            System.err.println("not readable: " + dstProperty + " of " + dst);
        }
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)srcbp, (Object)dst, (Property)dstbp));
    }

    private void addBindings() {
        Runnable run = new Runnable(){

            public String toString() {
                return "bindings";
            }

            @Override
            public void run() {
                logger.fine("adding bindings");
                BindingGroup bc = new BindingGroup();
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "drawAntiAlias", AutoplotUI.this.drawAntiAliasMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "textAntiAlias", AutoplotUI.this.textAntiAlias, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "specialEffects", AutoplotUI.this.specialEffectsMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "overRendering", AutoplotUI.this.overRenderingMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "drawGrid", AutoplotUI.this.drawGridCheckBox, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "autolabelling", AutoplotUI.this.autoLabellingCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "autolayout", AutoplotUI.this.autoLayoutCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "autoranging", AutoplotUI.this.autoRangingCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "dataVisible", AutoplotUI.this.dataPanelCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "layoutVisible", AutoplotUI.this.layoutPanelCheckBoxMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "dayOfYear", AutoplotUI.this.doyCB, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "nearestNeighbor", AutoplotUI.this.nnCb, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "useTimeRangeEditor", AutoplotUI.this.timeRangeSelectorMenuItem, "selected");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom, "timeRange", AutoplotUI.this.timeRangeEditor, "range");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "dayOfYear", AutoplotUI.this.timeRangeEditor, "useDoy");
                AutoplotUI.this.bind(bc, AutoplotUI.this.dom.getOptions(), "printingTag", AutoplotUI.this.dom.getCanvases(0).getController().getDasCanvas(), "printingTag");
                bc.bind();
                AutoplotUI.this.dom.addPropertyChangeListener("bindings", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        BindingModel[] bms = AutoplotUI.this.dom.getBindings();
                        boolean isBound = false;
                        for (BindingModel bm : bms) {
                            if (!bm.getSrcProperty().equals("timeRange")) continue;
                            isBound = true;
                        }
                        if (isBound && !AutoplotUI.this.dsSelectTimerangeBound) {
                            AutoplotUI.this.dom.getController().bind(AutoplotUI.this.dom, "timeRange", AutoplotUI.this.dataSetSelector, "timeRange");
                            AutoplotUI.this.dsSelectTimerangeBound = true;
                        } else if (!isBound && AutoplotUI.this.dsSelectTimerangeBound) {
                            AutoplotUI.this.dom.getController().unbind(AutoplotUI.this.dom, "timeRange", AutoplotUI.this.dataSetSelector, "timeRange");
                            AutoplotUI.this.dataSetSelector.setTimeRange(null);
                            AutoplotUI.this.dsSelectTimerangeBound = false;
                        }
                    }
                });
                AutoplotUI.this.dom.addPropertyChangeListener("eventsListUri", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        logger.finer("events list URI property change");
                        final String uri = (String)evt.getNewValue();
                        if (uri.trim().length() > 0) {
                            Runnable run = new Runnable(){

                                @Override
                                public void run() {
                                    logger.log(Level.FINEST, "resetting events list URI to {0}", uri);
                                    EventsListToolUtil.setEventsListURI(AutoplotUI.this, uri);
                                }
                            };
                            if (EventQueue.isDispatchThread()) {
                                run.run();
                            } else {
                                SwingUtilities.invokeLater(run);
                                System.err.println("resetting events list URI later");
                            }
                        }
                    }
                });
            }
        };
        this.invokeLater(-1, false, run);
        this.dataSetSelector.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.applicationModel.setDataSourceURL(AutoplotUI.this.dataSetSelector.getValue());
            }
        });
    }

    public void plotUri(String uri) {
        this.dataSetSelector.setValue(uri);
        this.dataSetSelector.maybePlot(false);
    }

    private Action getAddPlotElementAction() {
        return new AbstractAction("Add Plot..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                AutoplotUI.this.support.addPlotElement("Add Plot");
            }
        };
    }

    public void enterAddPlotElementDialog() {
        this.support.addPlotElement("Add Bookmarked Plot");
    }

    private synchronized JMenu getAddDataFromMenu() {
        JMenu result = new JMenu("Add Plot From");
        result.add(new JMenuItem("looking up discoverable sources..."));
        this.addDataFromMenu = result;
        RequestProcessor.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.fillAddDataFromMenu();
            }
        });
        return result;
    }

    private void addToDiscoveryUseSoon(final String uri) {
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
                File f3 = new File(f2, "discovery.txt");
                FileWriter out3 = null;
                try {
                    out3 = new FileWriter(f3, true);
                    TimeParser tp = TimeParser.create("$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z");
                    Datum now = Units.t1970.createDatum((double)System.currentTimeMillis() / 1000.0);
                    out3.append(tp.format(now, null) + "\t" + uri + "\n");
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                finally {
                    if (out3 != null) {
                        try {
                            out3.close();
                        }
                        catch (IOException ex1) {
                            logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                        }
                    }
                }
            }
        };
        new Thread(run).start();
    }

    private void fillAddDataFromMenuImmediately(List<String> exts) {
        this.addDataFromMenu.removeAll();
        for (String ext : exts) {
            if (ext.equals("file:")) {
                AbstractAction a = new AbstractAction("Local File..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AutoplotUI.this.addToDiscoveryUseSoon("file:");
                        AutoplotUI.this.dataSetSelector.getOpenLocalAction().actionPerformed(e);
                    }
                };
                this.addDataFromMenu.add(new JMenuItem(a));
                continue;
            }
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            final String fext = ext;
            AbstractAction a = new AbstractAction(ext + "..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    try {
                        String uri = "vap+" + fext + ":";
                        String refuri = AutoplotUI.this.dataSetSelector.getValue();
                        if (refuri.toLowerCase().startsWith(uri)) {
                            AutoplotUI.this.addToDiscoveryUseSoon(refuri);
                            AutoplotUI.this.dataSetSelector.browseSourceType();
                        } else {
                            AutoplotUI.this.addToDiscoveryUseSoon(uri);
                            AutoplotUI.this.dataSetSelector.setValue(uri);
                            AutoplotUI.this.dataSetSelector.maybePlot(true);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            JMenuItem item = new JMenuItem(a);
            this.addDataFromMenu.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAddDataFromMenu() {
        final List<String> exts = DataSetURI.getDiscoverableExtensions();
        exts.add("file:");
        File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData") + "/bookmarks/discovery.txt");
        if (f.exists() && f.canRead()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(f));
                String s = reader.readLine();
                while (s != null) {
                    if (s.length() > 29) {
                        String ss;
                        switch (ss = s.substring(25, 29)) {
                            case "file": {
                                String ex1 = "file:";
                                if (!exts.contains(ex1)) break;
                                exts.remove(ex1);
                                exts.add(0, ex1);
                                break;
                            }
                            case "vap+": {
                                int i = s.indexOf(58, 29);
                                String ex1 = "." + s.substring(29, i);
                                if (!exts.contains(ex1)) break;
                                exts.remove(ex1);
                                exts.add(0, ex1);
                                break;
                            }
                        }
                    }
                    s = reader.readLine();
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.fillAddDataFromMenuImmediately(exts);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void fillInitialBookmarksMenu() {
        JMenuItem mi = new JMenuItem("Manage and Browse...");
        mi.setEnabled(false);
        this.bookmarksMenu.add(mi);
        mi = new JMenuItem("Add bookmark...");
        mi.setEnabled(false);
        this.bookmarksMenu.add(mi);
        this.bookmarksMenu.add(new JSeparator());
        mi = new JMenuItem("Loading...");
        mi.setToolTipText("Loading initial bookmarks file...");
        this.bookmarksMenu.add(mi);
        for (int i = 0; i < 5; ++i) {
            mi = new JMenuItem(" ");
            this.bookmarksMenu.add(mi);
        }
    }

    private void fillFileMenu() {
        ArrayList<JComponent> expertItems = new ArrayList<JComponent>();
        expertItems.add(new JMenuItem(this.support.createNewApplicationAction()));
        expertItems.add(new JMenuItem(this.support.createCloneApplicationAction()));
        this.fileMenu.add((Component)expertItems.get(0));
        this.fileMenu.add((Component)expertItems.get(1));
        JMenuItem mi = new JMenuItem(this.support.createNewDOMAction());
        expertItems.add(mi);
        mi.setToolTipText("Reset application to initial state");
        this.fileMenu.add(mi);
        this.fileMenu.add(new JSeparator());
        APSplash.checkTime("init 51");
        this.fileMenu.add(this.getAddDataFromMenu());
        APSplash.checkTime("init 52");
        mi = new JMenuItem(this.getAddPlotElementAction());
        mi.setToolTipText("Add a new plot or overplot to the application");
        expertItems.add(mi);
        this.fileMenu.add(mi);
        APSplash.checkTime("init 52.3");
        mi = new JMenuItem(new AbstractAction("Open URI History..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                RecentUrisDialog dia = new RecentUrisDialog((Frame)SwingUtilities.getWindowAncestor(AutoplotUI.this.fileMenu), true);
                dia.setExpertMode(AutoplotUI.this.isExpertMode());
                WindowManager.getInstance().showModalDialog(dia);
                if (dia.isCancelled()) {
                    return;
                }
                String suri = dia.getSelectedURI();
                if (suri != null) {
                    AutoplotUI.this.dataSetSelector.setValue(suri);
                    AutoplotUI.this.dataSetSelector.maybePlot(dia.getModifiers());
                }
            }
        });
        mi.setToolTipText("Open URI history dialog");
        APSplash.checkTime("init 52.4");
        mi.setIcon(new ImageIcon(this.getClass().getResource("/resources/history.png")));
        APSplash.checkTime("init 52.5");
        this.fileMenu.add(mi);
        APSplash.checkTime("init 52.7");
        this.fileMenu.add(new JSeparator());
        mi = new JMenuItem(this.dataSetSelector.getOpenLocalVapAction());
        mi.setToolTipText("Open local .vap application state file");
        this.fileMenu.add(mi);
        mi = new JMenuItem(this.stateSupport.createSaveAsAction());
        mi.setToolTipText("Save the application state to a file");
        this.fileMenu.add(mi);
        mi = new JMenuItem(this.stateSupport.createSaveAction());
        mi.setToolTipText("Save the application state to a file");
        mi.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(mi);
        this.fileMenu.addSeparator();
        APSplash.checkTime("init 52.8");
        JMenu printToMenu = new JMenu("Print to");
        printToMenu.setToolTipText("Print to file");
        this.fileMenu.add(printToMenu);
        AutoplotUI focus = this;
        JMenuItem item = new JMenuItem(GuiSupport.getPrintAction(this.dom, focus, "pdf"));
        item.setText("PDF...");
        printToMenu.add(item);
        item = new JMenuItem(GuiSupport.getPrintAction(this.dom, focus, "svg"));
        item.setText("SVG...");
        printToMenu.add(item);
        item = new JMenuItem(GuiSupport.getPrintAction(this.dom, focus, "png"));
        item.setText("PNG...");
        printToMenu.add(item);
        AbstractAction printAction = new AbstractAction("Printer..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                AutoplotUI.this.applicationModel.getCanvas().makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        };
        mi = new JMenuItem(printAction);
        mi.setToolTipText("Print to printer");
        printToMenu.add(mi);
        this.fileMenu.addSeparator();
        item = new JMenuItem(this.support.getDumpDataAction(this.dom));
        item.setToolTipText("Export the data that has the focus");
        expertItems.add(item);
        this.fileMenu.add(item);
        item = new JMenuItem(this.support.getDumpAllDataAction(this.dom));
        item.setToolTipText("Export the all data on the canvas");
        expertItems.add(item);
        this.fileMenu.add(item);
        APSplash.checkTime("init 52.9");
        JSeparator dumpSep = new JSeparator();
        expertItems.add(dumpSep);
        this.fileMenu.add(dumpSep);
        this.fileMenu.add(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                if (AppManager.getInstance().getApplicationCount() == 1) {
                    int opt = JOptionPane.showConfirmDialog(AutoplotUI.this, "Quit application?", "Quit Autoplot", 1);
                    switch (opt) {
                        case 0: {
                            if (AppManager.getInstance().requestQuit()) break;
                            return;
                        }
                        case 1: {
                            AutoplotUI.this.dom.getController().reset();
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                AutoplotUI.this.dispose();
                ScriptContext.close();
                AppManager.getInstance().closeApplication(AutoplotUI.this);
            }
        });
        this.fileMenu.add(new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoggerManager.logGuiEvent(ev);
                if (AppManager.getInstance().requestQuit()) {
                    AutoplotUI.this.dispose();
                    AppManager.getInstance().quit();
                }
            }
        });
        this.expertMenuItems.addAll(expertItems);
    }

    public void resetAction(String name, Action a) {
        for (int i = 0; i < this.fileMenu.getItemCount(); ++i) {
            JMenuItem item = this.fileMenu.getItem(i);
            if (item == null || !item.getText().equals(name)) continue;
            this.fileMenu.getItem(i).setAction(a);
        }
    }

    private JPanel initLogConsole() throws SecurityException {
        this.logConsole = new LogConsole();
        this.logConsole.setScriptContext(Collections.singletonMap("dom", this.applicationModel.dom));
        this.logConsole.turnOffConsoleHandlers();
        this.logConsole.logConsoleMessages();
        Handler h = this.logConsole.getHandler();
        Logger.getLogger("").addHandler(h);
        this.setMessage("log console added");
        this.applicationModel.getDocumentModel().getOptions().setLogConsoleVisible(true);
        if (this.applicationModel.getExceptionHandler() instanceof GuiExceptionHandler) {
            ((GuiExceptionHandler)this.applicationModel.getExceptionHandler()).setLogConsole(this.logConsole);
        }
        this.logConsoleMenuItem.setSelected(true);
        return this.logConsole;
    }

    private void initServer() {
        String result = JOptionPane.showInputDialog(this, "<html>Select port for server.  This port will <br>accept Jython commands to control and <br>receive services from the application", 12345);
        if (result == null) {
            return;
        }
        int iport = Integer.parseInt(result);
        this.setupServer(iport, this.applicationModel);
    }

    private void stopServer() {
        if (this.rlistener != null) {
            this.rlistener.stopListening();
        }
        this.rlistener = null;
        this.updateFrameTitle();
    }

    private ProgressMonitor getStatusBarProgressMonitor(final String finishMessage) {
        return new NullProgressMonitor(){

            @Override
            public void setProgressMessage(String message) {
                AutoplotUI.this.setStatus(BUSY_ICON, message);
            }

            @Override
            public void finished() {
                AutoplotUI.this.setStatus(IDLE_ICON, finishMessage);
            }
        };
    }

    private void plotUrlImmediately(String surl) {
        try {
            logger.log(Level.FINE, "plotUrl({0})", surl);
            URISplit split = URISplit.parse(surl);
            ProgressMonitor mon = this.getStatusBarProgressMonitor("Finished loading " + surl);
            if (!(split.file != null && (split.file.endsWith(".vap") || split.file.endsWith(".vapx")) || "true".equals(AutoplotUtil.getProperty("java.awt.headless", "false")))) {
                try {
                    DataSetURI.getDataSourceFactory(DataSetURI.getURIValid(surl), mon);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                catch (URISyntaxException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    String s = "<li>scheme:arguments</li>vap+cdaweb:ds=AC_H3_SWI&id=SW_type<br><li>scheme:URL?scheme-arguments</li>vap+dat:http://autoplot.org/data/somedata.dat?column=field1<br><li>URL?scheme-arguments</li>http://autoplot.org/data/somedata.dat?column=field1</br>";
                    JOptionPane.showMessageDialog(this, "<html><p>URI Syntax Error found when parsing.</p>" + s, "URI Syntax Error", 0);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    SourceTypesBrowser browser = new SourceTypesBrowser();
                    browser.getDataSetSelector().setValue(DataSetURI.fromUri(DataSetURI.getResourceURI(surl)));
                    int r = AutoplotUtil.showConfirmDialog(this, browser, "Select Data Source Type", 2);
                    if (r == 0) {
                        surl = browser.getUri();
                        this.dataSetSelector.getValue();
                        this.dataSetSelector.setValue(surl);
                        this.dataSetSelector.maybePlot(true);
                        return;
                    }
                    return;
                }
            }
            this.applicationModel.resetDataSetSourceURL(surl, mon);
            if (split.file != null && (split.file.endsWith(".vap") || split.file.endsWith(".vapx"))) {
                this.tickleTimer.tickle();
                this.pendingVap = surl;
            } else {
                this.applicationModel.addRecent(surl);
            }
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof HtmlResponseIOException) {
                this.handleHtmlResponse(surl, ex);
            }
            if (ex.getCause() != null && ex.getCause() instanceof IOException) {
                this.setStatus(ERROR_ICON, "Unable to open URI: " + surl);
                AutoplotUtil.showUserExceptionDialog(this, "<html>Unable to open URI: <br>" + surl + "<br><br>" + ex.getCause(), ex, this.applicationModel.getExceptionHandler());
            }
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ex.toString();
            }
            this.setStatus(ERROR_ICON, msg);
        }
    }

    private void handleHtmlResponse(String surl, Exception ex) {
        this.setStatus(ERROR_ICON, "HTML response from URI: " + surl);
        HtmlResponseIOException htmlEx = ex instanceof HtmlResponseIOException ? (HtmlResponseIOException)ex : (HtmlResponseIOException)ex.getCause();
        if (htmlEx.getURL() != null) {
            final String link = htmlEx.getURL().toString();
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)new JLabel("<html>Unable to open URI: <br>" + surl + "<br><br>" + htmlEx.getMessage() + "<br><br>"), "Center");
            JPanel p1 = new JPanel(new BorderLayout());
            p1.add((Component)new JButton(new AbstractAction("View in Browser"){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    LoggerManager.logGuiEvent(ev);
                    AutoplotUtil.openBrowser(link);
                }
            }), "East");
            p.add((Component)p1, "South");
            JOptionPane.showMessageDialog(this, p, "HTML response", 0);
        } else {
            JOptionPane.showMessageDialog(this, "<html>Unable to open URI: <br>" + surl + "<br><br>" + htmlEx, "HTML response", 0);
        }
    }

    private void plotUrl(final String surl) {
        HashMap<Object, Object> changes = new HashMap<Object, Object>();
        this.dom.getController().pendingChanges(changes);
        this.dom.getController().registerPendingChange(this, PENDING_CHANGE_PLOTURI);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.dom.getController().performingChange(AutoplotUI.this, AutoplotUI.PENDING_CHANGE_PLOTURI);
                AutoplotUI.this.plotUrlImmediately(surl);
                AutoplotUI.this.dom.getController().changePerformed(AutoplotUI.this, AutoplotUI.PENDING_CHANGE_PLOTURI);
            }
        };
        logger.fine("plotUrl on this thread");
        run.run();
    }

    private void plotAnotherUrl() {
        this.plotAnotherUrl(this.dataSetSelector.getValue(), null);
    }

    private void plotAnotherUrl(String surl, Map<String, Object> options) {
        try {
            logger.log(Level.FINE, "plotAnotherUrl({0})", surl);
            if (options != null && LayoutConstants.ABOVE == options.get("direction")) {
                Plot domPlot = this.dom.getController().addPlot(LayoutConstants.ABOVE);
                PlotElement panel = this.dom.getController().addPlotElement(domPlot, null);
                this.dom.getController().getDataSourceFilterFor(panel).setUri(surl);
                this.dom.getController().setPlotElement(panel);
            } else {
                PlotElement panel = this.dom.getController().addPlotElement(null, null);
                this.dom.getController().getDataSourceFilterFor(panel).setUri(surl);
                this.dom.getController().setPlotElement(panel);
            }
        }
        catch (RuntimeException ex) {
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
            this.setStatus(ERROR_ICON, ex.getMessage());
        }
    }

    private void overplotAnotherUrl() {
        this.overplotAnotherUrl(this.dataSetSelector.getValue());
    }

    private void overplotAnotherUrl(String surl) {
        try {
            logger.log(Level.FINE, "overplotAnotherUrl({0})", surl);
            PlotElement panel = this.dom.getController().addPlotElement(this.dom.getController().getPlot(), null);
            this.dom.getController().getDataSourceFilterFor(panel).setUri(surl);
            this.dom.getController().setPlotElement(panel);
        }
        catch (RuntimeException ex) {
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
            this.setStatus(ERROR_ICON, ex.getMessage());
        }
    }

    public double resizeForCanvasSize(int w, int h) {
        Window parentToAdjust = SwingUtilities.isDescendingFrom(this.applicationModel.getCanvas(), this) ? this : SwingUtilities.getWindowAncestor(this.applicationModel.getCanvas());
        Dimension dout = parentToAdjust.getSize();
        Dimension din = this.applicationModel.getCanvas().getSize();
        Dimension desiredAppSize = new Dimension();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Dimension screenSize = gc.getBounds().getSize();
        boolean maximize = false;
        if (this.applicationModel.dom.getCanvases(0).isFitted()) {
            int maximizedPixelGain = 0;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                maximizedPixelGain = 8;
            } else if (osName.startsWith("Linux")) {
                maximizedPixelGain = 10;
            }
            desiredAppSize.width = w + (dout.width - din.width);
            desiredAppSize.height = h + (dout.height - din.height);
            if ((double)w > screenSize.getWidth() - (double)maximizedPixelGain && (double)w < screenSize.getWidth()) {
                maximize = true;
            }
        } else {
            desiredAppSize.width = dout.width;
            desiredAppSize.height = dout.height;
        }
        double scale = 1.0;
        boolean oldFitted = this.applicationModel.dom.getCanvases(0).isFitted();
        if (w < 640 || h < 480) {
            this.applicationModel.dom.getCanvases(0).setFitted(false);
            this.applicationModel.dom.getCanvases(0).setHeight(h);
            this.applicationModel.dom.getCanvases(0).setWidth(w);
        } else if (maximize) {
            if (parentToAdjust instanceof JFrame) {
                ((JFrame)parentToAdjust).setExtendedState(6);
                this.setStatus("Window maximized to approximate original size");
            } else {
                this.applicationModel.dom.getCanvases(0).setFitted(false);
                this.applicationModel.dom.getCanvases(0).setHeight(h);
                this.applicationModel.dom.getCanvases(0).setWidth(w);
            }
        } else if ((double)desiredAppSize.width > screenSize.getWidth() || (double)desiredAppSize.height > screenSize.getHeight()) {
            Object[] options = new String[]{"Scale to fit display", "Use scrollbars"};
            int i = JOptionPane.showOptionDialog(this, "Canvas size doesn't fit well on this display.", "Incompatible Canvas Size", 0, 1, ERROR_ICON, options, options[1]);
            if (i != -1) {
                if (i == 0) {
                    int nh;
                    int nw;
                    double aspect = 1.0 * (double)h / (double)w;
                    if (1.0 * screenSize.getHeight() / screenSize.getWidth() > aspect) {
                        nw = screenSize.width * 4 / 5;
                        nh = (int)((double)nw * aspect);
                    } else {
                        int controlsHeight = 160;
                        nh = screenSize.height - controlsHeight;
                        nw = (int)((double)nh / aspect);
                    }
                    scale = (double)nw / (double)w;
                    ((Component)parentToAdjust).setSize(nw + (dout.width - din.width), nh + (dout.height - din.height));
                } else if (i == 1) {
                    this.applicationModel.dom.getCanvases(0).setFitted(false);
                    this.applicationModel.dom.getCanvases(0).setHeight(h);
                    this.applicationModel.dom.getCanvases(0).setWidth(w);
                }
            }
        } else {
            ((Component)parentToAdjust).setSize(desiredAppSize.width, desiredAppSize.height);
            if (parentToAdjust.getSize().getWidth() != (double)desiredAppSize.width) {
                this.applicationModel.dom.getCanvases(0).setFitted(false);
                this.setStatus("warning: unable to resize to requested size, using scrollbars.");
            }
            this.applicationModel.dom.getCanvases(0).setHeight(h);
            this.applicationModel.dom.getCanvases(0).setWidth(w);
        }
        if (oldFitted && !this.applicationModel.dom.getCanvases(0).isFitted()) {
            this.setStatus("warning: canvas is no longer fitted, see options->plot style->canvas size");
        }
        return scale;
    }

    public void setStatus(String message) {
        if (message.startsWith("busy:")) {
            this.setMessage(BUSY_ICON, message.substring(5).trim());
            logger.fine(message);
        } else if (message.startsWith("warning:")) {
            this.setMessage(WARNING_ICON, message.substring(8).trim());
            logger.warning(message);
        } else if (message.startsWith("error:")) {
            this.setMessage(ERROR_ICON, message.substring(6).trim());
            logger.severe(message);
        } else {
            logger.fine(message);
            this.setMessage(message);
        }
    }

    public void setStatus(Icon icon, String message) {
        if (ERROR_ICON == icon) {
            logger.severe(message);
        } else if (WARNING_ICON == icon) {
            logger.warning(message);
        } else {
            logger.fine(message);
        }
        this.setMessage(icon, message);
    }

    private void clearCache() {
        if (AutoplotUtil.showConfirmDialog(this, "delete all cached files?", "clear cache", 2) == 0) {
            try {
                if (this.applicationModel.clearCache()) {
                    this.setStatus("cache cleared");
                } else {
                    this.setStatus(ERROR_ICON, "unable to clear cache");
                    JOptionPane.showMessageDialog(this, "unable to clear cache");
                }
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this, "unable to clear cache: " + ex.getMessage());
            }
        }
    }

    private void maybeCreateToolsManager() {
        if (this.toolsManager == null) {
            this.toolsManager = new BookmarksManager((Frame)this, false, "Tools");
            this.toolsManager.setTitle("Tools Manager");
            this.toolsManager.setPrefNode("tools");
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.applicationModel, (Property)BeanProperty.create((String)"tools"), (Object)this.toolsManager.getModel(), (Property)BeanProperty.create((String)"list"));
            b.bind();
            this.toolsManager.getModel().addPropertyChangeListener("bookmark", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AutoplotUI.this.updateToolsBookmarks();
                }
            });
        }
    }

    private void updateToolsBookmarks() {
        if (this.toolsManager == null) {
            this.maybeCreateToolsManager();
            this.toolsManager.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoplotUI.this.toolsManager.updateBookmarks(AutoplotUI.this.toolsMenu, "userSep", AutoplotUI.this, AutoplotUI.this.dataSetSelector);
                        }
                    });
                }
            });
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.toolsManager.setPrefNode("tools");
            }
        };
        this.invokeLater(-1, false, run);
    }

    protected BookmarksManager getToolsManager() {
        return this.toolsManager;
    }

    private void maybeCreateBookmarksManager() {
        if (this.bookmarksManager == null) {
            this.bookmarksManager = new BookmarksManager((Frame)this, false, "Bookmarks");
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.applicationModel, (Property)BeanProperty.create((String)"bookmarks"), (Object)this.bookmarksManager.getModel(), (Property)BeanProperty.create((String)"list"));
            b.bind();
            this.bookmarksManager.getModel().addPropertyChangeListener("bookmark", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AutoplotUI.this.updateBookmarks();
                }
            });
        }
    }

    protected BookmarksManager getBookmarksManager() {
        return this.bookmarksManager;
    }

    private void updateBookmarks() {
        if (this.bookmarksManager == null) {
            this.maybeCreateBookmarksManager();
            this.bookmarksManager.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AutoplotUI.this.bookmarksManager.updateBookmarks(AutoplotUI.this.bookmarksMenu, AutoplotUI.this, AutoplotUI.this.dataSetSelector);
                        }
                    });
                }
            });
        }
        if (!this.bookmarksManager.hasPrefNode("bookmarks")) {
            List<Bookmark> bookmarks;
            if (this.bookmarksManager.hasPrefNode("autoplot")) {
                this.bookmarksManager.setPrefNode("autoplot");
                if (this.bookmarksManager.getModel().getList() == null) {
                    this.setStatus("importing legacy bookmarks");
                    this.bookmarksManager.setPrefNode("autoplot");
                    bookmarks = this.applicationModel.getLegacyBookmarks();
                    this.bookmarksManager.getModel().setList(bookmarks);
                }
                this.bookmarksManager.resetPrefNode("bookmarks");
            } else {
                this.setStatus("busy: loading initial demo bookmarks");
                bookmarks = this.applicationModel.getLegacyBookmarks();
                this.bookmarksManager.getModel().setList(bookmarks);
                this.bookmarksManager.resetPrefNode("bookmarks");
                this.setStatus("done loading initial demo bookmarks");
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.bookmarksManager.setPrefNode("bookmarks");
                if (AutoplotUI.this.initialBookmarksUrl != null) {
                    AutoplotUI.this.loadInitialBookmarks(AutoplotUI.this.initialBookmarksUrl);
                    AutoplotUI.this.initialBookmarksUrl = null;
                }
            }
        };
        this.invokeLater(-1, false, run);
    }

    public static PersistentStateSupport getPersistentStateSupport(final AutoplotUI parent, final ApplicationModel applicationModel) {
        final PersistentStateSupport stateSupport = new PersistentStateSupport(parent, null, "vap"){

            @Override
            protected void saveImpl(File f, String scheme) throws IOException {
                applicationModel.doSave(f, scheme);
                applicationModel.addRecent(DataSetURI.fromFile(f));
                parent.setStatus("saved " + f);
            }

            @Override
            protected void openImpl(File file) throws IOException {
                applicationModel.doOpen(file);
                parent.setStatus("opened " + file);
            }
        };
        stateSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (stateSupport.isCurrentFileOpened()) {
                    String label = stateSupport.getCurrentFile() + " " + (stateSupport.isDirty() ? "*" : "");
                    parent.setMessage(label);
                }
            }
        });
        return stateSupport;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.addressBarButtonGroup = new ButtonGroup();
        this.statusLabel = new JLabel();
        this.tabbedPanelContainer = new JPanel();
        this.statusTextField = new JTextField();
        this.timeRangePanel = new JPanel();
        this.dataSetSelector = new DataSetSelector();
        this.uriTimeRangeToggleButton1 = new UriTimeRangeToggleButton();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.undoMultipleMenu = new JMenu();
        this.editDomSeparator = new JSeparator();
        this.editDomMenuItem = new JMenuItem();
        this.editOptions = new JMenuItem();
        this.inspectVapFileMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.pasteDataSetURLMenuItem = new JMenuItem();
        this.copyDataSetURLMenuItem = new JMenuItem();
        this.copyImageMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.addressBarMenu = new JMenu();
        this.dataSetSelectorMenuItem = new JRadioButtonMenuItem();
        this.timeRangeSelectorMenuItem = new JRadioButtonMenuItem();
        this.textSizeMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.resetFontMI = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.resetZoomMenu = new JMenu();
        this.resetZoomMenuItem = new JMenuItem();
        this.resetXMenuItem = new JMenuItem();
        this.resetYMenuItem = new JMenuItem();
        this.resetZMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.renderingOptionsMenu = new JMenu();
        this.textAntiAlias = new JCheckBoxMenuItem();
        this.drawAntiAliasMenuItem = new JCheckBoxMenuItem();
        this.specialEffectsMenuItem = new JCheckBoxMenuItem();
        this.overRenderingMenuItem = new JCheckBoxMenuItem();
        this.drawGridCheckBox = new JCheckBoxMenuItem();
        this.doyCB = new JCheckBoxMenuItem();
        this.nnCb = new JCheckBoxMenuItem();
        this.plotStyleMenu = new JMenu();
        this.fontsAndColorsMenuItem = new JMenuItem();
        this.canvasSizeMenuItem = new JMenuItem();
        this.enableFeatureMenu = new JMenu();
        this.scriptPanelMenuItem = new JCheckBoxMenuItem();
        this.logConsoleMenuItem = new JCheckBoxMenuItem();
        this.serverCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.dataPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.layoutPanelCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.referenceCacheCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.autoMenu = new JMenu();
        this.autoRangingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.autoLabellingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.autoLayoutCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.additionalOptionsMI = new JMenuItem();
        this.bookmarksMenu = new JMenu();
        this.toolsMenu = new JMenu();
        this.cacheMenu = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.workOfflineCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.resetMemoryCachesMI = new JMenuItem();
        this.manageFilesystemsMI = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.pngWalkMenuItem = new JMenuItem();
        this.createPngWalkMenuItem = new JMenuItem();
        this.runBatchMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem6 = new JMenuItem();
        this.fixLayoutMenuItem = new JMenuItem();
        this.createPngWalkSeparator = new JSeparator();
        this.aggregateMenuItem = new JMenuItem();
        this.replaceFileMenuItem = new JMenuItem();
        this.mashDataMenuItem = new JMenuItem();
        this.filtersMenuItem = new JMenuItem();
        this.aggSeparator = new JSeparator();
        this.decodeURLItem = new JMenuItem();
        this.reloadAllMenuItem = new JMenuItem();
        this.toolsUserSep = new JPopupMenu.Separator();
        this.helpMenu = new JMenu();
        this.autoplotHelpMenuItem = new JMenuItem();
        this.gettingStartedMenuItem = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.aboutDas2MenuItem = new JMenuItem();
        this.autoplotHomepageButton = new JMenuItem();
        this.searchToolTipsMenuItem = new JMenuItem();
        this.exceptionReport = new JMenuItem();
        this.aboutAutoplotMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Autoplot");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AutoplotUI.this.formMouseClicked(evt);
            }
        });
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont((float)this.statusLabel.getFont().getSize() - 2.0f));
        this.statusLabel.setText("starting...");
        this.statusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AutoplotUI.this.statusLabelMouseClicked(evt);
            }
        });
        this.tabbedPanelContainer.setLayout(new BorderLayout());
        this.statusTextField.setEditable(false);
        this.statusTextField.setFont(this.statusTextField.getFont().deriveFont((float)this.statusTextField.getFont().getSize() - 2.0f));
        this.statusTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.statusLabel, (Property)ELProperty.create((String)"${text}"), (Object)this.statusTextField, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.statusTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AutoplotUI.this.statusTextFieldMouseClicked(evt);
            }
        });
        this.timeRangePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.timeRangePanel.setLayout(new CardLayout());
        this.dataSetSelector.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dataSetSelector.setPromptText("<html><i>Just a moment...</i></html>");
        this.dataSetSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.dataSetSelectorActionPerformed(evt);
            }
        });
        this.timeRangePanel.add((Component)this.dataSetSelector, CARD_DATA_SET_SELECTOR);
        GroupLayout uriTimeRangeToggleButton1Layout = new GroupLayout((Container)this.uriTimeRangeToggleButton1);
        this.uriTimeRangeToggleButton1.setLayout((LayoutManager)uriTimeRangeToggleButton1Layout);
        uriTimeRangeToggleButton1Layout.setHorizontalGroup((GroupLayout.Group)uriTimeRangeToggleButton1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        uriTimeRangeToggleButton1Layout.setVerticalGroup((GroupLayout.Group)uriTimeRangeToggleButton1Layout.createParallelGroup(1).add(0, 28, Short.MAX_VALUE));
        this.fileMenu.setText("File");
        this.jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.undoMenuItem.setAction(this.undoRedoSupport.getUndoAction());
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.setToolTipText("Undo the last operation");
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAction(this.undoRedoSupport.getRedoAction());
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.redoMenuItem.setText("Redo");
        this.redoMenuItem.setToolTipText("Redo the last undone operation");
        this.editMenu.add(this.redoMenuItem);
        this.undoMultipleMenu.setText("Undo...");
        this.editMenu.add(this.undoMultipleMenu);
        this.editMenu.add(this.editDomSeparator);
        this.editDomMenuItem.setText("Edit DOM");
        this.editDomMenuItem.setToolTipText("Edit the application state using the property editor");
        this.editDomMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.editDomMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editDomMenuItem);
        this.editOptions.setText("Options...");
        this.editOptions.setToolTipText("Edit user options like background colors and fonts");
        this.editOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.editOptionsActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editOptions);
        this.inspectVapFileMenuItem.setText("Inspect Vap File...");
        this.inspectVapFileMenuItem.setToolTipText("View a vap file from a local disk in the property editor");
        this.inspectVapFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.inspectVapFileMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.inspectVapFileMenuItem);
        this.editMenu.add(this.jSeparator1);
        this.pasteDataSetURLMenuItem.setText("Paste URI");
        this.pasteDataSetURLMenuItem.setToolTipText("Paste a data address in the system clipboard into the address bar");
        this.pasteDataSetURLMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.pasteDataSetURLMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteDataSetURLMenuItem);
        this.copyDataSetURLMenuItem.setText("Copy URI");
        this.copyDataSetURLMenuItem.setToolTipText("Copy the data address in the address bar into the system clipboard");
        this.copyDataSetURLMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.copyDataSetURLMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyDataSetURLMenuItem);
        this.copyImageMenuItem.setText("Copy Image To Clipboard");
        this.copyImageMenuItem.setToolTipText("Copy the canvas image into the system clipboard.");
        this.copyImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.copyImageMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyImageMenuItem);
        this.jMenuBar1.add(this.editMenu);
        this.viewMenu.setText("View");
        this.addressBarMenu.setText("Address Bar");
        this.dataSetSelectorMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.addressBarButtonGroup.add(this.dataSetSelectorMenuItem);
        this.dataSetSelectorMenuItem.setSelected(true);
        this.dataSetSelectorMenuItem.setText("Data Set Selector");
        this.dataSetSelectorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.dataSetSelectorMenuItemActionPerformed(evt);
            }
        });
        this.addressBarMenu.add(this.dataSetSelectorMenuItem);
        this.timeRangeSelectorMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.addressBarButtonGroup.add(this.timeRangeSelectorMenuItem);
        this.timeRangeSelectorMenuItem.setText("Time Range Selector");
        this.timeRangeSelectorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.timeRangeSelectorMenuItemActionPerformed(evt);
            }
        });
        this.addressBarMenu.add(this.timeRangeSelectorMenuItem);
        this.viewMenu.add(this.addressBarMenu);
        this.textSizeMenu.setText("Text Size");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItem1.setText("Bigger");
        this.jMenuItem1.setToolTipText("Make canvas font bigger");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.textSizeMenu.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.jMenuItem2.setText("Smaller");
        this.jMenuItem2.setToolTipText("Make canvas font smaller");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.textSizeMenu.add(this.jMenuItem2);
        this.resetFontMI.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.resetFontMI.setText("Reset to 100%");
        this.resetFontMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetFontMIActionPerformed(evt);
            }
        });
        this.textSizeMenu.add(this.resetFontMI);
        this.viewMenu.add(this.textSizeMenu);
        this.viewMenu.add(this.jSeparator4);
        this.resetZoomMenu.setText("Reset Zoom");
        this.resetZoomMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.resetZoomMenuItem.setText("Reset Zoom");
        this.resetZoomMenuItem.setToolTipText("Revert to the original axis settings");
        this.resetZoomMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetZoomMenuItemActionPerformed(evt);
            }
        });
        this.resetZoomMenu.add(this.resetZoomMenuItem);
        this.resetXMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 3));
        this.resetXMenuItem.setText("Reset X");
        this.resetXMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetXMenuItemActionPerformed(evt);
            }
        });
        this.resetZoomMenu.add(this.resetXMenuItem);
        this.resetYMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 3));
        this.resetYMenuItem.setText("Reset Y");
        this.resetYMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetYMenuItemActionPerformed(evt);
            }
        });
        this.resetZoomMenu.add(this.resetYMenuItem);
        this.resetZMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.resetZMenuItem.setText("Reset Z");
        this.resetZMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetZMenuItemActionPerformed(evt);
            }
        });
        this.resetZoomMenu.add(this.resetZMenuItem);
        this.viewMenu.add(this.resetZoomMenu);
        this.jMenu1.setText("Zoom");
        this.jMenu1.setToolTipText("Note zooming can be done by dragging ranges with the mouse, or use the mouse wheel.");
        this.zoomInMenuItem.setText("Zoom In");
        this.zoomInMenuItem.setToolTipText("zoom in on the X axis");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setText("Zoom Out");
        this.zoomOutMenuItem.setToolTipText("zoom out the X axis");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.zoomOutMenuItem);
        this.viewMenu.add(this.jMenu1);
        this.jMenuBar1.add(this.viewMenu);
        this.optionsMenu.setText("Options");
        this.renderingOptionsMenu.setText("Rendering Options");
        this.textAntiAlias.setSelected(true);
        this.textAntiAlias.setText("Text Antialias");
        this.textAntiAlias.setToolTipText("Enable/Disable Text Antialiasing");
        this.textAntiAlias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.textAntiAliasActionPerformed(evt);
            }
        });
        this.renderingOptionsMenu.add(this.textAntiAlias);
        this.drawAntiAliasMenuItem.setSelected(true);
        this.drawAntiAliasMenuItem.setText("Graphics Antialias");
        this.drawAntiAliasMenuItem.setToolTipText("Enable/Disable Graphics Antialiasing");
        this.drawAntiAliasMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.drawAntiAliasMenuItemActionPerformed(evt);
            }
        });
        this.renderingOptionsMenu.add(this.drawAntiAliasMenuItem);
        this.specialEffectsMenuItem.setText("Special Effects");
        this.specialEffectsMenuItem.setToolTipText("Enable animated axes and other visual clues");
        this.specialEffectsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.specialEffectsMenuItemActionPerformed(evt);
            }
        });
        this.renderingOptionsMenu.add(this.specialEffectsMenuItem);
        this.overRenderingMenuItem.setSelected(true);
        this.overRenderingMenuItem.setText("Over-Rendering");
        this.overRenderingMenuItem.setToolTipText("Render (and load) data outside plot bounds to improve appearance.");
        this.renderingOptionsMenu.add(this.overRenderingMenuItem);
        this.drawGridCheckBox.setSelected(true);
        this.drawGridCheckBox.setText("Draw Grid");
        this.drawGridCheckBox.setToolTipText("Draw gridlines at major ticks");
        this.renderingOptionsMenu.add(this.drawGridCheckBox);
        this.doyCB.setText("Day of Year Labels");
        this.doyCB.setToolTipText("Use Day of Year instead of Year-Month-Day for labels");
        this.renderingOptionsMenu.add(this.doyCB);
        this.nnCb.setText("Nearest Neighbor Spectrograms");
        this.nnCb.setToolTipText("Use Nearest Neighbor rebinning for new spectrograms");
        this.renderingOptionsMenu.add(this.nnCb);
        this.optionsMenu.add(this.renderingOptionsMenu);
        this.plotStyleMenu.setText("Plot Style");
        this.fontsAndColorsMenuItem.setText("Fonts and Colors...");
        this.fontsAndColorsMenuItem.setToolTipText("Edit canvas font and colors");
        this.fontsAndColorsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.fontsAndColorsMenuItemActionPerformed(evt);
            }
        });
        this.plotStyleMenu.add(this.fontsAndColorsMenuItem);
        this.canvasSizeMenuItem.setText("Canvas Size...");
        this.canvasSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.canvasSizeMenuItemActionPerformed(evt);
            }
        });
        this.plotStyleMenu.add(this.canvasSizeMenuItem);
        this.optionsMenu.add(this.plotStyleMenu);
        this.enableFeatureMenu.setText("Enable Feature");
        this.scriptPanelMenuItem.setText("Script Panel");
        this.scriptPanelMenuItem.setToolTipText("Script Panel adds a tab that displays scripts used for the jython data source.  It also provides a way to create new jython sources.");
        this.scriptPanelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.scriptPanelMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.scriptPanelMenuItem);
        this.logConsoleMenuItem.setText("Log Console");
        this.logConsoleMenuItem.setToolTipText("Add a tab that receives and displays messages posted to the java logging system.  ");
        this.logConsoleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.logConsoleMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.logConsoleMenuItem);
        this.serverCheckBoxMenuItem.setText("Server");
        this.serverCheckBoxMenuItem.setToolTipText("<html> Start up back end server that allows commands to be send to Autoplot via a port. </html>");
        this.serverCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.serverCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.serverCheckBoxMenuItem);
        this.dataPanelCheckBoxMenuItem.setText("Data Panel");
        this.dataPanelCheckBoxMenuItem.setToolTipText("The data panel allows for explicitly setting valid range and fill values for the dataset, and additional controls for data reduction before plotting. ");
        this.enableFeatureMenu.add(this.dataPanelCheckBoxMenuItem);
        this.layoutPanelCheckBoxMenuItem.setText("Layout Panel");
        this.layoutPanelCheckBoxMenuItem.setToolTipText("Enables the layout panel, which shows all the plots and plot elements in thier relative positions.\n");
        this.enableFeatureMenu.add(this.layoutPanelCheckBoxMenuItem);
        this.referenceCacheCheckBoxMenuItem.setSelected(true);
        this.referenceCacheCheckBoxMenuItem.setText("Reference Caching");
        this.referenceCacheCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.referenceCacheCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.enableFeatureMenu.add(this.referenceCacheCheckBoxMenuItem);
        this.optionsMenu.add(this.enableFeatureMenu);
        this.autoMenu.setText("Auto");
        this.autoRangingCheckBoxMenuItem.setSelected(true);
        this.autoRangingCheckBoxMenuItem.setText("AutoRanging");
        this.autoRangingCheckBoxMenuItem.setToolTipText("Allow automatic axis range setting.  Range is based on metadata hints and data range.");
        this.autoMenu.add(this.autoRangingCheckBoxMenuItem);
        this.autoLabellingCheckBoxMenuItem.setSelected(true);
        this.autoLabellingCheckBoxMenuItem.setText("AutoLabelling");
        this.autoLabellingCheckBoxMenuItem.setToolTipText("Allow automatic setting of axis labels based on metadata. ");
        this.autoMenu.add(this.autoLabellingCheckBoxMenuItem);
        this.autoLayoutCheckBoxMenuItem.setSelected(true);
        this.autoLayoutCheckBoxMenuItem.setText("AutoLayout");
        this.autoLayoutCheckBoxMenuItem.setToolTipText("<html><p>Allow the application to reposition axes so labels are not clipped and unused space is reduced.  </P><p>Axes can be positioned manually by turning off this option, then hold shift down to enable plot corner drag anchors.</p></html>");
        this.autoLayoutCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.autoLayoutCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.autoMenu.add(this.autoLayoutCheckBoxMenuItem);
        this.optionsMenu.add(this.autoMenu);
        this.additionalOptionsMI.setText("Additional Options...");
        this.additionalOptionsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.additionalOptionsMIActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.additionalOptionsMI);
        this.jMenuBar1.add(this.optionsMenu);
        this.bookmarksMenu.setText("Bookmarks");
        this.jMenuBar1.add(this.bookmarksMenu);
        this.toolsMenu.setText("Tools");
        this.cacheMenu.setText("Cache");
        this.jMenuItem3.setText("Manage Cached Files...");
        this.jMenuItem3.setToolTipText("Manage cache of downloaded data files.");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.jMenuItem3);
        this.jMenuItem4.setText("Clear Cache");
        this.jMenuItem4.setToolTipText("Delete all downloaded data files.");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.jMenuItem4);
        this.jMenuItem7.setText("Move Cache...");
        this.jMenuItem7.setToolTipText("Move file cache to new location");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.jMenuItem7);
        this.workOfflineCheckBoxMenuItem.setText("Work Offline");
        this.workOfflineCheckBoxMenuItem.setToolTipText("Only use previously downloaded files. ");
        this.workOfflineCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.workOfflineCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.workOfflineCheckBoxMenuItem);
        this.resetMemoryCachesMI.setText("Reset Memory Caches");
        this.resetMemoryCachesMI.setToolTipText("Reset the internal state of the filesystems, re-listing them and resetting offline status.");
        this.resetMemoryCachesMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.resetMemoryCachesMIActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.resetMemoryCachesMI);
        this.manageFilesystemsMI.setText("Manage Filesystems");
        this.manageFilesystemsMI.setToolTipText("Show the active filesystems and their status.");
        this.manageFilesystemsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.manageFilesystemsMIActionPerformed(evt);
            }
        });
        this.cacheMenu.add(this.manageFilesystemsMI);
        this.toolsMenu.add(this.cacheMenu);
        this.toolsMenu.add(this.jSeparator3);
        this.pngWalkMenuItem.setText("PNG Walk Viewer");
        this.pngWalkMenuItem.setToolTipText("Bring up the PNG Walk tool to browse a set of images.");
        this.pngWalkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.pngWalkMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.pngWalkMenuItem);
        this.createPngWalkMenuItem.setText("Create PNG Walk...");
        this.createPngWalkMenuItem.setToolTipText("Create a series of images, and start the PNG Walk tool to browse the images.");
        this.createPngWalkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.createPngWalkMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.createPngWalkMenuItem);
        this.runBatchMenuItem.setText("Run Batch...");
        this.runBatchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.runBatchMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.runBatchMenuItem);
        this.toolsMenu.add(this.jSeparator2);
        this.jMenuItem6.setText("Events List");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.jMenuItem6);
        this.fixLayoutMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fixLayoutMenuItem.setText("Fix Layout");
        this.fixLayoutMenuItem.setToolTipText("Run new layout routine that removes spaces between plots");
        this.fixLayoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.fixLayoutMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.fixLayoutMenuItem);
        this.toolsMenu.add(this.createPngWalkSeparator);
        this.aggregateMenuItem.setText("Aggregate...");
        this.aggregateMenuItem.setToolTipText("Combine files into a time series");
        this.aggregateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.aggregateMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.aggregateMenuItem);
        this.replaceFileMenuItem.setText("Replace File...");
        this.replaceFileMenuItem.setToolTipText("<html>Replace the file with a new one.  This assumes that any parameters used to load the file<br>should be preserved, and axis settings should be preserved.  We re-range on the x-axis, since often we are switching to a new interval in time.</html>\n");
        this.replaceFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.replaceFileMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.replaceFileMenuItem);
        this.mashDataMenuItem.setText("Mash Data...");
        this.mashDataMenuItem.setToolTipText("Combine data from several sources.");
        this.mashDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.mashDataMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.mashDataMenuItem);
        this.filtersMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/resources/pipeMag2.png")));
        this.filtersMenuItem.setText("Additional Operations...");
        this.filtersMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.filtersMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.filtersMenuItem);
        this.toolsMenu.add(this.aggSeparator);
        this.decodeURLItem.setText("Decode URL");
        this.decodeURLItem.setToolTipText("Decode the URL escapes to correct the URL\n");
        this.decodeURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.decodeURLItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.decodeURLItem);
        this.reloadAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.reloadAllMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/resources/reload.png")));
        this.reloadAllMenuItem.setText("Reload All Data");
        this.reloadAllMenuItem.setToolTipText("Reload all data, updating to get any changes.  Axis settings and labels should remain the same.");
        this.reloadAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.reloadAllMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.reloadAllMenuItem);
        this.toolsUserSep.setToolTipText("User items below here");
        this.toolsUserSep.setName("userSep");
        this.toolsMenu.add(this.toolsUserSep);
        this.jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.helpMenuActionPerformed(evt);
            }
        });
        CSH.setHelpIDString((Component)this.autoplotHelpMenuItem, (String)"aphelp_main");
        this.autoplotHelpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.autoplotHelpMenuItem.setText("Help Contents...");
        this.autoplotHelpMenuItem.setToolTipText("Start up help system");
        this.autoplotHelpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.autoplotHelpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.autoplotHelpMenuItem);
        this.gettingStartedMenuItem.setText("Getting Started...");
        this.gettingStartedMenuItem.setToolTipText("Bring up the getting started dialog");
        this.gettingStartedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.gettingStartedMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.gettingStartedMenuItem);
        this.jMenuItem5.setText("Release Notes");
        this.jMenuItem5.setToolTipText("View release notes");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.jMenuItem5);
        this.aboutDas2MenuItem.setText("Das2 Homepage");
        this.aboutDas2MenuItem.setToolTipText("Browse the Das2 homepage, which provides graphics and interactivity.");
        this.aboutDas2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.aboutDas2MenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutDas2MenuItem);
        this.autoplotHomepageButton.setText("Autoplot Homepage");
        this.autoplotHomepageButton.setToolTipText("Browse the Autoplot homepage");
        this.autoplotHomepageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.autoplotHomepageButtonActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.autoplotHomepageButton);
        this.searchToolTipsMenuItem.setText("Search Tooltips...");
        this.searchToolTipsMenuItem.setToolTipText("Experimental search all GUI tooltips");
        this.searchToolTipsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.searchToolTipsMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.searchToolTipsMenuItem);
        this.exceptionReport.setText("Provide Feedback...");
        this.exceptionReport.setToolTipText("Send feedback to application support");
        this.exceptionReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.exceptionReportActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.exceptionReport);
        this.aboutAutoplotMenuItem.setText("About Autoplot");
        this.aboutAutoplotMenuItem.setToolTipText("Show information about this release");
        this.aboutAutoplotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoplotUI.this.aboutAutoplotMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutAutoplotMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.timeRangePanel, -1, 708, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.statusLabel, -2, 16, -2).add(4, 4, 4).add((Component)this.statusTextField, -1, 700, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.tabbedPanelContainer, -1, 732, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.uriTimeRangeToggleButton1, -2, 11, -2).add(0, 721, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.timeRangePanel, -2, 31, -2).addPreferredGap(0, 695, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.statusLabel).add((Component)this.statusTextField, -2, -1, -2))).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(48, 48, 48).add((Component)this.tabbedPanelContainer, -1, 686, Short.MAX_VALUE).add(20, 20, 20))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.uriTimeRangeToggleButton1, -2, 28, -2).addContainerGap(714, Short.MAX_VALUE))));
        this.bindingGroup.bind();
        this.pack();
    }

    private void copyImageMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.doCopyDataSetImage();
    }

    private void copyDataSetURLMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.doCopyDataSetURL();
    }

    private void pasteDataSetURLMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.doPasteDataSetURL();
    }

    protected void doPlotGoButton(final String uri, final int modifiers) {
        LoggerManager.getLogger("gui").log(Level.FINE, "plot URI \"{0}\"", uri);
        ExceptionHandler eh = this.applicationModel.getExceptionHandler();
        if (eh instanceof GuiExceptionHandler) {
            ((GuiExceptionHandler)eh).setFocusURI(uri);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (AutoplotUI.this.isExpertMode()) {
                    if ((modifiers & 2) == 2) {
                        if ((modifiers & 1) == 1) {
                            String uri2 = AutoplotUI.this.dataSetSelector.getValue();
                            AutoplotUI.this.plotAnotherUrl(uri2, Collections.singletonMap("direction", LayoutConstants.ABOVE));
                        } else {
                            AutoplotUI.this.plotAnotherUrl();
                        }
                    } else if ((modifiers & 1) == 1) {
                        AutoplotUI.this.overplotAnotherUrl();
                    } else {
                        AutoplotUI.this.plotUrl(uri);
                    }
                } else {
                    AutoplotUI.this.dom.getController().reset();
                    AutoplotUI.this.plotUrl(uri);
                }
            }
        };
        new Thread(run, "dataSetSelectThread").start();
    }

    private void dataSetSelectorActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        String uri = this.dataSetSelector.getValue();
        int modifiers = evt.getModifiers();
        this.doPlotGoButton(uri, modifiers);
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        DasPlot p = this.dom.getController().getPlot().getController().getDasPlot();
        DatumRange dr = DatumRangeUtil.rescale(p.getXAxis().getDatumRange(), -0.333, 1.333);
        p.getXAxis().setDatumRange(dr);
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        DasPlot p = this.dom.getController().getPlot().getController().getDasPlot();
        DatumRange dr = DatumRangeUtil.rescale(p.getXAxis().getDatumRange(), 0.25, 0.75);
        p.getXAxis().setDatumRange(dr);
    }

    private void resetZoomMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.dom.getController().getPlot().getController().resetZoom(true, true, true);
        if (!AutoplotUtil.resetZoomX(this.dom)) {
            System.err.println("unable to zoom x");
        }
        if (!AutoplotUtil.resetZoomY(this.dom)) {
            System.err.println("unable to zoom y");
        }
        if (!AutoplotUtil.resetZoomZ(this.dom)) {
            System.err.println("unable to zoom z");
        }
    }

    private void fontsAndColorsMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (this.fontAndColorsDialog == null) {
            this.fontAndColorsDialog = new FontAndColorsDialog((Frame)this, false, this.applicationModel);
        }
        this.fontAndColorsDialog.setVisible(true);
    }

    private void specialEffectsMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.getDocumentModel().getOptions().setSpecialEffects(this.specialEffectsMenuItem.isSelected());
    }

    private void drawAntiAliasMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.getDocumentModel().getOptions().setDrawAntiAlias(this.drawAntiAliasMenuItem.isSelected());
    }

    private void textAntiAliasActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.getDocumentModel().getOptions().setTextAntiAlias(this.textAntiAlias.isSelected());
    }

    private void aboutAutoplotMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        try {
            String bufStr = AutoplotUtil.getAboutAutoplotHtml();
            JTextPane jtp = new JTextPane();
            jtp.setContentType("text/html");
            jtp.read(new StringReader(bufStr), null);
            jtp.setEditable(false);
            jtp.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        AutoplotUtil.openBrowser(e.getURL().toString());
                    }
                }
            });
            final JPopupMenu menu = new JPopupMenu();
            JMenuItem copyItem = menu.add(new DefaultEditorKit.CopyAction());
            copyItem.setText("Copy");
            jtp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && menu != null) {
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() && menu != null) {
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            JScrollPane pane = new JScrollPane(jtp, 20, 30);
            pane.getVerticalScrollBar().setUnitIncrement(12);
            pane.setPreferredSize(new Dimension(690, 480));
            AutoplotUtil.showMessageDialog(this, pane, "About Autoplot " + AboutUtil.getReleaseTag(), 1);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void aboutDas2MenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        AutoplotUtil.openBrowser("http://das2.org");
    }

    private void autoplotHomepageButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        AutoplotUtil.openBrowser("http://autoplot.org/");
    }

    private void helpMenuActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
    }

    private void scriptPanelMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.getDocumentModel().getOptions().setScriptVisible(this.scriptPanelMenuItem.isSelected());
        if (this.scriptPanelMenuItem.isSelected() && this.jythonScriptPanel == null) {
            this.jythonScriptPanel = new JPanel(new BorderLayout());
            this.scriptPanel = new JythonScriptPanel(this, this.dataSetSelector);
            this.jythonScriptPanel.add((Component)this.scriptPanel, "Center");
            this.tabs.insertTab(TAB_SCRIPT, null, this.jythonScriptPanel, String.format("<html>Editor panel for Jython scripts and data sources.<br>%s</html>", "Right-click or drag to undock."), 4);
            ExceptionHandler h = this.getApplicationModel().getExceptionHandler();
            if (h != null && h instanceof GuiExceptionHandler) {
                ((GuiExceptionHandler)h).setScriptPanel(this.scriptPanel);
            }
        } else if (this.scriptPanelMenuItem.isSelected() && this.jythonScriptPanel != null) {
            this.tabs.insertTab(TAB_SCRIPT, null, this.jythonScriptPanel, String.format("<html>Editor panel for Jython scripts and data sources.<br>%s</html>", "Right-click or drag to undock."), 4);
        } else {
            this.tabs.remove(this.jythonScriptPanel);
        }
    }

    private void logConsoleMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.getDocumentModel().getOptions().setLogConsoleVisible(this.logConsoleMenuItem.isSelected());
        if (this.logConsoleMenuItem.isSelected() && this.logConsolePanel == null) {
            this.logConsolePanel = new JScrollPane();
            this.tabs.addTab(TAB_CONSOLE, null, this.logConsolePanel, String.format("<html>Log console displays log messages and stdout/stderr.<br>%s</html>", "Right-click or drag to undock."));
            this.initLogConsole();
            this.logConsolePanel.setViewportView(this.logConsole);
        } else if (this.logConsoleMenuItem.isSelected() && this.logConsolePanel != null) {
            this.tabs.addTab(TAB_CONSOLE, null, this.logConsolePanel, String.format("<html>Log console displays log messages and stdout/stderr.<br>%s</html>", "Right-click or drag to undock."));
        } else {
            if (this.logConsoleMenuItem.isSelected() && this.logConsolePanel != null) {
                this.logConsole.undoLogConsoleMessages();
            }
            this.tabs.remove(this.logConsolePanel);
        }
    }

    private void serverCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.getDocumentModel().getOptions().setServerEnabled(this.serverCheckBoxMenuItem.isSelected());
        if (this.applicationModel.getDocumentModel().getOptions().isServerEnabled()) {
            this.initServer();
        } else {
            this.stopServer();
            JOptionPane.showMessageDialog(this.rootPane, "<html>The server will not be stopped completely.<br>https://sourceforge.net/tracker/?func=detail&aid=3441071&group_id=199733&atid=970682");
        }
        this.serverCheckBoxMenuItem.setSelected(this.rlistener != null);
        this.serverCheckBoxMenuItem.setToolTipText(this.rlistener == null ? null : "listening on port " + this.rlistener.getPort());
        this.applicationModel.getDocumentModel().getOptions().setServerEnabled(this.rlistener != null);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.increaseFontSize();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.decreaseFontSize();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        final JDiskHogPanel panel = new JDiskHogPanel(this);
        JDialog dia = new JDialog(this, "Manage Cache", true);
        dia.add(panel);
        dia.pack();
        RequestProcessor.invokeLater(new Runnable(){

            @Override
            public void run() {
                panel.scan(new File(AutoplotSettings.settings().resolveProperty("fscache")));
            }
        });
        dia.setLocationRelativeTo(this);
        dia.setVisible(true);
        if (panel.isGoPressed()) {
            panel.doPlotSelected();
        }
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.clearCache();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        try {
            String release = AboutUtil.getReleaseTag();
            if (release.equals("(dev)")) {
                release = "devel";
            }
            String surl = "http://autoplot.org/jnlp/" + release;
            AutoplotUtil.openBrowser(surl);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void editDomMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        PropertyEditor edit = new PropertyEditor(this.applicationModel.dom);
        edit.showDialog(this, "DOM Properties", new ImageIcon(this.getClass().getResource("/resources/logo16.png")).getImage());
    }

    private void statusLabelMouseClicked(MouseEvent evt) {
        this.statusLabel.setIcon(IDLE_ICON);
        this.statusTextField.setText("");
    }

    private void inspectVapFileMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.doInspectVap();
    }

    private void autoLayoutCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (this.autoLayoutCheckBoxMenuItem.isSelected()) {
            this.applicationModel.doAutoLayout();
        }
    }

    private void autoplotHelpMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.helpSystem.displayHelpFromEvent(evt);
    }

    private void pngWalkMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        PngWalkTool.start(null, this);
    }

    private void createPngWalkMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    CreatePngWalk.doIt(AutoplotUI.this.applicationModel.dom, null);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    ex.printStackTrace();
                    AutoplotUI.this.setStatus(ERROR_ICON, "Unable to create PNG Walk: " + ex.getMessage());
                    AutoplotUI.this.applicationModel.showMessage("<html>Unable to create PNG Walk:<br>" + ex.getMessage(), "PNG Walk Error", 2);
                }
                catch (InterruptedException | ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private void aggregateMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        AggregateUrisDialog dia = new AggregateUrisDialog(this.dom, this.dataSetSelector);
        dia.showDialog();
    }

    private void decodeURLItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        String s = this.dataSetSelector.getValue();
        s = DataSourceUtil.unescape(s);
        this.dataSetSelector.setValue(s);
    }

    private void statusTextFieldMouseClicked(MouseEvent evt) {
        this.statusLabelMouseClicked(evt);
    }

    private void gettingStartedMenuItemActionPerformed(ActionEvent evt) {
        String uri;
        LoggerManager.logGuiEvent(evt);
        GettingStartedPanel gettingStartedPanel = new GettingStartedPanel();
        int result = JOptionPane.showConfirmDialog(this, gettingStartedPanel, "Getting Started", 2, -1);
        if (result == 0 && (uri = gettingStartedPanel.getInitialUri().trim()).length() > 0) {
            this.plotUri(uri);
        }
    }

    private void exceptionReportActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        ExceptionHandler eh = this.applicationModel.getExceptionHandler();
        if (eh == null || !(eh instanceof GuiExceptionHandler)) {
            new GuiExceptionHandler().submitRuntimeException(new RuntimeException("user-generated comment"), false);
        } else {
            ((GuiExceptionHandler)eh).submitRuntimeException(new RuntimeException("user-generated comment"), false);
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        String newv;
        LoggerManager.logGuiEvent(evt);
        MoveCacheDialog dia = new MoveCacheDialog();
        if (JOptionPane.showConfirmDialog(this, dia, "Move Cache", 2) == 0 && !(newv = dia.getNewDir().getText()).equals(AutoplotSettings.settings().getFscache())) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    File fnewv = new File(newv);
                    if (!fnewv.exists() && !fnewv.mkdirs()) {
                        JOptionPane.showMessageDialog(AutoplotUI.this, "Unable to move cache, couldn't create new folder.");
                        return;
                    }
                    AutoplotUI.this.applicationModel.moveCache(fnewv);
                }
            };
            new Thread(run).start();
        }
    }

    private void canvasSizeMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        CanvasSizePanel p = new CanvasSizePanel();
        p.getResizeRadioButton().setSelected(this.dom.getCanvases(0).isFitted());
        p.getFixedRadioButton().setSelected(!this.dom.getCanvases(0).isFitted());
        p.updateSizeEnabled();
        p.getHeightTextField().setValue(this.dom.getCanvases(0).getHeight());
        p.getWidthTextField().setValue(this.dom.getCanvases(0).getWidth());
        if (AutoplotUtil.showConfirmDialog(this, p, "Set Canvas Size", 2) == 0) {
            if (p.getResizeRadioButton().isSelected()) {
                this.dom.getCanvases(0).setFitted(true);
            } else {
                this.dom.getCanvases(0).setWidth((Integer)p.getWidthTextField().getValue());
                this.dom.getCanvases(0).setHeight((Integer)p.getHeightTextField().getValue());
                this.dom.getCanvases(0).setFitted(false);
            }
        }
    }

    public String getEditorCard() {
        return this.editorCard;
    }

    public void setEditorCard(String editorCard) {
        String oldEditorCard = this.editorCard;
        this.editorCard = editorCard;
        this.switchToEditorCard(editorCard);
        this.firePropertyChange(PROP_EDITORCARD, oldEditorCard, editorCard);
    }

    public void switchToEditorCard(String selector) {
        logger.log(Level.FINE, "switch to selector: {0}", selector);
        ((CardLayout)this.timeRangePanel.getLayout()).show(this.timeRangePanel, selector);
        if (CARD_TIME_RANGE_SELECTOR.equals(selector)) {
            this.uriTimeRangeToggleButton1.setPosition(0);
            this.dataSetSelector.setCardSelectedNoEventKludge(false);
            this.timeRangeEditor.setCardSelected(true);
        } else if (CARD_DATA_SET_SELECTOR.equals(selector)) {
            this.uriTimeRangeToggleButton1.setPosition(1);
            this.timeRangeEditor.setCardSelectedNoEventKludge(false);
            this.dataSetSelector.setCardSelected(true);
        } else {
            throw new IllegalArgumentException("huh card?");
        }
        this.uriTimeRangeToggleButton1.setPosition(CARD_TIME_RANGE_SELECTOR.equals(selector) ? 1 : 0);
        this.dom.getOptions().setUseTimeRangeEditor(CARD_TIME_RANGE_SELECTOR.equals(selector));
    }

    private void dataSetSelectorMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (this.dataSetSelectorMenuItem.isSelected()) {
            this.setEditorCard(CARD_DATA_SET_SELECTOR);
        }
    }

    private void timeRangeSelectorMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (this.timeRangeSelectorMenuItem.isSelected()) {
            this.setEditorCard(CARD_TIME_RANGE_SELECTOR);
        }
    }

    private void editOptionsActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        OptionsDialog p = new OptionsDialog();
        p.setOptions(this.applicationModel.dom.getOptions());
        if (AutoplotUtil.showConfirmDialog(this, p, "Options", 2) == 0) {
            p.copyOptions(this.applicationModel.dom.getOptions());
        }
    }

    private void fixLayoutMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DomOps.newCanvasLayout(AutoplotUI.this.dom);
            }
        };
        new Thread(run, "canvas layout").start();
    }

    private void resetXMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (!AutoplotUtil.resetZoomX(this.dom)) {
            System.err.println("unable to zoom x");
        }
    }

    private void resetYMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (!AutoplotUtil.resetZoomY(this.dom)) {
            System.err.println("unable to zoom y");
        }
    }

    private void resetZMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (!AutoplotUtil.resetZoomZ(this.dom)) {
            System.err.println("unable to zoom z");
        }
    }

    private void replaceFileMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUtil.replaceFile(AutoplotUI.this, AutoplotUI.this.dom);
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private void reloadAllMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        RequestProcessor.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoplotUtil.reloadAll(AutoplotUI.this.dom);
            }
        });
    }

    private void workOfflineCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        final boolean workOffline = this.workOfflineCheckBoxMenuItem.isSelected();
        FileSystem.settings().setOffline(workOffline);
        RequestProcessor.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileSystem.reset();
                AutoplotUI.this.setMessage(workOffline ? "Now working offline" : "Working online");
            }
        });
    }

    private void searchToolTipsMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        AutoplotUtil.doSearchToolTips(this);
    }

    private void manageFilesystemsMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        AutoplotUtil.doManageFilesystems(this);
    }

    private void resetMemoryCachesMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        logger.fine("Resetting FileSystems...");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ReferenceCache.getInstance().reset();
                FileSystem.reset();
                AutoplotUI.this.setMessage("FileSystem memory caches reset");
            }
        };
        RequestProcessor.invokeLater(run);
    }

    private void referenceCacheCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (this.referenceCacheCheckBoxMenuItem.isSelected()) {
            System.setProperty("enableReferenceCache", "true");
            this.setMessage("Reference Cache is enabled");
        } else {
            ReferenceCache.getInstance().printStatus();
            ReferenceCache.getInstance().reset();
            DataSetAnnotations.getInstance().reset();
            System.setProperty("enableReferenceCache", "false");
            this.setMessage("Reference Cache is disabled.");
        }
    }

    private void additionalOptionsMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        OptionsDialog p = new OptionsDialog();
        p.setOptions(this.applicationModel.dom.getOptions());
        if (AutoplotUtil.showConfirmDialog(this, p, "Additional Options", 2) == 0) {
            p.copyOptions(this.applicationModel.dom.getOptions());
        }
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        EventsListToolUtil.show(this);
    }

    private void formMouseClicked(MouseEvent evt) {
        Rectangle dssBounds = this.getDataSetSelector().getBounds();
        dssBounds = SwingUtilities.convertRectangle(this.getDataSetSelector(), dssBounds, this);
        if (evt.getX() < dssBounds.x && evt.getY() > dssBounds.y && evt.getY() < dssBounds.y + dssBounds.height) {
            if (evt.getY() < dssBounds.y + dssBounds.height / 2) {
                this.setEditorCard(CARD_DATA_SET_SELECTOR);
            } else {
                this.setEditorCard(CARD_TIME_RANGE_SELECTOR);
            }
        }
    }

    private void filtersMenuItemActionPerformed(ActionEvent evt) {
        String filter = this.dom.getController().getPlotElement().getComponent();
        if (filter.length() == 0) {
            AddFilterDialog dia = new AddFilterDialog();
            if (0 == AutoplotUtil.showConfirmDialog(this, dia, "Add Operation", 2)) {
                filter = dia.getValue();
            } else {
                return;
            }
        }
        FiltersChainPanel fcp = new FiltersChainPanel();
        fcp.setFilter(filter);
        DataSourceFilter dsf = this.dom.getController().getDataSourceFilterFor(this.dom.getController().getPlotElement());
        if (dsf != null) {
            fcp.setInput(dsf.getController().getFillDataSet());
            fcp.setFilter(filter);
        }
        if (0 == AutoplotUtil.showConfirmDialog(this, fcp, "Edit Operations", 2)) {
            this.dom.getController().getPlotElement().setComponent(fcp.getFilter());
        }
    }

    private void resetFontMIActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.applicationModel.resetFontSize();
    }

    private void mashDataMenuItemActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        String uri = this.dataSetSelector.getValue();
        if (uri.trim().length() > 0) {
            URISplit split = URISplit.parse(uri);
            if (split.vapScheme == null || !split.vapScheme.equals("vap+inline")) {
                if ("vap+internal".equals(split.vapScheme)) {
                    String[] ss = split.path.split(",", -2);
                    StringBuilder urib = new StringBuilder("vap+inline:");
                    for (String s : ss) {
                        String uri1;
                        try {
                            DomNode n = this.dom.getElementById(s);
                            if (n instanceof DataSourceFilter) {
                                DataSourceFilter dsf = (DataSourceFilter)n;
                                uri1 = dsf.getUri();
                            } else {
                                uri1 = "";
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            uri1 = "";
                        }
                        urib.append(s).append("=getDataSet('").append(uri1).append("')&");
                    }
                    urib.append("link(").append(split.path).append(")");
                    uri = urib.toString();
                } else {
                    uri = "vap+inline:ds=getDataSet('" + uri + "')";
                }
            }
        }
        if (uri.length() > 0) {
            this.dataSetSelector.setValue(uri);
            this.dataSetSelector.maybePlot(8);
        } else {
            final DataMashUp dm = new DataMashUp();
            dm.setResolver(new DataMashUp.Resolver(){

                @Override
                public QDataSet getDataSet(String uri) {
                    try {
                        return DataSetURI.getDataSource(uri).getDataSet(new NullProgressMonitor());
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, null, ex);
                        return null;
                    }
                }

                @Override
                public BufferedImage getImage(QDataSet qds) {
                    return AutoplotUtil.createImage(qds, 120, 60);
                }

                @Override
                public void interactivePlot(QDataSet qds) {
                    Window w = SwingUtilities.getWindowAncestor(dm);
                    ApplicationModel model = ScriptContext.newDialogWindow(w, qds.toString());
                    model.setDataSet(qds);
                }
            });
            if (0 == AutoplotUtil.showConfirmDialog(this, dm, "Data Mash Up", 2)) {
                this.dataSetSelector.setValue(dm.getAsJythonInline());
                this.dataSetSelector.maybePlot(0);
            }
        }
    }

    private void runBatchMenuItemActionPerformed(ActionEvent evt) {
        BatchMaster mmm = new BatchMaster(this.dom);
        JDialog dia = new JDialog((Frame)this, "Run Batch");
        dia.setContentPane(mmm);
        dia.pack();
        dia.setLocationRelativeTo(this);
        dia.setVisible(true);
    }

    public static String getProcessId(String fallback) {
        return AutoplotUtil.getProcessId(fallback);
    }

    private void updateFrameTitle() {
        String theTitle;
        String apname;
        String suri = this.applicationModel.getVapFile();
        String v = APSplash.getVersion();
        if (v.equals("untagged_version")) {
            v = "(dev)";
        }
        if (v.equals("(dev)")) {
            v = "(dev" + AutoplotUI.getProcessId("") + ")";
        }
        String title0 = "Autoplot " + v;
        String isoffline = FileSystem.settings().isOffline() ? " (offline)" : "";
        String server = this.rlistener == null ? "" : " (port=" + this.rlistener.getPort() + ")";
        String s32bit = AutoplotUtil.is32bit ? " (32bit)" : "";
        String string = apname = this.applicationName.length() == 0 ? "" : this.applicationName + " - ";
        if (suri == null) {
            theTitle = apname + title0 + isoffline + server + s32bit + AutoplotUtil.javaVersionWarning;
        } else {
            boolean dirty;
            URISplit split = URISplit.parse(suri);
            boolean bl = dirty = this.undoRedoSupport.getDepth() > 1;
            if (split.path != null && split.file != null) {
                String titleStr = split.file.substring(split.path.length()) + (dirty ? "*" : "");
                theTitle = apname + titleStr + " - " + title0 + isoffline + server + s32bit;
            } else {
                logger.log(Level.WARNING, "Unable to get path from: {0}", suri);
                theTitle = apname + "??? - " + title0 + isoffline + server + s32bit;
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.setTitle(theTitle);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public static void raiseApplicationWindow(Frame frame) {
        GuiSupport.raiseApplicationWindow(frame);
    }

    public AutoplotUI newApplication() {
        ApplicationModel model = this.support.newApplication();
        return (AutoplotUI)model.application.getMainFrame();
    }

    private static void addSingleInstanceListener(final ArgumentList alm, final AutoplotUI app) {
        SingleInstanceService sis;
        try {
            sis = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
        }
        catch (UnavailableServiceException ex) {
            sis = null;
        }
        if (sis == null) {
            logger.fine("not running with webstart");
            return;
        }
        SingleInstanceListener sisL = new SingleInstanceListener(){

            public void newActivation(String[] argv) {
                String suri;
                int i;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("single instance listener argv:");
                    for (i = 0; i < argv.length; ++i) {
                        logger.log(Level.FINE, " argv[{0}]: {1}\n", new Object[]{i, argv[i]});
                    }
                }
                for (i = 0; i < argv.length; ++i) {
                    if (argv[i].equals("-print")) {
                        argv[i] = "--print";
                    }
                    if (!argv[i].equals("-open")) continue;
                    argv[i] = "--open";
                }
                alm.process(argv);
                JFrame frame = (JFrame)ScriptContext.getViewWindow();
                if (frame != null) {
                    AutoplotUI.raiseApplicationWindow(frame);
                }
                if ((suri = alm.getValue("URI") != null ? alm.getValue("URI").trim() : (alm.getValue("open") != null ? alm.getValue("open").trim() : null)) != null && suri.length() > 1) {
                    logger.log(Level.FINE, "setting initial URI to >>>{0}<<<", suri);
                }
                String pos = alm.getValue("position");
                app.handleSingleInstanceURI(suri, pos);
            }
        };
        sis.addSingleInstanceListener(sisL);
    }

    public void handleSingleInstanceURI(String suri, String pos) {
        final AutoplotUI app = this;
        boolean raise = false;
        if (suri != null && (suri.startsWith("pngwalk:") || suri.endsWith(".pngwalk") || suri.contains(".pngwalk?"))) {
            PngWalkTool.start(suri, app);
            app.applicationModel.addRecent(app.dataSetSelector.getValue());
            return;
        }
        if (suri != null && app.dataSetSelector.hasActionTrigger(suri)) {
            app.dataSetSelector.setValue(suri);
            app.dataSetSelector.maybePlot(false);
            return;
        }
        if (suri != null && suri.length() > 1) {
            try {
                suri = URISplit.makeAbsolute(new File(".").getCanonicalPath(), suri);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (pos != null) {
            app.applicationModel.setFocus(Integer.parseInt(pos));
            if (suri != null) {
                app.dataSetSelector.setValue(suri);
            }
            app.dataSetSelector.maybePlot(false);
        } else if (suri == null) {
            int action = JOptionPane.showConfirmDialog(ScriptContext.getViewWindow(), "<html>Autoplot is already running.<br>Start another window?", "Reenter Autoplot", 0);
            if (action == 0) {
                app.support.newApplication();
            } else {
                raise = true;
            }
        } else {
            String ssuri = suri;
            if (ssuri.length() > 80) {
                ssuri = DataSetURI.abbreviateForHumanComsumption(ssuri, 80);
            }
            String msg = app.isExpertMode() ? String.format("<html>Autoplot is already running. Autoplot can use this address in a new window, <br>or replace the current plot with the new URI, possibly entering the editor, <br>or always enter the editor to inspect and insert the plot below.<br>View in new window, replace, or add plot, using<br>%s?", ssuri) : String.format("<html>Autoplot is already running. Autoplot can use this address in a new window, <br>or replace the current plot with the new URI, possibly entering the editor <br>or always enter the editor to inspect before plotting.<br>View in new window, replace, or add plot, using<br>%s?", ssuri);
            String action = (String)JOptionPane.showInputDialog(ScriptContext.getViewWindow(), msg, "Incorporate New URI", 3, new ImageIcon(this.getClass().getResource("/resources/logo64.png")), new String[]{"New Window", "Replace", "Add Plot"}, "Add Plot");
            if (action != null) {
                switch (action) {
                    case "Replace": {
                        app.plotUri(suri);
                        raise = true;
                        break;
                    }
                    case "Add Plot": {
                        app.dataSetSelector.setValue(suri);
                        app.dataSetSelector.maybePlot(8);
                        raise = true;
                        break;
                    }
                    case "New Window": {
                        AutoplotUI ui2 = app.newApplication();
                        ui2.plotUri(suri);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("One of [New Window, Replace,  Add Plot] expected: " + action);
                    }
                }
            } else {
                raise = true;
            }
        }
        if (raise) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoplotUI.raiseApplicationWindow(app);
                }
            });
        }
    }

    private static void runScriptImmediately(AutoplotUI app, ApplicationModel model, String script, List<String> scriptArgs, boolean quit, String testPngFilename) {
        try {
            String pwd = URISplit.parse((String)script).path;
            ScriptContext.setApplicationModel(model);
            org.autoplot.JythonUtil.runScript(model, script, scriptArgs.toArray(new String[scriptArgs.size()]), pwd);
            if (testPngFilename != null && testPngFilename.length() > 0) {
                logger.log(Level.FINE, "Writing to {0}", testPngFilename);
                Logger.getLogger("autoplot.scriptcontext.writeToPng").setLevel(Level.FINER);
                Logger.getLogger("autoplot.scriptcontext.writeToPng").fine("Logging at FINE");
                ScriptContext.writeToPng(testPngFilename);
            }
            if (app != null) {
                app.setStatus(READY_MESSAGE);
            }
            if (quit) {
                AppManager.getInstance().quit();
            }
        }
        catch (IOException ex) {
            if (quit) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                System.err.println(ex.getMessage());
                AppManager.getInstance().quit(1);
            }
            model.getExceptionHandler().handle(ex);
        }
    }

    private static Runnable getRunScriptRunnable(final AutoplotUI app, final ApplicationModel model, final String script, final List<String> scriptArgs, final boolean quit, final String testPngFilename) {
        Runnable r = new Runnable(){

            public String toString() {
                return "runScriptRunnable";
            }

            @Override
            public void run() {
                AutoplotUI.runScriptImmediately(app, model, script, scriptArgs, quit, testPngFilename);
            }
        };
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String s;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof ActionEvent) {
                    LoggerManager.logGuiEvent((ActionEvent)event);
                }
            }
        }, 8L);
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Util.addFonts();
        File f1 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "config");
        File f2 = new File(f1, "logging.properties");
        if (f2.exists()) {
            if (!f2.canRead()) {
                logger.log(Level.WARNING, "Unable to read {0}", f2);
            }
            InputStream in = null;
            try {
                logger.log(Level.FINE, "Reading {0}", f2);
                in = new FileInputStream(f2);
                LogManager.getLogManager().readConfiguration(in);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "IOException during read of {0}", f2);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "IOException during close of {0}", f2);
                }
            }
        }
        if (System.getProperty("autoplot.default.bookmarks") == null && (s = System.getProperty("jnlp.autoplot.default.bookmarks")) != null) {
            System.setProperty("autoplot.default.bookmarks", s);
        }
        if (System.getProperty("java.util.logging.config.file") == null && (s = System.getProperty("jnlp.java.util.logging.config.file")) != null) {
            System.setProperty("java.util.logging.config.file", s);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("==arguments==");
            for (int i = 0; i < args.length; ++i) {
                logger.log(Level.FINE, "arg{0}: {1}", new Object[]{i, args[i]});
            }
            logger.fine("==end,arguments==");
        }
        final ArgumentList alm = new ArgumentList("AutoplotUI");
        alm.addOptionalPositionArgument(0, "URI", null, "initial URI to load");
        alm.addOptionalSwitchArgument("position", null, "position", null, "plot position for the URI, an integer indicating which data position to update.");
        alm.addOptionalSwitchArgument("bookmarks", null, "bookmarks", null, "bookmarks to load");
        alm.addOptionalSwitchArgument("port", "p", "port", "-1", "enable scripting via this port (deprecated, use server instead)");
        alm.addBooleanSwitchArgument("scriptPanel", null, "scriptPanel", "enable script panel");
        alm.addBooleanSwitchArgument("logConsole", "l", "logConsole", "enable log console");
        alm.addOptionalSwitchArgument("nativeLAF", "n", "nativeLAF", alm.TRUE, "use the system look and feel (T or F)");
        alm.addOptionalSwitchArgument("open", "o", "open", null, "open this URI (to support javaws)");
        alm.addOptionalSwitchArgument("print", null, "print", "", "print this URI (to support javaws)");
        alm.addOptionalSwitchArgument(TAB_SCRIPT, "s", TAB_SCRIPT, "", "run this script after starting.  Arguments following are passed into the script as sys.argv");
        alm.addOptionalSwitchArgument("testPngFilename", null, "testPngFilename", "", "write canvas to this png file after script is run");
        alm.addOptionalSwitchArgument("autoLayout", null, "autoLayout", alm.TRUE, "turn on/off initial autolayout setting");
        alm.addOptionalSwitchArgument("mode", "m", "mode", "expert", "start in basic (browse,reduced) mode or expert mode");
        alm.addBooleanSwitchArgument("eventThreadMonitor", null, "eventThreadMonitor", "monitor the event thread for long unresponsive pauses (deprecated, use enableResponseMonitor)");
        alm.addBooleanSwitchArgument("enableResponseMonitor", null, "enableResponseMonitor", "monitor the event thread for long unresponsive pauses");
        alm.addBooleanSwitchArgument("samp", null, "samp", "enable SAMP connection for use with European Space Agency applications and websites");
        alm.addOptionalSwitchArgument("server", null, "server", "-1", "start server at the given port listening to commands. (Replaces port)");
        alm.addBooleanSwitchArgument("nop", null, "nop", "no operation, to be a place holder for jnlp script.");
        alm.addBooleanSwitchArgument("headless", null, "headless", "run in headless mode");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-print")) {
                args[i] = "--print";
            }
            if (!args[i].equals("-open")) continue;
            args[i] = "--open";
            if (args.length <= i + 1 || args[i + 1].length() >= 3) continue;
            logger.fine("ignoring -open argument with less than three character URI.");
            args[i + 1] = "";
        }
        final ArrayList<String> scriptArgs = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            int j;
            if (args.length <= i || !args[i - 1].startsWith("--script") && !args[i - 1].equals("-s")) continue;
            ArrayList<String> apArgs = new ArrayList<String>();
            if (args[i - 1].length() > 8 && args[i - 1].charAt(8) == '=') {
                for (j = 0; j < i; ++j) {
                    apArgs.add(args[j]);
                }
                for (j = i; j < args.length; ++j) {
                    if (args[j].startsWith("--testPngFilename")) {
                        throw new IllegalArgumentException("--testPngFilename needs to come before --script");
                    }
                    scriptArgs.add(args[j]);
                }
            } else {
                for (j = 0; j <= i; ++j) {
                    apArgs.add(args[j]);
                }
                for (j = i + 1; j < args.length; ++j) {
                    if (args[j].startsWith("--testPngFilename")) {
                        throw new IllegalArgumentException("--testPngFilename needs to come before --script");
                    }
                    scriptArgs.add(args[j]);
                }
            }
            args = apArgs.toArray(new String[apArgs.size()]);
            break;
        }
        alm.process(args);
        if (alm.getBooleanValue("headless")) {
            System.setProperty("java.awt.headless", "true");
        }
        AutoplotUtil.maybeLoadSystemProperties();
        String welcome = "welcome to autoplot";
        try {
            String tag = AboutUtil.getReleaseTag(APSplash.class);
            welcome = welcome + " (" + tag + ")";
            System.setProperty("http.agent", "Autoplot-" + tag);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        final boolean headless = "true".equals(System.getProperty("java.awt.headless"));
        System.err.println(welcome);
        logger.info(welcome);
        final ApplicationModel model = new ApplicationModel();
        String initialURL = alm.getValue("URI") != null ? alm.getValue("URI").trim() : (alm.getValue("open") != null ? alm.getValue("open").trim() : null);
        if (initialURL != null && initialURL.startsWith("open=")) {
            JOptionPane.showMessageDialog(null, "<html>open= switch is missing -- prefix: should be<br>--" + initialURL, "open= switch is missing -- ", 0);
        }
        if (initialURL != null && initialURL.length() > 1) {
            boolean isAbsolute;
            int i = initialURL.indexOf(58);
            logger.log(Level.FINE, "setting initial URI to >>>{0}<<<", initialURL);
            if (i == -1 && !(isAbsolute = initialURL.startsWith("/"))) {
                try {
                    String pwd = new File(".").getCanonicalPath();
                    if (pwd.length() > 2) {
                        pwd = pwd + "/";
                    }
                    initialURL = pwd + initialURL;
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        final String finitialURL = initialURL;
        final String bookmarks = alm.getValue("bookmarks");
        if (alm.getBooleanValue("scriptPanel")) {
            logger.fine("enable scriptPanel");
            model.getDocumentModel().getOptions().setScriptVisible(true);
        }
        if (alm.getBooleanValue("logConsole")) {
            logger.fine("enable scriptPanel");
            model.getDocumentModel().getOptions().setLogConsoleVisible(true);
        }
        if (!headless && alm.getBooleanValue("nativeLAF")) {
            logger.fine("nativeLAF");
            try {
                String s2 = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(s2);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        logger.fine("invokeLater()");
        EventQueue.invokeLater(new Runnable(){

            public String toString() {
                return "initAutoplotRunnable";
            }

            @Override
            public void run() {
                String script;
                boolean doCatchUncaughtExceptions;
                boolean server;
                boolean port;
                AutoplotUI app;
                logger.fine("enter invokeLater");
                if (!headless) {
                    logger.addHandler(APSplash.getInstance().getLogHandler());
                    APSplash.showSplash();
                }
                APSplash.checkTime("init -100");
                OptionsPrefsController opc = new OptionsPrefsController(model.dom.getOptions());
                opc.loadPreferences();
                if (!alm.getBooleanValue("autoLayout")) {
                    logger.fine("set autoLayout");
                    model.getDocumentModel().getOptions().setAutolayout(false);
                }
                APSplash.checkTime("init -90");
                if (!headless) {
                    APSplash.showSplash();
                }
                model.addDasPeersToApp();
                APSplash.checkTime("init -80");
                if (!headless) {
                    APSplash.showSplash();
                }
                APSplash.checkTime("init -70");
                if (headless) {
                    app = null;
                } else {
                    app = new AutoplotUI(model);
                    app.createDropTargetListener(app.dataSetSelector);
                    Preferences prefs = AutoplotSettings.settings().getPreferences(AutoplotUI.class);
                    int posx = prefs.getInt("locationx", app.getLocation().x);
                    int posy = prefs.getInt("locationy", app.getLocation().y);
                    if (posx != app.getLocation().x || posy != app.getLocation().y) {
                        boolean scncheck;
                        boolean bl = scncheck = Toolkit.getDefaultToolkit().getScreenSize().width == prefs.getInt("locationscreenwidth", 0);
                        if (scncheck) {
                            app.setLocation(posx, posy);
                        }
                    }
                    APSplash.checkTime("init 200");
                    boolean addSingleInstanceListener = true;
                    if (addSingleInstanceListener) {
                        AutoplotUI.addSingleInstanceListener(alm, app);
                    }
                    if (alm.getBooleanValue("samp")) {
                        AddSampListener.addSampListener(app);
                        app.setMessage("SAMP listener started");
                    }
                }
                APSplash.checkTime("init 210");
                if (!headless && finitialURL != null && app != null) {
                    app.dom.getController().registerPendingChange(app, AutoplotUI.PENDING_CHANGE_INITIAL_URI);
                }
                boolean bl = port = !alm.getValue("port").equals("-1");
                if (port) {
                    System.err.println("port keyword is deprecated, use --server=" + port + " instead");
                    if (app == null) {
                        throw new IllegalArgumentException("Server cannot be used in headless mode");
                    }
                    int iport = Integer.parseInt(alm.getValue("port"));
                    app.setupServer(iport, model);
                    model.getDocumentModel().getOptions().setServerEnabled(true);
                }
                boolean bl2 = server = !alm.getValue("server").equals("-1");
                if (server) {
                    if (app == null) {
                        throw new IllegalArgumentException("Server cannot be used in headless mode");
                    }
                    int iport = Integer.parseInt(alm.getValue("server"));
                    app.setupServer(iport, model);
                    model.getDocumentModel().getOptions().setServerEnabled(true);
                }
                if (doCatchUncaughtExceptions = true) {
                    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            logger.log(Level.SEVERE, "runtime exception: " + e, e);
                            if (app != null) {
                                app.setStatus(ERROR_ICON, "caught exception: " + e.toString());
                            }
                            if (e instanceof InconvertibleUnitsException) {
                                return;
                            }
                            model.getExceptionHandler().handleUncaught(e);
                        }
                    });
                }
                APSplash.checkTime("init 220");
                if (!headless) {
                    logger.fine("UI.setVisible(true)");
                    Runnable repaintRunnable = new Runnable(){

                        public String toString() {
                            return "repaintRunnable";
                        }

                        @Override
                        public void run() {
                            if (app != null) {
                                app.applicationModel.canvas.repaint();
                                if (finitialURL == null || !finitialURL.startsWith("pngwalk:") && !finitialURL.endsWith(".pngwalk") && !finitialURL.contains(".pngwalk?")) {
                                    app.setVisible(true);
                                }
                            }
                        }
                    };
                    repaintRunnable.run();
                    if (System.getProperty("enableResponseMonitor", "false").equals("true") || alm.getBooleanValue("eventThreadMonitor") || alm.getBooleanValue("enableResponseMonitor")) {
                        EventThreadResponseMonitor emon = new EventThreadResponseMonitor();
                        if (app != null) {
                            emon.addToMap("UNDO_REDO_SUPPORT", app.undoRedoSupport);
                            emon.addToMap("APP_MODEL", app.applicationModel);
                        }
                        emon.start();
                    }
                    logger.fine("UI is visible");
                    APSplash.hideSplash();
                    logger.removeHandler(APSplash.getInstance().getLogHandler());
                    if (alm.getValue("mode").equals("basic") && app != null) {
                        app.setExpertMode(false);
                    }
                }
                APSplash.checkTime("init 230");
                boolean useInitialURL = false;
                if (!headless && finitialURL != null && app != null) {
                    app.dataSetSelector.setValue(finitialURL);
                    app.dataSetSelector.maybePlot(false);
                    useInitialURL = true;
                }
                if (bookmarks != null && app != null) {
                    app.initialBookmarksUrl = bookmarks;
                }
                String script_ = alm.getValue(AutoplotUI.TAB_SCRIPT);
                if (!useInitialURL && script_.equals("") && finitialURL != null) {
                    if (finitialURL.startsWith("script:")) {
                        script_ = finitialURL.substring(7);
                    } else if (finitialURL.endsWith(".jy")) {
                        script_ = finitialURL;
                    }
                }
                if (!(script = script_).equals("")) {
                    if (headless) {
                        model.setExceptionHandler(new ExceptionHandler(){

                            @Override
                            public void handle(Throwable t) {
                                t.printStackTrace();
                            }

                            @Override
                            public void handleUncaught(Throwable t) {
                                t.printStackTrace();
                            }
                        });
                    }
                    String s = URISplit.makeAbsolute(new File(".").getAbsolutePath(), script);
                    if (app != null) {
                        app.setStatus("running script " + s);
                    }
                    Runnable run = AutoplotUI.getRunScriptRunnable(app, model, s, scriptArgs, headless && !server, alm.getValue("testPngFilename"));
                    new Thread(run, "batchRunScriptThread").start();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(AutoplotUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    APSplash.checkTime("init 240");
                    if (app != null) {
                        app.setStatus(AutoplotUI.READY_MESSAGE);
                    }
                }
                if (app != null) {
                    AutoplotUI.checkStatusLoop(app);
                }
                if (!headless && finitialURL != null && app != null) {
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            app.dom.getController().performingChange(app, AutoplotUI.PENDING_CHANGE_INITIAL_URI);
                            app.dom.getController().changePerformed(app, AutoplotUI.PENDING_CHANGE_INITIAL_URI);
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
            }
        });
    }

    protected static void checkStatusLoop(final AutoplotUI app) {
        TimerTask run = new TimerTask(){

            public String toString() {
                return "apPendingChangesMonitor";
            }

            @Override
            public void run() {
                String currentStatusLabel;
                LinkedHashMap<Object, Object> changes = new LinkedHashMap<Object, Object>();
                app.dom.getController().pendingChanges(changes);
                if (app.statusLabel.getIcon() != WARNING_ICON) {
                    if (changes.size() > 0) {
                        app.currentIcon = BUSY_ICON;
                        String chstr = "";
                        for (Map.Entry<Object, Object> e : changes.entrySet()) {
                            String client = String.valueOf(e.getValue());
                            int ist = client.indexOf(40);
                            int ien = client.lastIndexOf(41);
                            if (ist != -1) {
                                client = client.substring(0, ist) + client.substring(ien + 1);
                            }
                            if (chstr.equals("")) {
                                chstr = "* " + e.getKey() + " (" + client + ")";
                                continue;
                            }
                            chstr = chstr + "\n* " + e.getKey() + " (" + client + ")";
                        }
                        app.currentIconTooltip = chstr;
                    } else {
                        app.currentIcon = IDLE_ICON;
                        app.currentIconTooltip = null;
                    }
                }
                app.dom.getController().setPendingChangeCount(changes.size());
                boolean update = false;
                if (app.currentIcon != app.statusLabel.getIcon()) {
                    update = true;
                }
                if (app.currentIconTooltip != (currentStatusLabel = app.statusLabel.getToolTipText()) || app.currentIconTooltip != null && !app.currentIconTooltip.equals(currentStatusLabel)) {
                    update = true;
                }
                if (update) {
                    try {
                        SwingUtilities.invokeAndWait(app.updateIconRunnable);
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        app.apbusy.schedule(run, 500L, 200L);
    }

    void createDropTargetListener(DataSetSelector dataSetSelector) {
        this.dropListener = new UriDropTargetListener(dataSetSelector, this.applicationModel);
        DropTarget dropTarget = new DropTarget();
        dropTarget.setComponent(this.applicationModel.canvas);
        try {
            dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.applicationModel.getCanvas().setDropTarget(dropTarget);
        for (DasCanvasComponent cc : this.applicationModel.getCanvas().getCanvasComponents()) {
            if (!(cc instanceof DasPlot)) continue;
            DropTarget dropTarget1 = new DropTarget();
            dropTarget1.setComponent(cc);
            try {
                dropTarget1.addDropTargetListener(this.dropListener);
            }
            catch (TooManyListenersException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            cc.setDropTarget(dropTarget1);
        }
        this.applicationModel.dom.getCanvases(0).getController().setDropTargetListener(this.dropListener);
    }

    public DropTargetListener getDropTargetListener() {
        return this.dropListener;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    private void setupServer(int port, final ApplicationModel model) {
        this.rlistener = new RequestListener();
        this.rlistener.setPort(port);
        final RequestHandler rhandler = new RequestHandler();
        this.rlistener.addPropertyChangeListener("requestCount", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    if (AutoplotUI.this.rlistener == null) {
                        logger.log(Level.FINE, "the server is no longer listening");
                        return;
                    }
                    Socket socket = AutoplotUI.this.rlistener.getSocket();
                    if (!socket.getInetAddress().isLoopbackAddress()) {
                        logger.log(Level.FINE, "connection from {0}", socket);
                        socket.getOutputStream().write("\nConnections to Autoplot are only allowed from localhost\n\n".getBytes());
                        socket.close();
                    } else {
                        logger.log(Level.FINE, "connection from {0}", socket);
                        rhandler.handleRequest(socket.getInputStream(), model, socket.getOutputStream());
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        });
        this.rlistener.addPropertyChangeListener("port", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotUI.this.updateFrameTitle();
            }
        });
        this.rlistener.startListening();
        this.serverCheckBoxMenuItem.setSelected(true);
        this.serverCheckBoxMenuItem.setToolTipText("server listening on port " + port);
        this.updateFrameTitle();
    }

    public void setMessage(String message) {
        this.setMessage(IDLE_ICON, message);
    }

    public void setMessage(Icon icon, String message) {
        if (message == null) {
            message = "<null>";
        }
        String myMess = message;
        final String fmyMess = myMess = myMess.replaceAll("\n", "");
        final String fmessage = message;
        final Icon ficon = icon;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ficon == WARNING_ICON) {
                        AutoplotUI.this.statusLabel.setIcon(ficon);
                    } else if (AutoplotUI.this.statusLabel.getIcon() == WARNING_ICON) {
                        AutoplotUI.this.statusLabel.setIcon(BUSY_ICON);
                    }
                    try {
                        AutoplotUI.this.statusTextField.setText(fmyMess);
                        AutoplotUI.this.statusTextField.setToolTipText(fmessage);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void invokeLater(int delayMillis, final boolean evt, final Runnable run) {
        TimerTask sleepRun = new TimerTask(){

            @Override
            public void run() {
                if (evt) {
                    SwingUtilities.invokeLater(run);
                } else {
                    run.run();
                }
            }
        };
        if (delayMillis == -1) {
            delayMillis = 500;
        }
        this.apbusy.schedule(sleepRun, delayMillis);
    }

    private void addTools() {
        TimerTask addToolsRun = new TimerTask(){

            @Override
            public void run() {
                AutoplotUI.this.reloadTools();
            }
        };
        this.apbusy.schedule(addToolsRun, 500L);
    }

    public void reloadTools() {
        List<Bookmark> tools;
        int i;
        int isep = -1;
        for (i = 0; i < this.toolsMenu.getMenuComponentCount(); ++i) {
            Component c = this.toolsMenu.getMenuComponent(i);
            if (!(c instanceof JSeparator) || !"userSep".equals(c.getName())) continue;
            isep = i;
            break;
        }
        if (isep > -1) {
            for (i = this.toolsMenu.getMenuComponentCount() - 1; i > isep; --i) {
                this.toolsMenu.remove(this.toolsMenu.getMenuComponent(i));
            }
        }
        if ((tools = this.loadTools()).size() > 0 && isep == -1) {
            JSeparator userSep = new JSeparator();
            userSep.setName("userSep");
            this.toolsMenu.add(userSep);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AutoplotUI.this.maybeCreateToolsManager();
                AutoplotUI.this.toolsManager.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AutoplotUI.this.toolsManager.updateBookmarks(AutoplotUI.this.toolsMenu, "userSep", AutoplotUI.this, AutoplotUI.this.dataSetSelector);
                            }
                        });
                    }
                });
                AutoplotUI.this.toolsManager.updateBookmarks(AutoplotUI.this.toolsMenu, "userSep", AutoplotUI.this, AutoplotUI.this.dataSetSelector);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Bookmark> loadTools() {
        ArrayList<Bookmark> tools = new ArrayList<Bookmark>();
        File toolsDir = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools");
        File booksDir = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks");
        if (!toolsDir.exists()) {
            return Collections.emptyList();
        }
        if (booksDir.exists()) {
            File toolsFile = new File(booksDir, "tools.xml");
            if (toolsFile.exists()) {
                try {
                    logger.fine("found tools.xml, use it instead of old logic.");
                    return Bookmark.parseBookmarks(toolsFile.toURI().toURL());
                }
                catch (IOException | BookmarksException | SAXException exception) {
                    return tools;
                }
            }
            File[] ff = toolsDir.listFiles();
            if (ff == null) {
                logger.log(Level.WARNING, "unable to read tools folder: {0}", toolsDir);
                ff = new File[]{};
            }
            for (File ff1 : ff) {
                if (!ff1.getName().toLowerCase().endsWith(".jy")) continue;
                Bookmark.Item book = new Bookmark.Item(ff1.toURI().toString());
                String toolLabel = ff1.getName();
                try (BufferedReader reader = new BufferedReader(new FileReader(ff1));){
                    String s = reader.readLine();
                    while (s != null && s.startsWith("#")) {
                        if (s.startsWith("# label:")) {
                            toolLabel = s.substring(8).trim();
                        } else if (s.startsWith("# LABEL:")) {
                            toolLabel = s.substring(8).trim();
                        } else if (s.startsWith("#LABEL:")) {
                            toolLabel = s.substring(7).trim();
                        }
                        s = reader.readLine();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                book.setTitle(toolLabel);
                tools.add(book);
            }
            InputStream ins = null;
            try {
                URL url = new URL("http://autoplot.org/data/tools.xml");
                ins = url.openStream();
                Document doc = AutoplotUtil.readDoc(ins);
                List<Bookmark> importBook = Bookmark.parseBookmarks(doc.getDocumentElement());
                tools.addAll(importBook);
            }
            catch (IOException | ParserConfigurationException | BookmarksException | SAXException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(toolsFile);
                Bookmark.formatBooks(fout, tools);
                return tools;
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        if (toolsDir.mkdirs()) return tools;
        System.err.println("failed to make tools directory");
        return tools;
    }

    public UndoRedoSupport getUndoRedoSupport() {
        return this.undoRedoSupport;
    }

    public Application getDocumentModel() {
        return this.applicationModel.getDocumentModel();
    }

    public DataSetSelector getDataSetSelector() {
        return this.dataSetSelector;
    }

    public TimeRangeEditor getTimeRangeEditor() {
        return this.timeRangeEditor;
    }

    public DataPanel getDataPanel() {
        return this.dataPanel;
    }

    public void basicMode() {
        this.setExpertMode(false);
    }

    public void setExpertMode(boolean expert) {
        this.autoMenu.setVisible(expert);
        for (JComponent mi : this.expertMenuItems) {
            mi.setVisible(expert);
        }
        this.expertMenu.setText(expert ? "Expert" : "Basic");
        this.dataSetSelector.setExpertMode(expert);
        if (this.dataPanel != null) {
            this.dataPanel.setExpertMode(expert);
        }
        for (Plot p : this.dom.getPlots()) {
            p.getController().setExpertMode(expert);
        }
        if (this.jythonScriptPanel != null) {
            if (expert) {
                this.tabs.add(TAB_SCRIPT, this.jythonScriptPanel);
            } else {
                this.tabs.remove(this.jythonScriptPanel);
            }
        }
        if (this.logConsolePanel != null) {
            if (expert) {
                this.tabs.add(TAB_CONSOLE, this.logConsolePanel);
            } else {
                this.tabs.remove(this.logConsolePanel);
            }
        }
        if (this.layoutPanel1 != null) {
            if (expert) {
                this.tabs.add("layout", this.layoutPanel1);
            } else {
                this.tabs.remove(this.layoutPanel1);
            }
        }
        this.dataSetSelector.setExpertMode(expert);
        final boolean fexpert = expert;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!fexpert) {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_TIME_RANGE_SELECTOR);
                } else {
                    AutoplotUI.this.setEditorCard(AutoplotUI.CARD_DATA_SET_SELECTOR);
                }
            }
        });
    }

    public boolean isExpertMode() {
        return this.expertMenuItems.get(0).isVisible();
    }

    public boolean isBasicMode() {
        return !this.expertMenuItems.get(0).isVisible();
    }

    private void loadInitialBookmarks(String bookmarks) {
        try {
            URL url = new URL(bookmarks);
            System.err.println("Reading bookmarks from " + url);
            Document doc = AutoplotUtil.readDoc(url.openStream());
            List<Bookmark> b = Bookmark.parseBookmarks(doc.getDocumentElement());
            BookmarksManagerModel mm = this.bookmarksManager.getModel();
            List<Bookmark> l = mm.getList();
            mm.mergeList(b, l);
            mm.setList(l);
        }
        catch (IOException | ParserConfigurationException | BookmarksException | SAXException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.applicationModel.getExceptionHandler().handleUncaught(ex);
        }
    }

    protected void installTool(final File ff, URI resourceUri) {
        try {
            String scriptUri = new URI(TAB_SCRIPT, resourceUri.toString(), null).toString();
            final Bookmark b = this.toolsManager.addBookmark(scriptUri);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try (BufferedReader reader = new BufferedReader(new FileReader(ff));){
                        Window w;
                        String label;
                        Map<String, String> doc = JythonUtil.getDocumentation(reader);
                        String title = doc.get("TITLE");
                        if (title != null) {
                            b.setDescription(title);
                        }
                        if ((label = doc.get("LABEL")) != null) {
                            b.setTitle(label);
                        }
                        if ((w = ScriptContext.getViewWindow()) instanceof AutoplotUI) {
                            ((AutoplotUI)w).reloadTools();
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(run).start();
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public void runScriptTools(String script) {
        this.runScript(script);
    }

    private void runScript(final String script) {
        try {
            final URISplit split = URISplit.parse(script);
            RunScriptPanel pp = new RunScriptPanel();
            final LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            pp.loadFileSoon(this, script);
            final DasProgressPanel mon = DasProgressPanel.createFramed(this, "Running script " + script);
            File tools = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "tools");
            boolean isTool = split.path.contains(tools.toString());
            Bookmark trust = this.toolsManager == null ? null : BookmarksManager.findBookmarkByUri(this.toolsManager.getModel().getList(), script, 1);
            final boolean fisTool = isTool = isTool || trust != null;
            mon.addPropertyChangeListener("finished", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            AutoplotUI.this.getDataSetSelector().setValue(script);
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
            });
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        int res = org.autoplot.JythonUtil.invokeScriptSoon(split.resourceUri, AutoplotUI.this.dom, (Map<String, String>)params, true, !fisTool, AutoplotUI.this.scriptPanel, (ProgressMonitor)mon);
                        if (res == 0) {
                            split.params = URISplit.formatParams(params);
                            AutoplotUI.this.dom.getController().getApplicationModel().addRecent(URISplit.format(split));
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
        catch (HtmlResponseIOException ex) {
            this.handleHtmlResponse(script, ex);
        }
        catch (IOException ex) {
            this.setMessage(WARNING_ICON, ex.getMessage());
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void reviewBookmark(String uri, final int modifiers) {
        final DataSetSelector sel = this.dataSetSelector;
        if (uri.contains(".vap")) {
            sel.setValue(uri);
            if (0 == AutoplotUtil.showConfirmDialog(this, "Use vap file " + uri + "?", "Use Bookmarked .vap File", 2)) {
                sel.setValue(uri);
                sel.maybePlot(modifiers);
            }
        } else if (uri.endsWith(".jy") || uri.contains(".jy?")) {
            sel.setValue(uri);
            sel.maybePlot(modifiers);
        } else {
            final String furi = uri;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    sel.setValue(furi);
                    DataSourceFactory factory = null;
                    try {
                        factory = DataSetURI.getDataSourceFactory(DataSetURI.getURI(furi), new NullProgressMonitor());
                    }
                    catch (IOException | IllegalArgumentException | URISyntaxException ex) {
                        Logger.getLogger(DelayMenu.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (factory == null) {
                        logger.fine("unable to find factory when I expected to see uri");
                        sel.setValue(furi);
                        sel.maybePlot(modifiers);
                    } else {
                        ArrayList<String> problems = new ArrayList<String>();
                        if (factory.reject(furi, problems, new NullProgressMonitor())) {
                            sel.maybePlot(8);
                        } else {
                            Runnable run = new Runnable(){

                                @Override
                                public void run() {
                                    AutoplotUI.this.support.addPlotElementFromBookmark("Add Bookmarked URI", furi);
                                }
                            };
                            SwingUtilities.invokeLater(run);
                        }
                    }
                }
            };
            new Thread(run).start();
        }
    }

    public TickleTimer getTickleTimer() {
        return this.tickleTimer;
    }

    public EditorTextPane getScriptPanel() {
        if (this.scriptPanel != null) {
            return this.scriptPanel.getEditorPanel();
        }
        return null;
    }
}

