/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.APSplash;
import org.autoplot.EventThreadResponseMonitor;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.DataSourceRegistry;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.jythonsupport.Util;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.util.ArgumentList;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.AbstractProgressMonitor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class AutoplotDataServer {
    private static final String DEFT_OUTFILE = "-";
    private static final String FORM_D2S = "d2s";
    private static final String FORM_QDS = "qds";
    private static final String FORM_HAPI_INFO = "hapi-info";
    private static final String FORM_HAPI_DATA = "hapi-data";
    private static final String FORM_HAPI_CSV = "hapi-csv";
    private static final String FORM_HAPI_DATA_BINARY = "hapi-data-binary";
    private static final String FORM_HAPI_BINARY = "hapi-binary";
    private static final Logger logger = LoggerManager.getLogger("autoplot.server");

    public static void doService(String timeRange, String suri, String step, boolean stream, String format, PrintStream out, boolean ascii, Set outEmpty, ProgressMonitor mon) throws Exception {
        long t0 = System.currentTimeMillis();
        boolean someValid = false;
        if (!timeRange.equals("")) {
            logger.fine("org.autoplot.jythonsupport.Util.getDataSet( suri,timeRange ):");
            logger.log(Level.FINE, "   suri={0}", suri);
            logger.log(Level.FINE, "   timeRange={0}", timeRange);
            DatumRange outer = DatumRangeUtil.parseTimeRange(timeRange);
            DataSource dss = DataSetURI.getDataSource(suri);
            TimeSeriesBrowse tsb = dss.getCapability(TimeSeriesBrowse.class);
            if (tsb != null && suri.contains("$H")) {
                step = "3600s";
            }
            Datum first = TimeUtil.prevMidnight(outer.min());
            Datum next = first.add(Units.seconds.parse(step));
            List<DatumRange> drs = stream && (format.equals(FORM_D2S) || format.equals(FORM_QDS) || format.equals(FORM_HAPI_DATA) || format.equals(FORM_HAPI_DATA_BINARY)) ? DatumRangeUtil.generateList(outer, new DatumRange(first, next)) : Collections.singletonList(outer);
            int i = 0;
            mon.setTaskSize(10 * drs.size());
            mon.setTaskProgress(5L);
            for (DatumRange dr : drs) {
                logger.log(Level.FINER, "time at read start read of {0}= {1}", new Object[]{dr.toString(), System.currentTimeMillis() - t0});
                logger.fine(String.format("getDataSet('%s','%s')", suri, dr));
                QDataSet ds1 = null;
                try {
                    ds1 = Util.getDataSet(suri, dr.toString(), (ProgressMonitor)SubTaskMonitor.create(mon, i * 10, (i + 1) * 10));
                }
                catch (NoDataInIntervalException ex) {
                    logger.log(Level.INFO, "no data trying to read " + dr, ex);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "exception when trying to read " + dr, ex);
                }
                logger.log(Level.FINE, "  --> {0} )", ds1);
                if (ds1 != null) {
                    if (!SemanticOps.isTimeSeries(ds1)) {
                        logger.fine(String.format("dataset doesn't appear to be a timeseries, reloading everything", new Object[0]));
                        ds1 = Util.getDataSet(suri, outer.toString(), (ProgressMonitor)SubTaskMonitor.create(mon, i * 10, (i + 1) * 10));
                        logger.log(Level.FINE, "  --> {0} )", ds1);
                        AutoplotDataServer.writeData(format, out, ds1, ascii, stream);
                        someValid = true;
                        break;
                    }
                    if (ds1.rank() == 1) {
                        QDataSet xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1));
                        logger.log(Level.FINE, "loaded ds={0}  bounds: {1}", new Object[]{ds1, xrange});
                        logger.log(Level.FINE, "time at read done read of {0}= {1}\n", new Object[]{dr.toString(), System.currentTimeMillis() - t0});
                    } else if (ds1.rank() == 2 || ds1.rank() == 3) {
                        QDataSet range = DataSetOps.dependBounds(ds1);
                        logger.log(Level.FINE, "loaded ds={0}  bounds: {1}", new Object[]{ds1, range});
                        logger.log(Level.FINE, "time at read done read of {0}= {1}\n", new Object[]{dr.toString(), System.currentTimeMillis() - t0});
                    }
                    AutoplotDataServer.writeData(format, out, ds1, ascii, stream);
                    outEmpty.add("out is no longer empty");
                    someValid = true;
                }
                mon.setTaskProgress(++i * 10);
                logger.log(Level.FINER, "time at write to output channel {0}= {1}\n", new Object[]{dr.toString(), System.currentTimeMillis() - t0});
            }
            mon.finished();
        } else {
            logger.fine("org.autoplot.jythonsupport.Util.getDataSet( suri ):");
            logger.log(Level.FINE, "   suri={0}\n", suri);
            QDataSet ds = Util.getDataSet(suri, mon);
            logger.log(Level.FINE, "loaded ds={0}", ds);
            if (ds != null) {
                AutoplotDataServer.writeData(format, out, ds, false, false);
                someValid = true;
            }
        }
        logger.log(Level.FINE, "time to read (ms): {0}", System.currentTimeMillis() - t0);
        if (!someValid) {
            switch (format) {
                case "d2s": {
                    String s;
                    if (!stream) {
                        s = "<stream><properties int:taskSize=\"00000010\" /></stream>";
                        out.printf(String.format("[00]%06d%s", s.length(), s), new Object[0]);
                    }
                    s = String.format("<exception type=\"NoDataInInterval\" message='%s'/>\n", "no data found in " + timeRange);
                    out.printf(String.format("[xx]%06d%s", s.length(), s), new Object[0]);
                    break;
                }
                case "qds": {
                    String s = String.format("<exception type=\"NoDataInInterval\" message='%s'/>\n", "no data found in " + timeRange);
                    out.printf(String.format("[xx]%06d%s", s.length(), s), new Object[0]);
                    break;
                }
            }
        }
    }

    public AutoplotDataServer() {
        throw new IllegalArgumentException("AutoplotDataServer should not be instantiated");
    }

    private static void formatD2S(QDataSet data, OutputStream fo, boolean ascii, boolean stream) {
        boolean binary;
        boolean bl = binary = !ascii;
        if (data.rank() == 3) {
            TableDataSet tds = TableDataSetAdapter.create(data);
            if (binary) {
                TableUtil.dumpToDas2Stream(tds, Channels.newChannel(fo), false, !stream);
            } else {
                TableUtil.dumpToDas2Stream(tds, Channels.newChannel(fo), true, !stream);
            }
        } else if (data.rank() == 2) {
            TableDataSet tds = TableDataSetAdapter.create(data);
            if (binary) {
                TableUtil.dumpToDas2Stream(tds, Channels.newChannel(fo), false, !stream);
            } else {
                TableUtil.dumpToDas2Stream(tds, Channels.newChannel(fo), true, !stream);
            }
        } else if (data.rank() == 1) {
            VectorDataSet vds = VectorDataSetAdapter.create(data);
            if (binary) {
                VectorUtil.dumpToDas2Stream(vds, Channels.newChannel(fo), false, !stream);
            } else {
                VectorUtil.dumpToDas2Stream(vds, Channels.newChannel(fo), true, !stream);
            }
        }
    }

    private static void writeData(String format, OutputStream out, QDataSet ds, boolean ascii, boolean stream) throws Exception {
        if (format.equals(FORM_D2S)) {
            AutoplotDataServer.formatD2S(ds, out, ascii, stream);
        } else if (format.equals(FORM_QDS)) {
            if (ds.property("DEPEND_1") != null && ds.property("BUNDLE_1") != null) {
                logger.info("dropping BUNDLE_1 when DEPEND_1 is present");
                ds = Ops.maybeCopy(ds);
                ((MutablePropertyDataSet)ds).putProperty("BUNDLE_1", null);
            }
            new SimpleStreamFormatter().format(ds, out, ascii);
        } else if (format.equals(FORM_HAPI_INFO)) {
            DataSourceFormat dsf = DataSourceRegistry.getInstance().getFormatByExt("hapi");
            File file = new File("/tmp/ap-hapi/foo.hapi");
            dsf.formatData(file.toString() + "?id=temp", ds, new NullProgressMonitor());
            File infoFile = new File("/tmp/ap-hapi/foo/info/temp.json");
            FileInputStream fin = new FileInputStream(infoFile);
            DataSourceUtil.transfer(fin, out);
        } else if (format.equals(FORM_HAPI_DATA_BINARY) || format.equals(FORM_HAPI_BINARY)) {
            DataSourceFormat dsf = DataSourceRegistry.getInstance().getFormatByExt("hapi");
            File file = new File("/tmp/ap-hapi/foo.hapi");
            dsf.formatData(file.toString() + "?id=temp&format=binary", ds, new NullProgressMonitor());
            File binaryFile = new File("/tmp/ap-hapi/foo/data/temp.binary");
            FileInputStream fin = new FileInputStream(binaryFile);
            DataSourceUtil.transfer(fin, out);
        } else if (format.equals(FORM_HAPI_DATA) || format.equals(FORM_HAPI_CSV)) {
            DataSourceFormat dsf = DataSourceRegistry.getInstance().getFormatByExt("hapi");
            File file = new File("/tmp/ap-hapi/foo.hapi");
            dsf.formatData(file.toString() + "?id=temp", ds, new NullProgressMonitor());
            File csvFile = new File("/tmp/ap-hapi/foo/data/temp.csv");
            FileInputStream fin = new FileInputStream(csvFile);
            DataSourceUtil.transfer(fin, out);
        } else if (format.equals("dat") || format.equals("xls") || format.equals("bin")) {
            File file = File.createTempFile("autoplotDataServer", "." + format);
            ScriptContext.formatDataSet(ds, file.toString());
            FileInputStream fin = new FileInputStream(file);
            DataSourceUtil.transfer(fin, out);
        } else {
            throw new IllegalAccessException("bad format: " + format);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean stream;
        System.err.println("org.autoplot.AutoplotDataServer 20160309 (Autoplot version " + APSplash.getVersion() + ")");
        ArgumentList alm = new ArgumentList("AutoplotDataServer");
        alm.addOptionalSwitchArgument("uri", "u", "uri", "", "URI to plot");
        alm.addOptionalSwitchArgument("format", "f", "format", "", "output format qds, d2s (default=d2s if no filename) which support streaming, or xls bin dat hapi-info hapi-csv hapi-binary");
        alm.addOptionalSwitchArgument("outfile", "o", "outfile", DEFT_OUTFILE, "output filename or -, extension implies format.");
        alm.addOptionalSwitchArgument("timeRange", "t", "timeRange", "", "timerange for TimeSeriesBrowse datasources");
        alm.addOptionalSwitchArgument("timeStep", "s", "timeStep", "86400s", "atom step size for loading and sending, default is 86400s");
        alm.addOptionalSwitchArgument("cache", "c", "cache", "", "location where files are downloaded, default is $HOME/autoplot_data/cache");
        alm.addBooleanSwitchArgument("nostream", "", "nostream", "disable streaming, as with Bill's dataset which is X and Y table");
        alm.addBooleanSwitchArgument("ascii", "a", "ascii", "request that ascii streams be sent instead of binary.");
        alm.addBooleanSwitchArgument("noexit", "z", "noexit", "don't exit after running, for use with scripts.");
        alm.addBooleanSwitchArgument("enableResponseMonitor", null, "enableResponseMonitor", "monitor the event thread for long unresponsive pauses");
        alm.requireOneOf(new String[]{"uri"});
        alm.process(args);
        alm.logPrefsSettings(logger);
        String suri = alm.getValue("uri");
        if (suri.startsWith("'") && suri.endsWith("'")) {
            suri = suri.substring(1, suri.length() - 1);
        }
        String timeRange = alm.getValue("timeRange");
        String step = alm.getValue("timeStep");
        boolean ascii = alm.getBooleanValue("ascii");
        boolean bl = stream = !alm.getBooleanValue("nostream");
        if (alm.getBooleanValue("enableResponseMonitor")) {
            EventThreadResponseMonitor emon = new EventThreadResponseMonitor();
            emon.start();
        }
        ScriptContext.getDocumentModel();
        String cache = alm.getValue("cache");
        if (!cache.equals("")) {
            File fcache = new File(cache);
            if (!fcache.exists() && !fcache.mkdirs()) {
                logger.log(Level.FINE, "unable to make dirs for cache={0}", fcache);
            }
            if (!fcache.canWrite()) {
                logger.log(Level.FINE, "unable to write to cache={0}", fcache);
            }
            File ff = new File(fcache, "testCache.empty");
            try (FileOutputStream fo = new FileOutputStream(ff);){
                fo.write("AutoplotDataServer is able to write a file\n".getBytes());
            }
            FileSystem.settings().setLocalCacheDir(new File(cache));
            logger.log(Level.FINE, "using cache dir {0}", FileSystem.settings().getLocalCacheDir());
        } else {
            logger.log(Level.FINE, "using default cache dir {0}", FileSystem.settings().getLocalCacheDir());
        }
        if (suri.equals("")) {
            alm.printUsage();
            logger.fine("uri must be specified.");
            if (!alm.getBooleanValue("noexit")) {
                System.exit(-1);
            } else {
                return;
            }
        }
        String format = alm.getValue("format");
        String outfile = alm.getValue("outfile");
        if (!(format.length() <= 0 || format.startsWith("hapi") || outfile.equals(DEFT_OUTFILE) || outfile.endsWith(format))) {
            System.err.println("format=" + format + " doesn't match outfile extension. outfile=" + outfile);
            if (!alm.getBooleanValue("noexit")) {
                System.exit(-2);
            } else {
                return;
            }
        }
        if (outfile.endsWith(".qds")) {
            format = FORM_QDS;
        } else if (outfile.endsWith(".d2s")) {
            format = FORM_D2S;
        } else if (outfile.contains(".")) {
            URISplit split = URISplit.parse(outfile);
            if (!format.startsWith("hapi") && (format = split.ext) == null) {
                split = URISplit.parse("file:///" + outfile);
                format = split.ext;
            }
        }
        if (format.length() == 0) {
            format = FORM_D2S;
        }
        if (format.startsWith(".")) {
            format = format.substring(1);
        }
        AbstractProgressMonitor mon = new NullProgressMonitor();
        HashSet outEmpty = new HashSet();
        PrintStream out = outfile.equals(DEFT_OUTFILE) ? System.out : new PrintStream(outfile);
        if (format.equals(FORM_D2S) && stream) {
            mon = new D2SMonitor(out, outEmpty);
        } else if (format.equals(FORM_QDS) && stream) {
            mon = new QStreamMonitor(out, outEmpty);
        } else {
            logger.fine("no progress available because output is not d2s stream");
        }
        AutoplotDataServer.doService(timeRange, suri, step, stream, format, out, ascii, outEmpty, mon);
        if (!alm.getBooleanValue("noexit")) {
            System.exit(0);
        }
    }

    private static class D2SMonitor
    extends AbstractProgressMonitor {
        PrintStream out;
        Set outEmpty;
        long lastUpdateTime = -1L;

        D2SMonitor(OutputStream out, Set outEmpty) {
            this.out = new PrintStream(out);
            this.outEmpty = outEmpty;
        }

        @Override
        public void setTaskSize(long taskSize) {
            String msg2 = String.format("[00]000056<stream><properties int:taskSize=\"%08d\" /></stream>\n", taskSize);
            this.out.print(msg2);
        }

        @Override
        public void setTaskProgress(long position) throws IllegalArgumentException {
            long tnow = System.currentTimeMillis();
            if (this.getTaskProgress() == position && tnow - this.lastUpdateTime < 10000L) {
                return;
            }
            this.lastUpdateTime = tnow;
            super.setTaskProgress(position);
            String msg = String.format("[xx]000059<comment type=\"taskProgress\" value=\"%08d\" source=\"\" />\n", position);
            if (this.outEmpty.isEmpty()) {
                return;
            }
            this.out.print(msg);
        }
    }

    private static class QStreamMonitor
    extends AbstractProgressMonitor {
        PrintStream out;
        Set outEmpty;
        long lastUpdateTime = -1L;

        QStreamMonitor(OutputStream out, Set outEmpty) {
            this.out = new PrintStream(out);
            this.outEmpty = outEmpty;
        }

        @Override
        public void setTaskSize(long taskSize) {
            super.setTaskSize(taskSize);
        }

        @Override
        public void setTaskProgress(long position) throws IllegalArgumentException {
            long tnow = System.currentTimeMillis();
            super.setTaskProgress(position);
            if (this.getTaskProgress() == position && tnow - this.lastUpdateTime < 1000L) {
                return;
            }
            this.lastUpdateTime = tnow;
            String comment = String.format("<comment type='taskProgress' message='%d of %d'/>\n", this.getTaskProgress(), this.getTaskSize());
            String msg = String.format("[xx]%06d%s", comment.length(), comment);
            if (this.outEmpty.isEmpty()) {
                return;
            }
            this.out.print(msg);
        }
    }
}

