/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.RenderType;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;

public class AutoRangeUtil {
    private static final Logger logger = LoggerManager.getLogger("qdataset.ops.autorange");

    private static void setRange(DDataSet range, DatumRange drange, boolean log) {
        range.putProperty("UNITS", drange.getUnits());
        range.putValue(0, drange.min().doubleValue(drange.getUnits()));
        range.putValue(1, drange.max().doubleValue(drange.getUnits()));
        if (log) {
            range.putProperty("SCALE_TYPE", "log");
        }
    }

    private static double[] simpleRange(QDataSet ds) {
        QDataSet delta;
        QDataSet max = ds;
        QDataSet min = ds;
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((delta = (QDataSet)ds.property("DELTA_PLUS")) != null) {
            max = Ops.add(ds, delta);
        } else {
            delta = (QDataSet)ds.property("BIN_PLUS");
            if (delta != null) {
                max = Ops.add(ds, delta);
            }
        }
        delta = (QDataSet)ds.property("DELTA_MINUS");
        if (delta != null) {
            min = Ops.subtract(ds, delta);
        } else {
            delta = (QDataSet)ds.property("BIN_MINUS");
            if (delta != null) {
                min = Ops.subtract(ds, delta);
            }
        }
        QDataSet wmin = DataSetUtil.weightsDataSet(min);
        QDataSet wmax = DataSetUtil.weightsDataSet(max);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        double[] result = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int i = 0;
        while (i < 10000000 && it.hasNext()) {
            double maxv;
            it.next();
            ++i;
            if (it.getValue(wds) == 0.0 || Double.isInfinite(maxv = it.getValue(max))) continue;
            if (it.getValue(wmin) > 0.0) {
                result[0] = Math.min(result[0], it.getValue(min));
            }
            if (!(it.getValue(wmax) > 0.0)) continue;
            result[1] = Math.max(result[1], maxv);
        }
        if (result[0] == Double.POSITIVE_INFINITY) {
            if (UnitsUtil.isTimeLocation(u)) {
                result[0] = Units.t2000.convertDoubleTo(u, 0.0);
                result[1] = Units.t2000.convertDoubleTo(u, 86400.0);
            } else {
                result[0] = 0.0;
                result[1] = 1.0;
            }
        }
        return result;
    }

    private static DatumRange getRange(Number min, Number max, Units units) {
        if (units != null && UnitsUtil.isTimeLocation(units)) {
            if (min == null) {
                min = Units.mj1958.convertDoubleTo(units, -100000.0);
            }
            if (max == null) {
                max = Units.mj1958.convertDoubleTo(units, 100000.0);
            }
        } else {
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            if (units == null) {
                units = Units.dimensionless;
            }
        }
        if (UnitsUtil.isTimeLocation(units)) {
            TimeLocationUnits tu = (TimeLocationUnits)units;
            if (!tu.isValid(min.doubleValue())) {
                min = tu.validMin();
            }
            if (!tu.isValid(max.doubleValue())) {
                max = tu.validMax();
            }
            return new DatumRange(min.doubleValue(), max.doubleValue(), units);
        }
        try {
            return new DatumRange(min.doubleValue(), max.doubleValue(), units);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("here here");
            throw ex;
        }
    }

    private static DatumRange makeDimensionless(DatumRange dr) {
        Units u = dr.getUnits();
        return new DatumRange(dr.min().doubleValue(u), dr.max().doubleValue(u), Units.dimensionless);
    }

    public static QDataSet bounds(QDataSet dataSet, RenderType renderType) throws Exception {
        AutoRangeDescriptor xdesc;
        DDataSet xrange = DDataSet.createRank1(2);
        DDataSet yrange = DDataSet.createRank1(2);
        DDataSet zrange = DDataSet.createRank1(2);
        JoinDataSet result = new JoinDataSet(2);
        result.join(xrange);
        result.join(yrange);
        result.join(zrange);
        HashMap props = new HashMap();
        if (renderType == RenderType.spectrogram || renderType == RenderType.nnSpectrogram) {
            QDataSet xds = (QDataSet)dataSet.property("DEPEND_0");
            if (xds == null) {
                if (dataSet.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < dataSet.length(); ++i) {
                        ds.join((QDataSet)dataSet.property("DEPEND_0", i));
                    }
                    xds = ds;
                } else {
                    xds = DataSetUtil.indexGenDataSet(dataSet.length());
                }
            }
            QDataSet yds = (QDataSet)dataSet.property("DEPEND_1");
            Map yprops = (Map)props.get("DEPEND_1");
            if (yds == null) {
                if (dataSet.property("JOIN_0") != null) {
                    JoinDataSet ds = new JoinDataSet(2);
                    for (int i = 0; i < dataSet.length(); ++i) {
                        ds.join((QDataSet)dataSet.property("DEPEND_1", i));
                    }
                    yds = ds;
                } else if (dataSet.rank() > 1) {
                    yds = DataSetUtil.indexGenDataSet(dataSet.length(0));
                } else {
                    yds = DataSetUtil.indexGenDataSet(10);
                    yprops = null;
                }
            }
            xdesc = AutoRangeUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            AutoRangeDescriptor ydesc = AutoRangeUtil.autoRange(yds, yprops);
            AutoRangeDescriptor desc = AutoRangeUtil.autoRange(dataSet, props);
            AutoRangeUtil.setRange(zrange, desc.range, desc.log);
            AutoRangeUtil.setRange(xrange, xdesc.range, xdesc.log);
            AutoRangeUtil.setRange(yrange, ydesc.range, ydesc.log);
        } else {
            QDataSet depend0;
            AutoRangeDescriptor ydesc;
            if (SemanticOps.isBundle(dataSet)) {
                ydesc = AutoRangeUtil.autoRange(DataSetOps.unbundle(dataSet, 1), props);
                depend0 = DataSetOps.unbundle(dataSet, 0);
            } else {
                ydesc = AutoRangeUtil.autoRange(dataSet, props);
                depend0 = (QDataSet)dataSet.property("DEPEND_0");
            }
            AutoRangeUtil.setRange(yrange, ydesc.range, ydesc.log);
            QDataSet xds = depend0;
            if (xds == null) {
                xds = DataSetUtil.indexGenDataSet(dataSet.length());
            }
            xdesc = AutoRangeUtil.autoRange(xds, (Map)props.get("DEPEND_0"));
            AutoRangeUtil.setRange(xrange, xdesc.range, xdesc.log);
            if (renderType == RenderType.colorScatter) {
                AutoRangeDescriptor zdesc;
                if (dataSet.property("BUNDLE_1") != null) {
                    zdesc = AutoRangeUtil.autoRange(DataSetOps.unbundle(dataSet, 2), null);
                } else {
                    QDataSet plane0 = (QDataSet)dataSet.property("PLANE_0");
                    zdesc = AutoRangeUtil.autoRange(plane0, (Map)props.get("PLANE_0"));
                }
                AutoRangeUtil.setRange(zrange, zdesc.range, zdesc.log);
            }
        }
        for (int i = 0; i < result.length(); ++i) {
            Units u = (Units)result.property("UNITS", i);
            if (u != null) {
                DatumRange dr = DatumRange.newDatumRange(result.value(i, 0), result.value(i, 1), u);
                logger.log(Level.FINER, "{0}: {1}", new Object[]{i, dr});
                continue;
            }
            logger.log(Level.FINER, "{0}: {1},{2}", new Object[]{i, result.value(i, 0), result.value(i, 1)});
        }
        return result;
    }

    public static AutoRangeDescriptor autoRange(QDataSet hist, QDataSet ds, Map properties) {
        double[] dd;
        Logger logger1 = LoggerManager.getLogger("qdataset.ops.autorange");
        logger1.log(Level.FINE, "enter autoRange {0}", ds);
        logger1.entering("org.virbo.autoplot.AutoplotUtil", "autoRange");
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        AutoRangeDescriptor result = new AutoRangeDescriptor();
        boolean mono = Boolean.TRUE.equals(ds.property("MONOTONIC")) || null != ds.property("CADENCE");
        long total = (Long)((Map)hist.property("USER_PROPERTIES")).get("total");
        double median = Double.NaN;
        if (mono) {
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(ds, null);
            if (cadence == null || cadence.value() > 1.7976931348623156E306) {
                cadence = DRank0DataSet.create(0.0);
            }
            if (ds.length() > 1) {
                double min = Math.min(ds.value(0), ds.value(ds.length() - 1));
                double max = Math.max(ds.value(0), ds.value(ds.length() - 1));
                double dcadence = Math.abs(cadence.value());
                if ("log".equals(cadence.property("SCALE_TYPE"))) {
                    Units cu = (Units)cadence.property("UNITS");
                    double factor = (cu.convertDoubleTo(Units.percentIncrease, dcadence) + 100.0) / 100.0;
                    dd = new double[]{min / factor, max * factor};
                } else {
                    dd = new double[]{min - dcadence, max + dcadence};
                }
            } else {
                dd = UnitsUtil.isTimeLocation(u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
            median = (dd[0] + dd[1]) / 2.0;
        } else {
            dd = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
            QDataSet dep0 = (QDataSet)hist.property("DEPEND_0");
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(dep0, null);
            int tot = 0;
            for (int i = 0; i < hist.length(); ++i) {
                tot = (int)((double)tot + hist.value(i));
                if (dd[0] == Double.NEGATIVE_INFINITY && hist.value(i) > 0.0) {
                    dd[0] = dep0.value(i);
                }
                if (hist.value(i) > 0.0) {
                    dd[1] = dep0.value(i) + cadence.value();
                }
                if ((long)tot < total / 2L) continue;
                median = dep0.value(i);
            }
        }
        if (total < 3L) {
            result.median = median;
            result.range = DatumRange.newDatumRange(dd[0], dd[1], u);
            result.robustMin = dd[0];
            result.robustMax = dd[1];
        } else {
            double clog;
            double nomMax;
            double nomMin;
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (mono) {
                nomMin = ds.value(0);
                nomMax = ds.value(ds.length() - 1);
            } else {
                nomMin = dd[0];
                nomMax = dd[1];
            }
            double clin = (nomMax - result.median) / (result.median - nomMin);
            if (clin > 1.0) {
                clin = 1.0 / clin;
            }
            if ((clog = nomMax / result.median / Math.abs(result.median / nomMin)) > 1.0) {
                clog = 1.0 / clog;
            }
            if (clog > clin && nomMax / nomMin > 100.0) {
                result.log = true;
            }
            result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
        }
        if ("log".equals(ds.property("SCALE_TYPE"))) {
            result.log = true;
        }
        if (properties != null) {
            String log1 = (String)properties.get("SCALE_TYPE");
            if (log1 != null) {
                result.log = log1.equals("log");
            }
            Number tmin = (Number)properties.get("TYPICAL_MIN");
            Number tmax = (Number)properties.get("TYPICAL_MAX");
            DatumRange range = AutoRangeUtil.getRange((Number)properties.get("TYPICAL_MIN"), (Number)properties.get("TYPICAL_MAX"), (Units)properties.get("UNITS"));
            if (tmin != null || tmax != null) {
                double d2;
                double d1;
                if (result.log) {
                    try {
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog(range, dd1);
                        d2 = DatumRangeUtil.normalizeLog(range, dd2);
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoRangeUtil.makeDimensionless(range);
                        result.range = AutoRangeUtil.makeDimensionless(result.range);
                        Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                        Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                        d1 = DatumRangeUtil.normalizeLog(range, dd1);
                        d2 = DatumRangeUtil.normalizeLog(range, dd2);
                    }
                } else {
                    try {
                        d1 = DatumRangeUtil.normalize(range, result.range.min());
                        d2 = DatumRangeUtil.normalize(range, result.range.max());
                    }
                    catch (InconvertibleUnitsException ex) {
                        range = AutoRangeUtil.makeDimensionless(range);
                        result.range = AutoRangeUtil.makeDimensionless(result.range);
                        d1 = DatumRangeUtil.normalize(range, result.range.min());
                        d2 = DatumRangeUtil.normalize(range, result.range.max());
                    }
                }
                if (d2 - d1 > 0.1 && d2 > 0.0 && d1 < 1.0) {
                    result.range = range;
                    logger1.exiting("org.virbo.autoplot.AutoplotUtil", "autoRange");
                    return result;
                }
            }
        }
        if (UnitsUtil.isRatioMeasurement(u) || UnitsUtil.isIntervalMeasurement(u)) {
            if (result.log) {
                if (result.robustMin <= 0.0) {
                    result.robustMin = result.robustMax / 1000.0;
                }
                result.range = DatumRange.newDatumRange(Math.pow(10.0, Math.floor(Math.log10(result.robustMin))), Math.pow(10.0, Math.ceil(Math.log10(result.robustMax))), u);
            } else {
                result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
                if (result.robustMin < result.robustMax) {
                    result.range = DatumRangeUtil.rescale(result.range, -0.05, 1.05);
                }
                if (result.robustMin == 0.0 && result.robustMax == 0.0) {
                    result.range = DatumRange.newDatumRange(-0.1, 1.0, u);
                }
            }
        } else {
            result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
        }
        logger1.exiting("org.virbo.autoplot.AutoplotUtil", "autoRange");
        return result;
    }

    public static AutoRangeDescriptor autoRange(QDataSet ds, Map properties) {
        return AutoRangeUtil.autoRange(ds, properties, false);
    }

    public static AutoRangeDescriptor autoRange(QDataSet ds, Map properties, boolean ignoreDsProps) {
        int total;
        double positiveMin;
        double median;
        double[] dd;
        boolean isLin;
        Logger logger1 = LoggerManager.getLogger("qdataset.ops.autorange");
        logger1.entering("org.virbo.autoplot.AutoplotUtil", "autoRange", ds);
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            if (ds.property("JOIN_0") != null) {
                if (ds.length() == 0) {
                    throw new IllegalArgumentException("dataset is empty");
                }
                u = (Units)ds.property("UNITS", 0);
            }
            if (u == null) {
                u = Units.dimensionless;
            }
        }
        AutoRangeDescriptor result = new AutoRangeDescriptor();
        if (UnitsUtil.isOrdinalMeasurement(u) || UnitsUtil.isNominalMeasurement(u)) {
            QDataSet ext = Ops.extent(ds);
            result.range = DataSetUtil.asDatumRange(ext, true);
            result.robustMin = result.range.min().doubleValue(u);
            result.robustMax = result.range.max().doubleValue(u);
            logger1.exiting("org.virbo.autoplot.AutoplotUtil", "autoRange", ds);
            return result;
        }
        boolean mono = Boolean.TRUE.equals(ds.property("MONOTONIC"));
        if (mono) {
            mono = DataSetUtil.isMonotonicAndIncreasingQuick(ds);
        }
        if (null != ds.property("CADENCE") && DataSetUtil.isMonotonic(ds)) {
            mono = true;
        }
        if (ds.rank() != 1) {
            mono = false;
        }
        AutoRangeDescriptor typical = null;
        boolean isLog = "log".equals(ds.property("SCALE_TYPE")) && !UnitsUtil.isTimeLocation(u);
        boolean bl = isLin = "linear".equals(ds.property("SCALE_TYPE")) || UnitsUtil.isTimeLocation(u);
        if (!ignoreDsProps) {
            Number typicalMin = (Number)ds.property("TYPICAL_MIN");
            Number typicalMax = (Number)ds.property("TYPICAL_MAX");
            if (typicalMin != null && typicalMax != null) {
                typical = new AutoRangeDescriptor();
                typical.range = new DatumRange(typicalMin.doubleValue(), typicalMax.doubleValue(), u);
                typical.log = isLog;
            }
        }
        if (properties != null && "log".equals(properties.get("SCALE_TYPE")) && !UnitsUtil.isTimeLocation(u)) {
            isLog = true;
        }
        if (typical == null && SemanticOps.isJoin(ds)) {
            result.range = null;
            result.robustMax = -1.7976931348623157E308;
            result.robustMin = Double.MAX_VALUE;
            Units units = null;
            UnitsConverter uc = UnitsConverter.IDENTITY;
            for (int i = 0; i < ds.length(); ++i) {
                AutoRangeDescriptor r1 = AutoRangeUtil.autoRange(ds.slice(i), properties, false);
                if (units == null) {
                    units = r1.range.getUnits();
                } else {
                    uc = r1.range.getUnits().getConverter(units);
                }
                DatumRange datumRange = result.range = result.range == null ? r1.range : DatumRangeUtil.union(result.range, r1.range);
                if (!r1.log) continue;
                result.log = true;
            }
            result.robustMin = result.range.min().doubleValue(result.range.getUnits());
            result.robustMax = result.range.max().doubleValue(result.range.getUnits());
            logger1.exiting("org.virbo.autoplot.AutoplotUtil", "autoRange", ds);
            return result;
        }
        if (mono && ds.rank() == 1) {
            RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(ds, null);
            QDataSet wds = DataSetUtil.weightsDataSet(ds);
            if (cadence == null || cadence.value() > 1.7976931348623156E306) {
                cadence = DRank0DataSet.create(0.0);
            }
            if (ds.length() > 1) {
                int lastValid;
                int firstValid;
                for (firstValid = 0; firstValid < wds.length() && wds.value(firstValid) == 0.0; ++firstValid) {
                }
                if (firstValid == wds.length()) {
                    throw new IllegalArgumentException("data contains no valid measurements");
                }
                for (lastValid = wds.length() - 1; lastValid >= 0 && wds.value(lastValid) == 0.0; --lastValid) {
                }
                if (lastValid - firstValid + 1 == 0) {
                    logger1.fine("special case where monotonic dataset contains no valid data");
                    dd = UnitsUtil.isTimeLocation(u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
                } else {
                    double min = Math.min(ds.value(firstValid), ds.value(lastValid));
                    double max = Math.max(ds.value(firstValid), ds.value(lastValid));
                    double dcadence = Math.abs(cadence.value());
                    if (isLog) {
                        Units cu = (Units)cadence.property("UNITS");
                        if (cu == null) {
                            cu = Units.dimensionless;
                        }
                        if (UnitsUtil.isRatiometric(cu)) {
                            double factor = (cu.convertDoubleTo(Units.percentIncrease, dcadence) + 100.0) / 100.0;
                            dd = new double[]{min / factor, max * factor};
                        } else if (cu.isConvertibleTo(u.getOffsetUnits())) {
                            dcadence = cu.convertDoubleTo(u.getOffsetUnits(), dcadence);
                            double[] dArray = new double[]{min - dcadence, max + dcadence};
                            dd = dArray;
                            if (dd[0] < 0.0) {
                                dd[0] = min / 2.0;
                            }
                        } else {
                            dd = new double[]{min, max};
                        }
                    } else {
                        dd = new double[]{min - dcadence, max + dcadence};
                        try {
                            logger1.log(Level.FINEST, "range of monotonic set by min to max, extended by cadence: {0}", DatumRange.newDatumRange(dd[0], dd[1], u));
                        }
                        catch (RuntimeException cu) {}
                    }
                }
            } else if (ds.length() == 1) {
                dd = AutoRangeUtil.simpleRange(ds);
                dd = UnitsUtil.isTimeLocation(u) ? new double[]{dd[0], dd[0] + Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{dd[0], dd[0] + 1.0};
            } else {
                dd = UnitsUtil.isTimeLocation(u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
        } else {
            try {
                dd = AutoRangeUtil.simpleRange(ds);
                logger1.log(Level.FINEST, "simpleRange(ds)= {0} - {1}", new Object[]{dd[0], dd[1]});
                if (Units.dimensionless.isFill(dd[0])) {
                    dd[0] = dd[0] / 100.0;
                }
                if (Units.dimensionless.isFill(dd[1])) {
                    dd[1] = dd[1] / 100.0;
                }
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                dd = UnitsUtil.isTimeLocation(u) ? new double[]{0.0, Units.days.createDatum(1).doubleValue(u.getOffsetUnits())} : new double[]{0.0, 1.0};
            }
        }
        if (UnitsUtil.isTimeLocation(u) && dd[0] == dd[1]) {
            if (dd[0] <= -1.0E29) {
                throw new IllegalArgumentException("timetags are all invalid ");
            }
            Units du = u.getOffsetUnits();
            double d = Units.days.convertDoubleTo(du, 1.0);
            dd[0] = Math.floor(dd[0] / d) * d;
            dd[1] = dd[0] + d;
        }
        boolean isHist = false;
        if (dd[0] == dd[1]) {
            if (dd[0] == 0.0) {
                dd[0] = -1.0;
                dd[1] = 1.0;
            } else if (dd[0] > 0.0) {
                dd[0] = 0.0;
            } else {
                dd[1] = 0.0;
            }
            median = (dd[0] + dd[1]) / 2.0;
            positiveMin = dd[0] + (dd[1] - dd[0]) * 0.1;
            total = ds.length();
        } else {
            isHist = "stairSteps".equals(ds.property("RENDER_TYPE"));
            double binSize = (dd[1] - dd[0]) * 0.01;
            QDataSet hist = DataSetOps.histogram(ds, dd[0] - binSize / 2.0, dd[1] + binSize / 2.0, (dd[1] - dd[0]) / 100.0);
            positiveMin = (Double)hist.property("positiveMin");
            total = 0;
            for (int i = 0; i < hist.length(); ++i) {
                total = (int)((double)total + hist.value(i));
            }
            median = u.getFillDouble();
            int total50 = 0;
            for (int i = 0; i < hist.length(); ++i) {
                if ((total50 = (int)((double)total50 + hist.value(i))) < total / 2) continue;
                median = ((QDataSet)hist.property("DEPEND_0")).value(i);
                break;
            }
        }
        if (total < 3) {
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (UnitsUtil.isTimeLocation(u)) {
                double dmin = TimeUtil.createTimeDatum(1000, 1, 1, 0, 0, 0, 0).doubleValue(u);
                double dmax = TimeUtil.createTimeDatum(9000, 1, 1, 0, 0, 0, 0).doubleValue(u);
                if (result.robustMin > dmax) {
                    result.robustMin = dmax;
                }
                if (result.robustMin < dmin) {
                    result.robustMin = dmin;
                }
                if (result.robustMax > dmax) {
                    result.robustMax = dmax;
                }
                if (result.robustMax < dmin) {
                    result.robustMax = dmin;
                }
            }
            result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
        } else {
            double nomMax;
            double nomMin;
            result.median = median;
            result.robustMin = dd[0];
            result.robustMax = dd[1];
            if (mono) {
                nomMin = ds.value(0);
                nomMax = ds.value(ds.length() - 1);
            } else {
                nomMin = dd[0];
                nomMax = dd[1];
            }
            double clin = (nomMax - result.median) / (result.median - nomMin);
            if (clin > 1.0) {
                clin = 1.0 / clin;
            }
            if (!isLin && result.median > 0.0 && !UnitsUtil.isTimeLocation(u)) {
                double clog = nomMax / result.median / Math.abs(result.median / nomMin);
                if (clog > 1.0) {
                    clog = 1.0 / clog;
                }
                if (clog > clin && nomMax / nomMin > 100.0) {
                    isLog = true;
                }
            }
            if (!isLin && !isHist && result.median == 0.0 && nomMin == 0.0 && nomMax / positiveMin > 1000.0) {
                isLog = true;
                result.robustMin = positiveMin / 10.0;
            }
            if (UnitsUtil.isTimeLocation(u)) {
                double dmin = TimeUtil.createTimeDatum(1000, 1, 1, 0, 0, 0, 0).doubleValue(u);
                double dmax = TimeUtil.createTimeDatum(9000, 1, 1, 0, 0, 0, 0).doubleValue(u);
                if (result.robustMin > dmax) {
                    result.robustMin = dmax;
                }
                if (result.robustMin < dmin) {
                    result.robustMin = dmin;
                }
                if (result.robustMax > dmax) {
                    result.robustMax = dmax;
                }
                if (result.robustMax < dmin) {
                    result.robustMax = dmin;
                }
            }
            result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
        }
        result.log = isLog;
        if (properties != null) {
            Number tmin = (Number)properties.get("TYPICAL_MIN");
            Number tmax = (Number)properties.get("TYPICAL_MAX");
            Units uu = (Units)properties.get("UNITS");
            if (uu == null) {
                uu = Units.dimensionless;
            }
            if (UnitsUtil.isTimeLocation(u)) {
                uu = u;
            }
            if (UnitsUtil.isIntervalOrRatioMeasurement(uu)) {
                Datum ftmin = uu.createDatum(tmin == null ? (Number)-1.7976931348623157E308 : (Number)tmin);
                if (isLog && tmin != null && tmin.doubleValue() <= 0.0) {
                    tmin = tmax.doubleValue() / 10000.0;
                }
                DatumRange range = AutoRangeUtil.getRange(tmin, tmax, uu);
                if (tmin != null && tmax != null) {
                    double d2;
                    double d1;
                    if (result.log) {
                        if (ftmin.doubleValue(uu) <= 0.0) {
                            ftmin = uu.createDatum(1.0E-38);
                        }
                        Datum limit = ftmin;
                        try {
                            Datum dd1 = result.range.min().ge(limit) ? result.range.min() : limit;
                            Datum dd2 = result.range.max().ge(limit) ? result.range.max() : limit;
                            d1 = DatumRangeUtil.normalizeLog(range, dd1);
                            d2 = DatumRangeUtil.normalizeLog(range, dd2);
                        }
                        catch (InconvertibleUnitsException ex) {
                            range = AutoRangeUtil.makeDimensionless(range);
                            result.range = AutoRangeUtil.makeDimensionless(result.range);
                            Datum dd1 = result.range.min().ge(range.min()) ? result.range.min() : range.min();
                            Datum dd2 = result.range.max().ge(range.min()) ? result.range.max() : range.min();
                            d1 = DatumRangeUtil.normalizeLog(range, dd1);
                            d2 = DatumRangeUtil.normalizeLog(range, dd2);
                        }
                        if (d2 > 1.2 && d2 < 2.0) {
                            logger1.log(Level.FINE, "TYPICAL_MAX rejected because max ({0}) outside the value of TYPICAL range ({1})", new Object[]{result.range.max(), range});
                            range = DatumRangeUtil.rescaleLog(range, 0.0, 1.333);
                            DatumRange range2 = DatumRangeUtil.rescaleLog(range, 0.0, 2.0);
                            d2 /= 1.333;
                            d1 /= 1.333;
                            logger1.fine("adjusting TYPICAL_MAX from metadata, multiply by 1.2");
                            if (d2 > 1.2 && d2 < 2.0) {
                                range = range2;
                                d2 = d2 * 1.333 / 2.0;
                                d1 = d1 * 1.333 / 2.0;
                                logger1.fine("adjusting TYPICAL_MAX from metadata, multiply by 2.0");
                            }
                        }
                        if (d1 < -4.0 && d2 > 0.0) {
                            logger1.fine("rejecting statistical range because min is too small.");
                            result.range = range;
                            result.robustMin = range.min().doubleValue(result.range.getUnits());
                            result.robustMax = range.max().doubleValue(result.range.getUnits());
                            d1 = 0.0;
                            d2 = 1.0;
                        }
                    } else {
                        try {
                            d1 = DatumRangeUtil.normalize(range, result.range.min());
                            d2 = DatumRangeUtil.normalize(range, result.range.max());
                        }
                        catch (InconvertibleUnitsException ex) {
                            range = AutoRangeUtil.makeDimensionless(range);
                            result.range = AutoRangeUtil.makeDimensionless(result.range);
                            d1 = DatumRangeUtil.normalize(range, result.range.min());
                            d2 = DatumRangeUtil.normalize(range, result.range.max());
                        }
                        if (d2 > 1.2 && d2 < 2.0) {
                            range = DatumRangeUtil.rescale(range, 0.0, 2.0);
                            d2 /= 2.0;
                            d1 /= 2.0;
                            logger1.fine("adjusting TYPICAL_MAX from metadata, multiply by 2.0");
                        }
                    }
                    if (d2 - d1 > 0.1 && d2 > 0.0 && d2 < 1.14 && d1 > -0.1 && d1 < 1.0 && uu.isConvertibleTo(u)) {
                        result.range = range;
                        logger1.fine("using TYPICAL_MIN, TYPICAL_MAX from metadata");
                        logger1.exiting("org.virbo.autoplot.AutoplotUtil", "autoRange", ds);
                        return result;
                    }
                    logger1.log(Level.FINE, "TYPICAL_MIN={0} and TYPICAL_MAX={1} from metadata rejected because it clipped or squished the data {2}", new Object[]{tmin.toString(), tmax.toString(), result.range});
                }
            }
        }
        if (UnitsUtil.isIntervalOrRatioMeasurement(u)) {
            if (result.log) {
                if (result.robustMax <= 0.0 || Double.isNaN(result.robustMax)) {
                    result.robustMax = 1000.0;
                }
                if (result.robustMin <= 0.0 || Double.isNaN(result.robustMin)) {
                    result.robustMin = result.robustMax / 1000.0;
                }
                Datum min = u.createDatum(result.robustMin);
                Datum max = u.createDatum(result.robustMax);
                DomainDivider div = DomainDividerUtil.getDomainDivider(min, max, true);
                while (div.boundaryCount(min, max) > 40L) {
                    div = div.coarserDivider(false);
                }
                while (div.boundaryCount(min, max) < 20L) {
                    div = div.finerDivider(true);
                }
                result.range = new DatumRange(div.rangeContaining(min).min(), div.rangeContaining(max).max());
            } else if (UnitsUtil.isTimeLocation(u)) {
                if (result.range.min().doubleValue(Units.us2000) > -6.311348E15) {
                    if (result.range.width().value() == 0.0) {
                        result.range = new DatumRange(result.range.min(), result.range.min().add(Units.seconds.createDatum(1)));
                    } else {
                        DomainDivider div = DomainDividerUtil.getDomainDivider(result.range.min(), result.range.max());
                        while (div.boundaryCount(result.range.min(), result.range.max()) > 40L) {
                            div = div.coarserDivider(false);
                        }
                        while (div.boundaryCount(result.range.min(), result.range.max()) < 20L) {
                            div = div.finerDivider(true);
                        }
                        result.range = new DatumRange(div.rangeContaining(result.range.min()).min(), div.rangeContaining(result.range.max()).max());
                    }
                }
            } else {
                result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
                if (result.robustMin < result.robustMax) {
                    result.range = DatumRangeUtil.rescale(result.range, -0.05, 1.05);
                }
                if (result.robustMin == 0.0 && result.robustMax == 0.0) {
                    result.range = DatumRange.newDatumRange(-0.1, 1.0, u);
                }
            }
        } else {
            result.range = DatumRange.newDatumRange(result.robustMin, result.robustMax, u);
        }
        logger1.exiting("org.virbo.autoplot.AutoplotUtil", "autoRange", ds);
        if (typical != null) {
            double overlap;
            if (result.log && typical.log) {
                double overlap2;
                if (typical.range.min().doubleValue(typical.range.getUnits()) <= 0.0) {
                    typical.range = new DatumRange(result.range.min(), typical.range.max());
                }
                if (result.range.intersects(typical.range) && (overlap2 = DatumRangeUtil.normalizeLog(result.range, typical.range.max()) - DatumRangeUtil.normalizeLog(result.range, typical.range.min())) > 0.01 && overlap2 < 100.0) {
                    return typical;
                }
            } else if (!typical.log && result.range.intersects(typical.range) && (overlap = DatumRangeUtil.normalize(result.range, typical.range.max()) - DatumRangeUtil.normalize(result.range, typical.range.min())) > 0.01 && overlap < 100.0) {
                return typical;
            }
        }
        return result;
    }

    public static class AutoRangeDescriptor {
        public DatumRange range;
        public boolean log;
        private double robustMin;
        private double robustMax;
        private double median;

        public String toString() {
            return "" + this.range + " " + (this.log ? "log" : "");
        }
    }
}

