/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.autoplot.AutoplotUI;
import org.autoplot.GuiSupport;
import org.autoplot.ScriptContext;
import org.das2.util.LoggerManager;

public class AppManager {
    private static Logger logger = LoggerManager.getLogger("autoplot.appmanager");
    private static AppManager instance;
    List<Object> apps = new ArrayList<Object>();
    HashMap<Object, Map<String, CloseCallback>> appCloseCallbacks = new LinkedHashMap<Object, Map<String, CloseCallback>>();

    public static synchronized AppManager getInstance() {
        if (instance == null) {
            instance = new AppManager();
        }
        return instance;
    }

    public void addApplication(Object app) {
        this.apps.add(app);
        if (app instanceof JFrame) {
            ((JFrame)app).setDefaultCloseOperation(0);
        }
    }

    public synchronized boolean isRunningApplication(Object app) {
        for (Object o : this.apps) {
            if (o != app) continue;
            return true;
        }
        return false;
    }

    public void closeApplication(Object app) {
        if (app instanceof AutoplotUI) {
            boolean resetMain = false;
            if (ScriptContext.getViewWindow() == null) {
                resetMain = true;
            }
            if (this.requestClose(app)) {
                this.appCloseCallbacks.remove(app);
                this.apps.remove(app);
                if (this.apps.isEmpty()) {
                    this.quit();
                }
            }
            if (resetMain) {
                for (Object o : this.apps) {
                    if (!(o instanceof AutoplotUI)) continue;
                    ScriptContext.setView((AutoplotUI)o);
                    ScriptContext.setApplicationModel(((AutoplotUI)o).applicationModel);
                }
            }
        } else {
            this.apps.remove(app);
            if (this.apps.size() == 1 && this.apps.get(0) instanceof JFrame && !((JFrame)this.apps.get(0)).isVisible()) {
                this.apps.clear();
            }
            if (this.apps.isEmpty()) {
                this.quit();
            }
        }
    }

    public Object getApplication(int i) {
        return this.apps.get(i);
    }

    public void quit() {
        System.exit(0);
    }

    public void quit(int status) {
        System.exit(status);
    }

    public boolean requestQuit() {
        boolean okay = true;
        for (Map.Entry<Object, Map<String, CloseCallback>> closeCallbacks : this.appCloseCallbacks.entrySet()) {
            Object app = closeCallbacks.getKey();
            okay = okay && this.requestClose(app);
        }
        return okay;
    }

    public boolean requestClose(Object app) {
        boolean okay = true;
        Map<String, CloseCallback> closeCallbacks = this.appCloseCallbacks.get(app);
        if (closeCallbacks == null) {
            return true;
        }
        for (Map.Entry<String, CloseCallback> ent : closeCallbacks.entrySet()) {
            try {
                if (app instanceof Frame) {
                    GuiSupport.raiseApplicationWindow((Frame)app);
                }
                okay = okay && ent.getValue().checkClose();
            }
            catch (Exception e) {
                Object parent;
                Object object = parent = this.apps.size() > 0 ? this.apps.get(0) : null;
                if (!(parent instanceof Component)) {
                    parent = null;
                }
                JOptionPane.showMessageDialog((Component)parent, String.format("<html>Unable to call closeCallback id=\"%s\",<br>because of exception:<br>%s", ent.getKey(), e));
            }
        }
        return okay;
    }

    public WindowListener getWindowListener(final Object app, final Action closeAction) {
        return new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                boolean okay = AppManager.this.requestClose(app);
                if (!okay) {
                    return;
                }
                AppManager.this.appCloseCallbacks.remove(app);
                if (closeAction != null) {
                    closeAction.actionPerformed(new ActionEvent(this, e.getID(), "close"));
                }
                e.getWindow().dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AppManager.this.closeApplication(app);
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        };
    }

    public WindowListener getWindowListener(Object app) {
        return this.getWindowListener(app, null);
    }

    public int getApplicationCount() {
        return this.apps.size();
    }

    public synchronized void addCloseCallback(Object app, String id, CloseCallback c) {
        Map<String, CloseCallback> appCallbacks = this.appCloseCallbacks.get(id);
        if (appCallbacks == null) {
            appCallbacks = new LinkedHashMap<String, CloseCallback>();
        }
        appCallbacks.put(id, c);
        this.appCloseCallbacks.put(app, appCallbacks);
    }

    public static interface CloseCallback {
        public boolean checkClose();
    }
}

