/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.MessageHandler;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.autoplot.AutoplotUI;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.FileSystemUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;

public class AddSampListener {
    private static final Logger logger = LoggerManager.getLogger("autoplot.samp");
    private static final Map<Integer, AbstractMessageHandler> listeners = new HashMap<Integer, AbstractMessageHandler>();
    private static GuiHubConnector hubConnector;

    private static synchronized void maybePlot(DataSetSelector sel, String uri) {
        sel.setValue(uri);
        final DataSetSelector fsel = sel;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                fsel.maybePlot(8);
            }
        };
        try {
            SwingUtilities.invokeAndWait(run);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static synchronized void addSampListener(AutoplotUI app) {
        DataSetSelector sel = app.getDataSetSelector();
        AddSampListener.addSampListener(sel);
    }

    public static synchronized HubConnector getHubConnector() {
        return hubConnector;
    }

    public static synchronized void addSampListener(DataSetSelector sel) {
        AbstractMessageHandler l = listeners.get(sel.hashCode());
        if (listeners.size() > 0) {
            logger.info("handler is already running.");
            return;
        }
        logger.info("starting up SAMP listener");
        StandardClientProfile profile = StandardClientProfile.getInstance();
        if (!profile.isHubRunning()) {
            try {
                logger.info("starting SAMP hub...");
                Hub.runMain((String[])new String[0]);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, "error when starting hub");
                logger.log(Level.SEVERE, null, ex);
            }
        } else {
            logger.info("Client is already running.");
        }
        hubConnector = new GuiHubConnector((ClientProfile)profile);
        hubConnector.setAutoconnect(3);
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            JComponent cc = hubConnector.createMonitorPanel();
            ScriptContext.addTab("samp", cc);
        }
        Metadata meta = new Metadata();
        meta.setName("Autoplot");
        meta.setDescriptionText("Autoplot");
        meta.setIconUrl("http://autoplot.org/wiki/images/logo32.png");
        meta.setDocumentationUrl("http://autoplot.org");
        hubConnector.declareMetadata((Map)meta);
        listeners.put(sel.hashCode(), l);
        class ConcreteMessageReceiver
        extends AbstractMessageHandler {
            String mType;
            boolean isFileResource;
            final /* synthetic */ DataSetSelector val$sel;

            ConcreteMessageReceiver(String string) {
                this.val$sel = string;
                super((String)mType);
                this.mType = mType;
                this.isFileResource = !mType.equals("table.load.das2");
            }

            public Map processCall(HubConnection connection, String senderId, Message message) {
                String ext;
                logger.log(Level.FINE, "got message: {0}", message.toString());
                logger.log(Level.FINER, "handling as file resource: {0}", this.isFileResource);
                String s = (String)message.getParam("url");
                String n = (String)message.getParam("name");
                if (n != null && n.endsWith(" table")) {
                    n = n.substring(0, n.length() - 6).trim();
                }
                if (s.startsWith("file://")) {
                    if (s.startsWith("file://localhost")) {
                        s = s.substring(16);
                    }
                    if (s.startsWith("file://")) {
                        s = s.substring(7);
                    }
                } else {
                    try {
                        if (this.isFileResource && !FileSystemUtil.hasParent(new URL(s))) {
                            try {
                                File nnfile;
                                logger.log(Level.FINER, "downloading file {0}", s);
                                File file = DataSetURI.downloadResourceAsTempFile(new URL(s), new NullProgressMonitor());
                                String s1 = file.getAbsolutePath();
                                if (n != null) {
                                    int i1 = s1.lastIndexOf("/");
                                    nnfile = new File(s1.substring(0, i1) + "/" + n);
                                } else {
                                    int i1 = s1.lastIndexOf("@");
                                    nnfile = new File(s1.substring(0, i1));
                                }
                                if (!file.renameTo(nnfile)) {
                                    logger.log(Level.WARNING, "unable to rename resource: {0}", file);
                                }
                                if (n != null) {
                                    // empty if block
                                }
                                s = nnfile.toURI().toASCIIString();
                            }
                            catch (MalformedURLException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                            catch (IOException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    catch (MalformedURLException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                String string = ext = s.endsWith(".cdf") ? "cdf" : null;
                if ("cdf".equals(ext) || this.mType.equals("table.load.cdf")) {
                    AddSampListener.maybePlot(this.val$sel, "vap+cdf:" + s);
                } else if (this.mType.equals("table.load.das2")) {
                    AddSampListener.maybePlot(this.val$sel, "vap+das2server:" + s);
                } else if (this.mType.equals("image.load.fits")) {
                    AddSampListener.maybePlot(this.val$sel, "vap+fits:" + s);
                } else if (this.mType.equals("table.load.fits")) {
                    AddSampListener.maybePlot(this.val$sel, "vap+fits:" + s);
                }
                return null;
            }
        }
        ConcreteMessageReceiver messageHandler = new ConcreteMessageReceiver("image.load.fits", sel);
        hubConnector.addMessageHandler((MessageHandler)messageHandler);
        messageHandler = new ConcreteMessageReceiver("table.load.fits", sel);
        hubConnector.addMessageHandler((MessageHandler)messageHandler);
        messageHandler = new ConcreteMessageReceiver("table.load.cdf", sel);
        hubConnector.addMessageHandler((MessageHandler)messageHandler);
        messageHandler = new ConcreteMessageReceiver("table.load.das2", sel);
        hubConnector.addMessageHandler((MessageHandler)messageHandler);
        hubConnector.declareSubscriptions((Map)hubConnector.computeSubscriptions());
    }
}

