/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.autoplot.AutoplotUI;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.datasource.DataSetSelector;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class AddPlotElementDialog
extends JDialog {
    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";
    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";
    private JButton cancelButton;
    private JCheckBox doShowAdditionalFiltersCB;
    private JLabel jLabel1;
    private JLabel messagesLabel;
    private JButton overplotButton;
    private JButton plotBelowButton;
    private JButton plotButton;
    private DataSetSelector primaryDataSetSelector;
    private JCheckBox primaryFiltersCB;
    private JComboBox<String> primaryFiltersComboBox;
    private JCheckBox secondaryCheckBox;
    private DataSetSelector secondaryDataSetSelector;
    private JCheckBox secondaryFiltersCB;
    private JComboBox<String> secondaryFiltersComboBox;
    private JCheckBox tertiaryCheckBox;
    private DataSetSelector tertiaryDataSetSelector;
    private JCheckBox tertiaryFiltersCB;
    private JComboBox<String> tertiaryFiltersComboBox;
    private BindingGroup bindingGroup;

    public AddPlotElementDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.messagesLabel.setVisible(false);
        this.invalidate();
        this.setLocationRelativeTo(parent);
        this.secondaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryCheckBox.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected() && this.tertiaryCheckBox.isSelected());
        this.addAdditionalVisibleListener(null, this.primaryFiltersCB, this.primaryFiltersComboBox);
        this.addAdditionalVisibleListener(this.secondaryCheckBox, this.secondaryFiltersCB, this.secondaryFiltersComboBox);
        this.addAdditionalVisibleListener(this.tertiaryCheckBox, this.tertiaryFiltersCB, this.tertiaryFiltersComboBox);
        this.secondaryFiltersCB.setVisible(this.secondaryDataSetSelector.isVisible());
        if (parent instanceof AutoplotUI) {
            DataSetSelector source = null;
            source = ((AutoplotUI)parent).getDataSetSelector();
            this.primaryDataSetSelector.setTimeRange(source.getTimeRange());
            this.secondaryDataSetSelector.setTimeRange(source.getTimeRange());
            this.tertiaryDataSetSelector.setTimeRange(source.getTimeRange());
        }
        ImageIcon bookmarkIcon = new ImageIcon(this.getClass().getResource("/resources/purplebookmark.png"));
        this.primaryDataSetSelector.replacePlayButton(bookmarkIcon, new AbstractAction("bookmarks"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPlotElementDialog.this.doBookmarks(AddPlotElementDialog.this.primaryDataSetSelector);
            }
        });
        this.secondaryDataSetSelector.replacePlayButton(bookmarkIcon, new AbstractAction("bookmarks"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPlotElementDialog.this.doBookmarks(AddPlotElementDialog.this.secondaryDataSetSelector);
            }
        });
        this.tertiaryDataSetSelector.replacePlayButton(bookmarkIcon, new AbstractAction("bookmarks"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPlotElementDialog.this.doBookmarks(AddPlotElementDialog.this.tertiaryDataSetSelector);
            }
        });
    }

    public void setMessagesLabelText(String text) {
        if (text == null || text.trim().length() == 0) {
            this.messagesLabel.setVisible(false);
        } else {
            this.messagesLabel.setText(text);
            this.messagesLabel.setVisible(true);
        }
        this.revalidate();
    }

    private void addAdditionalVisibleListener(final JCheckBox enabled, final JCheckBox useFilters, final JComboBox filtersCB) {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPlotElementDialog.this.doUpdateAdditionalVisible(enabled, useFilters, filtersCB);
            }
        };
        if (enabled != null) {
            enabled.addActionListener(al);
        }
        this.doShowAdditionalFiltersCB.addActionListener(al);
        this.doUpdateAdditionalVisible(enabled, useFilters, filtersCB);
    }

    private void doUpdateAdditionalVisible(JCheckBox enabled, JCheckBox useFilters, JComboBox filtersCB) {
        boolean v = (enabled == null || enabled.isSelected()) && this.doShowAdditionalFiltersCB.isSelected();
        useFilters.setVisible(v);
        filtersCB.setVisible(v);
    }

    private void doBookmarks(DataSetSelector sel) {
        BookmarksManager man = new BookmarksManager((Frame)SwingUtilities.getWindowAncestor(this), true, "Bookmarks");
        man.setHidePlotButtons(true);
        man.setPrefNode("bookmarks", "autoplot.default.bookmarks", "http://autoplot.org/data/bookmarks.xml");
        man.setVisible(true);
        Bookmark book = man.getSelectedBookmark();
        if (book != null) {
            sel.setValue(((Bookmark.Item)book).getUri());
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.primaryDataSetSelector = new DataSetSelector();
        this.secondaryCheckBox = new JCheckBox();
        this.secondaryDataSetSelector = new DataSetSelector();
        this.tertiaryCheckBox = new JCheckBox();
        this.tertiaryDataSetSelector = new DataSetSelector();
        this.overplotButton = new JButton();
        this.plotBelowButton = new JButton();
        this.plotButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.primaryFiltersCB = new JCheckBox();
        this.primaryFiltersComboBox = new JComboBox();
        this.secondaryFiltersComboBox = new JComboBox();
        this.secondaryFiltersCB = new JCheckBox();
        this.tertiaryFiltersComboBox = new JComboBox();
        this.tertiaryFiltersCB = new JCheckBox();
        this.doShowAdditionalFiltersCB = new JCheckBox();
        this.messagesLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setName("addPlotElementDialog");
        this.secondaryCheckBox.setText("Plot Against (X):");
        this.secondaryCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.secondaryCheckBoxActionPerformed(evt);
            }
        });
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.secondaryCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.secondaryDataSetSelector, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.tertiaryCheckBox.setText("And Against (Y):");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.secondaryCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.tertiaryCheckBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.tertiaryCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.tertiaryCheckBoxActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tertiaryCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.tertiaryDataSetSelector, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.overplotButton.setText("Overplot");
        this.overplotButton.setToolTipText("Add this to the current plot as an overplot");
        this.overplotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.overplotButtonActionPerformed(evt);
            }
        });
        this.plotBelowButton.setText("Plot Below");
        this.plotBelowButton.setToolTipText("Plot below the current plot, possibly inserting a plot.  Holding shift will plot above.");
        this.plotBelowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.plotBelowButtonActionPerformed(evt);
            }
        });
        this.plotButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/go.png")));
        this.plotButton.setText("Plot");
        this.plotButton.setToolTipText("Replace the current plot with this");
        this.plotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.plotButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPlotElementDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Plot the Data Set URI:");
        this.primaryFiltersCB.setText("Additional Operations: ");
        this.primaryFiltersComboBox.setEditable(true);
        this.primaryFiltersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.primaryFiltersCB, (Property)ELProperty.create((String)"${selected}"), this.primaryFiltersComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.secondaryFiltersComboBox.setEditable(true);
        this.secondaryFiltersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.secondaryFiltersCB, (Property)ELProperty.create((String)"${selected}"), this.secondaryFiltersComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.secondaryFiltersCB.setText("Additional Operations: ");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.secondaryCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.secondaryFiltersCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.tertiaryFiltersComboBox.setEditable(true);
        this.tertiaryFiltersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" "}));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tertiaryFiltersCB, (Property)ELProperty.create((String)"${selected}"), this.tertiaryFiltersComboBox, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.tertiaryFiltersCB.setText("Additional Operations: ");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tertiaryCheckBox, (Property)ELProperty.create((String)"${selected}"), (Object)this.tertiaryFiltersCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.doShowAdditionalFiltersCB.setText("Show \"Additional Operations\" fields, where filters can be applied immediately after loading.");
        this.doShowAdditionalFiltersCB.setName("showAdditionalOperations");
        this.messagesLabel.setText("messages");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.primaryDataSetSelector, -1, 678, Short.MAX_VALUE).add((Component)this.secondaryDataSetSelector, -2, 0, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -1, 503, Short.MAX_VALUE).add(175, 175, 175)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.overplotButton).addPreferredGap(0).add((Component)this.plotBelowButton).addPreferredGap(0).add((Component)this.plotButton, -2, 96, -2)).add((Component)this.tertiaryDataSetSelector, -2, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.secondaryFiltersCB).addPreferredGap(0).add(this.secondaryFiltersComboBox, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.primaryFiltersCB).addPreferredGap(0).add(this.primaryFiltersComboBox, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tertiaryFiltersCB).addPreferredGap(0).add(this.tertiaryFiltersComboBox, 0, -1, Short.MAX_VALUE)))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.secondaryCheckBox).add((Component)this.tertiaryCheckBox).add((Component)this.doShowAdditionalFiltersCB)).add(0, 0, Short.MAX_VALUE)).add((Component)this.messagesLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.messagesLabel).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.primaryDataSetSelector, -2, -1, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.primaryFiltersCB).add(this.primaryFiltersComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.secondaryCheckBox).addPreferredGap(0).add((Component)this.secondaryDataSetSelector, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.secondaryFiltersCB).add(this.secondaryFiltersComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.tertiaryCheckBox).addPreferredGap(0).add((Component)this.tertiaryDataSetSelector, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tertiaryFiltersCB).add(this.tertiaryFiltersComboBox, -2, -1, -2)).add(18, 18, 18).add((Component)this.doShowAdditionalFiltersCB).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.plotButton).add((Component)this.plotBelowButton).add((Component)this.overplotButton).add((Component)this.cancelButton)).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void secondaryCheckBoxActionPerformed(ActionEvent evt) {
        if (this.secondaryCheckBox.isSelected()) {
            this.secondaryDataSetSelector.setValue(this.primaryDataSetSelector.getValue());
        }
        this.secondaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryCheckBox.setVisible(this.secondaryCheckBox.isSelected());
        this.tertiaryDataSetSelector.setVisible(this.secondaryCheckBox.isSelected() && this.tertiaryCheckBox.isSelected());
    }

    private void overplotButtonActionPerformed(ActionEvent evt) {
        this.setModifiers(1);
        this.cancelled = false;
        this.setVisible(false);
    }

    private void plotBelowButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(2 | evt.getModifiers() & 1);
        this.setVisible(false);
    }

    private void plotButtonActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.setModifiers(evt.getModifiers());
        this.setVisible(false);
    }

    private void tertiaryCheckBoxActionPerformed(ActionEvent evt) {
        if (this.tertiaryCheckBox.isSelected()) {
            this.tertiaryDataSetSelector.setValue(this.primaryDataSetSelector.getValue());
        }
        this.tertiaryDataSetSelector.setVisible(this.tertiaryCheckBox.isSelected());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        int oldModifiers = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChange(PROP_MODIFIERS, oldModifiers, modifiers);
    }

    public int getDepCount() {
        if (this.tertiaryCheckBox.isSelected()) {
            return 2;
        }
        if (this.secondaryCheckBox.isSelected()) {
            return 1;
        }
        return 0;
    }

    public void setDepCount(int i) {
        this.primaryDataSetSelector.setVisible(i > -1);
        this.secondaryCheckBox.setVisible(i > -1);
        this.secondaryCheckBox.setSelected(i > 0);
        this.secondaryDataSetSelector.setVisible(i > 0);
        this.tertiaryCheckBox.setVisible(i > 0);
        this.tertiaryCheckBox.setSelected(i > 1);
        this.tertiaryDataSetSelector.setVisible(i > 1);
    }

    public void setShowAdditionalOperations(boolean show) {
        this.doShowAdditionalFiltersCB.setSelected(show);
        this.doUpdateAdditionalVisible(null, this.primaryFiltersCB, this.primaryFiltersComboBox);
        this.doUpdateAdditionalVisible(this.secondaryCheckBox, this.secondaryFiltersCB, this.secondaryFiltersComboBox);
        this.doUpdateAdditionalVisible(this.tertiaryCheckBox, this.tertiaryFiltersCB, this.tertiaryFiltersComboBox);
    }

    public void setUsePrimaryFilters(boolean show) {
        this.primaryFiltersCB.setSelected(show);
    }

    public void setPrimaryFilter(String f) {
        this.primaryFiltersComboBox.setSelectedItem(f);
    }

    public void setUseSecondaryFilters(boolean show) {
        this.secondaryFiltersCB.setSelected(show);
    }

    public void setSecondaryFilter(String f) {
        this.secondaryFiltersComboBox.setSelectedItem(f);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public DataSetSelector getPrimaryDataSetSelector() {
        return this.primaryDataSetSelector;
    }

    public DataSetSelector getSecondaryDataSetSelector() {
        return this.secondaryDataSetSelector;
    }

    public DataSetSelector getTertiaryDataSetSelector() {
        return this.tertiaryDataSetSelector;
    }

    public String getPrimaryFilters() {
        return (String)this.primaryFiltersComboBox.getSelectedItem();
    }

    public String getSecondaryFilters() {
        return (String)this.secondaryFiltersComboBox.getSelectedItem();
    }

    public String getTertiaryFilters() {
        return (String)this.tertiaryFiltersComboBox.getSelectedItem();
    }

    void setFilter(int i, String filters) {
        if (filters.trim().length() == 0) {
            return;
        }
        this.doShowAdditionalFiltersCB.setSelected(true);
        switch (i) {
            case 0: {
                this.primaryFiltersComboBox.setSelectedItem(filters);
                this.primaryFiltersCB.setSelected(true);
                this.doUpdateAdditionalVisible(null, this.primaryFiltersCB, this.primaryFiltersComboBox);
                break;
            }
            case 1: {
                this.secondaryFiltersComboBox.setSelectedItem(filters);
                this.secondaryFiltersCB.setSelected(true);
                this.doUpdateAdditionalVisible(this.secondaryCheckBox, this.secondaryFiltersCB, this.secondaryFiltersComboBox);
                break;
            }
            case 2: {
                this.tertiaryFiltersComboBox.setSelectedItem(filters);
                this.tertiaryFiltersCB.setSelected(true);
                this.doUpdateAdditionalVisible(this.tertiaryCheckBox, this.tertiaryFiltersCB, this.tertiaryFiltersComboBox);
                break;
            }
        }
    }
}

