/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.dom.Annotation;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AddAnnotationDialog
extends JPanel {
    private static Logger logger = Logger.getLogger("autoplot.gui");
    EnumerationEditor edit;
    private JPanel anchorPositionPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jTextField1;
    private JCheckBox pointAtCB;
    private JTextField xDatumField;
    private JTextField yDatumField;
    private BindingGroup bindingGroup;
    Datum x = null;
    Datum y = null;

    public AddAnnotationDialog() {
        this.initComponents();
        this.edit = new EnumerationEditor();
        this.edit.setValue(AnchorPosition.NE);
        this.anchorPositionPanel.setLayout(new BorderLayout());
        this.anchorPositionPanel.add(this.edit.getCustomEditor(), "Center");
        this.validate();
    }

    public String getText() {
        return this.jTextField1.getText();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.pointAtCB = new JCheckBox();
        this.xDatumField = new JTextField();
        this.yDatumField = new JTextField();
        this.jLabel1 = new JLabel();
        this.anchorPositionPanel = new JPanel();
        this.jTextField1.setText("Annotation 1");
        this.jLabel2.setText("Annotation Text: ");
        this.pointAtCB.setText("Point At:");
        this.pointAtCB.setToolTipText("Point at this data location, and annotation will move with data.");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.pointAtCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.xDatumField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.pointAtCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.yDatumField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel1.setText("Position:");
        this.jLabel1.setToolTipText("Position of anchor relative to corner or data point");
        GroupLayout anchorPositionPanelLayout = new GroupLayout(this.anchorPositionPanel);
        this.anchorPositionPanel.setLayout(anchorPositionPanelLayout);
        anchorPositionPanelLayout.setHorizontalGroup(anchorPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        anchorPositionPanelLayout.setVerticalGroup(anchorPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 15, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.pointAtCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xDatumField, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yDatumField, -2, 124, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorPositionPanel, -1, -1, Short.MAX_VALUE))).addGap(0, 12, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pointAtCB).addComponent(this.xDatumField, -2, -1, -2).addComponent(this.yDatumField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.anchorPositionPanel, -2, -1, -2)).addContainerGap(79, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    void configure(Annotation ann) {
        ann.setText(this.jTextField1.getText());
        ann.setAnchorType(this.pointAtCB.isSelected() ? AnchorType.PLOT : AnchorType.CANVAS);
        ann.setAnchorPosition((AnchorPosition)this.edit.getValue());
        if (this.pointAtCB.isSelected()) {
            try {
                Datum x = this.x.getUnits().parse(this.xDatumField.getText());
                ann.setPointAtX(x);
                ann.setXrange(new DatumRange(x, x));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            try {
                Datum y = this.y.getUnits().parse(this.yDatumField.getText());
                ann.setPointAtY(y);
                ann.setYrange(new DatumRange(y, y));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            ann.setShowArrow(true);
        }
    }

    void setPointAtX(Datum invTransform) {
        this.xDatumField.setText(invTransform.toString());
        this.x = invTransform;
        this.pointAtCB.setEnabled(true);
        if (this.y != null) {
            this.pointAtCB.setEnabled(true);
        }
    }

    void setPointAtY(Datum invTransform) {
        this.yDatumField.setText(invTransform.toString());
        this.y = invTransform;
        if (this.x != null) {
            this.pointAtCB.setEnabled(true);
        }
    }
}

