/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.AutoplotUtil;
import org.das2.datum.LoggerManager;
import org.das2.util.AboutUtil;

public class APSplash
extends JFrame {
    private static APSplash instance = null;
    private Handler handler;
    private final JLabel messageLabel;
    private long t0;
    private static final Logger logger = LoggerManager.getLogger("autoplot.splash");

    public static String getVersion() {
        try {
            String tag = AboutUtil.getReleaseTag(APSplash.class);
            return tag;
        }
        catch (IOException ex) {
            return "untagged_version";
        }
    }

    public synchronized Handler getLogHandler() {
        if (this.handler == null) {
            this.handler = this.createhandler();
        }
        return this.handler;
    }

    private Handler createhandler() {
        Handler result = new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                APSplash.this.messageLabel.setText(logRecord.getMessage());
                APSplash.this.messageLabel.paint(APSplash.this.messageLabel.getGraphics());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        return result;
    }

    private static ImageIcon getSplashImage() {
        URL url = APSplash.class.getResource("/splash.png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static synchronized APSplash getInstance() {
        if (instance == null) {
            instance = new APSplash();
            APSplash.instance.t0 = System.currentTimeMillis();
        }
        return instance;
    }

    public static void showSplash() {
        APSplash.getInstance();
        instance.setVisible(true);
        instance.paint(instance.getGraphics());
        APSplash.checkTime("showSplash");
    }

    public static void checkTime(String msg) {
        if (instance != null) {
            logger.log(Level.FINE, "checkTime {0} @ {1} ms ", new Object[]{msg.replaceAll(" ", "_").replaceFirst("_", " "), String.valueOf(System.currentTimeMillis() - APSplash.instance.t0)});
        } else {
            logger.log(Level.FINE, "checkTime {0} @ -1 ms ", msg.replaceAll(" ", "_").replaceFirst("_", " "));
        }
    }

    public static void hideSplash() {
        APSplash.getInstance();
        instance.setVisible(false);
        APSplash.checkTime("hideSplash");
    }

    public APSplash() {
        this.setUndecorated(true);
        this.setIconImage(AutoplotUtil.getAutoplotIcon());
        this.setTitle("Starting Autoplot");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(APSplash.getSplashImage()), "Center");
        Box bottomPanel = Box.createHorizontalBox();
        this.messageLabel = new JLabel("");
        this.messageLabel.setMinimumSize(new Dimension(200, 10));
        bottomPanel.add(this.messageLabel);
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(new JLabel("version " + APSplash.getVersion() + "   ", 4));
        panel.add((Component)bottomPanel, "South");
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo(null);
    }
}

