/*
 * Decompiled with CFR 0.152.
 */
package ftpfs;

import ftpfs.FtpFileObject;
import ftpfs.ftp.FtpBean;
import ftpfs.ftp.FtpException;
import ftpfs.ftp.FtpObserver;
import it.sauronsoftware.ftp4j.FTPFile;
import it.sauronsoftware.ftp4j.FTPListParseException;
import it.sauronsoftware.ftp4j.FTPListParser;
import it.sauronsoftware.ftp4j.listparsers.DOSListParser;
import it.sauronsoftware.ftp4j.listparsers.EPLFListParser;
import it.sauronsoftware.ftp4j.listparsers.MLSDListParser;
import it.sauronsoftware.ftp4j.listparsers.NetWareListParser;
import it.sauronsoftware.ftp4j.listparsers.UnixListParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.OsUtil;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class FTPBeanFileSystem
extends WebFileSystem {
    private static final Logger logger = Logger.getLogger("das2.filesystem.ftp");
    FTPListParser parser = null;
    private static final List<FTPListParser> listParsers = new ArrayList<FTPListParser>(5);

    protected FtpBean getFtpBean() {
        FtpBean bean = new FtpBean();
        try {
            bean.setSocketTimeout(FileSystem.settings().getConnectTimeoutMs());
        }
        catch (SocketException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        bean.setPassiveModeTransfer(true);
        return bean;
    }

    FTPBeanFileSystem(URI root) throws FileSystem.FileSystemOfflineException, FileSystem.FileSystemOfflineException, IOException {
        super(root, FTPBeanFileSystem.userLocalRoot(root));
        if (FileSystem.settings().isOffline()) {
            this.setOffline(true);
        }
        try {
            this.listDirectory("/");
        }
        catch (ConnectException ex) {
            FileNotFoundException ex2 = new FileNotFoundException(ex.getLocalizedMessage());
            throw ex2;
        }
        catch (IOException ex) {
            if (ex.getMessage().startsWith("550")) {
                throw new FileNotFoundException("550 not found: " + root.toString());
            }
            logger.log(Level.INFO, "exception when listing the first time, going offline", ex);
            this.offline = true;
        }
    }

    private static File userLocalRoot(URI rooturi) throws IOException {
        int icolon;
        String host;
        String auth = rooturi.getAuthority();
        if (auth == null) {
            throw new MalformedURLException("URL doesn't contain authority, check for ///");
        }
        String[] ss = auth.split("@");
        String userInfoNoPassword = null;
        if (ss.length > 3) {
            throw new IllegalArgumentException("user info section can contain at most two at (@) symbols");
        }
        if (ss.length == 3) {
            if (ss[1].endsWith(":")) {
                ss[1] = ss[1].substring(0, ss[1].length() - 1);
            }
            userInfoNoPassword = ss[0] + "@" + ss[1];
            host = ss[2];
        } else if (ss.length == 1) {
            userInfoNoPassword = null;
            host = ss[0];
        } else {
            userInfoNoPassword = ss[0];
            host = rooturi.getHost();
        }
        int n = icolon = userInfoNoPassword == null ? -1 : userInfoNoPassword.indexOf(58);
        if (icolon > -1) {
            userInfoNoPassword = userInfoNoPassword.substring(0, icolon);
        }
        File local = FileSystem.settings().getLocalCacheDir();
        String s = rooturi.getScheme() + "/" + (userInfoNoPassword != null ? userInfoNoPassword + "@" : "") + host + rooturi.getPath();
        local = new File(local, s);
        return local;
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        File parentFile = f.getParentFile();
        String parent = this.getLocalName(parentFile);
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String[] list = this.listDirectory(parent);
        String lookFor = filename.startsWith("/") ? filename.substring(1) + "/" : filename + "/";
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(lookFor)) continue;
            return true;
        }
        return false;
    }

    private boolean copyFile(File partFile, File targetFile) throws IOException {
        logger.log(Level.FINER, "ftpBeanFilesystem copyFile({0},{1}", new Object[]{partFile, targetFile});
        WritableByteChannel dest = Channels.newChannel(new FileOutputStream(targetFile));
        ReadableByteChannel src = Channels.newChannel(new FileInputStream(partFile));
        DataSourceUtil.transfer(src, dest);
        return true;
    }

    private long parseTime1970(String time, Calendar context) {
        try {
            return (long)TimeUtil.toDatum(TimeUtil.parseTime(time)).doubleValue(Units.t1970);
        }
        catch (ParseException ex) {
            try {
                return (long)TimeUtil.toDatum(TimeUtil.parseTime("" + context.get(1) + " " + time)).doubleValue(Units.t1970);
            }
            catch (ParseException ex1) {
                return -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem.DirectoryEntry[] parseLslNew(String dir, File listing) throws IOException {
        logger.log(Level.FINE, "parseLslNew {0}", dir);
        FTPFile[] ret = null;
        ArrayList<String> llist = new ArrayList<String>(370);
        try (BufferedReader reader = new BufferedReader(new FileReader(listing));){
            String aline = reader.readLine();
            while (aline != null) {
                llist.add(aline);
                aline = reader.readLine();
            }
        }
        String[] list = llist.toArray(new String[llist.size()]);
        if (this.parser != null) {
            try {
                ret = this.parser.parse(list);
            }
            catch (FTPListParseException e) {
                this.parser = null;
            }
        }
        if (ret == null) {
            for (FTPListParser aux : listParsers) {
                try {
                    ret = aux.parse(list);
                    this.parser = aux;
                    break;
                }
                catch (FTPListParseException e) {
                }
            }
        }
        if (ret == null) {
            throw new IOException("unable to parse FTP listing, because the format is not recognized");
        }
        FileSystem.DirectoryEntry[] result = new FileSystem.DirectoryEntry[ret.length];
        for (int i = 0; i < result.length; ++i) {
            FileSystem.DirectoryEntry de1 = new FileSystem.DirectoryEntry();
            de1.modified = ret[i].getModifiedDate().getTime();
            de1.name = ret[i].getName();
            de1.size = ret[i].getSize();
            de1.type = (char)(ret[i].getType() == 0 ? 102 : 100);
            result[i] = de1;
        }
        return result;
    }

    public FileSystem.DirectoryEntry[] parseLsl(String dir, File listing) throws IOException {
        ArrayList<FileSystem.DirectoryEntry> result;
        FileInputStream in = new FileInputStream(listing);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "US-ASCII"));){
            String aline = reader.readLine();
            boolean done = aline == null;
            String types = "d-";
            long bytesRead = 0L;
            result = new ArrayList<FileSystem.DirectoryEntry>(20);
            int lineNum = 1;
            int sizePos = 31;
            int modifiedPos = 42;
            while (!done) {
                bytesRead = bytesRead + (long)aline.length() + 1L;
                if ((aline = aline.trim()).length() == 0) {
                    done = true;
                    continue;
                }
                char type = aline.charAt(0);
                if (type == 't') {
                    // empty if block
                }
                if (types.indexOf(type) != -1) {
                    int i = aline.lastIndexOf(32);
                    FileSystem.DirectoryEntry item = new FileSystem.DirectoryEntry();
                    item.name = aline.substring(i + 1);
                    try {
                        item.size = Long.parseLong(aline.substring(sizePos, sizePos + 11).trim());
                    }
                    catch (NumberFormatException ex) {
                        try {
                            item.size = Long.parseLong(aline.substring(sizePos, sizePos + 10).trim());
                        }
                        catch (NumberFormatException ex2) {
                            logger.log(Level.WARNING, "unable to parse size in " + aline + " at " + sizePos, ex2);
                            item.size = 1L;
                        }
                    }
                    item.type = (char)(type == 'd' ? 100 : 102);
                    item.modified = aline.length() >= modifiedPos + 12 ? this.parseTime1970(aline.substring(modifiedPos, modifiedPos + 12), Calendar.getInstance()) : 0L;
                    result.add(item);
                }
                aline = reader.readLine();
                ++lineNum;
                done = aline == null;
            }
        }
        return result.toArray(new FileSystem.DirectoryEntry[result.size()]);
    }

    @Override
    public final synchronized String[] listDirectory(String directory) throws IOException {
        if (this.isListingCached(directory = FTPBeanFileSystem.toCanonicalFolderName(directory))) {
            logger.log(Level.FINE, "using cached listing for {0}", directory);
            File listing = this.listingFile(directory);
            FileSystem.DirectoryEntry[] des = this.parseLslNew(directory, listing);
            this.cacheListing(directory, des);
            return FileSystem.getListing(des);
        }
        boolean successOrCancel = false;
        if (this.isOffline()) {
            File f = new File(this.localRoot, directory);
            if (!f.exists()) {
                throw new FileSystem.FileSystemOfflineException("unable to list " + f + " when offline");
            }
            String[] listing = f.list();
            return listing;
        }
        URL url = this.getRootURL();
        String userInfo = null;
        while (!successOrCancel) {
            try {
                File listingt;
                File listing;
                File newDir = new File(this.localRoot, directory);
                FtpBean bean = this.getFtpBean();
                try {
                    userInfo = KeyChain.getDefault().getUserInfo(url);
                    if (userInfo != null) {
                        String[] userHostArr = userInfo.split(":");
                        if (userHostArr.length == 1) {
                            userHostArr = new String[]{userHostArr[0], "pass"};
                        } else if (userHostArr.length == 0) {
                            userHostArr = new String[]{"user", "pass"};
                        }
                        bean.ftpConnect(url.getHost(), userHostArr[0], userHostArr[1]);
                    } else {
                        bean.ftpConnect(url.getHost(), "ftp");
                    }
                    String cwd = bean.getDirectory();
                    bean.setDirectory(cwd + this.getRootURL().getPath() + directory.substring(1));
                    FileSystemUtil.maybeMkdirs(newDir);
                    listing = new File(this.localRoot, directory + ".listing");
                    listingt = new File(this.localRoot, directory + ".listing.temp");
                }
                catch (NullPointerException ex) {
                    logger.log(Level.SEVERE, "Unable to make connection to " + this.getRootURL().getHost(), ex);
                    throw new IOException("Unable to make connection to " + this.getRootURL().getHost(), ex);
                }
                catch (CancelledOperationException ex) {
                    throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
                }
                String ss = bean.getDirectoryContentAsString();
                try (FileWriter fw = new FileWriter(listingt);){
                    fw.write(ss);
                }
                if (listing.exists() && !listing.delete()) {
                    throw new IllegalArgumentException("unable to delete old listing file " + listing);
                }
                if (!listingt.renameTo(listing)) {
                    throw new IllegalArgumentException("unable to rename file " + listingt + " to " + listing);
                }
                successOrCancel = true;
                FileSystem.DirectoryEntry[] result = this.parseLslNew(directory, listing);
                this.cacheListing(directory, result);
                return FileSystem.getListing(result);
            }
            catch (FtpException e) {
                if (e.getMessage().startsWith("530")) {
                    if (userInfo == null) {
                        userInfo = "user:pass";
                        url = new URL(url.getProtocol() + "://" + userInfo + "@" + url.getHost() + url.getFile());
                    }
                    KeyChain.getDefault().clearUserPassword(url);
                    continue;
                }
                if (e.getMessage().startsWith("550")) {
                    new File(this.localRoot, directory);
                    throw new IOException(e.getMessage() + ": " + directory);
                }
                throw new IOException(e.getMessage());
            }
        }
        return new String[]{"should not get here"};
    }

    protected void uploadFile(String filename, File srcFile, final ProgressMonitor mon) throws IOException {
        logger.log(Level.FINE, "ftpfs uploadFile({0})", filename);
        filename = FTPBeanFileSystem.toCanonicalFilename(filename);
        URL url = new URL(this.getRootURL(), filename.substring(1));
        String[] ss = FileSystem.splitUrl(url.toString());
        try {
            FtpBean bean = this.getFtpBean();
            String fname = ss[2].substring(ss[1].length());
            String userInfo = KeyChain.getDefault().getUserInfo(this.getRootURL());
            if (userInfo != null) {
                String[] userHostArr = userInfo.split(":");
                bean.ftpConnect(this.getRootURL().getHost(), userHostArr[0], userHostArr[1]);
            } else {
                bean.ftpConnect(this.getRootURL().getHost(), "ftp");
            }
            String cwd = bean.getDirectory();
            bean.setDirectory(cwd + fname);
            String lfilename = ss[3].substring(ss[2].length());
            long size = srcFile.length();
            mon.setTaskSize(size);
            mon.started();
            final long t0 = System.currentTimeMillis();
            FtpObserver observer = new FtpObserver(){
                int totalBytes = 0;

                @Override
                public boolean byteRead(int bytes) {
                    this.totalBytes += bytes;
                    if (mon.isCancelled()) {
                        return false;
                    }
                    long dt = System.currentTimeMillis() - t0;
                    mon.setTaskProgress(this.totalBytes);
                    mon.setProgressMessage(this.totalBytes / 1000 + "KB read at " + (long)this.totalBytes / dt + " KB/sec");
                    return true;
                }

                @Override
                public boolean byteWrite(int bytes) {
                    this.totalBytes += bytes;
                    mon.setTaskProgress(this.totalBytes);
                    if (mon.isCancelled()) {
                        return false;
                    }
                    long dt = System.currentTimeMillis() - t0;
                    mon.setTaskProgress(this.totalBytes);
                    mon.setProgressMessage(this.totalBytes / 1000 + "KB written at " + (long)this.totalBytes / dt + " KB/sec");
                    return true;
                }
            };
            bean.putBinaryFile(srcFile.getAbsolutePath(), lfilename, observer);
            FtpFileObject fo = (FtpFileObject)this.getFileObject(filename);
            this.resetListCache(fo.getParent().getNameExt());
            this.listDirectory(fo.getParent().getNameExt());
            bean.close();
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(ex.toString());
        }
        catch (FtpException | CancelledOperationException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            mon.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void downloadFile(String filename, File targetFile, File partFile, final ProgressMonitor mon) throws IOException {
        Lock lock = this.getDownloadLock(filename, targetFile, mon);
        if (lock == null) {
            return;
        }
        logger.log(Level.FINE, "ftpfs downloadFile({0})", filename);
        try {
            filename = FTPBeanFileSystem.toCanonicalFilename(filename);
            URL url = new URL(this.getRootURL(), filename.substring(1));
            String[] ss = FileSystem.splitUrl(url.toString());
            url = this.getRootURL();
            String userInfo = null;
            boolean done = false;
            while (!done) {
                try {
                    FtpBean bean = this.getFtpBean();
                    userInfo = KeyChain.getDefault().getUserInfo(url);
                    if (userInfo != null) {
                        String[] userHostArr = userInfo.split(":");
                        if (userHostArr.length == 1) {
                            userHostArr = new String[]{userHostArr[0], "pass"};
                        } else if (userHostArr.length == 0) {
                            userHostArr = new String[]{"user", "pass"};
                        }
                        bean.ftpConnect(this.getRootURL().getHost(), userHostArr[0], userHostArr[1]);
                        String cwd = bean.getDirectory();
                        bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
                    } else {
                        bean.ftpConnect(this.getRootURL().getHost(), "ftp");
                        String cwd = bean.getDirectory();
                        bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
                    }
                    File listingFile = new File(targetFile.getParentFile(), ".listing");
                    if (!listingFile.exists()) {
                        String listing = bean.getDirectoryContentAsString();
                        try (FileOutputStream out2 = new FileOutputStream(listingFile);){
                            out2.write(listing.getBytes("US-ASCII"));
                        }
                    }
                    long size = this.getFileObject(filename).getSize();
                    mon.setTaskSize(size);
                    mon.started();
                    final long t0 = System.currentTimeMillis();
                    FtpObserver observer = new FtpObserver(){
                        int totalBytes = 0;

                        @Override
                        public boolean byteRead(int bytes) {
                            this.totalBytes += bytes;
                            if (mon.isCancelled()) {
                                return false;
                            }
                            long dt = Math.max(1L, System.currentTimeMillis() - t0);
                            mon.setTaskProgress(this.totalBytes);
                            mon.setProgressMessage(this.totalBytes / 1000 + "KB read at " + (long)this.totalBytes / dt + " KB/sec");
                            return true;
                        }

                        @Override
                        public boolean byteWrite(int bytes) {
                            this.totalBytes += bytes;
                            mon.setTaskProgress(this.totalBytes);
                            return true;
                        }
                    };
                    bean.getBinaryFile(ss[3].substring(ss[2].length()), partFile.toString(), observer);
                    bean.close();
                    done = true;
                }
                catch (RuntimeException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    Throwable cause = ex.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    IOException tex = new IOException(ex);
                    throw tex;
                }
                catch (FtpException ex) {
                    if (!ex.getMessage().startsWith("530")) throw new IOException(ex);
                    if (userInfo == null) {
                        userInfo = "user:pass";
                        url = new URL(url.getProtocol() + "://" + userInfo + "@" + url.getHost() + url.getFile());
                    }
                    KeyChain.getDefault().clearUserPassword(url);
                }
                catch (CancelledOperationException ex) {
                    throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
                }
                finally {
                    mon.finished();
                }
            }
            if (targetFile.length() == partFile.length() && OsUtil.contentEquals(targetFile, partFile)) {
                logger.fine("another thread must have downloaded file.");
                if (partFile.delete()) return;
                throw new IllegalArgumentException("unable to delete " + partFile);
            }
            if (!this.copyFile(partFile, targetFile)) return;
            logger.fine(String.format("%s: deleting %s", Thread.currentThread(), partFile));
            Class<FTPBeanFileSystem> clazz = FTPBeanFileSystem.class;
            synchronized (FTPBeanFileSystem.class) {
                if (!partFile.exists() || partFile.delete()) return;
                throw new IllegalArgumentException("unable to delete file " + partFile);
            }
        }
        catch (IOException e) {
            Class<FTPBeanFileSystem> clazz = FTPBeanFileSystem.class;
            synchronized (FTPBeanFileSystem.class) {
                logger.fine(String.format("%s: deleting %s", Thread.currentThread(), partFile));
                if (!partFile.exists() || partFile.delete()) throw e;
                throw new IllegalArgumentException("unable to delete file " + partFile);
            }
        }
        finally {
            mon.finished();
            lock.unlock();
        }
    }

    @Override
    public FileObject getFileObject(String filename) {
        FileSystem.DirectoryEntry result = null;
        try {
            result = this.maybeUpdateDirectoryEntry(filename, false);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (result == null && this.isOffline()) {
            File localfile = new File(this.getLocalRoot(), filename);
            Date t = new Date(System.currentTimeMillis());
            if (localfile.exists()) {
                t = new Date(localfile.lastModified());
            }
            return new FtpFileObject(this, filename, t);
        }
        if (result == null) {
            return new FtpFileObject(this, filename, new Date(0L));
        }
        return new FtpFileObject(this, filename, new Date(result.modified));
    }

    boolean delete(FtpFileObject aThis) throws IOException {
        String userInfo;
        FtpBean bean = this.getFtpBean();
        try {
            userInfo = KeyChain.getDefault().getUserInfo(this.getRootURL());
        }
        catch (CancelledOperationException ex) {
            IOException result = new IOException(ex.toString());
            throw result;
        }
        String filename = FTPBeanFileSystem.toCanonicalFilename(aThis.getNameExt());
        URL url = new URL(this.getRootURL(), filename.substring(1));
        String[] ss = FileSystem.splitUrl(url.toString());
        try {
            if (userInfo != null) {
                String[] userHostArr = userInfo.split(":");
                bean.ftpConnect(this.getRootURL().getHost(), userHostArr[0], userHostArr[1]);
                String cwd = bean.getDirectory();
                bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
            } else {
                bean.ftpConnect(this.getRootURL().getHost(), "ftp");
                String cwd = bean.getDirectory();
                bean.setDirectory(cwd + ss[2].substring(ss[1].length()));
            }
            bean.fileDelete(ss[3].substring(ss[2].length()));
            bean.close();
            return true;
        }
        catch (IOException iOException) {
            try {
                bean.close();
            }
            catch (FtpException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            return false;
        }
        catch (FtpException ftpException) {
            try {
                bean.close();
            }
            catch (FtpException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            return false;
        }
    }

    protected static final Logger getLogger() {
        return logger;
    }

    static {
        listParsers.add(new UnixListParser());
        listParsers.add(new DOSListParser());
        listParsers.add(new EPLFListParser());
        listParsers.add(new NetWareListParser());
        listParsers.add(new MLSDListParser());
    }
}

