/*
 * Decompiled with CFR 0.152.
 */
package external;

import external.FunctionSupport;
import java.util.Arrays;
import java.util.logging.Logger;
import org.autoplot.ScriptContext;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.jythonsupport.JythonOps;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.BorderType;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;

public class AnnotationCommand
extends PyObject {
    private static final Logger logger = LoggerManager.getLogger("autoplot");
    public static final PyString __doc__ = new PyString("<html><H2>annotation([index],[named parameters])</H2>annotation puts an annotation on the canvas.\nSee <a href='http://autoplot.org/help.annotationCommand'>http://autoplot.org/help.annotationCommand</a><br>\n<br><b>named parameters:</b>\n<table><tr><td>text</td><td>The message, allowing Granny codes</td></tr> <tr><td> textColor      </td><td> text color\n</td></tr> <tr><td> background     </td><td> background color\n</td></tr> <tr><td> foreground     </td><td> foreground color\n</td></tr> <tr><td> fontSize     </td><td> size relative to parent (1.2em) or in pts (8pt)\n</td></tr> <tr><td> borderType     </td><td> draw a border around the annotation text<br>none,rectangle,roundedRectangle<br>.</td></tr> <tr><td> anchorBorderType </td><td> draw a border around the anchor box.</td></tr> <tr><td> anchorPosition </td><td>One of NE,NW,SE,SW,<br>N,E,W,S,<br>outsideN,outsideNNW</td></tr> <tr><td> anchorOffset </td><td>position relative to the anchor, like '1em,1em'</td></tr> <tr><td> anchorType </td><td>PLOT means relative to the plot.<br>DATA means relative to xrange and yrange</td></tr> <tr><td> xrange, yrange </td><td> anchor box when data coordinates</td></tr> <tr><td> plotId </td><td> ID of the plot containing axes.</td></tr> <tr><td> pointAt </td><td>comma separated X and Y to point the annotation arrow at.</td></tr> <tr><td> rowId </td><td>ID of the row containing for positioning this annotation<br>(See dom.plots[0].rowId)</td></tr> <tr><td> columnId </td><td>ID of the column containing for positioning this annotation</td></tr></table></html>");

    private static AnchorPosition anchorPosition(PyObject val) {
        AnchorPosition c = null;
        if (val.__tojava__(AnchorPosition.class) != Py.NoConversion) {
            c = (AnchorPosition)val.__tojava__(AnchorPosition.class);
        } else if (val instanceof PyString) {
            String sval = (String)val.__str__().__tojava__(String.class);
            c = (AnchorPosition)AnnotationCommand.lookupEnum(AnchorPosition.values(), sval);
        } else {
            throw new IllegalArgumentException("anchorPosition must be a string or AnchorPosition");
        }
        return c;
    }

    private static Object lookupEnum(Object[] vs, String s) {
        s = s.toLowerCase();
        for (Object v : vs) {
            if (!v.toString().toLowerCase().equals(s)) continue;
            return v;
        }
        throw new IllegalArgumentException("unable to find enumerated value for " + s);
    }

    private static AnchorType anchorType(PyObject val) {
        AnchorType c = null;
        if (val.__tojava__(AnchorType.class) != Py.NoConversion) {
            c = (AnchorType)((Object)val.__tojava__(AnchorType.class));
        } else if (val instanceof PyString) {
            String sval = (String)val.__str__().__tojava__(String.class);
            c = (AnchorType)((Object)AnnotationCommand.lookupEnum((Object[])AnchorType.values(), sval));
        } else {
            throw new IllegalArgumentException("anchorType must be a string or AnchorType");
        }
        return c;
    }

    private static BorderType borderType(PyObject val) {
        BorderType c = null;
        if (val.__tojava__(BorderType.class) != Py.NoConversion) {
            c = (BorderType)((Object)val.__tojava__(BorderType.class));
        } else if (val instanceof PyString) {
            String sval = (String)val.__str__().__tojava__(String.class);
            c = (BorderType)((Object)AnnotationCommand.lookupEnum((Object[])BorderType.values(), sval));
        } else {
            throw new IllegalArgumentException("borderType must be a string or BorderType");
        }
        return c;
    }

    private static boolean booleanValue(PyObject arg0) {
        if (arg0.isNumberType()) {
            return arg0.__nonzero__();
        }
        String s = String.valueOf(arg0);
        return s.equals("True") || s.equals("T") || s.equals("1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __call__(PyObject[] args, String[] keywords) {
        int i;
        FunctionSupport fs = new FunctionSupport("annotation", new String[]{"index", "text", "textColor", "background", "foreground", "anchorPosition", "anchorOffset", "anchorType", "borderType", "anchorBorderType", "fontSize", "pointAtX", "pointAtY", "pointAt", "xrange", "yrange", "plotId", "rowId", "columnId"}, new PyObject[]{new PyInteger(0), Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None});
        fs.args(args, keywords);
        int nparm = args.length - keywords.length;
        int index = 0;
        int nargs = nparm;
        if (args.length > 0) {
            PyObject po0 = args[0];
            if (po0 instanceof PyInteger) {
                index = ((PyInteger)po0).getValue();
                PyObject[] newArgs = new PyObject[args.length - 1];
                for (i = 0; i < args.length - 1; ++i) {
                    newArgs[i] = args[i + 1];
                }
                args = newArgs;
                --nargs;
                nparm = args.length - keywords.length;
                po0 = args[0];
            }
        } else {
            index = 0;
        }
        Application dom = ScriptContext.getDocumentModel();
        dom.getController().registerPendingChange((Object)this, (Object)this);
        dom.getController().performingChange((Object)this, (Object)this);
        while (index >= dom.getAnnotations().length) {
            dom.getController().addAnnotation(new Annotation());
        }
        Annotation annotation = dom.getAnnotations(index);
        annotation.syncTo(new Annotation(), Arrays.asList("id", "plotId", "rowId", "columnId"));
        try {
            block45: for (i = nparm; i < args.length; ++i) {
                String kw = keywords[i - nparm];
                PyObject val = args[i];
                String sval = (String)val.__str__().__tojava__(String.class);
                switch (kw) {
                    case "text": {
                        annotation.setText(sval);
                        continue block45;
                    }
                    case "textColor": {
                        annotation.setTextColor(JythonOps.color(val));
                        annotation.setOverrideColors(true);
                        continue block45;
                    }
                    case "background": {
                        annotation.setBackground(JythonOps.color(val));
                        annotation.setOverrideColors(true);
                        continue block45;
                    }
                    case "foreground": {
                        annotation.setForeground(JythonOps.color(val));
                        annotation.setOverrideColors(true);
                        continue block45;
                    }
                    case "anchorPosition": {
                        annotation.setAnchorPosition(AnnotationCommand.anchorPosition(val));
                        continue block45;
                    }
                    case "anchorOffset": {
                        annotation.setAnchorOffset(sval);
                        continue block45;
                    }
                    case "anchorType": {
                        annotation.setAnchorType(AnnotationCommand.anchorType(val));
                        continue block45;
                    }
                    case "anchorBorderType": {
                        annotation.setAnchorBorderType(AnnotationCommand.borderType(val));
                        continue block45;
                    }
                    case "borderType": {
                        annotation.setBorderType(AnnotationCommand.borderType(val));
                        continue block45;
                    }
                    case "fontSize": {
                        annotation.setFontSize(sval);
                        continue block45;
                    }
                    case "pointAtX": {
                        annotation.setPointAtX(JythonOps.datum(val));
                        annotation.setShowArrow(true);
                        continue block45;
                    }
                    case "pointAtY": {
                        annotation.setPointAtY(JythonOps.datum(val));
                        annotation.setShowArrow(true);
                        continue block45;
                    }
                    case "pointAt": {
                        String[] ss = sval.split(",", -2);
                        annotation.setPointAtX(Ops.datum(ss[0]));
                        annotation.setPointAtY(Ops.datum(ss[1]));
                        annotation.setShowArrow(true);
                        continue block45;
                    }
                    case "plotId": {
                        annotation.setPlotId(sval);
                        annotation.setAnchorType(AnchorType.DATA);
                        continue block45;
                    }
                    case "xrange": {
                        annotation.setXrange(JythonOps.datumRange(val));
                        annotation.setAnchorOffset("");
                        annotation.setAnchorType(AnchorType.DATA);
                        continue block45;
                    }
                    case "yrange": {
                        annotation.setYrange(JythonOps.datumRange(val));
                        annotation.setAnchorOffset("");
                        annotation.setAnchorType(AnchorType.DATA);
                        continue block45;
                    }
                    case "rowId": {
                        annotation.setRowId(sval);
                        annotation.setAnchorType(AnchorType.CANVAS);
                        continue block45;
                    }
                    case "columnId": {
                        annotation.setColumnId(sval);
                        annotation.setAnchorType(AnchorType.CANVAS);
                        continue block45;
                    }
                }
            }
        }
        finally {
            dom.getController().changePerformed((Object)this, (Object)this);
        }
        return new PyJavaInstance((Object)annotation);
    }
}

