/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.JDiskHogPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MyMouseListener
extends MouseAdapter {
    JTree jtree;
    JDiskHogPanel panel;
    TreePath context;
    JPopupMenu popup;

    MyMouseListener(JTree jtree, JDiskHogPanel panel) {
        this.jtree = jtree;
        this.panel = panel;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.context = this.jtree.getPathForLocation(e.getX(), e.getY());
            this.jtree.getSelectionModel().addSelectionPath(this.context);
            if (this.context != null) {
                this.showPopup(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.context = this.jtree.getPathForLocation(e.getX(), e.getY());
            this.jtree.getSelectionModel().addSelectionPath(this.context);
            if (this.context != null) {
                this.showPopup(e);
            }
        }
    }

    private synchronized void showPopup(MouseEvent e) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            JMenuItem mi = new JMenuItem(this.panel.getDeleteAction(this.jtree));
            mi.setToolTipText("Delete files or folders from the local cache");
            this.popup.add(mi);
            mi = new JMenuItem(this.panel.getPruneTreeAction(this.jtree));
            mi.setToolTipText("Delete empty folders from the local cache");
            this.popup.add(mi);
            mi = new JMenuItem(this.panel.getCopyToAction(this.jtree));
            mi.setToolTipText("Make a copy of files or folders to location outside of file cache.");
            this.popup.add(mi);
            mi = new JMenuItem(this.panel.getLocalROCacheAction(this.jtree));
            mi.setToolTipText("Specify a local copy of the remote files, and use files from here before downloading.");
            this.popup.add(mi);
        }
        this.popup.show(this.jtree, e.getX(), e.getY());
    }
}

