/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.DiskUsageModel;
import com.cottagesystems.jdiskhog.FSTreeModel;
import com.cottagesystems.jdiskhog.MyMouseListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.AutoplotUI;
import org.autoplot.Util;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.components.DasProgressLabel;
import org.das2.components.DasProgressPanel;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.jdesktop.layout.GroupLayout;

public final class JDiskHogPanel
extends JPanel {
    AutoplotUI app;
    TreeModel def = new DefaultTreeModel(new DefaultMutableTreeNode("moment..."));
    MouseListener l = null;
    boolean goPressed = false;
    private static final Logger logger = LoggerManager.getLogger("autoplot.jdiskhog");
    public JButton goButton;
    public JButton jButton1;
    public JLabel jLabel1;
    public JScrollPane jScrollPane2;
    public JTree jTree1;
    public JLabel progressLabel;
    public JComboBox sortCB;

    public JDiskHogPanel(AutoplotUI model) {
        this.app = model;
        this.initComponents();
        this.jTree1.setModel(this.def);
    }

    private MouseListener createMouseListener(JTree jtree) {
        return new MyMouseListener(jtree, this);
    }

    Action getDeleteAction(final JTree jtree) {
        return new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                FSTreeModel model = (FSTreeModel)jtree.getModel();
                TreePath[] paths = jtree.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                boolean okay = true;
                Throwable ex = null;
                for (TreePath path : paths) {
                    File f = model.getFile(path);
                    if (f.equals(model.root)) continue;
                    if (f.isFile()) {
                        if (!f.exists()) continue;
                        okay = f.delete();
                        continue;
                    }
                    try {
                        HashSet<String> exclude = new HashSet<String>();
                        exclude.add("ro_cache.txt");
                        exclude.add("keychain.txt");
                        okay = FileUtil.deleteFileTree(f, exclude);
                    }
                    catch (IllegalArgumentException ex1) {
                        ex = ex1;
                        okay = false;
                    }
                }
                if (!okay) {
                    assert (ex != null);
                    JOptionPane.showConfirmDialog(jtree, ex.getLocalizedMessage(), "unable to delete", -1, 2);
                }
                JDiskHogPanel.this.scan(model.root);
            }
        };
    }

    Action getPlotAction(JTree jtree) {
        return new AbstractAction("Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (JDiskHogPanel.this.doPlotSelected()) {
                    return;
                }
                Container p = JDiskHogPanel.this.getTopLevelAncestor();
                if (p instanceof JDialog) {
                    p.setVisible(false);
                }
            }
        };
    }

    private String outsideName(String sf) {
        String cache = AutoplotSettings.settings().resolveProperty("fscache");
        String outsideName = sf.substring(cache.length());
        boolean acceptOutside = false;
        if (sf.startsWith(cache)) {
            String[] protos;
            for (String proto : protos = new String[]{"ftp", "http", "https"}) {
                if (!outsideName.startsWith("/" + proto + "/")) continue;
                outsideName = proto + "://" + outsideName.substring(proto.length() + 2);
                acceptOutside = true;
            }
        }
        if (acceptOutside) {
            return outsideName;
        }
        return null;
    }

    public boolean doPlotSelected() {
        File f = this.getSelectedFile(this.jTree1);
        if (f == null) {
            return true;
        }
        String sf = f.toString();
        String outsideName = this.outsideName(sf);
        if (this.app != null) {
            if (outsideName != null) {
                this.app.plotUri(outsideName);
            } else {
                this.app.plotUri(sf);
            }
        }
        return false;
    }

    Action getPruneTreeAction(final JTree jtree) {
        return new AbstractAction("Prune empty branches"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                File local = JDiskHogPanel.this.getSelectedFile(jtree);
                if (local == null) {
                    return;
                }
                DasProgressPanel mon1 = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(jtree), "Pruning Cache...");
                mon1.started();
                ArrayList<String> problems = new ArrayList<String>();
                boolean y = Util.pruneFileTree(local, problems);
                mon1.finished();
                if (y) {
                    JOptionPane.showMessageDialog(jtree, "<html>Successful", "Prune fscache", -1);
                } else {
                    StringBuilder msg = new StringBuilder("Some problems occured while pruning cache:");
                    for (String s : problems) {
                        msg.append("<br>").append(s);
                    }
                    JOptionPane.showMessageDialog(jtree, "<html>" + msg + "</html>");
                }
                FSTreeModel model = (FSTreeModel)jtree.getModel();
                JDiskHogPanel.this.scan(model.root);
            }
        };
    }

    private File getSelectedFile(JTree jtree) {
        FSTreeModel model = (FSTreeModel)jtree.getModel();
        TreePath[] paths = jtree.getSelectionPaths();
        File f = paths != null && paths.length == 1 ? model.getFile(paths[0]) : null;
        return f;
    }

    Action getCopyToAction(JTree jtree) {
        CopyToAction a = new CopyToAction(this.getSelectedFile(jtree), jtree);
        return a;
    }

    private boolean writeROCacheLink(File src, File dest) throws IOException {
        try (BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(src, "ro_cache.txt")), "UTF-8"));){
            write.append(dest.toString());
            write.append("\n");
        }
        return true;
    }

    Action getLocalROCacheAction(final JTree jtree) {
        return new AbstractAction("Link to Local Read-Only Cache..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                FSTreeModel model = (FSTreeModel)jtree.getModel();
                TreePath path = jtree.getSelectionPath();
                if (path == null) {
                    return;
                }
                File f = model.getFile(path);
                if (f.isFile()) {
                    JOptionPane.showConfirmDialog(jtree, "Folder must be selected, not a file", "Link to Local R/O Cache", -1, 2);
                } else {
                    String outsideName = JDiskHogPanel.this.outsideName(f.toString());
                    String[] nn = null;
                    if (outsideName != null) {
                        try {
                            FileSystem fs = FileSystem.create(outsideName);
                            nn = fs.listDirectory("/");
                        }
                        catch (IOException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    JFileChooser choose = new JFileChooser();
                    if (nn != null && nn.length > 1) {
                        for (int i = 0; i < nn.length; ++i) {
                            if (nn[i] != null) continue;
                            nn[i] = "";
                        }
                        StringBuilder s = new StringBuilder(nn[0]);
                        for (int i = 1; i < 6; ++i) {
                            if (nn.length <= i) continue;
                            s.append("<br>").append(nn[i]);
                        }
                        JLabel label = new JLabel("<html>Target should contain the files:<br>" + s.toString());
                        choose.setAccessory(label);
                    }
                    choose.setFileSelectionMode(1);
                    if (choose.showOpenDialog(jtree) == 0) {
                        try {
                            File ff = choose.getSelectedFile();
                            JDiskHogPanel.this.writeROCacheLink(f, ff);
                            JOptionPane.showConfirmDialog(jtree, "<html>Wrote link file in " + f, "Link to Local R/O Cache", -1, -1);
                        }
                        catch (IOException ex2) {
                            JOptionPane.showConfirmDialog(jtree, "<html>Unable to write link file in " + f + "<br>" + ex2.toString(), "Link to Local R/O Cache", -1, 2);
                        }
                    }
                }
            }
        };
    }

    public synchronized void scan(final File root) {
        final DiskUsageModel dumodel = new DiskUsageModel();
        final DasProgressLabel monitor = new DasProgressLabel("Scanning disk usage");
        monitor.setLabelComponent(this.progressLabel);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                dumodel.search(root, 0, monitor);
            }
        };
        new Thread(run, "diskUsage").start();
        final FSTreeModel model = new FSTreeModel(dumodel, root);
        if (model.getComparator() == FSTreeModel.alphaComparator) {
            this.sortCB.setSelectedIndex(1);
        }
        model.setHideListingFile(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDiskHogPanel.this.jTree1.setModel(model);
                if (JDiskHogPanel.this.l == null) {
                    JDiskHogPanel.this.l = JDiskHogPanel.this.createMouseListener(JDiskHogPanel.this.jTree1);
                    JDiskHogPanel.this.jTree1.addMouseListener(JDiskHogPanel.this.l);
                }
                JDiskHogPanel.this.progressLabel.setText("");
            }
        });
    }

    public boolean isGoPressed() {
        return this.goPressed;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jButton1 = new JButton();
        this.goButton = new JButton();
        this.sortCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.progressLabel = new JLabel();
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDiskHogPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.goButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/go.png")));
        this.goButton.setText("Plot");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDiskHogPanel.this.goButtonActionPerformed(evt);
            }
        });
        this.sortCB.setModel(new DefaultComboBoxModel<String>(new String[]{"File Size", "Alphabetical"}));
        this.sortCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDiskHogPanel.this.sortCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Sort By:");
        this.progressLabel.setText(" ");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 688, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.sortCB, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.progressLabel, -2, 295, -2).add(4, 4, 4).add((Component)this.goButton, -2, 87, -2).addPreferredGap(0).add((Component)this.jButton1, -2, 69, -2)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 293, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButton1).add((Component)this.goButton).add((Component)this.jLabel1).add((Component)this.sortCB, -2, -1, -2).add((Component)this.progressLabel))));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        SwingUtilities.getWindowAncestor(this).setVisible(false);
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.goPressed = true;
        SwingUtilities.getWindowAncestor(this).setVisible(false);
    }

    private void sortCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (!(this.jTree1.getModel() instanceof FSTreeModel)) {
            return;
        }
        FSTreeModel model = (FSTreeModel)this.jTree1.getModel();
        if (this.sortCB.getSelectedIndex() == 0) {
            model.setComparator(model.fileSizeComparator);
        } else if (this.sortCB.getSelectedIndex() == 1) {
            model.setComparator(FSTreeModel.alphaComparator);
        }
    }

    static class CopyToAction
    extends AbstractAction {
        private final File f;
        private final JTree jtree;

        public CopyToAction(File f, JTree jtree) {
            super("Copy to..");
            this.f = f;
            this.jtree = jtree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LoggerManager.logGuiEvent(e);
            if (this.f == null) {
                JOptionPane.showMessageDialog(this.jtree, "<html>Wait for scanning to complete.</html>");
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            File p = new File("foo").getAbsoluteFile().getParentFile();
            chooser.setCurrentDirectory(p);
            chooser.setSelectedFile(new File(p, this.f.getName()));
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showSaveDialog(this.jtree) == 0) {
                File destdir = chooser.getSelectedFile();
                FSTreeModel model = (FSTreeModel)this.jtree.getModel();
                TreePath[] paths = this.jtree.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                for (TreePath path : paths) {
                    File f1 = model.getFile(path);
                    try {
                        FileUtil.fileCopy(f1, destdir);
                    }
                    catch (FileNotFoundException ex1) {
                        logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                        JOptionPane.showMessageDialog(this.jtree, "File Not Found:\n" + ex1.getLocalizedMessage());
                    }
                    catch (IOException ex1) {
                        logger.log(Level.SEVERE, ex1.getMessage(), ex1);
                        JOptionPane.showMessageDialog(this.jtree, "Error Occurred:\n" + ex1.getLocalizedMessage());
                    }
                }
            }
        }
    }
}

