/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.math;

import ProGAL.math.Constants;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Trigonometry {
    public static Double[] solveAsinXPlusBcosXplusC(double A, double B, double C) {
        Double[] roots = new Double[2];
        double a = C - B;
        if (Math.abs(a) < Constants.EPSILON) {
            return null;
        }
        double b = 2.0 * A;
        double c = B + C;
        double delta = b * b - 4.0 * a * c;
        if (delta < -Constants.EPSILON) {
            return null;
        }
        if (delta < Constants.EPSILON) {
            roots[0] = 2.0 * Math.atan(-0.5 * b / a);
            roots[1] = null;
        } else {
            delta = Math.sqrt(delta);
            roots[0] = Math.atan2(0.5 * (delta - b), a);
            if (roots[0] < 0.0) {
                roots[0] = Constants.TAU + roots[0];
            }
            roots[0] = 2.0 * roots[0];
            if (roots[0] > Constants.TAU) {
                roots[0] = roots[0] - Constants.TAU;
            }
            roots[1] = Math.atan2(-0.5 * (delta + b), a);
            if (roots[1] < 0.0) {
                roots[1] = Constants.TAU + roots[1];
            }
            roots[1] = 2.0 * roots[1];
            if (roots[1] > Constants.TAU) {
                roots[1] = roots[1] - Constants.TAU;
            }
        }
        return roots;
    }

    public static Double[] solveBDAsinXPlusBcosXplusC(double A, double B, double C) {
        Double[] roots = new Double[2];
        BigDecimal bdA = BigDecimal.valueOf(A);
        BigDecimal bdB = BigDecimal.valueOf(B);
        BigDecimal bdC = BigDecimal.valueOf(C);
        BigDecimal a = bdC.subtract(bdB);
        if (a.abs().compareTo(Constants.EPSILONBD) == -1) {
            System.out.println("No solution");
            return null;
        }
        BigDecimal b = bdA.multiply(new BigDecimal("2.0"), MathContext.DECIMAL128);
        BigDecimal c = bdB.add(bdC);
        BigDecimal delta = b.pow(2).subtract(a.multiply(c).multiply(new BigDecimal("4.0")));
        if (delta.compareTo(Constants.EPSILONBD.negate()) == -1) {
            return null;
        }
        if (delta.compareTo(Constants.EPSILONBD) == -1) {
            BigDecimal d = b.divide(a).multiply(new BigDecimal("-0.5"));
            roots[0] = 2.0 * Math.atan(d.doubleValue());
            roots[1] = null;
        } else {
            delta = BigDecimal.valueOf(Math.sqrt(delta.doubleValue()));
            BigDecimal e = delta.subtract(b).divide(a, 50, RoundingMode.HALF_UP).multiply(new BigDecimal("0.5"));
            roots[0] = 2.0 * Math.atan(e.doubleValue());
            if (roots[0] < 0.0) {
                roots[0] = roots[0] + Constants.TAU;
            }
            BigDecimal f = delta.add(b).divide(a, 50, RoundingMode.HALF_UP).multiply(new BigDecimal("-0.5"));
            roots[1] = 2.0 * Math.atan(f.doubleValue());
            if (roots[1] < 0.0) {
                roots[1] = roots[1] + Constants.TAU;
            }
        }
        return roots;
    }

    public static void main(String[] args) {
        Trigonometry.solveAsinXPlusBcosXplusC(12.0, 5.0, -4.0);
        Trigonometry.solveAsinXPlusBcosXplusC(1.0, 1.0, 0.0);
    }
}

