/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.math;

import ProGAL.geom3d.Vector;
import ProGAL.math.Constants;
import ProGAL.math.Matrix;
import ProGAL.math.Randomization;

public class Matrix3x3
extends Matrix {
    public Matrix3x3() {
        super(3, 3);
    }

    public Matrix3x3(double[][] coords) {
        super(coords);
        if (this.M != 3 || this.N != 3) {
            throw new RuntimeException("Dimensions dont fit");
        }
    }

    @Override
    public Vector getColumn(int c) {
        return new Vector(this.coords[0][c], this.coords[1][c], this.coords[2][c]);
    }

    @Override
    public Vector getRow(int r) {
        return new Vector(this.coords[r][0], this.coords[r][1], this.coords[r][2]);
    }

    @Override
    public Matrix3x3 getTranspose() {
        Matrix3x3 ret = this.clone();
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                double tmp = this.coords[i][j];
                this.coords[i][j] = this.coords[j][i];
                this.coords[j][i] = tmp;
            }
        }
        return ret;
    }

    @Override
    public double determinant() {
        double ret = this.coords[0][0] * (this.coords[1][1] * this.coords[2][2] - this.coords[1][2] * this.coords[2][1]);
        ret -= this.coords[0][1] * (this.coords[1][0] * this.coords[2][2] - this.coords[1][2] * this.coords[2][0]);
        return ret += this.coords[0][2] * (this.coords[1][0] * this.coords[2][1] - this.coords[1][1] * this.coords[2][0]);
    }

    @Override
    public Matrix invertThis() {
        double[][] newCoords = new double[this.coords.length][this.coords[0].length];
        newCoords[0][0] = this.coords[1][1] * this.coords[2][2] - this.coords[1][2] * this.coords[2][1];
        newCoords[0][1] = this.coords[0][2] * this.coords[2][1] - this.coords[0][1] * this.coords[2][2];
        newCoords[0][2] = this.coords[0][1] * this.coords[1][2] - this.coords[0][2] * this.coords[1][1];
        newCoords[1][0] = this.coords[1][2] * this.coords[2][0] - this.coords[1][0] * this.coords[2][2];
        newCoords[1][1] = this.coords[0][0] * this.coords[2][2] - this.coords[0][2] * this.coords[2][0];
        newCoords[1][2] = this.coords[0][2] * this.coords[1][0] - this.coords[0][0] * this.coords[1][2];
        newCoords[2][0] = this.coords[1][0] * this.coords[2][1] - this.coords[1][1] * this.coords[2][0];
        newCoords[2][1] = this.coords[0][1] * this.coords[2][0] - this.coords[0][0] * this.coords[2][1];
        newCoords[2][2] = this.coords[0][0] * this.coords[1][1] - this.coords[0][1] * this.coords[1][0];
        double det = this.coords[0][0] * newCoords[0][0] + this.coords[0][1] * newCoords[1][0] + this.coords[0][2] * newCoords[2][0];
        this.coords = newCoords;
        return this.multiplyThis(1.0 / det);
    }

    public Vector[] getEigenvectors() {
        if (this.coords.length != 3 || this.coords[0].length != 3) {
            throw new Error("Matrix is " + this.coords.length + "x" + this.coords[0].length);
        }
        boolean issymmetric = true;
        int j = 0;
        while (j < 3 & issymmetric) {
            int i = 0;
            while (i < 3 & issymmetric) {
                issymmetric = this.coords[i][j] == this.coords[j][i];
                ++i;
            }
            ++j;
        }
        if (issymmetric) {
            double c = this.coords[0][0] * this.coords[1][1];
            double d = this.coords[1][2] * this.coords[2][1];
            double e = this.coords[0][1] * this.coords[1][0];
            double f = this.coords[0][2] * this.coords[2][0];
            double p = -this.coords[0][0] - this.coords[1][1] - this.coords[2][2];
            double q = c + (this.coords[0][0] + this.coords[1][1]) * this.coords[2][2] - d - e - f;
            double r = (e - c) * this.coords[2][2] + d * this.coords[0][0] - 2.0 * (this.coords[0][1] * this.coords[1][2] * this.coords[2][0]) + f * this.coords[1][1];
            double pThirds = p / 3.0;
            double a = q - p * pThirds;
            double b = (2.0 * pThirds * pThirds - q) * pThirds + r;
            double aThirds = a / 3.0;
            double m = 2.0 * Math.sqrt(-aThirds);
            double t = Math.acos(b / (aThirds * m)) / 3.0;
            double cosT = Math.cos(t);
            double sinT = Math.sin(t);
            double l1 = m * cosT - pThirds;
            double l2 = -m * ((cosT + Constants.SQRT3 * sinT) / 2.0) - pThirds;
            double l3 = -m * ((cosT - Constants.SQRT3 * sinT) / 2.0) - pThirds;
            Matrix3x3 m1 = this.clone();
            m1.set(0, 0, -l1 + m1.get(0, 0));
            m1.set(1, 1, -l1 + m1.get(1, 1));
            m1.set(2, 2, -l1 + m1.get(2, 2));
            m1.reduceThis();
            m1.toConsole();
            Vector v1 = new Vector(-m1.coords[0][2], -m1.coords[1][2], 1.0);
            Vector v2 = null;
            Vector v3 = null;
            if (l2 > Constants.EPSILON) {
                Matrix3x3 m2 = this.clone();
                m2.set(0, 0, -l2 + m2.get(0, 0));
                m2.set(1, 1, -l2 + m2.get(1, 1));
                m2.set(2, 2, -l2 + m2.get(2, 2));
                m2.reduceThis();
                v2 = new Vector(-m2.coords[0][2], -m2.coords[1][2], 1.0);
            }
            if (l3 > Constants.EPSILON) {
                Matrix3x3 m3 = this.clone();
                m3.set(0, 0, -l3 + m3.get(0, 0));
                m3.set(1, 1, -l3 + m3.get(1, 1));
                m3.set(2, 2, -l3 + m3.get(2, 2));
                m3.reduceThis();
                v3 = new Vector(-m3.coords[0][2], -m3.coords[1][2], 1.0);
            }
            return new Vector[]{v1, v2, v3};
        }
        Matrix.EigenvalueDecomposition ed = new Matrix.EigenvalueDecomposition(this);
        Vector[] ret = new Vector[3];
        double[][] V = ed.getV().coords;
        ret[0] = new Vector(V[0][0], V[1][0], V[2][0]).multiplyThis(ed.getRealEigenvalues()[0]);
        ret[1] = new Vector(V[0][1], V[1][1], V[2][1]).multiplyThis(ed.getRealEigenvalues()[1]);
        ret[2] = new Vector(V[0][2], V[1][2], V[2][2]).multiplyThis(ed.getRealEigenvalues()[2]);
        return ret;
    }

    public Matrix3x3 multiply(Matrix3x3 M) {
        double[] r0 = new double[]{this.coords[0][0] * M.coords[0][0] + this.coords[0][1] * M.coords[1][0] + this.coords[0][2] * M.coords[2][0], this.coords[0][0] * M.coords[0][1] + this.coords[0][1] * M.coords[1][1] + this.coords[0][2] * M.coords[2][1], this.coords[0][0] * M.coords[0][2] + this.coords[0][1] * M.coords[1][2] + this.coords[0][2] * M.coords[2][2]};
        double[] r1 = new double[]{this.coords[1][0] * M.coords[0][0] + this.coords[1][1] * M.coords[1][0] + this.coords[1][2] * M.coords[2][0], this.coords[1][0] * M.coords[0][1] + this.coords[1][1] * M.coords[1][1] + this.coords[1][2] * M.coords[2][1], this.coords[1][0] * M.coords[0][2] + this.coords[1][1] * M.coords[1][2] + this.coords[1][2] * M.coords[2][2]};
        double[] r2 = new double[]{this.coords[2][0] * M.coords[0][0] + this.coords[2][1] * M.coords[1][0] + this.coords[2][2] * M.coords[2][0], this.coords[2][0] * M.coords[0][1] + this.coords[2][1] * M.coords[1][1] + this.coords[2][2] * M.coords[2][1], this.coords[2][0] * M.coords[0][2] + this.coords[2][1] * M.coords[1][2] + this.coords[2][2] * M.coords[2][2]};
        double[][] mat = new double[][]{r0, r1, r2};
        return new Matrix3x3(mat);
    }

    public static Matrix3x3 randRotation(double[] x) {
        double theta = x[0] * Constants.PI * 2.0;
        double phi = x[1] * Constants.PI * 2.0;
        double z = x[2] * 2.0;
        double r = Math.sqrt(z);
        double Vx = Math.sin(phi) * r;
        double Vy = Math.cos(phi) * r;
        double Vz = Math.sqrt(2.0 - z);
        double st = Math.sin(theta);
        double ct = Math.cos(theta);
        double Sx = Vx * ct - Vy * st;
        double Sy = Vx * st + Vy * ct;
        Matrix3x3 ret = new Matrix3x3();
        ret.coords[0][0] = -(Vx * Sx - ct);
        ret.coords[0][1] = -(Vx * Sy - st);
        ret.coords[0][2] = -(Vx * Vz);
        ret.coords[1][0] = -(Vy * Sx + st);
        ret.coords[1][1] = -(Vy * Sy - ct);
        ret.coords[1][2] = -(Vy * Vz);
        ret.coords[2][0] = Vz * Sx;
        ret.coords[2][1] = Vz * Sy;
        ret.coords[2][2] = 1.0 - z;
        return ret;
    }

    public static Matrix3x3 randRotation2(double[] x) {
        double ax = x[0] * Math.PI * 2.0;
        double ay = x[1] * Math.PI * 2.0;
        double az = x[2] * Math.PI * 2.0;
        Matrix3x3 mx = (Matrix3x3)Matrix3x3.createRotationMatrix(ax, Vector.X);
        Matrix3x3 my = (Matrix3x3)Matrix3x3.createRotationMatrix(ay, Vector.Y);
        Matrix3x3 mz = (Matrix3x3)Matrix3x3.createRotationMatrix(az, Vector.Z);
        return mz.multiply(my).multiply(mx);
    }

    public static Matrix3x3 randRotation3(double scl) {
        double theta = Math.acos(Randomization.randBetween(-1.0, 1.0));
        double phi = Randomization.randBetween(0.0, 2.0 * Constants.PI);
        Vector rax = new Vector(Math.sin(theta) * Math.cos(phi), Math.sin(theta) * Math.sin(phi), Math.cos(theta));
        double angle = Randomization.randBetween(0.0, scl);
        return (Matrix3x3)Matrix3x3.createRotationMatrix(angle, rax);
    }

    @Override
    public Matrix3x3 clone() {
        Matrix3x3 ret = new Matrix3x3();
        for (int r = 0; r < this.coords.length; ++r) {
            for (int c = 0; c < this.coords[0].length; ++c) {
                ret.coords[r][c] = this.coords[r][c];
            }
        }
        return ret;
    }
}

