/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.math;

import ProGAL.geom3d.Vector;
import ProGAL.geomNd.Point;
import ProGAL.math.Constants;
import ProGAL.math.Functions;
import ProGAL.math.LUDecomposition;
import ProGAL.math.Matrix3x3;
import ProGAL.math.Randomization;
import java.util.Arrays;
import java.util.Random;

public class Matrix {
    protected double[][] coords;
    protected int M;
    protected int N;

    public Matrix(int M, int N) {
        this.coords = new double[M][N];
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                this.coords[i][j] = 0.0;
            }
        }
        this.M = M;
        this.N = N;
    }

    public Matrix(double[][] coords) {
        this.M = coords.length;
        this.N = this.M > 0 ? coords[0].length : 0;
        this.coords = coords;
    }

    public Matrix(int M, int N, int seed) {
        this.coords = new double[M][N];
        Random r = new Random(seed);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                this.coords[i][j] = r.nextDouble();
            }
        }
        this.M = M;
        this.N = N;
    }

    public void set(int r, int c, double v) {
        this.coords[r][c] = v;
    }

    public double get(int i, int j) {
        return this.coords[i][j];
    }

    public double[][] getCoords() {
        double[][] ret = new double[this.M][this.N];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.M; ++j) {
                ret[i][j] = this.coords[i][j];
            }
        }
        return ret;
    }

    public int getM() {
        return this.M;
    }

    public int getN() {
        return this.N;
    }

    public ProGAL.geomNd.Vector getRow(int r) {
        ProGAL.geomNd.Vector ret = new ProGAL.geomNd.Vector(this.N);
        for (int c = 0; c < this.N; ++c) {
            ret.set(c, this.coords[r][c]);
        }
        return ret;
    }

    public ProGAL.geomNd.Vector getColumn(int c) {
        ProGAL.geomNd.Vector ret = new ProGAL.geomNd.Vector(this.M);
        for (int r = 0; r < this.M; ++r) {
            ret.set(r, this.coords[r][c]);
        }
        return ret;
    }

    public void setRow(int r, ProGAL.geomNd.Vector v) {
        for (int c = 0; c < Math.min(v.getDimensions(), this.N); ++c) {
            this.coords[r][c] = v.get(c);
        }
    }

    public void setColumn(int c, ProGAL.geomNd.Vector v) {
        for (int r = 0; r < Math.min(v.getDimensions(), this.M); ++r) {
            this.coords[r][c] = v.get(r);
        }
    }

    public Matrix getSubmatrix(int i1, int i2, int j1, int j2) {
        Matrix X = new Matrix(i2 - i1, j2 - j1);
        for (int i = 0; i < i2 - i1; ++i) {
            for (int j = 0; j < j2 - j1; ++j) {
                X.coords[i][j] = this.coords[i1 + i][j1 + j];
            }
        }
        return X;
    }

    public void setSubmatrix(int i1, int j1, Matrix M) {
        for (int i = 0; i < M.M; ++i) {
            for (int j = 0; j < M.N; ++j) {
                this.coords[i1 + i][j1 + j] = M.coords[i][j];
            }
        }
    }

    public Matrix getTranspose() {
        double[][] newCoords = new double[this.N][this.M];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                newCoords[j][i] = this.coords[i][j];
            }
        }
        return new Matrix(newCoords);
    }

    public Matrix transpose() {
        return this.getTranspose();
    }

    public ProGAL.geomNd.Vector multiplyIn(ProGAL.geomNd.Vector v) {
        if (this.N != v.getDimensions()) {
            throw new Error("Dimensions dont match");
        }
        double[] newCoords = new double[this.N];
        for (int r = 0; r < this.M; ++r) {
            for (int c = 0; c < this.N; ++c) {
                int n = r;
                newCoords[n] = newCoords[n] + this.coords[r][c] * v.get(c);
            }
        }
        v.setCoords(newCoords);
        return v;
    }

    public Point multiply(Point p) {
        return this.multiplyIn(p.clone());
    }

    public ProGAL.geom3d.Point multiply(ProGAL.geom3d.Point p) {
        return (ProGAL.geom3d.Point)this.multiplyIn(p.clone());
    }

    public Point multiplyIn(Point p) {
        int r;
        double[] ret = new double[this.M];
        for (r = 0; r < this.M; ++r) {
            for (int c = 0; c < this.N; ++c) {
                int n = r;
                ret[n] = ret[n] + p.get(c) * this.coords[r][c];
            }
        }
        for (r = 0; r < this.M; ++r) {
            p.set(r, ret[r]);
        }
        return p;
    }

    public Vector multiply(Vector v) {
        if (this.M == 3 && this.N == 3) {
            double[] ret = new double[3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n = i;
                    ret[n] = ret[n] + v.get(j) * this.coords[i][j];
                }
            }
            return new Vector(ret[0], ret[1], ret[2]);
        }
        if ((this.M == 4 || this.M == 3) && this.N == 4) {
            double[] ret = new double[3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n = i;
                    ret[n] = ret[n] + v.get(j) * this.coords[i][j];
                }
                int n = i;
                ret[n] = ret[n] + this.coords[i][3];
            }
            return new Vector(ret[0], ret[1], ret[2]);
        }
        throw new Error("Can only apply 3x3, 3x4 or 4x4 matrices to vectors");
    }

    public Matrix multiplyThis(Matrix m) {
        double[][] newCoords = new double[this.M][this.N];
        for (int r = 0; r < this.M; ++r) {
            for (int c = 0; c < this.N; ++c) {
                newCoords[r][c] = 0.0;
                for (int i = 0; i < this.N; ++i) {
                    double[] dArray = newCoords[r];
                    int n = c;
                    dArray[n] = dArray[n] + this.coords[r][i] * m.coords[i][c];
                }
            }
        }
        this.coords = newCoords;
        return this;
    }

    public Matrix multiply(Matrix m) {
        if (this.N != m.M) {
            throw new Error("Incompatible matrix sizes");
        }
        Matrix ret = new Matrix(this.M, m.N);
        double[][] newCoords = ret.coords;
        for (int r = 0; r < this.M; ++r) {
            for (int c = 0; c < m.N; ++c) {
                for (int i = 0; i < this.N; ++i) {
                    double[] dArray = newCoords[r];
                    int n = c;
                    dArray[n] = dArray[n] + this.coords[r][i] * m.coords[i][c];
                }
            }
        }
        return ret;
    }

    public Matrix multiply_Strassen(Matrix B) {
        if (this.N != B.M) {
            throw new Error("Incompatible matrix sizes");
        }
        Matrix extA = this.expand();
        Matrix extB = B.expand();
        return extA.multiply_Strassen_regular(extB);
    }

    private Matrix multiply_Strassen_regular(Matrix B) {
        Matrix C = new Matrix(this.M, this.M);
        if (this.M == 1) {
            C.coords[0][0] = this.coords[0][0] * B.coords[0][0];
            return C;
        }
        Matrix A11 = this.getSubmatrix(0, this.M / 2, 0, this.M / 2);
        Matrix A12 = this.getSubmatrix(0, this.M / 2, this.M / 2, this.M);
        Matrix A21 = this.getSubmatrix(this.M / 2, this.M, 0, this.M / 2);
        Matrix A22 = this.getSubmatrix(this.M / 2, this.M, this.M / 2, this.M);
        Matrix B11 = B.getSubmatrix(0, this.M / 2, 0, this.M / 2);
        Matrix B12 = B.getSubmatrix(0, this.M / 2, this.M / 2, this.M);
        Matrix B21 = B.getSubmatrix(this.M / 2, this.M, 0, this.M / 2);
        Matrix B22 = B.getSubmatrix(this.M / 2, this.M, this.M / 2, this.M);
        Matrix M1 = A11.add(A22).multiply_Strassen_regular(B11.add(B22));
        Matrix M2 = A21.add(A22).multiply_Strassen_regular(B11);
        Matrix M3 = A11.multiply_Strassen_regular(B12.subtract(B22));
        Matrix M4 = A22.multiply_Strassen_regular(B21.subtract(B11));
        Matrix M5 = A11.add(A12).multiply_Strassen_regular(B22);
        Matrix M6 = A21.subtract(A11).multiply_Strassen_regular(B11.add(B12));
        Matrix M7 = A12.subtract(A22).multiply_Strassen_regular(B21.add(B22));
        C.setSubmatrix(0, 0, M1.add(M4).subtract(M5).add(M7));
        C.setSubmatrix(0, this.M / 2, M3.add(M5));
        C.setSubmatrix(this.M / 2, 0, M2.add(M4));
        C.setSubmatrix(this.M / 2, this.M / 2, M1.subtract(M2).add(M3).add(M6));
        return C;
    }

    public Matrix add(Matrix m) {
        Matrix ret = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                ret.set(i, j, this.coords[i][j] + m.coords[i][j]);
            }
        }
        return ret;
    }

    public Matrix addThis(Matrix m) {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                double[] dArray = this.coords[i];
                int n = j;
                dArray[n] = dArray[n] + m.coords[i][j];
            }
        }
        return this;
    }

    public Matrix subtract(Matrix m) {
        Matrix ret = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                ret.set(i, j, this.coords[i][j] - m.coords[i][j]);
            }
        }
        return ret;
    }

    public Matrix subtractThis(Matrix m) {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                double[] dArray = this.coords[i];
                int n = j;
                dArray[n] = dArray[n] - m.coords[i][j];
            }
        }
        return this;
    }

    public Matrix multiply(double scalar) {
        Matrix ret = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                ret.set(i, j, this.coords[i][j] * scalar);
            }
        }
        return ret;
    }

    public Matrix multiplyThis(double scalar) {
        for (int i = 0; i < this.M; ++i) {
            int j = 0;
            while (j < this.N) {
                double[] dArray = this.coords[i];
                int n = j++;
                dArray[n] = dArray[n] * scalar;
            }
        }
        return this;
    }

    public Matrix minor(int r, int c) {
        if (this.M < 2 || this.N < 2) {
            throw new Error("The minor matrix is undefined for " + this.M + "x" + this.N + " matrices");
        }
        Matrix ret = new Matrix(this.M - 1, this.N - 1);
        for (int i = 0; i < this.M - 1; ++i) {
            for (int j = 0; j < this.N - 1; ++j) {
                ret.set(i, j, this.coords[i >= r ? i + 1 : i][j >= c ? j + 1 : j]);
            }
        }
        return ret;
    }

    public double determinant() {
        if (this.M != this.N) {
            throw new Error("Determinant undefined for non-square matrix");
        }
        if (this.M == 1) {
            return this.coords[0][0];
        }
        return new LUDecomposition(this).det();
    }

    public boolean isSquare() {
        return this.M == this.N;
    }

    public Matrix extend() {
        Matrix X;
        if (this.M < this.N) {
            X = new Matrix(this.N, this.N);
            X.setSubmatrix(0, 0, this);
            for (int i = this.M; i < this.N; ++i) {
                for (int j = 0; j < this.N; ++j) {
                    X.coords[i][j] = 0.0;
                }
            }
        } else {
            X = new Matrix(this.M, this.M);
            X.setSubmatrix(0, 0, this);
            for (int j = this.N; j < this.M; ++j) {
                for (int i = 0; i < this.M; ++i) {
                    X.coords[i][j] = 0.0;
                }
            }
        }
        return X;
    }

    public Matrix expand() {
        int j;
        int i;
        Matrix X = this.extend();
        int ext = Functions.roundUpToPowerOf2(X.M);
        Matrix Y = new Matrix(ext, ext);
        Y.setSubmatrix(0, 0, X);
        for (i = 0; i < X.M; ++i) {
            for (j = X.M; j < ext; ++j) {
                Y.coords[i][j] = 0.0;
            }
        }
        for (i = X.M; i < ext; ++i) {
            for (j = 0; j < ext; ++j) {
                Y.coords[i][j] = 0.0;
            }
        }
        return Y;
    }

    public Matrix invert() {
        Matrix ret = this.clone();
        return ret.invertThis();
    }

    public Matrix invertThis() {
        int c;
        int r;
        if (!this.isSquare()) {
            throw new Error("Cant invert non-square matrix (" + this.M + "x" + this.N + ")");
        }
        Matrix tmp = new Matrix(this.M, 2 * this.N);
        for (r = 0; r < this.M; ++r) {
            for (c = 0; c < this.N; ++c) {
                tmp.set(r, c, this.get(r, c));
            }
            tmp.set(r, this.N + r, 1.0);
        }
        tmp.reduceThis();
        for (r = 0; r < this.M; ++r) {
            for (c = 0; c < this.N; ++c) {
                this.set(r, c, tmp.get(r, c + this.N));
            }
        }
        return this;
    }

    public Matrix reduce() {
        Matrix ret = this.clone();
        ret.reduceThis();
        return ret;
    }

    public Matrix reduceThis() {
        int rowCount = this.M;
        int colCount = this.N;
        int lead = 0;
        for (int r = 0; r < rowCount; ++r) {
            if (lead >= colCount) {
                return this;
            }
            int i = r;
            while (Math.abs(this.coords[i][lead]) <= Constants.EPSILON) {
                if (rowCount != ++i) continue;
                i = r;
                if (colCount != ++lead) continue;
                return this;
            }
            if (i != r) {
                double[] tmpArr = this.coords[i];
                this.coords[i] = this.coords[r];
                this.coords[r] = tmpArr;
            }
            double tmp = this.coords[r][lead];
            int c = 0;
            while (c < this.coords[r].length) {
                double[] dArray = this.coords[r];
                int n = c++;
                dArray[n] = dArray[n] / tmp;
            }
            for (i = 0; i < rowCount; ++i) {
                if (i == r) continue;
                tmp = this.coords[i][lead];
                for (c = 0; c < this.coords[i].length; ++c) {
                    double[] dArray = this.coords[i];
                    int n = c;
                    dArray[n] = dArray[n] - tmp * this.coords[r][c];
                }
            }
            ++lead;
        }
        return this;
    }

    public Matrix orthonormalizeThis() {
        int i;
        ProGAL.geomNd.Vector[] bs = new ProGAL.geomNd.Vector[this.N];
        bs[0] = this.getColumn(0);
        double[] bSq = new double[this.N];
        for (i = 1; i < this.N; ++i) {
            ProGAL.geomNd.Vector ai = this.getColumn(i);
            bs[i] = ai.clone();
            bSq[i - 1] = bs[i - 1].dot(bs[i - 1]);
            for (int j = 0; j < i; ++j) {
                bs[i].addThis(bs[j].multiply(-ai.dot(bs[j]) / bSq[j]));
            }
        }
        bSq[this.N - 1] = bs[this.N - 1].dot(bs[this.N - 1]);
        for (i = 0; i < this.N; ++i) {
            if (bSq[i] != 1.0) {
                bs[i].divideThis(Math.sqrt(bSq[i]));
            }
            for (int r = 0; r < this.M; ++r) {
                this.coords[i][r] = bs[i].get(r);
            }
        }
        return this;
    }

    public boolean equals(Matrix m) {
        if (this.M != m.M) {
            return false;
        }
        for (int r = 0; r < this.M; ++r) {
            if (Arrays.equals(this.coords[r], m.coords[r])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof Matrix) {
            return this.equals((Matrix)o);
        }
        return false;
    }

    public EigenvalueDecomposition getEigenvalueDecomposition() {
        return new EigenvalueDecomposition();
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int dec) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.M; ++i) {
            sb.append('|');
            for (int j = 0; j < this.N; ++j) {
                sb.append(String.format("% 9." + dec + "f", this.coords[i][j]));
                sb.append(' ');
            }
            sb.append('|');
            sb.append('\n');
        }
        return sb.toString();
    }

    public void toConsole() {
        this.toConsole(2);
    }

    public void toConsole(int dec) {
        System.out.print(this.toString(dec));
    }

    public Matrix clone() {
        Matrix ret = new Matrix(this.M, this.N);
        for (int r = 0; r < this.M; ++r) {
            for (int c = 0; c < this.N; ++c) {
                ret.coords[r][c] = this.coords[r][c];
            }
        }
        return ret;
    }

    public static Matrix createRandomMatrix(int n) {
        Matrix ret = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                ret.coords[i][j] = Randomization.randBetween(0.0, 1.0);
            }
        }
        return ret;
    }

    public static Matrix createIdentityMatrix(int n) {
        Matrix ret = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            ret.coords[i][i] = 1.0;
        }
        return ret;
    }

    public static Matrix3x3 createColumnMatrix(Vector v1, Vector v2, Vector v3) {
        int i;
        Matrix3x3 ret = new Matrix3x3();
        for (i = 0; i < 3; ++i) {
            ret.coords[i][0] = v1.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[i][1] = v2.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[i][2] = v3.get(i);
        }
        return ret;
    }

    public static Matrix create4x4ColumnMatrix(Vector v1, Vector v2, Vector v3, Vector v4) {
        int i;
        Matrix ret = new Matrix(4, 4);
        for (i = 0; i < 3; ++i) {
            ret.coords[i][0] = v1.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[i][1] = v2.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[i][2] = v3.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[i][3] = v4.get(i);
        }
        ret.coords[3][3] = 1.0;
        return ret;
    }

    public static Matrix3x3 createRowMatrix(Vector v1, Vector v2, Vector v3) {
        int i;
        Matrix3x3 ret = new Matrix3x3();
        for (i = 0; i < 3; ++i) {
            ret.coords[0][i] = v1.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[1][i] = v2.get(i);
        }
        for (i = 0; i < 3; ++i) {
            ret.coords[2][i] = v3.get(i);
        }
        return ret;
    }

    public static Matrix createRotationMatrix(double angle, Vector v) {
        double ux = v.x();
        double uy = v.y();
        double uz = v.z();
        double cosA = Math.cos(angle);
        double sinA = Math.sin(angle);
        Matrix3x3 ret = new Matrix3x3();
        ret.coords[0][0] = ux * ux + cosA * (1.0 - ux * ux);
        ret.coords[1][0] = ux * uy * (1.0 - cosA) + uz * sinA;
        ret.coords[2][0] = uz * ux * (1.0 - cosA) - uy * sinA;
        ret.coords[0][1] = ux * uy * (1.0 - cosA) - uz * sinA;
        ret.coords[1][1] = uy * uy + cosA * (1.0 - uy * uy);
        ret.coords[2][1] = uy * uz * (1.0 - cosA) + ux * sinA;
        ret.coords[0][2] = uz * ux * (1.0 - cosA) + uy * sinA;
        ret.coords[1][2] = uy * uz * (1.0 - cosA) - ux * sinA;
        ret.coords[2][2] = uz * uz + cosA * (1.0 - uz * uz);
        return ret;
    }

    Matrix getMatrix(int[] r, int j0, int j1) {
        Matrix X = new Matrix(r.length, j1 - j0 + 1);
        double[][] B = X.coords;
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i][j - j0] = this.coords[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public class EigenvalueDecomposition {
        private int n;
        private boolean issymmetric;
        private double[] d;
        private double[] e;
        private double[][] V;
        private double[][] H;
        private double[] ort;
        private transient double cdivr;
        private transient double cdivi;

        private void tred2() {
            int i;
            int j;
            for (j = 0; j < this.n; ++j) {
                this.d[j] = this.V[this.n - 1][j];
            }
            for (i = this.n - 1; i > 0; --i) {
                int k;
                double scale = 0.0;
                double h = 0.0;
                for (k = 0; k < i; ++k) {
                    scale += Math.abs(this.d[k]);
                }
                if (scale == 0.0) {
                    this.e[i] = this.d[i - 1];
                    for (int j2 = 0; j2 < i; ++j2) {
                        this.d[j2] = this.V[i - 1][j2];
                        this.V[i][j2] = 0.0;
                        this.V[j2][i] = 0.0;
                    }
                } else {
                    int j3;
                    int j4;
                    for (k = 0; k < i; ++k) {
                        int n = k;
                        this.d[n] = this.d[n] / scale;
                        h += this.d[k] * this.d[k];
                    }
                    double f = this.d[i - 1];
                    double g = Math.sqrt(h);
                    if (f > 0.0) {
                        g = -g;
                    }
                    this.e[i] = scale * g;
                    h -= f * g;
                    this.d[i - 1] = f - g;
                    for (j4 = 0; j4 < i; ++j4) {
                        this.e[j4] = 0.0;
                    }
                    for (j4 = 0; j4 < i; ++j4) {
                        this.V[j4][i] = f = this.d[j4];
                        g = this.e[j4] + this.V[j4][j4] * f;
                        for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                            g += this.V[k2][j4] * this.d[k2];
                            int n = k2;
                            this.e[n] = this.e[n] + this.V[k2][j4] * f;
                        }
                        this.e[j4] = g;
                    }
                    f = 0.0;
                    for (j4 = 0; j4 < i; ++j4) {
                        int n = j4;
                        this.e[n] = this.e[n] / h;
                        f += this.e[j4] * this.d[j4];
                    }
                    double hh = f / (h + h);
                    for (j3 = 0; j3 < i; ++j3) {
                        int n = j3;
                        this.e[n] = this.e[n] - hh * this.d[j3];
                    }
                    for (j3 = 0; j3 < i; ++j3) {
                        f = this.d[j3];
                        g = this.e[j3];
                        for (int k3 = j3; k3 <= i - 1; ++k3) {
                            double[] dArray = this.V[k3];
                            int n = j3;
                            dArray[n] = dArray[n] - (f * this.e[k3] + g * this.d[k3]);
                        }
                        this.d[j3] = this.V[i - 1][j3];
                        this.V[i][j3] = 0.0;
                    }
                }
                this.d[i] = h;
            }
            for (i = 0; i < this.n - 1; ++i) {
                int k;
                this.V[this.n - 1][i] = this.V[i][i];
                this.V[i][i] = 1.0;
                double h = this.d[i + 1];
                if (h != 0.0) {
                    for (k = 0; k <= i; ++k) {
                        this.d[k] = this.V[k][i + 1] / h;
                    }
                    for (int j5 = 0; j5 <= i; ++j5) {
                        int k4;
                        double g = 0.0;
                        for (k4 = 0; k4 <= i; ++k4) {
                            g += this.V[k4][i + 1] * this.V[k4][j5];
                        }
                        for (k4 = 0; k4 <= i; ++k4) {
                            double[] dArray = this.V[k4];
                            int n = j5;
                            dArray[n] = dArray[n] - g * this.d[k4];
                        }
                    }
                }
                for (k = 0; k <= i; ++k) {
                    this.V[k][i + 1] = 0.0;
                }
            }
            for (j = 0; j < this.n; ++j) {
                this.d[j] = this.V[this.n - 1][j];
                this.V[this.n - 1][j] = 0.0;
            }
            this.V[this.n - 1][this.n - 1] = 1.0;
            this.e[0] = 0.0;
        }

        private void tql2() {
            for (int i = 1; i < this.n; ++i) {
                this.e[i - 1] = this.e[i];
            }
            this.e[this.n - 1] = 0.0;
            double f = 0.0;
            double tst1 = 0.0;
            double eps = Math.pow(2.0, -52.0);
            for (int l = 0; l < this.n; ++l) {
                int m;
                tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
                for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
                }
                if (m > l) {
                    int iter = 0;
                    do {
                        double c;
                        ++iter;
                        double g = this.d[l];
                        double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                        double r = this.hypot(p, 1.0);
                        if (p < 0.0) {
                            r = -r;
                        }
                        this.d[l] = this.e[l] / (p + r);
                        this.d[l + 1] = this.e[l] * (p + r);
                        double dl1 = this.d[l + 1];
                        double h = g - this.d[l];
                        int i = l + 2;
                        while (i < this.n) {
                            int n = i++;
                            this.d[n] = this.d[n] - h;
                        }
                        f += h;
                        p = this.d[m];
                        double c2 = c = 1.0;
                        double c3 = c;
                        double el1 = this.e[l + 1];
                        double s = 0.0;
                        double s2 = 0.0;
                        for (int i2 = m - 1; i2 >= l; --i2) {
                            c3 = c2;
                            c2 = c;
                            s2 = s;
                            g = c * this.e[i2];
                            h = c * p;
                            r = this.hypot(p, this.e[i2]);
                            this.e[i2 + 1] = s * r;
                            s = this.e[i2] / r;
                            c = p / r;
                            p = c * this.d[i2] - s * g;
                            this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                            for (int k = 0; k < this.n; ++k) {
                                h = this.V[k][i2 + 1];
                                this.V[k][i2 + 1] = s * this.V[k][i2] + c * h;
                                this.V[k][i2] = c * this.V[k][i2] - s * h;
                            }
                        }
                        p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                        this.e[l] = s * p;
                        this.d[l] = c * p;
                    } while (Math.abs(this.e[l]) > eps * tst1);
                }
                this.d[l] = this.d[l] + f;
                this.e[l] = 0.0;
            }
            for (int i = 0; i < this.n - 1; ++i) {
                int j;
                int k = i;
                double p = this.d[i];
                for (j = i + 1; j < this.n; ++j) {
                    if (!(this.d[j] < p)) continue;
                    k = j;
                    p = this.d[j];
                }
                if (k == i) continue;
                this.d[k] = this.d[i];
                this.d[i] = p;
                for (j = 0; j < this.n; ++j) {
                    p = this.V[j][i];
                    this.V[j][i] = this.V[j][k];
                    this.V[j][k] = p;
                }
            }
        }

        private void orthes() {
            int m;
            int low = 0;
            int high = this.n - 1;
            for (m = low + 1; m <= high - 1; ++m) {
                double f;
                double scale = 0.0;
                for (int i = m; i <= high; ++i) {
                    scale += Math.abs(this.H[i][m - 1]);
                }
                if (scale == 0.0) continue;
                double h = 0.0;
                for (int i = high; i >= m; --i) {
                    this.ort[i] = this.H[i][m - 1] / scale;
                    h += this.ort[i] * this.ort[i];
                }
                double g = Math.sqrt(h);
                if (this.ort[m] > 0.0) {
                    g = -g;
                }
                h -= this.ort[m] * g;
                this.ort[m] = this.ort[m] - g;
                for (int j = m; j < this.n; ++j) {
                    int i;
                    f = 0.0;
                    for (i = high; i >= m; --i) {
                        f += this.ort[i] * this.H[i][j];
                    }
                    f /= h;
                    for (i = m; i <= high; ++i) {
                        double[] dArray = this.H[i];
                        int n = j;
                        dArray[n] = dArray[n] - f * this.ort[i];
                    }
                }
                for (int i = 0; i <= high; ++i) {
                    int j;
                    f = 0.0;
                    for (j = high; j >= m; --j) {
                        f += this.ort[j] * this.H[i][j];
                    }
                    f /= h;
                    for (j = m; j <= high; ++j) {
                        double[] dArray = this.H[i];
                        int n = j;
                        dArray[n] = dArray[n] - f * this.ort[j];
                    }
                }
                this.ort[m] = scale * this.ort[m];
                this.H[m][m - 1] = scale * g;
            }
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.V[i][j] = i == j ? 1.0 : 0.0;
                }
            }
            for (m = high - 1; m >= low + 1; --m) {
                if (this.H[m][m - 1] == 0.0) continue;
                for (int i = m + 1; i <= high; ++i) {
                    this.ort[i] = this.H[i][m - 1];
                }
                for (int j = m; j <= high; ++j) {
                    int i;
                    double g = 0.0;
                    for (i = m; i <= high; ++i) {
                        g += this.ort[i] * this.V[i][j];
                    }
                    g = g / this.ort[m] / this.H[m][m - 1];
                    for (i = m; i <= high; ++i) {
                        double[] dArray = this.V[i];
                        int n = j;
                        dArray[n] = dArray[n] + g * this.ort[i];
                    }
                }
            }
        }

        private void cdiv(double xr, double xi, double yr, double yi) {
            if (Math.abs(yr) > Math.abs(yi)) {
                double r = yi / yr;
                double d = yr + r * yi;
                this.cdivr = (xr + r * xi) / d;
                this.cdivi = (xi - r * xr) / d;
            } else {
                double r = yr / yi;
                double d = yi + r * yr;
                this.cdivr = (r * xr + xi) / d;
                this.cdivi = (r * xi - xr) / d;
            }
        }

        private void hqr2() {
            double y;
            int i;
            int j;
            double x;
            double w;
            int l;
            int j2;
            int nn = this.n;
            int n = nn - 1;
            int low = 0;
            int high = nn - 1;
            double eps = Math.pow(2.0, -52.0);
            double exshift = 0.0;
            double p = 0.0;
            double q = 0.0;
            double r = 0.0;
            double s = 0.0;
            double z = 0.0;
            double norm = 0.0;
            for (int i2 = 0; i2 < nn; ++i2) {
                if (i2 < low | i2 > high) {
                    this.d[i2] = this.H[i2][i2];
                    this.e[i2] = 0.0;
                }
                for (j2 = Math.max(i2 - 1, 0); j2 < nn; ++j2) {
                    norm += Math.abs(this.H[i2][j2]);
                }
            }
            int iter = 0;
            block2: while (n >= low) {
                int m;
                for (l = n; l > low; --l) {
                    s = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                    if (s == 0.0) {
                        s = norm;
                    }
                    if (Math.abs(this.H[l][l - 1]) < eps * s) break;
                }
                if (l == n) {
                    this.H[n][n] = this.H[n][n] + exshift;
                    this.d[n] = this.H[n][n];
                    this.e[n] = 0.0;
                    --n;
                    iter = 0;
                    continue;
                }
                if (l == n - 1) {
                    w = this.H[n][n - 1] * this.H[n - 1][n];
                    p = (this.H[n - 1][n - 1] - this.H[n][n]) / 2.0;
                    q = p * p + w;
                    z = Math.sqrt(Math.abs(q));
                    this.H[n][n] = this.H[n][n] + exshift;
                    this.H[n - 1][n - 1] = this.H[n - 1][n - 1] + exshift;
                    x = this.H[n][n];
                    if (q >= 0.0) {
                        z = p >= 0.0 ? p + z : p - z;
                        this.d[n - 1] = x + z;
                        this.d[n] = this.d[n - 1];
                        if (z != 0.0) {
                            this.d[n] = x - w / z;
                        }
                        this.e[n - 1] = 0.0;
                        this.e[n] = 0.0;
                        x = this.H[n][n - 1];
                        s = Math.abs(x) + Math.abs(z);
                        p = x / s;
                        q = z / s;
                        r = Math.sqrt(p * p + q * q);
                        p /= r;
                        q /= r;
                        for (j = n - 1; j < nn; ++j) {
                            z = this.H[n - 1][j];
                            this.H[n - 1][j] = q * z + p * this.H[n][j];
                            this.H[n][j] = q * this.H[n][j] - p * z;
                        }
                        for (i = 0; i <= n; ++i) {
                            z = this.H[i][n - 1];
                            this.H[i][n - 1] = q * z + p * this.H[i][n];
                            this.H[i][n] = q * this.H[i][n] - p * z;
                        }
                        for (i = low; i <= high; ++i) {
                            z = this.V[i][n - 1];
                            this.V[i][n - 1] = q * z + p * this.V[i][n];
                            this.V[i][n] = q * this.V[i][n] - p * z;
                        }
                    } else {
                        this.d[n - 1] = x + p;
                        this.d[n] = x + p;
                        this.e[n - 1] = z;
                        this.e[n] = -z;
                    }
                    n -= 2;
                    iter = 0;
                    continue;
                }
                x = this.H[n][n];
                y = 0.0;
                w = 0.0;
                if (l < n) {
                    y = this.H[n - 1][n - 1];
                    w = this.H[n][n - 1] * this.H[n - 1][n];
                }
                if (iter == 10) {
                    exshift += x;
                    i = low;
                    while (i <= n) {
                        double[] dArray = this.H[i];
                        int n2 = i++;
                        dArray[n2] = dArray[n2] - x;
                    }
                    s = Math.abs(this.H[n][n - 1]) + Math.abs(this.H[n - 1][n - 2]);
                    x = y = 0.75 * s;
                    w = -0.4375 * s * s;
                }
                if (iter == 30) {
                    s = (y - x) / 2.0;
                    if ((s = s * s + w) > 0.0) {
                        s = Math.sqrt(s);
                        if (y < x) {
                            s = -s;
                        }
                        s = x - w / ((y - x) / 2.0 + s);
                        i = low;
                        while (i <= n) {
                            double[] dArray = this.H[i];
                            int n3 = i++;
                            dArray[n3] = dArray[n3] - s;
                        }
                        exshift += s;
                        w = 0.964;
                        y = 0.964;
                        x = 0.964;
                    }
                }
                ++iter;
                for (m = n - 2; m >= l; --m) {
                    z = this.H[m][m];
                    r = x - z;
                    s = y - z;
                    p = (r * s - w) / this.H[m + 1][m] + this.H[m][m + 1];
                    q = this.H[m + 1][m + 1] - z - r - s;
                    r = this.H[m + 2][m + 1];
                    s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (m == l || Math.abs(this.H[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.H[m + 1][m + 1])))) break;
                }
                for (int i3 = m + 2; i3 <= n; ++i3) {
                    this.H[i3][i3 - 2] = 0.0;
                    if (i3 <= m + 2) continue;
                    this.H[i3][i3 - 3] = 0.0;
                }
                for (int k = m; k <= n - 1; ++k) {
                    int i4;
                    boolean notlast;
                    boolean bl = notlast = k != n - 1;
                    if (k != m) {
                        p = this.H[k][k - 1];
                        q = this.H[k + 1][k - 1];
                        r = notlast ? this.H[k + 2][k - 1] : 0.0;
                        x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                        if (x != 0.0) {
                            p /= x;
                            q /= x;
                            r /= x;
                        }
                    }
                    if (x == 0.0) continue block2;
                    s = Math.sqrt(p * p + q * q + r * r);
                    if (p < 0.0) {
                        s = -s;
                    }
                    if (s == 0.0) continue;
                    if (k != m) {
                        this.H[k][k - 1] = -s * x;
                    } else if (l != m) {
                        this.H[k][k - 1] = -this.H[k][k - 1];
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    for (int j3 = k; j3 < nn; ++j3) {
                        p = this.H[k][j3] + q * this.H[k + 1][j3];
                        if (notlast) {
                            this.H[k + 2][j3] = this.H[k + 2][j3] - (p += r * this.H[k + 2][j3]) * z;
                        }
                        this.H[k][j3] = this.H[k][j3] - p * x;
                        this.H[k + 1][j3] = this.H[k + 1][j3] - p * y;
                    }
                    for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                        p = x * this.H[i4][k] + y * this.H[i4][k + 1];
                        if (notlast) {
                            this.H[i4][k + 2] = this.H[i4][k + 2] - (p += z * this.H[i4][k + 2]) * r;
                        }
                        this.H[i4][k] = this.H[i4][k] - p;
                        this.H[i4][k + 1] = this.H[i4][k + 1] - p * q;
                    }
                    for (i4 = low; i4 <= high; ++i4) {
                        p = x * this.V[i4][k] + y * this.V[i4][k + 1];
                        if (notlast) {
                            this.V[i4][k + 2] = this.V[i4][k + 2] - (p += z * this.V[i4][k + 2]) * r;
                        }
                        this.V[i4][k] = this.V[i4][k] - p;
                        this.V[i4][k + 1] = this.V[i4][k + 1] - p * q;
                    }
                }
            }
            if (norm == 0.0) {
                return;
            }
            for (n = nn - 1; n >= 0; --n) {
                double t;
                p = this.d[n];
                q = this.e[n];
                if (q == 0.0) {
                    l = n;
                    this.H[n][n] = 1.0;
                    for (i = n - 1; i >= 0; --i) {
                        int j4;
                        w = this.H[i][i] - p;
                        r = 0.0;
                        for (j4 = l; j4 <= n; ++j4) {
                            r += this.H[i][j4] * this.H[j4][n];
                        }
                        if (this.e[i] < 0.0) {
                            z = w;
                            s = r;
                            continue;
                        }
                        l = i;
                        if (this.e[i] == 0.0) {
                            this.H[i][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                        } else {
                            x = this.H[i][i + 1];
                            y = this.H[i + 1][i];
                            q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                            this.H[i][n] = t = (x * s - z * r) / q;
                            this.H[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                        }
                        t = Math.abs(this.H[i][n]);
                        if (!(eps * t * t > 1.0)) continue;
                        for (j4 = i; j4 <= n; ++j4) {
                            this.H[j4][n] = this.H[j4][n] / t;
                        }
                    }
                    continue;
                }
                if (!(q < 0.0)) continue;
                l = n - 1;
                if (Math.abs(this.H[n][n - 1]) > Math.abs(this.H[n - 1][n])) {
                    this.H[n - 1][n - 1] = q / this.H[n][n - 1];
                    this.H[n - 1][n] = -(this.H[n][n] - p) / this.H[n][n - 1];
                } else {
                    this.cdiv(0.0, -this.H[n - 1][n], this.H[n - 1][n - 1] - p, q);
                    this.H[n - 1][n - 1] = this.cdivr;
                    this.H[n - 1][n] = this.cdivi;
                }
                this.H[n][n - 1] = 0.0;
                this.H[n][n] = 1.0;
                for (i = n - 2; i >= 0; --i) {
                    int j5;
                    double ra = 0.0;
                    double sa = 0.0;
                    for (j5 = l; j5 <= n; ++j5) {
                        ra += this.H[i][j5] * this.H[j5][n - 1];
                        sa += this.H[i][j5] * this.H[j5][n];
                    }
                    w = this.H[i][i] - p;
                    if (this.e[i] < 0.0) {
                        z = w;
                        r = ra;
                        s = sa;
                        continue;
                    }
                    l = i;
                    if (this.e[i] == 0.0) {
                        this.cdiv(-ra, -sa, w, q);
                        this.H[i][n - 1] = this.cdivr;
                        this.H[i][n] = this.cdivi;
                    } else {
                        double vi;
                        x = this.H[i][i + 1];
                        y = this.H[i + 1][i];
                        double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                        if (vr == 0.0 & (vi = (this.d[i] - p) * 2.0 * q) == 0.0) {
                            vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                        }
                        this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                        this.H[i][n - 1] = this.cdivr;
                        this.H[i][n] = this.cdivi;
                        if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                            this.H[i + 1][n - 1] = (-ra - w * this.H[i][n - 1] + q * this.H[i][n]) / x;
                            this.H[i + 1][n] = (-sa - w * this.H[i][n] - q * this.H[i][n - 1]) / x;
                        } else {
                            this.cdiv(-r - y * this.H[i][n - 1], -s - y * this.H[i][n], z, q);
                            this.H[i + 1][n - 1] = this.cdivr;
                            this.H[i + 1][n] = this.cdivi;
                        }
                    }
                    t = Math.max(Math.abs(this.H[i][n - 1]), Math.abs(this.H[i][n]));
                    if (!(eps * t * t > 1.0)) continue;
                    for (j5 = i; j5 <= n; ++j5) {
                        this.H[j5][n - 1] = this.H[j5][n - 1] / t;
                        this.H[j5][n] = this.H[j5][n] / t;
                    }
                }
            }
            for (int i5 = 0; i5 < nn; ++i5) {
                if (!(i5 < low | i5 > high)) continue;
                for (j = i5; j < nn; ++j) {
                    this.V[i5][j] = this.H[i5][j];
                }
            }
            for (j2 = nn - 1; j2 >= low; --j2) {
                for (i = low; i <= high; ++i) {
                    z = 0.0;
                    for (int k = low; k <= Math.min(j2, high); ++k) {
                        z += this.V[i][k] * this.H[k][j2];
                    }
                    this.V[i][j2] = z;
                }
            }
        }

        private double hypot(double a, double b) {
            if (Math.abs(a) > Math.abs(b)) {
                double r = b / a;
                return Math.abs(a) * Math.sqrt(1.0 + r * r);
            }
            if (b != 0.0) {
                double r = a / b;
                return Math.abs(b) * Math.sqrt(1.0 + r * r);
            }
            return 0.0;
        }

        protected EigenvalueDecomposition() {
            int i;
            double[][] A = Matrix.this.coords;
            this.n = Matrix.this.N;
            this.V = new double[this.n][this.n];
            this.d = new double[this.n];
            this.e = new double[this.n];
            this.issymmetric = true;
            int j = 0;
            while (j < this.n & this.issymmetric) {
                i = 0;
                while (i < this.n & this.issymmetric) {
                    this.issymmetric = A[i][j] == A[j][i];
                    ++i;
                }
                ++j;
            }
            if (this.issymmetric) {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    for (int j2 = 0; j2 < this.n; ++j2) {
                        this.V[i2][j2] = A[i2][j2];
                    }
                }
                this.tred2();
                this.tql2();
            } else {
                this.H = new double[this.n][this.n];
                this.ort = new double[this.n];
                for (j = 0; j < this.n; ++j) {
                    for (i = 0; i < this.n; ++i) {
                        this.H[i][j] = A[i][j];
                    }
                }
                this.orthes();
                this.hqr2();
            }
        }

        public Matrix getV() {
            return new ImmutableMatrix(this.V);
        }

        public double[] getRealEigenvalues() {
            return this.d;
        }

        public double[] getImagEigenvalues() {
            return this.e;
        }

        public Matrix getD() {
            Matrix X = new Matrix(this.n, this.n);
            double[][] D = X.coords;
            for (int i = 0; i < this.n; ++i) {
                D[i][i] = this.d[i];
                if (this.e[i] > 0.0) {
                    D[i][i + 1] = this.e[i];
                    continue;
                }
                if (!(this.e[i] < 0.0)) continue;
                D[i][i - 1] = this.e[i];
            }
            return X;
        }
    }

    public static class ImmutableMatrix
    extends Matrix {
        public ImmutableMatrix(double[][] coords) {
            super(coords);
        }

        @Override
        public void set(int r, int c, double v) {
            throw new RuntimeException("This matrix is immutable");
        }

        @Override
        public Matrix multiplyThis(Matrix m) {
            return this.multiply(m);
        }

        @Override
        public Matrix addThis(Matrix m) {
            return this.add(m);
        }

        @Override
        public Matrix multiplyThis(double s) {
            return this.multiply(s);
        }

        @Override
        public Matrix invertThis() {
            return this.invert();
        }
    }
}

