/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geomNd;

import ProGAL.geomNd.Point;
import ProGAL.math.Constants;
import ProGAL.math.Matrix;
import ProGAL.math.Randomization;

public class Vector {
    protected double[] coords;
    protected final int dim;

    public Vector(Point p) {
        this.dim = p.dim;
        this.coords = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.coords[d] = p.coords[d];
        }
    }

    public Vector(Point p1, Point p2) {
        this.dim = p1.dim;
        this.coords = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.coords[d] = p2.coords[d] - p1.coords[d];
        }
    }

    public Vector(Vector v) {
        this.dim = v.dim;
        this.coords = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.coords[d] = v.coords[d];
        }
    }

    public Vector(double[] coords) {
        this.dim = coords.length;
        this.coords = coords;
    }

    public Vector(int dim) {
        this.dim = dim;
        this.coords = new double[dim];
    }

    public double getCoord(int i) {
        return this.coords[i];
    }

    public double get(int i) {
        return this.getCoord(i);
    }

    public int getDimensions() {
        return this.coords.length;
    }

    public void setCoord(int i, double v) {
        this.coords[i] = v;
    }

    public void setCoords(double[] coords) {
        for (int i = 0; i < Math.min(coords.length, this.coords.length); ++i) {
            this.coords[i] = coords[i];
        }
    }

    public void set(int i, double v) {
        this.setCoord(i, v);
    }

    public double getLengthSquared() {
        double sum = 0.0;
        for (int d = 0; d < this.dim; ++d) {
            sum += this.coords[d] * this.coords[d];
        }
        return sum;
    }

    public double length() {
        return Math.sqrt(this.getLengthSquared());
    }

    public boolean isZeroVector() {
        for (int d = 0; d < this.dim; ++d) {
            if (!(Math.abs(this.coords[d]) > Constants.EPSILON)) continue;
            return false;
        }
        return true;
    }

    public double dot(Vector v) {
        double sum = 0.0;
        for (int d = 0; d < this.dim; ++d) {
            sum += this.coords[d] * v.coords[d];
        }
        return sum;
    }

    public double angle(Vector v) {
        return Math.acos(Math.min(1.0, this.dot(v) / Math.sqrt(this.getLengthSquared() * v.getLengthSquared())));
    }

    public Vector add(Vector v) {
        double[] sum = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            sum[d] = this.coords[d] + v.coords[d];
        }
        return new Vector(sum);
    }

    public Vector addThis(Vector v) {
        for (int d = 0; d < this.dim; ++d) {
            int n = d;
            this.coords[n] = this.coords[n] + v.coords[d];
        }
        return this;
    }

    public Vector subtract(Vector v) {
        double[] sum = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            sum[d] = this.coords[d] - v.coords[d];
        }
        return new Vector(sum);
    }

    public Vector subtractThis(Vector v) {
        for (int d = 0; d < this.dim; ++d) {
            int n = d;
            this.coords[n] = this.coords[n] - v.coords[d];
        }
        return this;
    }

    public Vector multiply(double s) {
        double[] ret = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            ret[d] = this.coords[d] * s;
        }
        return new Vector(ret);
    }

    public Vector multiplyThis(double s) {
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.coords[n] = this.coords[n] * s;
        }
        return this;
    }

    public Vector divide(double s) {
        double[] ret = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            ret[d] = this.coords[d] / s;
        }
        return new Vector(ret);
    }

    public Vector divideThis(double s) {
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.coords[n] = this.coords[n] / s;
        }
        return this;
    }

    public Matrix outerProduct(Vector v) {
        Matrix M = new Matrix(this.dim, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                M.set(i, j, this.coords[i] * this.coords[j]);
            }
        }
        return M;
    }

    public Vector normalize() {
        return this.multiply(1.0 / this.length());
    }

    public Vector normalizeThis() {
        return this.multiplyThis(1.0 / this.length());
    }

    public Vector scaleToLength(double length) {
        return this.multiply(length / this.length());
    }

    public Vector scaleToLengthThis(double length) {
        return this.multiplyThis(length / this.length());
    }

    public Point toPoint() {
        return new Point(this.clone().coords);
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        StringBuilder sb = new StringBuilder();
        sb.append("Vector[");
        for (int d = 0; d < this.dim - 1; ++d) {
            sb.append(String.format("%." + dec + "f, ", this.coords[d]));
        }
        sb.append(String.format("%." + dec + "f]", this.coords[this.dim - 1]));
        return sb.toString();
    }

    public void toConsole() {
        this.toConsole(2);
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    public boolean equals(Vector v) {
        for (int d = 0; d < this.dim; ++d) {
            if (!(Math.abs(this.coords[d] - v.coords[d]) > Constants.EPSILON)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object v) {
        if (v instanceof Vector) {
            return this.equals((Vector)v);
        }
        return false;
    }

    public Vector clone() {
        double[] newCoords = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            newCoords[d] = this.coords[d];
        }
        return new Vector(newCoords);
    }

    public static double getAngle(Vector u, Vector v) {
        return u.angle(v);
    }

    public static Vector randomVector(int dim, double len) {
        Vector ret = new Vector(dim);
        do {
            for (int d = 0; d < dim; ++d) {
                ret.coords[d] = Randomization.randBetween(-1.0, 1.0);
            }
        } while (ret.length() > 1.0);
        ret.multiplyThis(len / ret.length());
        return ret;
    }
}

