/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.ParametricPlane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.Rectangle;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Volume;
import ProGAL.math.Matrix3x3;
import java.util.Arrays;

public class RSS
implements Volume {
    public Rectangle rectangle;
    public double radius;

    public RSS(Point center, Vector[] bases, double radius) {
        this.rectangle = new Rectangle(center, bases);
        this.radius = radius;
    }

    @Override
    public boolean overlaps(Volume vol) {
        if (vol instanceof RSS) {
            return this.overlaps((RSS)vol);
        }
        throw new Error("Unimplemented (" + vol.getClass().getSimpleName() + ")");
    }

    public boolean overlaps(RSS rss) {
        double sqRads = this.radius + rss.radius;
        sqRads *= sqRads;
        double sqCenterDist = this.rectangle.center.distanceSquared(rss.rectangle.center);
        if (sqCenterDist <= sqRads) {
            return true;
        }
        return this.rectangle.distance(rss.rectangle) <= this.radius + rss.radius;
    }

    @Override
    public double getVolume() {
        double boxVol = this.rectangle.bases[0].length() * this.rectangle.bases[1].length() * this.radius * 8.0;
        double cylVol = 2.0 * (this.rectangle.bases[0].length() + this.rectangle.bases[1].length()) * 3.1415927410125732 * this.radius * this.radius;
        double sphereVol = 3.1415927410125732 * this.radius * this.radius * this.radius * 4.0 / 3.0;
        return boxVol + cylVol + sphereVol;
    }

    @Override
    public Point getCenter() {
        return this.rectangle.center;
    }

    public String toString() {
        return String.format("RSS[center:%s,bases[%s,%s],radius:%f]", this.rectangle.center, this.rectangle.bases[0], this.rectangle.bases[1], this.radius);
    }

    public static RSS createBoundingRSS_covariance(PointList points) {
        Vector tmp;
        Matrix3x3 covMatr = points.getCovariance();
        Vector[] eigenVecs = covMatr.getEigenvectors();
        if (eigenVecs[0].length() < eigenVecs[1].length()) {
            tmp = eigenVecs[0];
            eigenVecs[0] = eigenVecs[1];
            eigenVecs[1] = tmp;
        }
        if (eigenVecs[0].length() < eigenVecs[2].length()) {
            tmp = eigenVecs[0];
            eigenVecs[0] = eigenVecs[2];
            eigenVecs[2] = tmp;
        }
        if (eigenVecs[1].length() < eigenVecs[2].length()) {
            tmp = eigenVecs[1];
            eigenVecs[1] = eigenVecs[2];
            eigenVecs[2] = tmp;
        }
        eigenVecs[0].normalizeThis();
        eigenVecs[1].normalizeThis();
        eigenVecs[2] = eigenVecs[0].cross(eigenVecs[1]);
        RSS ret = RSS.createBoundingRSSFromBases(eigenVecs, points);
        return ret;
    }

    private static RSS createBoundingRSSFromBases(Vector[] bases, PointList points) {
        double lowestDot = Double.POSITIVE_INFINITY;
        double highestDot = Double.NEGATIVE_INFINITY;
        for (Point p : points) {
            double dot = bases[2].dot(p.toVector());
            if (dot < lowestDot) {
                lowestDot = dot;
            }
            if (!(dot > highestDot)) continue;
            highestDot = dot;
        }
        double radius = (highestDot - lowestDot) / 2.0;
        if (radius < 1.0E-4) {
            radius = 1.0E-4;
        }
        ParametricPlane P = new ParametricPlane(bases[2].multiply((highestDot + lowestDot) / 2.0).toPoint(), bases[0], bases[1]);
        double[] dots = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (Point p : points) {
            double[] proj = P.projectPoint(p);
            double delta = Math.sqrt(radius * radius - proj[2] * proj[2]);
            if (radius * radius < proj[2] * proj[2]) {
                delta = 0.0;
            }
            if (proj[0] + delta < dots[0]) {
                dots[0] = proj[0] + delta;
            }
            if (proj[0] - delta > dots[1]) {
                dots[1] = proj[0] - delta;
            }
            if (proj[1] + delta < dots[2]) {
                dots[2] = proj[1] + delta;
            }
            if (!(proj[1] - delta > dots[3])) continue;
            dots[3] = proj[1] - delta;
        }
        double[] pars = new double[]{(dots[0] + dots[1]) / 2.0, (dots[2] + dots[3]) / 2.0};
        double[] dim = new double[]{(dots[1] - dots[0]) / 2.0, (dots[3] - dots[2]) / 2.0};
        Point center = new Point(P.getP(pars));
        Vector[] rssBases = new Vector[]{bases[0].multiply(dim[0]), bases[1].multiply(dim[1])};
        if (Double.isNaN(center.x())) {
            throw new Error(" nana " + Arrays.toString(dots));
        }
        return new RSS(center, rssBases, radius);
    }

    public static RSS createBoundingRSS_covariance(RSS s1, RSS s2) {
        PointList points = new PointList();
        for (Point p : s1.rectangle.getCorners()) {
            points.add(p);
        }
        for (Point p : s2.rectangle.getCorners()) {
            points.add(p);
        }
        RSS ret = RSS.createBoundingRSS_covariance(points);
        ret.radius += Math.max(s1.radius, s2.radius);
        return ret;
    }

    @Override
    public RSS clone() {
        Point p = this.rectangle.center.clone();
        Vector[] bases = new Vector[]{this.rectangle.bases[0].clone(), this.rectangle.bases[1].clone()};
        return new RSS(p, bases, this.radius);
    }
}

