/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Line;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.InfCylinder;
import ProGAL.geom3d.volumes.Volume;
import ProGAL.math.Constants;
import ProGAL.math.Matrix3x3;

public class Cylinder
implements Volume {
    protected double rad;
    protected LineSegment segment;

    public Cylinder(Point p1, Point p2, double r) {
        this(new LineSegment(p1, p2), r);
    }

    public Cylinder(LineSegment sgm, double r) {
        this.rad = r;
        this.segment = sgm;
    }

    public LineSegment getSegment() {
        return this.segment;
    }

    public double getLength() {
        return 2.0 * this.segment.getLength();
    }

    public double getRadius() {
        return this.rad;
    }

    @Override
    public double getVolume() {
        return Math.PI * this.rad * this.rad * this.getLength();
    }

    public double getSurfaceArea() {
        return Math.PI * 2 * this.rad * (this.rad + this.getLength());
    }

    public void setSegment(LineSegment sgm) {
        this.segment = sgm;
    }

    public boolean inCylinder(Point p) {
        return this.segment.getDistance(p) < this.rad;
    }

    public Double intersectionParameter(Line l) {
        Vector d = this.segment.getAToB();
        Vector m = this.segment.getA().vectorTo(l.getP());
        Vector n = l.getDir();
        double md = m.dot(d);
        double nd = n.dot(d);
        double dd = d.dot(d);
        if (md < 0.0 && md + nd < 0.0) {
            return null;
        }
        if (md > dd && md + nd > dd) {
            return null;
        }
        double nn = n.dot(n);
        double mn = m.dot(n);
        double a = dd * nn - nd * nd;
        double k = m.dot(m) - this.rad * this.rad;
        double c = dd * k - md * md;
        if (Math.abs(a) < Constants.EPSILON) {
            if (c > 0.0) {
                return null;
            }
            double t = md < 0.0 ? -mn / nn : (md > dd ? (nd - mn) / nn : 0.0);
            if (t > 0.0) {
                return t;
            }
            return null;
        }
        double b = dd * mn - nd * md;
        double discr = b * b - a * c;
        if (discr < 0.0) {
            return null;
        }
        double t = (-b - Math.sqrt(discr)) / a;
        double t0 = t = (-b - Math.sqrt(discr)) / a;
        if (md + t * nd < 0.0) {
            if (nd <= 0.0) {
                return null;
            }
            t = -md / nd;
            if (k + t * (2.0 * mn + t * nn) <= 0.0) {
                return t;
            }
        } else if (md + t * nd > dd) {
            if (nd >= 0.0) {
                return 0.0;
            }
            t = (dd - md) / nd;
            if (k + dd - 2.0 * md + t * (2.0 * (mn - nd) + t * nn) <= 0.0) {
                return t;
            }
        }
        t = t0;
        return t;
    }

    public static void main(String[] args) {
        Line l = new Line(new Point(0.0, 1.01, 0.0), new Vector(1.0, 0.0, 0.0));
        Cylinder cyl = new Cylinder(new Point(3.0, 1.0, 0.0), new Point(3.0, -1.0, 0.0), 1.0);
        System.out.println(cyl.intersectionParameter(l));
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        return String.format("Cylinder[%s,rad=%." + dec + "f]", this.segment.toString(dec), this.rad);
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    @Override
    public Point getCenter() {
        return this.segment.getMidPoint();
    }

    public static Cylinder createBoundingCylinder_CovarianceFit(PointList points) {
        if (points.size() <= 0) {
            throw new Error("Cannot create cylinder enclosing 0 points");
        }
        if (points.size() == 1) {
            return new Cylinder(((Point)points.get(0)).clone(), ((Point)points.get(0)).clone(), 0.0);
        }
        if (points.size() == 2) {
            return new Cylinder(((Point)points.get(0)).clone(), ((Point)points.get(1)).clone(), 0.0);
        }
        Matrix3x3 covMatr = points.getCovariance();
        Vector[] eigenVecs = covMatr.getEigenvectors();
        Vector dir = eigenVecs[0];
        if (eigenVecs[1].length() > dir.length()) {
            dir = eigenVecs[1];
        }
        if (eigenVecs[2].length() > dir.length()) {
            dir = eigenVecs[2];
        }
        InfCylinder iCyl = InfCylinder.createMinRadCylinderFromDirection(points, dir);
        Cylinder ret = iCyl.capWithDiscs(points);
        return ret;
    }

    @Override
    public boolean overlaps(Volume vol) {
        throw new Error("Not implemented");
    }

    @Override
    public Cylinder clone() {
        return new Cylinder(this.segment.clone(), this.rad);
    }
}

