/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.tessellation.BowyerWatson;

import ProGAL.geom3d.PointWeighted;
import ProGAL.geom3d.tessellation.BowyerWatson.ShewchuckPredicates;
import ProGAL.geom3d.tessellation.BowyerWatson.Tetr;
import ProGAL.math.Randomization;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class RegularTessellation {
    private final Tetr bigTetr;
    private final LinkedList<Tetr> tetras = new LinkedList();
    private final LinkedList<PointWeighted> points = new LinkedList();
    private int lastSize = 1;
    private final Queue<Tetr> lastQueue = new LinkedList<Tetr>();
    private static final int[] shared1 = new int[3];
    private static final int[] shared2 = new int[3];
    private final ShewchuckPredicates pred = ShewchuckPredicates.getInstance();

    public static void main(String[] args) {
        Tetr t = new Tetr(new PointWeighted(9.8, 9.19, -4.53, 0.0), new PointWeighted(8.73, 9.54, -0.53, 0.0), new PointWeighted(9.44, 9.78, 5.35, 0.0), new PointWeighted(9.97, 8.47, 2.45, 0.0));
        Randomization.seed(0L);
        int insertedPoints = 1000000;
        LinkedList<PointWeighted> points = new LinkedList<PointWeighted>();
        for (int i = 0; i < insertedPoints; ++i) {
            PointWeighted pw = new PointWeighted(Randomization.randBetween(-10.0, 10.0), Randomization.randBetween(-10.0, 10.0), Randomization.randBetween(-10.0, 10.0), 0.0);
            points.add(pw);
        }
        long start = System.nanoTime();
        RegularTessellation rc = new RegularTessellation(points);
        long end = System.nanoTime();
        System.out.printf("%d points took %.3fms\n", insertedPoints, (double)(end - start) / 1000000.0);
    }

    public RegularTessellation() {
        this.bigTetr = this.createBigTetr();
    }

    public RegularTessellation(List<PointWeighted> points) {
        this();
        int c = 0;
        for (PointWeighted pw : points) {
            this.insertPoint(pw);
            if (++c % 10000 != 0) continue;
            System.out.println(c);
        }
    }

    public void insertPoint(PointWeighted p) {
        Tetr tet = this.walk(p);
        LinkedList<Tetr> star = new LinkedList<Tetr>();
        this.collectStar(p, tet, star);
        if (star.size() == 0) {
            throw new IllegalArgumentException("point fails because it is not within the circumsphere of tet");
        }
        LinkedList<Tetr> newStar = new LinkedList<Tetr>();
        for (Tetr t : star) {
            for (int i = 0; i < 4; ++i) {
                if (t.neighbors[i] != null && star.contains(t.neighbors[i])) continue;
                Tetr newTet = new Tetr(p, t.corners[i + 1 & 3], t.corners[i + 2 & 3], t.corners[i + 3 & 3]);
                newTet.neighbors[0] = t.neighbors[i];
                if (t.neighbors[i] != null) {
                    RegularTessellation.oneConnect(t.neighbors[i], newTet);
                }
                newStar.add(newTet);
            }
        }
        for (Tetr t1 : newStar) {
            Tetr t2;
            Iterator iterator = newStar.iterator();
            while (iterator.hasNext() && t1 != (t2 = (Tetr)iterator.next())) {
                RegularTessellation.connect(t1, t2);
            }
        }
        this.points.add(p);
        this.lastQueue.add((Tetr)newStar.get(0));
        this.lastSize = Math.max(1, (int)Math.pow(this.points.size(), 0.25));
        while (this.lastQueue.size() > this.lastSize) {
            this.lastQueue.poll();
        }
    }

    private static void connect(Tetr t1, Tetr t2) {
        int s = 1;
        RegularTessellation.shared1[0] = 0;
        RegularTessellation.shared2[0] = 0;
        for (int i = 1; i < 4; ++i) {
            int partner = -1;
            for (int c = 1; c < 4; ++c) {
                if (t2.corners[c] != t1.corners[i]) continue;
                partner = c;
                break;
            }
            if (partner <= 0) continue;
            RegularTessellation.shared1[s] = i;
            RegularTessellation.shared2[s] = partner;
            if (++s == 3 || i > s + 1) break;
        }
        if (s == 3) {
            t1.neighbors[RegularTessellation.excluded((int[])RegularTessellation.shared1)] = t2;
            t2.neighbors[RegularTessellation.excluded((int[])RegularTessellation.shared2)] = t1;
        }
    }

    private static int excluded(int[] arr) {
        block0: for (int i = 1; i < 4; ++i) {
            for (int v : arr) {
                if (v == i) continue block0;
            }
            return i;
        }
        return -1;
    }

    private static void oneConnect(Tetr t1, Tetr t2) {
        for (int i = 0; i < 4; ++i) {
            int idx = t2.cornerIdx(t1.corners[i]);
            if (idx >= 0) continue;
            t1.neighbors[i] = t2;
            return;
        }
    }

    private void collectStar(PointWeighted p, Tetr t, Collection<Tetr> star) {
        if (this.regular(t.corners[0], t.corners[1], t.corners[2], t.corners[3], p) > 0.0) {
            star.add(t);
            if (t.neighbors[0] != null && !star.contains(t.neighbors[0])) {
                this.collectStar(p, t.neighbors[0], star);
            }
            if (t.neighbors[1] != null && !star.contains(t.neighbors[1])) {
                this.collectStar(p, t.neighbors[1], star);
            }
            if (t.neighbors[2] != null && !star.contains(t.neighbors[2])) {
                this.collectStar(p, t.neighbors[2], star);
            }
            if (t.neighbors[3] != null && !star.contains(t.neighbors[3])) {
                this.collectStar(p, t.neighbors[3], star);
            }
        }
    }

    public Tetr walk(PointWeighted p) {
        Tetr t = this.bigTetr;
        double minDistSq = Double.POSITIVE_INFINITY;
        for (Tetr last : this.lastQueue) {
            double dSq = last.corners[1].distanceSquared(p);
            if (!(dSq < minDistSq)) continue;
            minDistSq = dSq;
            t = last;
        }
        Tetr t1 = null;
        while (true) {
            for (int i = 0; i < 4; ++i) {
                int orient = (int)Math.signum(this.orient(t.corners[i + 1 & 3], t.corners[i + 2 & 3], t.corners[i + 3 & 3], p));
                if (orient == t.cornerSides[i] || orient == 0) continue;
                Tetr t2 = t1;
                t1 = t;
                t = t.neighbors[i];
                if (t == t2) {
                    throw new IllegalArgumentException("loop in walk.");
                }
                if (t != null) continue;
                throw new IllegalArgumentException("neighbor is null--is this because the point outside of the tesselation?");
            }
            break;
        }
        return t;
    }

    private Tetr createBigTetr() {
        double max = 100.0;
        PointWeighted c0 = new PointWeighted(-max, -max, 0.0, 0.0);
        PointWeighted c1 = new PointWeighted(max, -max, 0.0, 0.0);
        PointWeighted c2 = new PointWeighted(0.0, max, -max, 0.0);
        PointWeighted c3 = new PointWeighted(0.0, max, max, 0.0);
        Tetr ret = new Tetr(c0, c1, c2, c3);
        return ret;
    }

    public boolean bigTet(Tetr t) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (t.corners[i] != this.bigTetr.corners[j]) continue;
                return true;
            }
        }
        return false;
    }

    protected double regular(PointWeighted c0, PointWeighted c1, PointWeighted c2, PointWeighted c3, PointWeighted p) {
        double insphere = this.pred.insphere(c0.getCoords(), c1.getCoords(), c2.getCoords(), c3.getCoords(), p.getCoords());
        if (insphere == 0.0) {
            return 0.0;
        }
        double orient = this.pred.orient(c0.getCoords(), c1.getCoords(), c2.getCoords(), c3.getCoords());
        return insphere * orient;
    }

    protected double orient(PointWeighted c0, PointWeighted c1, PointWeighted c2, PointWeighted q) {
        return this.pred.orient(c0.getCoords(), c1.getCoords(), c2.getCoords(), q.getCoords());
    }
}

