/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.kineticDelaunay;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.kineticDelaunay.KineticAlphaComplex;
import ProGAL.geom3d.kineticDelaunay.Tet;
import ProGAL.geom3d.volumes.Sphere;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;

public class Vertex
extends Point
implements Comparable<Vertex> {
    private static final long serialVersionUID = 1L;
    private VertexType type;
    private double polarAngle;
    private double initAngle = -1.0;
    private double cosAngle;
    private double sinAngle;
    private double polarRadius;
    private double squaredPolarRadius;
    private Tet tet;
    private int depth = 999999;
    private Sphere sphere;
    public boolean flag = false;
    public String atomName;
    public int atomType;
    public char aaType;
    public double e;
    public HashSet<Vertex> adjacentVertices = null;
    private ArrayList<Vertex> adjacentVerticesFast = new ArrayList();
    private ArrayList<Tet> processedTetsFast = new ArrayList();
    private int index = indexCounter++;
    public int atomId;
    public static int indexCounter = 0;

    public Vertex(Point p) {
        super(p);
    }

    public int getId() {
        return this.index;
    }

    public void setId(int index) {
        this.index = index;
    }

    public VertexType getType() {
        return this.type;
    }

    public void setType(VertexType type) {
        this.type = type;
    }

    public double getPolarRadius() {
        return this.polarRadius;
    }

    public void setPolarRadius(double polarRadius) {
        this.polarRadius = polarRadius;
    }

    public double getSquaredPolarRadius() {
        return this.squaredPolarRadius;
    }

    public void setSquaredPolarRadius(double sqPR) {
        this.squaredPolarRadius = sqPR;
    }

    public double getPolarAngle() {
        return this.polarAngle;
    }

    public void setPolarAngle(double polarAngle) {
        this.polarAngle = polarAngle;
    }

    public double getInitAngle() {
        return this.initAngle;
    }

    public void setInitAngle(double initAngle) {
        if (this.initAngle == -1.0) {
            this.initAngle = initAngle;
        }
    }

    public Point returnAsPoint() {
        return new Point(this.toVector());
    }

    public double getCosAngle() {
        return this.cosAngle;
    }

    public void setCosAngle(double cosAngle) {
        this.cosAngle = cosAngle;
    }

    public double getSinAngle() {
        return this.sinAngle;
    }

    public void setSinAngle(double sinAngle) {
        this.sinAngle = sinAngle;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public ArrayList<Vertex> getAdjacentVerticesFast() {
        return this.adjacentVerticesFast;
    }

    public Tet getTet() {
        return this.tet;
    }

    public void setTet(Tet tet) {
        this.tet = tet;
    }

    public Tet getTetrahedron(KineticAlphaComplex kDT) {
        for (Tet tet : kDT.getTetrahedra()) {
            if (!tet.hasVertex(this)) continue;
            return tet;
        }
        return null;
    }

    public void computeAdjacentVerticesFast(double alpha2) {
        this.processedTetsFast.clear();
        this.computeAdjacentVerticesFast(this.tet, alpha2);
        for (Tet tet : this.processedTetsFast) {
            tet.setFlag(false);
        }
        for (Vertex v : this.adjacentVerticesFast) {
            v.setDepth(null);
        }
    }

    public void computeAdjacentVerticesFast(Tet tet, double alpha2) {
        Stack<Tet> stack = new Stack<Tet>();
        stack.push(tet);
        tet.setFlag(true);
        while (!stack.isEmpty()) {
            Tet nTet = (Tet)stack.pop();
            this.processedTetsFast.add(nTet);
            for (int k = 0; k < 4; ++k) {
                Tet nnTet;
                Vertex b = nTet.getCorner(k);
                if (b == this) continue;
                if (b.getDepth() == null && this.distanceSquared(b) < alpha2) {
                    this.adjacentVerticesFast.add(b);
                    b.setDepth(1);
                }
                if ((nnTet = nTet.neighbors[k]).getFlag()) continue;
                stack.push(nnTet);
                nnTet.setFlag(true);
            }
        }
    }

    public boolean isBig() {
        return this.index < 4;
    }

    @Override
    public int compareTo(Vertex arg0) {
        return this.index - arg0.index;
    }

    @Override
    public String toString() {
        return Integer.toString(this.index);
    }

    public static enum VertexType {
        S,
        R;

    }
}

