/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.kineticDelaunay;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.Shape;
import ProGAL.geom3d.kineticDelaunay.KineticAlphaComplex;
import ProGAL.geom3d.kineticDelaunay.Tet;
import ProGAL.geom3d.kineticDelaunay.Vertex;
import ProGAL.geom3d.viewer.J3DScene;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Hole {
    public List<Vertex> vertices = new ArrayList<Vertex>();
    public List<Face> faces = new ArrayList<Face>();
    J3DScene scene;

    public Hole(KineticAlphaComplex triangulation, Vertex u, J3DScene scene, boolean testing) {
        int i;
        Tet nTet;
        int indx;
        this.scene = scene;
        Stack<Tet> stack = new Stack<Tet>();
        for (Tet tet : triangulation.getTetrahedra()) {
            tet.onStack = false;
            tet.toConsole();
        }
        Tet tet = triangulation.getTetrahedron(u);
        stack.push(tet);
        tet.onStack = true;
        while (!stack.isEmpty()) {
            Face face;
            tet = (Tet)stack.pop();
            indx = tet.indexOf(u);
            Tet oppTet = tet.neighbors[indx];
            if (oppTet == null) {
                System.out.println("oppTet does not exist");
            }
            tet.selectedFace = face = new Face(tet.corners[(indx + 1) % 4], tet.corners[(indx + 2) % 4], tet.corners[(indx + 3) % 4], oppTet.corners[oppTet.apex(tet)], tet, oppTet);
            this.faces.add(face);
            if (testing) {
                face.shape = tet.toSceneFace(scene, indx, Color.red);
            }
            for (int i2 = 1; i2 < 4; ++i2) {
                nTet = tet.neighbors[(indx + i2) % 4];
                if (nTet == null || nTet.onStack) continue;
                stack.push(nTet);
                nTet.onStack = true;
            }
        }
        for (Face f : this.faces) {
            for (i = 0; i < 3; ++i) {
                Vertex v = f.vertices[i];
                indx = f.tet.indexOf(v);
                nTet = f.tet.neighbors[indx];
                f.neighbors[i] = nTet.selectedFace;
            }
        }
        Iterator<Face> iterator = this.faces.iterator();
        if (iterator.hasNext()) {
            Face f = iterator.next();
            nTet = f.tet.neighbors[f.tet.indexOf(u)];
            for (i = 0; i < 4; ++i) {
                if (nTet.neighbors[i] != f.tet) continue;
                nTet.neighbors[i] = null;
            }
            if (testing) {
                for (i = 0; i < 6; ++i) {
                    scene.removeShape(f.tet.LSSs[i]);
                }
            }
            throw new RuntimeException("Sorry .. we removed the removeTetrahedron method");
        }
    }

    class Face {
        Vertex[] vertices = new Vertex[3];
        Face[] neighbors = new Face[3];
        Tet tet;
        Tet oppTet;
        Shape shape;
        boolean processed = false;

        public Face(Vertex a, Vertex b, Vertex c, Vertex u, Tet tet, Tet oppTet) {
            this.vertices[0] = a;
            if (Point.orientation(a, b, c, u) > 0.0) {
                this.vertices[1] = c;
                this.vertices[2] = b;
            } else {
                this.vertices[1] = b;
                this.vertices[2] = c;
            }
            this.tet = tet;
            this.oppTet = oppTet;
        }

        public Tet getTet() {
            return this.tet;
        }

        public int indexOf(Vertex v) {
            for (int i = 0; i < 3; ++i) {
                if (this.vertices[i] != v) continue;
                return i;
            }
            return -1;
        }

        public Vertex getFreeVertex(Face f) {
            for (int i = 0; i < 3; ++i) {
                Vertex v = this.vertices[i];
                boolean found = false;
                int j = 0;
                while (!found && j < 3) {
                    found = v == f.vertices[j++];
                }
                if (found) continue;
                return v;
            }
            return null;
        }

        public int IndexOfFreeVertex(Face f) {
            for (int i = 0; i < 3; ++i) {
                Vertex v = this.vertices[i];
                boolean found = false;
                int j = 0;
                while (!found && j < 3) {
                    found = v == f.vertices[j++];
                }
                if (found) continue;
                return i;
            }
            return -1;
        }

        public boolean containsVertex(Vertex v) {
            return v == this.vertices[0] || v == this.vertices[1] || v == this.vertices[2];
        }

        public Face commonNeighbor(Face face) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.neighbors[i] != face.neighbors[j]) continue;
                    return this.neighbors[i];
                }
            }
            return null;
        }

        public Vertex getCommonVertex(Face f1, Face f2) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.vertices[i] != f1.vertices[j]) continue;
                    for (int k = 0; k < 3; ++k) {
                        if (this.vertices[i] != f2.vertices[k]) continue;
                        return this.vertices[i];
                    }
                }
            }
            return null;
        }

        public String toString() {
            return "[" + this.vertices[0] + " " + this.vertices[1] + " " + this.vertices[2] + "]";
        }
    }
}

