/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.kineticDelaunay;

import ProGAL.geom3d.Shape;
import ProGAL.geom3d.kineticDelaunay.Vertex;
import ProGAL.geom3d.viewer.J3DScene;
import ProGAL.geom3d.volumes.LSS;
import ProGAL.math.Constants;
import java.awt.Color;
import java.util.Arrays;

public class Edge {
    private Vertex[] corners = new Vertex[2];
    Integer count = null;
    boolean dAlive = true;
    boolean cAlive = true;
    private Shape LSSs;
    boolean alph = false;

    public Edge(Vertex[] corners) {
        this.corners = corners;
        this.sortCorners();
    }

    public Edge(Vertex v0, Vertex v1) {
        this.corners[0] = v0;
        this.corners[1] = v1;
        this.sortCorners();
    }

    private void sortCorners() {
        if (this.corners[0].getId() > this.corners[1].getId()) {
            Vertex tmp = this.corners[0];
            this.corners[0] = this.corners[1];
            this.corners[1] = tmp;
        }
    }

    public Vertex getCorner(int i) {
        return this.corners[i];
    }

    public void setAlph(boolean b) {
        this.alph = b;
    }

    public boolean getAlph() {
        return this.alph;
    }

    public int hashCode() {
        return this.corners[0].getId() + this.corners[1].getId() * 2;
    }

    public double getCircumRadius() {
        return this.corners[0].distance(this.corners[1]) / 2.0;
    }

    public boolean hasVertex(Vertex v) {
        for (int i = 0; i < 2; ++i) {
            if (this.corners[i] != v) continue;
            return true;
        }
        return false;
    }

    public boolean isAlive() {
        return this.dAlive;
    }

    public void setAlive(boolean dAlive) {
        this.dAlive = dAlive;
    }

    public boolean isBig() {
        return this.corners[0].getId() < 4 || this.corners[1].getId() < 4;
    }

    public boolean isAlpha(double alpha) {
        return this.getCircumRadius() < alpha + Constants.EPSILON;
    }

    public int getCount() {
        if (this.count != null) {
            return this.count;
        }
        this.count = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.corners[i].getType() != Vertex.VertexType.R) continue;
            this.count = this.count + (int)Math.pow(2.0, i);
        }
        return this.count;
    }

    public double getLength() {
        return this.corners[0].distance(this.corners[1]);
    }

    public double getLengthSquared() {
        return this.corners[0].distanceSquared(this.corners[1]);
    }

    public int indexOf_slow(Vertex v) {
        return Arrays.binarySearch(this.corners, v);
    }

    public String toString() {
        return Arrays.toString(this.corners);
    }

    public void toConsole() {
        System.out.println(this.toString());
    }

    public void fromSceneEdge(J3DScene scene) {
        scene.removeShape(this.LSSs);
        scene.repaint();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        return ((Edge)o).getCorner(0).equals(this.corners[0]) && ((Edge)o).getCorner(1).equals(this.corners[1]);
    }

    public void toSceneEdge(J3DScene scene, Color clr, double width) {
        this.LSSs = new LSS(this.corners[0], this.corners[1], width);
        scene.addShape(this.LSSs, clr, 3);
        scene.repaint();
    }
}

