/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.complex.delaunayComplex;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.complex.CTetrahedron;
import ProGAL.geom3d.complex.CVertex;
import ProGAL.geom3d.complex.delaunayComplex.Flip;
import ProGAL.geom3d.complex.delaunayComplex.Flip23;
import ProGAL.geom3d.complex.delaunayComplex.Flip32;
import ProGAL.geom3d.complex.delaunayComplex.Flip44;
import ProGAL.geom3d.predicates.Predicates;
import java.util.Stack;

class Flips {
    Predicates primitives;
    private Stack<CTetrahedron> tetrahedrastack;
    private Stack<Flip> flipstack;
    private final Flip23 f23;
    private final Flip32 f32;
    private final Flip44 f44;

    public Flips(Predicates primitives) {
        this.primitives = primitives;
        this.tetrahedrastack = new Stack();
        this.flipstack = new Stack();
        this.f23 = new Flip23(this);
        this.f32 = new Flip32(this.f23, this);
        this.f44 = new Flip44(this.f23, this);
    }

    public CTetrahedron fixDelaunay() {
        CTetrahedron next_t = null;
        while (!this.flipstack.empty()) {
            CVertex d;
            int did;
            Flip f = this.flipstack.pop();
            CTetrahedron t = f.getT();
            int pid = f.getId();
            CVertex p = t.getPoint(pid);
            CTetrahedron t2 = t.getNeighbour(pid);
            if (t.isModified()) continue;
            if (t2 != null && t.isFlat()) {
                if (p.getDegCase() == CVertex.DegenerateCase.ONFACE) {
                    did = this.apex(t, t2);
                    next_t = this.f23.flip23(t, pid, did);
                    continue;
                }
                if (p.getDegCase() != CVertex.DegenerateCase.ONEDGE) continue;
                continue;
            }
            if (t2 == null || this.primitives.insphere(t, (Point)(d = t2.getPoint(did = this.apex(t, t2)))) != Predicates.SphereConfig.INSIDE) continue;
            ApexConfig flipcase = this.apexConfig(t, p, pid, t2, d);
            if (flipcase == ApexConfig.CONVEX) {
                next_t = this.f23.flip23(t, pid, did);
                continue;
            }
            if (flipcase == ApexConfig.CONCAVE) {
                if (this.f23.getT3() == null) continue;
                next_t = this.f32.flip32(t, t2, this.f23.getT3(), pid, did);
                this.f23.setT3(null);
                continue;
            }
            if (flipcase == ApexConfig.COPLANAR && !this.config44(t, t2, p, d)) continue;
        }
        return next_t;
    }

    private boolean config44(CTetrahedron t1, CTetrahedron t2, CVertex p, CVertex d) {
        int d3id;
        int cid = this.f23.getCid();
        CVertex c = t1.getPoint(cid);
        int c2id = t2.findpoint(c);
        CTetrahedron t3 = t2.getNeighbour(c2id);
        CTetrahedron t4 = t1.getNeighbour(cid);
        if (t3 != null && t4 != null && t3.getNeighbour(d3id = t3.findpoint(d)) == t4) {
            this.f44.flip44(t1, t2, t3, t4, p, d);
            return true;
        }
        return false;
    }

    public void addFlip(int id, CTetrahedron t) {
        this.flipstack.push(new Flip(id, t));
    }

    public void addTetrahedron(CTetrahedron t) {
        this.tetrahedrastack.push(t);
    }

    public int apex(CTetrahedron t1, CTetrahedron t2) {
        for (int i = 0; i < 4; ++i) {
            if (t2.getNeighbour(i) != t1) continue;
            return i;
        }
        System.out.println("Problemer med apex\n");
        return -1;
    }

    public ApexConfig apexConfig(CTetrahedron t1, CVertex p, int pid, CTetrahedron t2, CVertex d) {
        Predicates.PlaneConfig case3;
        Predicates.PlaneConfig case2;
        boolean concave = false;
        Predicates.PlaneConfig case1 = this.primitives.diffsides(p, t1.getPoint((pid + 1) % 4), t1.getPoint((pid + 2) % 4), t1.getPoint((pid + 3) % 4), d);
        if (case1 == Predicates.PlaneConfig.DIFF) {
            this.f23.setT3(this.findthird(t1, t2, (pid + 3) % 4));
            this.f23.setA1((pid + 1) % 4);
            this.f23.setB1((pid + 2) % 4);
            concave = true;
            if (this.f23.getT3() != null) {
                return ApexConfig.CONCAVE;
            }
        }
        if ((case2 = this.primitives.diffsides(p, t1.getPoint((pid + 1) % 4), t1.getPoint((pid + 3) % 4), t1.getPoint((pid + 2) % 4), d)) == Predicates.PlaneConfig.DIFF) {
            this.f23.setT3(this.findthird(t1, t2, (pid + 2) % 4));
            this.f23.setA1((pid + 1) % 4);
            this.f23.setB1((pid + 3) % 4);
            concave = true;
            if (this.f23.getT3() != null) {
                return ApexConfig.CONCAVE;
            }
        }
        if ((case3 = this.primitives.diffsides(p, t1.getPoint((pid + 2) % 4), t1.getPoint((pid + 3) % 4), t1.getPoint((pid + 1) % 4), d)) == Predicates.PlaneConfig.DIFF) {
            this.f23.setT3(this.findthird(t1, t2, (pid + 1) % 4));
            this.f23.setA1((pid + 2) % 4);
            this.f23.setB1((pid + 3) % 4);
            concave = true;
            if (this.f23.getT3() != null) {
                return ApexConfig.CONCAVE;
            }
        }
        if (concave) {
            return ApexConfig.CONCAVE;
        }
        if (case1 == Predicates.PlaneConfig.COPLANAR) {
            this.f23.setCid((pid + 3) % 4);
            this.f23.setA1((pid + 1) % 4);
            this.f23.setB1((pid + 2) % 4);
            return ApexConfig.COPLANAR;
        }
        if (case2 == Predicates.PlaneConfig.COPLANAR) {
            this.f23.setCid((pid + 2) % 4);
            this.f23.setA1((pid + 1) % 4);
            this.f23.setB1((pid + 3) % 4);
            return ApexConfig.COPLANAR;
        }
        if (case3 == Predicates.PlaneConfig.COPLANAR) {
            this.f23.setCid((pid + 1) % 4);
            this.f23.setA1((pid + 2) % 4);
            this.f23.setB1((pid + 3) % 4);
            return ApexConfig.COPLANAR;
        }
        return ApexConfig.CONVEX;
    }

    public CTetrahedron findthird(CTetrahedron t1, CTetrahedron t2, int c1) {
        int c2 = this.findpoint(t2, t1.getPoint(c1));
        if (t1.getNeighbour(c1) == t2.getNeighbour(c2)) {
            return t1.getNeighbour(c1);
        }
        return null;
    }

    public int findpoint(CTetrahedron t, CVertex p) {
        for (int i = 0; i < 4; ++i) {
            if (t.getPoint(i) != p) continue;
            return i;
        }
        System.out.println("Problemer med findpoint");
        return -1;
    }

    public Stack<CTetrahedron> getTetrahedrastack() {
        return this.tetrahedrastack;
    }

    public Flip23 getFlip23() {
        return this.f23;
    }

    public Flip32 getFlip32() {
        return this.f32;
    }

    public Stack<Flip> getFlipstack() {
        return this.flipstack;
    }

    public void setTetrahedrastack(Stack<CTetrahedron> tetrahedrastack) {
        this.tetrahedrastack = tetrahedrastack;
    }

    static enum ApexConfig {
        CONVEX,
        CONCAVE,
        COPLANAR;

    }
}

