/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Point;
import ProGAL.math.Constants;
import ProGAL.math.Matrix;

public class Vector
extends ProGAL.geomNd.Vector {
    public static Vector X = new ImmutableVector3d(1.0, 0.0, 0.0);
    public static Vector Y = new ImmutableVector3d(0.0, 1.0, 0.0);
    public static Vector Z = new ImmutableVector3d(0.0, 0.0, 1.0);

    public Vector(double x, double y, double z) {
        super(new double[]{x, y, z});
    }

    public Vector(Point p) {
        super(p);
    }

    public Vector(Point p1, Point p2) {
        super(p1, p2);
    }

    public Vector(Vector v) {
        this(v.get(0), v.get(1), v.get(2));
    }

    public Vector(ProGAL.geomNd.Vector v) {
        this(v.get(0), v.get(1), v.get(2));
    }

    public Vector(double[] coords) {
        super(coords);
    }

    public double x() {
        return this.coords[0];
    }

    public double y() {
        return this.coords[1];
    }

    public double z() {
        return this.coords[2];
    }

    public void setX(double x) {
        this.coords[0] = x;
    }

    public void setY(double y) {
        this.coords[1] = y;
    }

    public void setZ(double z) {
        this.coords[2] = z;
    }

    public void set(Vector v) {
        this.coords[0] = v.coords[0];
        this.coords[1] = v.coords[1];
        this.coords[2] = v.coords[2];
    }

    public double dot(Vector v) {
        return this.coords[0] * v.coords[0] + this.coords[1] * v.coords[1] + this.coords[2] * v.coords[2];
    }

    public double dot(Point p) {
        return this.coords[0] * p.x() + this.coords[1] * p.y() + this.coords[2] * p.z();
    }

    public double angle(Vector v) {
        return Math.acos(this.dot(v) / (this.length() * v.length()));
    }

    public Vector add(Vector v) {
        return new Vector(this.coords[0] + v.coords[0], this.coords[1] + v.coords[1], this.coords[2] + v.coords[2]);
    }

    public Vector addThis(Vector v) {
        this.coords[0] = this.coords[0] + v.coords[0];
        this.coords[1] = this.coords[1] + v.coords[1];
        this.coords[2] = this.coords[2] + v.coords[2];
        return this;
    }

    public Vector add(Point p) {
        return new Vector(this.coords[0] + p.x(), this.coords[1] + p.y(), this.coords[2] + p.z());
    }

    public Vector addThis(Point p) {
        this.coords[0] = this.coords[0] + p.x();
        this.coords[1] = this.coords[1] + p.y();
        this.coords[2] = this.coords[2] + p.z();
        return this;
    }

    public Vector subtract(Vector v) {
        return new Vector(this.coords[0] - v.coords[0], this.coords[1] - v.coords[1], this.coords[2] - v.coords[2]);
    }

    public Vector subtractThis(Vector v) {
        this.coords[0] = this.coords[0] - v.coords[0];
        this.coords[1] = this.coords[1] - v.coords[1];
        this.coords[2] = this.coords[2] - v.coords[2];
        return this;
    }

    @Override
    public Vector multiply(double s) {
        return new Vector(this.coords[0] * s, this.coords[1] * s, this.coords[2] * s);
    }

    @Override
    public Vector multiplyThis(double s) {
        this.coords[0] = this.coords[0] * s;
        this.coords[1] = this.coords[1] * s;
        this.coords[2] = this.coords[2] * s;
        return this;
    }

    public Vector multiply(Vector v) {
        double[] ret = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            ret[d] = this.coords[d] * v.getCoord(d);
        }
        return new Vector(ret);
    }

    @Override
    public Vector divide(double s) {
        return new Vector(this.coords[0] / s, this.coords[1] / s, this.coords[2] / s);
    }

    @Override
    public Vector divideThis(double s) {
        this.coords[0] = this.coords[0] / s;
        this.coords[1] = this.coords[1] / s;
        this.coords[2] = this.coords[2] / s;
        return this;
    }

    @Override
    public Vector normalize() {
        return this.divide(this.length());
    }

    @Override
    public Vector normalizeThis() {
        return this.divideThis(this.length());
    }

    public Vector normalizeFast() {
        return this.multiply(Vector.invSqrt(this.getLengthSquared()));
    }

    public Vector normalizeThisFast() {
        return this.multiplyThis(Vector.invSqrt(this.getLengthSquared()));
    }

    private static double invSqrt(double x) {
        double xhalf = 0.5 * x;
        long i = Double.doubleToLongBits(x);
        i = 6910470738111508698L - (i >> 1);
        x = Double.longBitsToDouble(i);
        x *= 1.5 - xhalf * x * x;
        return x;
    }

    @Override
    public Vector scaleToLength(double length) {
        return this.multiply(length / this.length());
    }

    @Override
    public Vector scaleToLengthThis(double length) {
        return this.multiplyThis(length / this.length());
    }

    public Vector cross(Vector v) {
        return new Vector(this.coords[1] * v.coords[2] - this.coords[2] * v.coords[1], this.coords[2] * v.coords[0] - this.coords[0] * v.coords[2], this.coords[0] * v.coords[1] - this.coords[1] * v.coords[0]);
    }

    public Vector crossThis(Vector v) {
        double newX = this.coords[1] * v.coords[2] - this.coords[2] * v.coords[1];
        double newY = this.coords[2] * v.coords[0] - this.coords[0] * v.coords[2];
        double newZ = this.coords[0] * v.coords[1] - this.coords[1] * v.coords[0];
        this.coords[0] = newX;
        this.coords[1] = newY;
        this.coords[2] = newZ;
        return this;
    }

    public void rotation(Vector v, double alpha) {
        double c = Math.cos(alpha);
        double d = 1.0 - c;
        double s = Math.sin(alpha);
        double vxyd = v.x() * v.y() * d;
        double vxzd = v.x() * v.z() * d;
        double vyzd = v.y() * v.z() * d;
        double vxs = v.x() * s;
        double vys = v.y() * s;
        double vzs = v.z() * s;
        double xNew = (v.x() * v.x() * d + c) * this.x() + (vxyd - vzs) * this.y() + (vxzd + vys) * this.z();
        double yNew = (vxyd + vzs) * this.x() + (v.y() * v.y() * d + c) * this.y() + (vyzd - vxs) * this.z();
        this.setZ((vxzd - vys) * this.x() + (vyzd + vxs) * this.y() + (v.z() * v.z() * d + c) * this.z());
        this.setX(xNew);
        this.setY(yNew);
    }

    public Vector rotateIn(Vector v, double angle) {
        double l = this.length();
        if (l == 0.0) {
            throw new Error("Trying to rotate around 0-vector");
        }
        double ux = this.coords[0] / l;
        double uy = this.coords[1] / l;
        double uz = this.coords[2] / l;
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double a00 = ux * ux + cos * (1.0 - ux * ux);
        double a10 = ux * uy * (1.0 - cos) + uz * sin;
        double a20 = uz * ux * (1.0 - cos) - uy * sin;
        double a01 = ux * uy * (1.0 - cos) - uz * sin;
        double a11 = uy * uy + cos * (1.0 - uy * uy);
        double a21 = uy * uz * (1.0 - cos) + ux * sin;
        double a02 = uz * ux * (1.0 - cos) + uy * sin;
        double a12 = uy * uz * (1.0 - cos) - ux * sin;
        double a22 = uz * uz + cos * (1.0 - uz * uz);
        double newX = a00 * v.coords[0] + a01 * v.coords[1] + a02 * v.coords[2];
        double newY = a10 * v.coords[0] + a11 * v.coords[1] + a12 * v.coords[2];
        double newZ = a20 * v.coords[0] + a21 * v.coords[1] + a22 * v.coords[2];
        v.setX(newX);
        v.setY(newY);
        v.setZ(newZ);
        return v;
    }

    @Override
    public Point toPoint() {
        return new Point(this.coords[0], this.coords[1], this.coords[2]);
    }

    @Override
    public String toString() {
        return this.toString(2);
    }

    @Override
    public String toString(int dec) {
        return String.format("Vector3d[%." + dec + "f,%." + dec + "f,%." + dec + "f]", this.coords[0], this.coords[1], this.coords[2]);
    }

    @Override
    public void toConsole() {
        this.toConsole(2);
    }

    @Override
    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    @Override
    public Vector clone() {
        return new Vector(this.coords[0], this.coords[1], this.coords[2]);
    }

    public static double getAngle(Vector u, Vector v) {
        return u.angle(v);
    }

    public static double getDihedralAngle(Vector b1, Vector b2, Vector b3) {
        Vector b2xb3 = b2.cross(b3);
        double y = b1.multiply(b2.length()).dot(b2xb3);
        double x = b1.cross(b2).dot(b2xb3);
        return Math.atan2(y, x);
    }

    public Vector getOrthonormal() {
        if (Math.abs(this.z()) > Constants.EPSILON) {
            double ratio = this.x() / this.z();
            double length = Math.sqrt(1.0 + ratio * ratio);
            return new Vector(1.0 / length, 0.0, -ratio / length);
        }
        return new Vector(0.0, 0.0, 1.0);
    }

    public Vector getOrthogonal() {
        if (Math.abs(this.z()) > Constants.EPSILON) {
            return new Vector(1.0, 0.0, -this.x() / this.z());
        }
        return new Vector(0.0, 0.0, 1.0);
    }

    public boolean isParallel(Vector v) {
        return this.cross(v).isZeroVector();
    }

    public boolean isSteinerAngle(Vector v) {
        return this.dot(v) / (this.length() * v.length()) > -0.5;
    }

    public static double getCosDihedralAngle(Vector u, Vector v, Vector w) {
        if (u.isParallel(v)) {
            throw new Error("Vectors u and v are colinear");
        }
        if (v.isParallel(w)) {
            throw new Error("Vectors v and w are colinear");
        }
        Vector uv = u.cross(u.add(v));
        Vector vw = v.cross(v.add(w));
        return uv.dot(vw) / (uv.length() * vw.length());
    }

    public static void main(String[] args) {
        Vector a = new Vector(0.0, 0.0, 1.0);
        Vector b = new Vector(1.0, 0.0, 1.0);
        Point center = new Point(1.0, 1.0, 0.0);
        Circle C = new Circle(center, 0.2, b);
        Vector rotAxis = b.cross(a);
        double angle = b.angle(a);
        Matrix rotMatrix = Matrix.createRotationMatrix(angle, rotAxis);
        Vector translate = new Vector(-center.x(), -center.y(), -center.z());
        Vector newVector = rotMatrix.multiply(b);
        Circle newC = new Circle(center.add(translate), 0.2, newVector.normalize());
        System.out.println("newC = " + newC.toString());
        Vector n = new Vector(0.0, 0.0, 1.0);
        Vector u = new Vector(0.3, 0.4, 0.0).normalize();
        Vector v = n.cross(u);
        System.out.println(u.x() + " " + v.y());
        System.out.println("cross = " + n.cross(n));
    }

    public static class ImmutableVector3d
    extends Vector {
        public ImmutableVector3d(double x, double y, double z) {
            super(x, y, z);
        }

        @Override
        public void setCoord(int i, double v) {
            throw new RuntimeException("This vector is immutable");
        }

        @Override
        public void set(int i, double v) {
            throw new RuntimeException("This vector is immutable");
        }

        @Override
        public void setX(double x) {
            throw new RuntimeException("This vector is immutable");
        }

        @Override
        public void setY(double y) {
            throw new RuntimeException("This vector is immutable");
        }

        @Override
        public void setZ(double z) {
            throw new RuntimeException("This vector is immutable");
        }

        @Override
        public Vector addThis(Vector v) {
            return this.add(v);
        }

        @Override
        public Vector multiplyThis(double s) {
            return this.multiply(s);
        }

        @Override
        public Vector normalizeThis() {
            return this.multiply(1.0 / this.length());
        }

        @Override
        public Vector scaleToLengthThis(double length) {
            return this.multiply(length / this.length());
        }

        @Override
        public Vector crossThis(Vector v) {
            return this.cross(v);
        }
    }
}

