/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Line;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;

public class Rectangle {
    public Point center;
    public final Vector[] bases;
    private final Vector[] normBases;
    private final double[] extents;

    public Rectangle(Point center, Vector[] bases) {
        this.center = center;
        this.bases = new Vector[]{bases[0], bases[1]};
        this.normBases = new Vector[]{bases[0].normalize(), bases[1].normalize(), bases[0].cross(bases[1]).normalize()};
        this.extents = new double[]{bases[0].length() * 2.0, bases[1].length() * 2.0};
    }

    public double distance(Rectangle rect) {
        return this.distance_optimized(rect);
    }

    public double distance_optimized(Rectangle rect) {
        int[] perm;
        Point[] thisCorners = this.getCorners();
        Point[] rectCorners = rect.getCorners();
        Vector[] thisNormals = new Vector[]{this.bases[1], this.bases[0].multiply(-1.0), this.bases[1].multiply(-1.0), this.bases[0]};
        Vector[] rectNormals = new Vector[]{rect.bases[1], rect.bases[0].multiply(-1.0), rect.bases[1].multiply(-1.0), rect.bases[0]};
        boolean[][] inVoronoi1 = Rectangle.geninVoronoi(thisCorners, thisNormals, rectCorners, rectNormals);
        boolean[][] inVoronoi2 = Rectangle.geninVoronoi(rectCorners, rectNormals, thisCorners, thisNormals);
        for (int i : perm = new int[]{0, 2, 1, 3}) {
            for (int j : perm) {
                double c;
                if (!inVoronoi1[i][j] && !inVoronoi1[i][(j + 1) % 4] || !inVoronoi2[j][i] && !inVoronoi2[j][(i + 1) % 4] || !((c = this.checkEdgePair(thisCorners[i], thisCorners[(i + 1) % 4], thisNormals[i], rectCorners[j], rectCorners[(j + 1) % 4], rectNormals[j])) >= 0.0)) continue;
                return c;
            }
        }
        double sep1 = Rectangle.axisSeparation(thisCorners, rectCorners);
        double sep2 = Rectangle.axisSeparation(rectCorners, thisCorners);
        return Math.max(sep1, sep2);
    }

    private static boolean[][] geninVoronoi(Point[] corners1, Vector[] normals1, Point[] corners2, Vector[] normals2) {
        boolean[][] ret = new boolean[4][4];
        ret[0][0] = corners1[0].vectorTo(corners2[0]).dot(normals1[0]) >= 0.0;
        ret[0][1] = corners1[0].vectorTo(corners2[1]).dot(normals1[0]) >= 0.0;
        ret[0][2] = corners1[0].vectorTo(corners2[2]).dot(normals1[0]) >= 0.0;
        ret[0][3] = corners1[0].vectorTo(corners2[3]).dot(normals1[0]) >= 0.0;
        ret[1][0] = corners1[2].vectorTo(corners2[0]).dot(normals1[1]) >= 0.0;
        ret[1][1] = corners1[2].vectorTo(corners2[1]).dot(normals1[1]) >= 0.0;
        ret[1][2] = corners1[2].vectorTo(corners2[2]).dot(normals1[1]) >= 0.0;
        ret[1][3] = corners1[2].vectorTo(corners2[3]).dot(normals1[1]) >= 0.0;
        ret[2][0] = corners1[2].vectorTo(corners2[0]).dot(normals1[2]) >= 0.0;
        ret[2][1] = corners1[2].vectorTo(corners2[1]).dot(normals1[2]) >= 0.0;
        ret[2][2] = corners1[2].vectorTo(corners2[2]).dot(normals1[2]) >= 0.0;
        ret[2][3] = corners1[2].vectorTo(corners2[3]).dot(normals1[2]) >= 0.0;
        ret[3][0] = corners1[0].vectorTo(corners2[0]).dot(normals1[3]) >= 0.0;
        ret[3][1] = corners1[0].vectorTo(corners2[1]).dot(normals1[3]) >= 0.0;
        ret[3][2] = corners1[0].vectorTo(corners2[2]).dot(normals1[3]) >= 0.0;
        ret[3][3] = corners1[0].vectorTo(corners2[3]).dot(normals1[3]) >= 0.0;
        return ret;
    }

    public double distance_nonoptimized(Rectangle rect) {
        int[] perm;
        Point[] thisCorners = this.getCorners();
        Point[] rectCorners = rect.getCorners();
        Vector[] thisNormals = new Vector[]{this.bases[1], this.bases[0].multiply(-1.0), this.bases[1].multiply(-1.0), this.bases[0]};
        Vector[] rectNormals = new Vector[]{rect.bases[1], rect.bases[0].multiply(-1.0), rect.bases[1].multiply(-1.0), rect.bases[0]};
        for (int i : perm = new int[]{0, 2, 1, 3}) {
            for (int j : perm) {
                double c = this.checkEdgePair(thisCorners[i], thisCorners[(i + 1) % 4], thisNormals[i], rectCorners[j], rectCorners[(j + 1) % 4], rectNormals[j]);
                if (!(c >= 0.0)) continue;
                return c;
            }
        }
        double sep1 = Rectangle.axisSeparation(thisCorners, rectCorners);
        double sep2 = Rectangle.axisSeparation(rectCorners, thisCorners);
        return Math.max(sep1, sep2);
    }

    private static double axisSeparation(Point[] corners1, Point[] corners2) {
        Vector n = corners1[1].vectorTo(corners1[0]).cross(corners1[1].vectorTo(corners1[2])).normalizeThis();
        boolean negatives = false;
        boolean positives = false;
        double min = Double.POSITIVE_INFINITY;
        for (Point c : corners2) {
            Vector v = corners1[0].vectorTo(c);
            double dot = v.dot(n);
            min = Math.min(min, Math.abs(dot));
            if (dot > 0.0) {
                positives = true;
                continue;
            }
            negatives = true;
        }
        if (positives && negatives) {
            return 0.0;
        }
        return min;
    }

    private double checkEdgePair(Point p1, Point p2, Vector n1, Point q1, Point q2, Vector n2) {
        Point[] minDist = Rectangle.closestSegmentPoint(p1, p2, q1, q2);
        Vector v = minDist[0].vectorTo(minDist[1]);
        if (v.dot(n1) > 0.0 && v.dot(n2) < 0.0) {
            return v.length();
        }
        return -1.0;
    }

    public static Point[] closestSegmentPoint(Point p1, Point p2, Point q1, Point q2) {
        double t;
        double b;
        Point startPoint1 = p1;
        Point startPoint2 = q1;
        Vector dir1 = p1.vectorTo(p2);
        Vector dir2 = q1.vectorTo(q2);
        if (dir1.length() < 1.0E-6 && dir2.length() < 1.0E-5) {
            return new Point[]{startPoint1, startPoint2};
        }
        if (dir1.length() < 1.0E-6) {
            return new Point[]{startPoint1, Rectangle.closestSegmentPoint(startPoint2, q2, startPoint1)};
        }
        if (dir2.length() < 1.0E-6) {
            return new Point[]{Rectangle.closestSegmentPoint(startPoint1, p2, startPoint2), startPoint2};
        }
        Vector r = startPoint2.vectorTo(startPoint1);
        double a = dir1.dot(dir1);
        double e = dir2.dot(dir2);
        double f = dir2.dot(r);
        double c = dir1.dot(r);
        double denom = a * e - (b = dir1.dot(dir2)) * b;
        double s = denom != 0.0 ? Rectangle.clamp((b * f - c * e) / denom) : 0.0;
        double tnom = b * s + f;
        if (tnom < 0.0) {
            t = 0.0;
            s = Rectangle.clamp(-c / a);
        } else if (tnom > e) {
            t = 1.0;
            s = Rectangle.clamp((b - c) / a);
        } else {
            t = tnom / e;
        }
        Point c1 = startPoint1.add(dir1.multiplyThis(s));
        Point c2 = startPoint2.add(dir2.multiplyThis(t));
        return new Point[]{c1, c2};
    }

    public static Point closestSegmentPoint(Point p11, Point p12, Point p2) {
        Line l = new Line(p11, p11.vectorTo(p12));
        double t = l.orthogonalProjectionParameter(p2);
        t = Rectangle.clamp(t) * p11.distance(p12);
        return l.getPoint(t);
    }

    private static double clamp(double s) {
        if (s < 0.0) {
            return 0.0;
        }
        if (s > 1.0) {
            return 1.0;
        }
        return s;
    }

    public Point[] getCorners() {
        return new Point[]{this.center.add(this.bases[0]).addThis(this.bases[1]), this.center.subtract(this.bases[0]).addThis(this.bases[1]), this.center.subtract(this.bases[0]).subtractThis(this.bases[1]), this.center.add(this.bases[0]).subtractThis(this.bases[1])};
    }

    public Plane getPlane() {
        return new Plane(this.center, this.bases[0].cross(this.bases[1]).normalizeThis());
    }

    private static double clipToRange(double val, double a, double b) {
        if (val < a) {
            return a;
        }
        if (val > b) {
            return b;
        }
        return val;
    }

    private static double[] segCoords(double a, double b, double A_dot_B, double A_dot_T, double B_dot_T) {
        double t;
        double denom = 1.0 - A_dot_B * A_dot_B;
        if (denom == 0.0) {
            t = 0.0;
        } else {
            t = (A_dot_T - B_dot_T * A_dot_B) / denom;
            t = Rectangle.clipToRange(t, 0.0, a);
        }
        double u = t * A_dot_B - B_dot_T;
        if (u < 0.0) {
            u = 0.0;
            t = A_dot_T;
            t = Rectangle.clipToRange(t, 0.0, a);
        } else if (u > b) {
            u = b;
            t = u * A_dot_B + A_dot_T;
            t = Rectangle.clipToRange(t, 0.0, a);
        }
        return new double[]{t, u};
    }

    private static boolean inVoronoi(double a, double b, double Anorm_dot_B, double Anorm_dot_T, double A_dot_B, double A_dot_T, double B_dot_T) {
        if (Math.abs(Anorm_dot_B) < 1.0E-7) {
            return false;
        }
        double u = -Anorm_dot_T / Anorm_dot_B;
        u = Rectangle.clipToRange(u, 0.0, b);
        double t = u * A_dot_B + A_dot_T;
        t = Rectangle.clipToRange(t, 0.0, a);
        double v = t * A_dot_B - B_dot_T;
        return Anorm_dot_B > 0.0 ? v > u + 1.0E-7 : v < u - 1.0E-7;
    }

    private static double[] MTxV(double[][] M1, double[] V1) {
        double[] Vr = new double[]{M1[0][0] * V1[0] + M1[1][0] * V1[1] + M1[2][0] * V1[2], M1[0][1] * V1[0] + M1[1][1] * V1[1] + M1[2][1] * V1[2], M1[0][2] * V1[0] + M1[1][2] * V1[1] + M1[2][2] * V1[2]};
        return Vr;
    }

    public double distance_Gottschalk(Rectangle b) {
        double[][] Rab = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Rab[i][j] = this.normBases[i].dot(b.normBases[j]);
            }
        }
        Vector tmp = this.center.subtract(this.bases[0]).subtractThis(this.bases[1]).vectorTo(b.center.subtract(b.bases[0]).subtractThis(b.bases[1]));
        tmp = new Vector(tmp.dot(this.normBases[0]), tmp.dot(this.normBases[1]), tmp.dot(this.normBases[2]));
        double[] Tab = new double[]{tmp.x(), tmp.y(), tmp.z()};
        return Rectangle.rectDist(Rab, Tab, this.extents, b.extents);
    }

    private static double rectDist(double[][] Rab, double[] Tab, double[] a, double[] b) {
        double sep2;
        double sep1;
        double UB0_uy;
        double UB0_ly;
        double LB0_uy;
        double LB0_ly;
        double UA0_uy;
        double UA0_ly;
        double LA0_uy;
        double LA0_ly;
        double UB1_uy;
        double UB1_ly;
        double LB1_uy;
        double LB1_ly;
        double UA0_ux;
        double UA0_lx;
        double LA0_ux;
        double LA0_lx;
        double UB0_ux;
        double UB0_lx;
        double LB0_ux;
        double LB0_lx;
        double UA1_uy;
        double UA1_ly;
        double LA1_uy;
        double LA1_ly;
        double UB1_ux;
        double UB1_lx;
        double LB1_ux;
        double LB1_lx;
        double UA1_ux;
        double UA1_lx;
        double LA1_ux;
        double LA1_lx;
        double A0_dot_B0 = Rab[0][0];
        double A0_dot_B1 = Rab[0][1];
        double A1_dot_B0 = Rab[1][0];
        double A1_dot_B1 = Rab[1][1];
        double aA0_dot_B0 = a[0] * A0_dot_B0;
        double aA0_dot_B1 = a[0] * A0_dot_B1;
        double aA1_dot_B0 = a[1] * A1_dot_B0;
        double aA1_dot_B1 = a[1] * A1_dot_B1;
        double bA0_dot_B0 = b[0] * A0_dot_B0;
        double bA1_dot_B0 = b[0] * A1_dot_B0;
        double bA0_dot_B1 = b[1] * A0_dot_B1;
        double bA1_dot_B1 = b[1] * A1_dot_B1;
        double[] Tba = Rectangle.MTxV(Rab, Tab);
        double ALL_x = -Tba[0];
        double ALU_x = ALL_x + aA1_dot_B0;
        double AUL_x = ALL_x + aA0_dot_B0;
        double AUU_x = ALU_x + aA0_dot_B0;
        if (ALL_x < ALU_x) {
            LA1_lx = ALL_x;
            LA1_ux = ALU_x;
            UA1_lx = AUL_x;
            UA1_ux = AUU_x;
        } else {
            LA1_lx = ALU_x;
            LA1_ux = ALL_x;
            UA1_lx = AUU_x;
            UA1_ux = AUL_x;
        }
        double BLL_x = Tab[0];
        double BLU_x = BLL_x + bA0_dot_B1;
        double BUL_x = BLL_x + bA0_dot_B0;
        double BUU_x = BLU_x + bA0_dot_B0;
        if (BLL_x < BLU_x) {
            LB1_lx = BLL_x;
            LB1_ux = BLU_x;
            UB1_lx = BUL_x;
            UB1_ux = BUU_x;
        } else {
            LB1_lx = BLU_x;
            LB1_ux = BLL_x;
            UB1_lx = BUU_x;
            UB1_ux = BUL_x;
        }
        if (UA1_ux > b[0] && UB1_ux > a[0] && (UA1_lx > b[0] || Rectangle.inVoronoi(b[1], a[1], A1_dot_B0, aA0_dot_B0 - b[0] - Tba[0], A1_dot_B1, aA0_dot_B1 - Tba[1], -Tab[1] - bA1_dot_B0)) && (UB1_lx > a[0] || Rectangle.inVoronoi(a[1], b[1], A0_dot_B1, Tab[0] + bA0_dot_B0 - a[0], A1_dot_B1, Tab[1] + bA1_dot_B0, Tba[1] - aA0_dot_B1))) {
            double[] tu = Rectangle.segCoords(a[1], b[1], A1_dot_B1, Tab[1] + bA1_dot_B0, Tba[1] - aA0_dot_B1);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * b[0] + Rab[0][1] * u - a[0], Tab[1] + Rab[1][0] * b[0] + Rab[1][1] * u - t, Tab[2] + Rab[2][0] * b[0] + Rab[2][1] * u);
            return S.length();
        }
        if (UA1_lx < 0.0 && LB1_ux > a[0] && (UA1_ux < 0.0 || Rectangle.inVoronoi(b[1], a[1], -A1_dot_B0, Tba[0] - aA0_dot_B0, A1_dot_B1, aA0_dot_B1 - Tba[1], -Tab[1])) && (LB1_lx > a[0] || Rectangle.inVoronoi(a[1], b[1], A0_dot_B1, Tab[0] - a[0], A1_dot_B1, Tab[1], Tba[1] - aA0_dot_B1))) {
            double[] tu = Rectangle.segCoords(a[1], b[1], A1_dot_B1, Tab[1], Tba[1] - aA0_dot_B1);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * u - a[0], Tab[1] + Rab[1][1] * u - t, Tab[2] + Rab[2][1] * u);
            return S.length();
        }
        if (LA1_ux > b[0] && UB1_lx < 0.0 && (LA1_lx > b[0] || Rectangle.inVoronoi(b[1], a[1], A1_dot_B0, -Tba[0] - b[0], A1_dot_B1, -Tba[1], -Tab[1] - bA1_dot_B0)) && (UB1_ux < 0.0 || Rectangle.inVoronoi(a[1], b[1], -A0_dot_B1, -Tab[0] - bA0_dot_B0, A1_dot_B1, Tab[1] + bA1_dot_B0, Tba[1]))) {
            double[] tu = Rectangle.segCoords(a[1], b[1], A1_dot_B1, Tab[1] + bA1_dot_B0, Tba[1]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * b[0] + Rab[0][1] * u, Tab[1] + Rab[1][0] * b[0] + Rab[1][1] * u - t, Tab[2] + Rab[2][0] * b[0] + Rab[2][1] * u);
            return S.length();
        }
        if (LA1_lx < 0.0 && LB1_lx < 0.0 && (LA1_ux < 0.0 || Rectangle.inVoronoi(b[1], a[1], -A1_dot_B0, Tba[0], A1_dot_B1, -Tba[1], -Tab[1])) && (LB1_ux < 0.0 || Rectangle.inVoronoi(a[1], b[1], -A0_dot_B1, -Tab[0], A1_dot_B1, Tab[1], Tba[1]))) {
            double[] tu = Rectangle.segCoords(a[1], b[1], A1_dot_B1, Tab[1], Tba[1]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * b[0] + Rab[0][1] * u, Tab[1] + Rab[1][0] * b[0] + Rab[1][1] * u - t, Tab[2] + Rab[2][0] * b[0] + Rab[2][1] * u);
            return S.length();
        }
        double ALL_y = -Tba[1];
        double ALU_y = ALL_y + aA1_dot_B1;
        double AUL_y = ALL_y + aA0_dot_B1;
        double AUU_y = ALU_y + aA0_dot_B1;
        if (ALL_y < ALU_y) {
            LA1_ly = ALL_y;
            LA1_uy = ALU_y;
            UA1_ly = AUL_y;
            UA1_uy = AUU_y;
        } else {
            LA1_ly = ALU_y;
            LA1_uy = ALL_y;
            UA1_ly = AUU_y;
            UA1_uy = AUL_y;
        }
        if (BLL_x < BUL_x) {
            LB0_lx = BLL_x;
            LB0_ux = BUL_x;
            UB0_lx = BLU_x;
            UB0_ux = BUU_x;
        } else {
            LB0_lx = BUL_x;
            LB0_ux = BLL_x;
            UB0_lx = BUU_x;
            UB0_ux = BLU_x;
        }
        if (UA1_uy > b[1] && UB0_ux > a[0] && (UA1_ly > b[1] || Rectangle.inVoronoi(b[0], a[1], A1_dot_B1, aA0_dot_B1 - Tba[1] - b[1], A1_dot_B0, aA0_dot_B0 - Tba[0], -Tab[1] - bA1_dot_B1)) && (UB0_lx > a[0] || Rectangle.inVoronoi(a[1], b[0], A0_dot_B0, Tab[0] - a[0] + bA0_dot_B1, A1_dot_B0, Tab[1] + bA1_dot_B1, Tba[0] - aA0_dot_B0))) {
            double[] tu = Rectangle.segCoords(a[1], b[0], A1_dot_B0, Tab[1] + bA1_dot_B1, Tba[0] - aA0_dot_B0);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * b[1] + Rab[0][0] * u - a[0], Tab[1] + Rab[1][1] * b[1] + Rab[1][0] * u - t, Tab[2] + Rab[2][1] * b[1] + Rab[2][0] * u);
            return S.length();
        }
        if (UA1_ly < 0.0 && LB0_ux > a[0] && (UA1_uy < 0.0 || Rectangle.inVoronoi(b[0], a[1], -A1_dot_B1, Tba[1] - aA0_dot_B1, A1_dot_B0, aA0_dot_B0 - Tba[0], -Tab[1])) && (LB0_lx > a[0] || Rectangle.inVoronoi(a[1], b[0], A0_dot_B0, Tab[0] - a[0], A1_dot_B0, Tab[1], Tba[0] - aA0_dot_B0))) {
            double[] tu = Rectangle.segCoords(a[1], b[0], A1_dot_B0, Tab[1], Tba[0] - aA0_dot_B0);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * u - a[0], Tab[1] + Rab[1][0] * u - t, Tab[2] + Rab[2][0] * u);
            return S.length();
        }
        if (LA1_uy > b[1] && UB0_lx < 0.0 && (LA1_ly > b[1] || Rectangle.inVoronoi(b[0], a[1], A1_dot_B1, -Tba[1] - b[1], A1_dot_B0, -Tba[0], -Tab[1] - bA1_dot_B1)) && (UB0_ux < 0.0 || Rectangle.inVoronoi(a[1], b[0], -A0_dot_B0, -Tab[0] - bA0_dot_B1, A1_dot_B0, Tab[1] + bA1_dot_B1, Tba[0]))) {
            double[] tu = Rectangle.segCoords(a[1], b[0], A1_dot_B0, Tab[1] + bA1_dot_B1, Tba[0]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * b[1] + Rab[0][0] * u, Tab[1] + Rab[1][1] * b[1] + Rab[1][0] * u - t, Tab[2] + Rab[2][1] * b[1] + Rab[2][0] * u);
            return S.length();
        }
        if (LA1_ly < 0.0 && LB0_lx < 0.0 && (LA1_uy < 0.0 || Rectangle.inVoronoi(b[0], a[1], -A1_dot_B1, Tba[1], A1_dot_B0, -Tba[0], -Tab[1])) && (LB0_ux < 0.0 || Rectangle.inVoronoi(a[1], b[0], -A0_dot_B0, -Tab[0], A1_dot_B0, Tab[1], Tba[0]))) {
            double[] tu = Rectangle.segCoords(a[1], b[0], A1_dot_B0, Tab[1], Tba[0]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * u, Tab[1] + Rab[1][0] * u - t, Tab[2] + Rab[2][0] * u);
            return S.length();
        }
        double BLL_y = Tab[1];
        double BLU_y = BLL_y + bA1_dot_B1;
        double BUL_y = BLL_y + bA1_dot_B0;
        double BUU_y = BLU_y + bA1_dot_B0;
        if (ALL_x < AUL_x) {
            LA0_lx = ALL_x;
            LA0_ux = AUL_x;
            UA0_lx = ALU_x;
            UA0_ux = AUU_x;
        } else {
            LA0_lx = AUL_x;
            LA0_ux = ALL_x;
            UA0_lx = AUU_x;
            UA0_ux = ALU_x;
        }
        if (BLL_y < BLU_y) {
            LB1_ly = BLL_y;
            LB1_uy = BLU_y;
            UB1_ly = BUL_y;
            UB1_uy = BUU_y;
        } else {
            LB1_ly = BLU_y;
            LB1_uy = BLL_y;
            UB1_ly = BUU_y;
            UB1_uy = BUL_y;
        }
        if (UA0_ux > b[0] && UB1_uy > a[1] && (UA0_lx > b[0] || Rectangle.inVoronoi(b[1], a[0], A0_dot_B0, aA1_dot_B0 - Tba[0] - b[0], A0_dot_B1, aA1_dot_B1 - Tba[1], -Tab[0] - bA0_dot_B0)) && (UB1_ly > a[1] || Rectangle.inVoronoi(a[0], b[1], A1_dot_B1, Tab[1] - a[1] + bA1_dot_B0, A0_dot_B1, Tab[0] + bA0_dot_B0, Tba[1] - aA1_dot_B1))) {
            double[] tu = Rectangle.segCoords(a[0], b[1], A0_dot_B1, Tab[0] + bA0_dot_B0, Tba[1] - aA1_dot_B1);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * b[0] + Rab[0][1] * u - t, Tab[1] + Rab[1][0] * b[0] + Rab[1][1] * u - a[1], Tab[2] + Rab[2][0] * b[0] + Rab[2][1] * u);
            return S.length();
        }
        if (UA0_lx < 0.0 && LB1_uy > a[1] && (UA0_ux < 0.0 || Rectangle.inVoronoi(b[1], a[0], -A0_dot_B0, Tba[0] - aA1_dot_B0, A0_dot_B1, aA1_dot_B1 - Tba[1], -Tab[0])) && (LB1_ly > a[1] || Rectangle.inVoronoi(a[0], b[1], A1_dot_B1, Tab[1] - a[1], A0_dot_B1, Tab[0], Tba[1] - aA1_dot_B1))) {
            double[] tu = Rectangle.segCoords(a[0], b[1], A0_dot_B1, Tab[0], Tba[1] - aA1_dot_B1);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * u - t, Tab[1] + Rab[1][1] * u - a[1], Tab[2] + Rab[2][1] * u);
            return S.length();
        }
        if (LA0_ux > b[0] && UB1_ly < 0.0 && (LA0_lx > b[0] || Rectangle.inVoronoi(b[1], a[0], A0_dot_B0, -b[0] - Tba[0], A0_dot_B1, -Tba[1], -bA0_dot_B0 - Tab[0])) && (UB1_uy < 0.0 || Rectangle.inVoronoi(a[0], b[1], -A1_dot_B1, -Tab[1] - bA1_dot_B0, A0_dot_B1, Tab[0] + bA0_dot_B0, Tba[1]))) {
            double[] tu = Rectangle.segCoords(a[0], b[1], A0_dot_B1, Tab[0] + bA0_dot_B0, Tba[1]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * b[0] + Rab[0][1] * u - t, Tab[1] + Rab[1][0] * b[0] + Rab[1][1] * u, Tab[2] + Rab[2][0] * b[0] + Rab[2][1] * u);
            return S.length();
        }
        if (LA0_lx < 0.0 && LB1_ly < 0.0 && (LA0_ux < 0.0 || Rectangle.inVoronoi(b[1], a[0], -A0_dot_B0, Tba[0], A0_dot_B1, -Tba[1], -Tab[0])) && (LB1_uy < 0.0 || Rectangle.inVoronoi(a[0], b[1], -A1_dot_B1, -Tab[1], A0_dot_B1, Tab[0], Tba[1]))) {
            double[] tu = Rectangle.segCoords(a[0], b[1], A0_dot_B1, Tab[0], Tba[1]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * u - t, Tab[1] + Rab[1][1] * u, Tab[2] + Rab[2][1] * u);
            return S.length();
        }
        if (ALL_y < AUL_y) {
            LA0_ly = ALL_y;
            LA0_uy = AUL_y;
            UA0_ly = ALU_y;
            UA0_uy = AUU_y;
        } else {
            LA0_ly = AUL_y;
            LA0_uy = ALL_y;
            UA0_ly = AUU_y;
            UA0_uy = ALU_y;
        }
        if (BLL_y < BUL_y) {
            LB0_ly = BLL_y;
            LB0_uy = BUL_y;
            UB0_ly = BLU_y;
            UB0_uy = BUU_y;
        } else {
            LB0_ly = BUL_y;
            LB0_uy = BLL_y;
            UB0_ly = BUU_y;
            UB0_uy = BLU_y;
        }
        if (UA0_uy > b[1] && UB0_uy > a[1] && (UA0_ly > b[1] || Rectangle.inVoronoi(b[0], a[0], A0_dot_B1, aA1_dot_B1 - Tba[1] - b[1], A0_dot_B0, aA1_dot_B0 - Tba[0], -Tab[0] - bA0_dot_B1)) && (UB0_ly > a[1] || Rectangle.inVoronoi(a[0], b[0], A1_dot_B0, Tab[1] - a[1] + bA1_dot_B1, A0_dot_B0, Tab[0] + bA0_dot_B1, Tba[0] - aA1_dot_B0))) {
            double[] tu = Rectangle.segCoords(a[0], b[0], A0_dot_B0, Tab[0] + bA0_dot_B1, Tba[0] - aA1_dot_B0);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * b[1] + Rab[0][0] * u - t, Tab[1] + Rab[1][1] * b[1] + Rab[1][0] * u - a[1], Tab[2] + Rab[2][1] * b[1] + Rab[2][0] * u);
            return S.length();
        }
        if (UA0_ly < 0.0 && LB0_uy > a[1] && (UA0_uy < 0.0 || Rectangle.inVoronoi(b[0], a[0], -A0_dot_B1, Tba[1] - aA1_dot_B1, A0_dot_B0, aA1_dot_B0 - Tba[0], -Tab[0])) && (LB0_ly > a[1] || Rectangle.inVoronoi(a[0], b[0], A1_dot_B0, Tab[1] - a[1], A0_dot_B0, Tab[0], Tba[0] - aA1_dot_B0))) {
            double[] tu = Rectangle.segCoords(a[0], b[0], A0_dot_B0, Tab[0], Tba[0] - aA1_dot_B0);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * u - t, Tab[1] + Rab[1][0] * u - a[1], Tab[2] + Rab[2][0] * u);
            return S.length();
        }
        if (LA0_uy > b[1] && UB0_ly < 0.0 && (LA0_ly > b[1] || Rectangle.inVoronoi(b[0], a[0], A0_dot_B1, -Tba[1] - b[1], A0_dot_B0, -Tba[0], -Tab[0] - bA0_dot_B1)) && (UB0_uy < 0.0 || Rectangle.inVoronoi(a[0], b[0], -A1_dot_B0, -Tab[1] - bA1_dot_B1, A0_dot_B0, Tab[0] + bA0_dot_B1, Tba[0]))) {
            double[] tu = Rectangle.segCoords(a[0], b[0], A0_dot_B0, Tab[0] + bA0_dot_B1, Tba[0]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][1] * b[1] + Rab[0][0] * u - t, Tab[1] + Rab[1][1] * b[1] + Rab[1][0] * u, Tab[2] + Rab[2][1] * b[1] + Rab[2][0] * u);
            return S.length();
        }
        if (LA0_ly < 0.0 && LB0_ly < 0.0 && (LA0_uy < 0.0 || Rectangle.inVoronoi(b[0], a[0], -A0_dot_B1, Tba[1], A0_dot_B0, -Tba[0], -Tab[0])) && (LB0_uy < 0.0 || Rectangle.inVoronoi(a[0], b[0], -A1_dot_B0, -Tab[1], A0_dot_B0, Tab[0], Tba[0]))) {
            double[] tu = Rectangle.segCoords(a[0], b[0], A0_dot_B0, Tab[0], Tba[0]);
            double t = tu[0];
            double u = tu[1];
            Vector S = new Vector(Tab[0] + Rab[0][0] * u - t, Tab[1] + Rab[1][0] * u, Tab[2] + Rab[2][0] * u);
            return S.length();
        }
        if (Tab[2] > 0.0) {
            sep1 = Tab[2];
            if (Rab[2][0] < 0.0) {
                sep1 += b[0] * Rab[2][0];
            }
            if (Rab[2][1] < 0.0) {
                sep1 += b[1] * Rab[2][1];
            }
        } else {
            sep1 = -Tab[2];
            if (Rab[2][0] > 0.0) {
                sep1 -= b[0] * Rab[2][0];
            }
            if (Rab[2][1] > 0.0) {
                sep1 -= b[1] * Rab[2][1];
            }
        }
        if (Tba[2] < 0.0) {
            sep2 = -Tba[2];
            if (Rab[0][2] < 0.0) {
                sep2 += a[0] * Rab[0][2];
            }
            if (Rab[1][2] < 0.0) {
                sep2 += a[1] * Rab[1][2];
            }
        } else {
            sep2 = Tba[2];
            if (Rab[0][2] > 0.0) {
                sep2 -= a[0] * Rab[0][2];
            }
            if (Rab[1][2] > 0.0) {
                sep2 -= a[1] * Rab[1][2];
            }
        }
        double sep = sep1 > sep2 ? sep1 : sep2;
        return sep > 0.0 ? sep : 0.0;
    }
}

