/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.math.Matrix3x3;
import ProGAL.math.Randomization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class PointList
extends ArrayList<Point> {
    private static final long serialVersionUID = -4824374877674925546L;

    public PointList() {
    }

    public PointList(Point[] elements) {
        this();
        for (Point p : elements) {
            this.add(p);
        }
    }

    public PointList(Collection<Point> points) {
        super(points);
    }

    public double getCoord(int k, int i) {
        return ((Point)this.get(k)).getCoord(i);
    }

    public PointList getSubList(int from, int to) {
        PointList ret = new PointList();
        for (int i = from; i < to; ++i) {
            ret.add(this.get(i));
        }
        return ret;
    }

    public PointList getRandomPermutation() {
        PointList ret = this.clone();
        Collections.shuffle(ret, Randomization.getGenerator());
        return ret;
    }

    public Point getCentroid() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Point p : this) {
            x += p.x();
            y += p.y();
            z += p.z();
        }
        int n = this.size();
        return new Point(x / (double)n, y / (double)n, z / (double)n);
    }

    public double getVariance() {
        Point c = this.getCentroid();
        double sum = 0.0;
        for (Point p : this) {
            sum += c.distanceSquared(p);
        }
        return sum / (double)this.size();
    }

    public Matrix3x3 getCovariance() {
        Matrix3x3 cov = new Matrix3x3();
        Point c = this.getCentroid();
        for (int i = 0; i < 3; ++i) {
            double ci = c.getCoord(i);
            for (int j = i; j < 3; ++j) {
                double cj = c.getCoord(j);
                double cv = 0.0;
                for (int k = 0; k < this.size(); ++k) {
                    Point p = (Point)this.get(k);
                    cv += (p.getCoord(i) - ci) * (p.getCoord(j) - cj);
                }
                cov.set(i, j, cv / (double)this.size());
                cov.set(j, i, cov.get(i, j));
            }
        }
        return cov;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public Point getExtreme(Vector direction) {
        double maxDot = Double.NEGATIVE_INFINITY;
        Point ret = null;
        for (Point p : this) {
            double dot = direction.dot(p.toVector());
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            ret = p;
        }
        return ret;
    }

    public int getExtremeIndex(Vector direction) {
        double maxDot = Double.NEGATIVE_INFINITY;
        int ret = -1;
        for (Point p : this) {
            double dot = direction.dot(p.toVector());
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            ret = this.indexOf(p);
        }
        return ret;
    }

    public int getExtremeIndex(int ix, int iy, int iz, boolean high) {
        int indx = 0;
        Point q = (Point)this.get(0);
        for (int i = 1; i < this.size(); ++i) {
            Point p = (Point)this.get(i);
            if (high) {
                if (!p.dominates(q, ix, iy, iz)) continue;
                indx = i;
                q = p;
                continue;
            }
            if (!q.dominates(p, ix, iy, iz)) continue;
            indx = i;
            q = p;
        }
        return indx;
    }

    public Point getExtremeRight() {
        return (Point)this.get(this.getExtremeIndex(0, 1, 2, true));
    }

    public Point getExtremeLeft() {
        return (Point)this.get(this.getExtremeIndex(0, 1, 2, false));
    }

    public Point getExtremeTop() {
        return (Point)this.get(this.getExtremeIndex(1, 0, 2, true));
    }

    public Point getExtremeBottom() {
        return (Point)this.get(this.getExtremeIndex(1, 0, 2, false));
    }

    public Point getExtremeFront() {
        return (Point)this.get(this.getExtremeIndex(1, 2, 0, true));
    }

    public Point getExtremeBack() {
        return (Point)this.get(this.getExtremeIndex(1, 2, 0, false));
    }

    public LineSegment getDiameter() {
        Point best1 = null;
        Point best2 = null;
        double best = 0.0;
        for (int i = 0; i < this.size() - 1; ++i) {
            Point p = (Point)this.get(i);
            for (int j = i + 1; j < this.size(); ++j) {
                Point q = (Point)this.get(j);
                double pq = p.distanceSquared(q);
                if (!(pq > best)) continue;
                best = pq;
                best1 = p;
                best2 = q;
            }
        }
        return new LineSegment(best1, best2);
    }

    public LineSegment diameterSqrt3Approx() {
        LineSegment seg0 = new LineSegment(this.getExtremeLeft(), this.getExtremeRight());
        LineSegment seg1 = new LineSegment(this.getExtremeBottom(), this.getExtremeTop());
        LineSegment seg2 = new LineSegment(this.getExtremeFront(), this.getExtremeBack());
        double l0 = seg0.getLengthSquared();
        double l1 = seg1.getLengthSquared();
        double l2 = seg2.getLengthSquared();
        if (l0 < l1) {
            return l2 < l0 ? seg2 : seg0;
        }
        return l2 < l1 ? seg2 : seg1;
    }

    @Override
    public PointList clone() {
        PointList ret = new PointList();
        ret.addAll(this);
        return ret;
    }

    public void toConsole() {
        System.out.println("PointList3d:");
        for (int i = 0; i < this.size(); ++i) {
            System.out.print(String.format("%3d> ", i));
            ((Point)this.get(i)).toConsole();
        }
    }

    public void toConsole(int dec) {
        System.out.println("PointList3d:");
        for (int i = 0; i < this.size(); ++i) {
            System.out.print(String.format("%3d> ", i));
            ((Point)this.get(i)).toConsole(dec);
        }
    }

    public static PointList generatePointsInCube(int n) {
        return PointList.generatePointsInCube(n, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    public static PointList generatePointsInCube(int n, double xL, double xH, double yL, double yH, double zL, double zH) {
        PointList list = new PointList();
        for (int i = 0; i < n; ++i) {
            list.add(new Point(Randomization.randBetween(xL, xH), Randomization.randBetween(yL, yH), Randomization.randBetween(zL, zH)));
        }
        return list;
    }

    public static PointList generateRandomPointsOnSphere(int n) {
        PointList list = new PointList();
        for (int i = 0; i < n; ++i) {
            double theta0 = Randomization.randBetween(0.0, Math.PI * 2);
            double theta1 = Math.acos(Randomization.randBetween(-1.0, 1.0));
            list.add(new Point(Math.sin(theta0) * Math.cos(theta1), Math.sin(theta0) * Math.sin(theta1), Math.cos(theta0)));
        }
        return list;
    }

    public static PointList generatePointsOnSphere(int n) {
        PointList list = new PointList();
        double l = 0.0;
        double dl = Math.PI * (3.0 - Math.sqrt(5.0));
        double dz = 2.0 / (double)n;
        double z = 1.0 - dz / 2.0;
        for (int k = 0; k < n; ++k) {
            double r = Math.sqrt(1.0 - z * z);
            list.add(new Point(Math.cos(l) * r, Math.sin(l) * r, z));
            z -= dz;
            l += dl;
        }
        return list;
    }
}

