/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Simplex;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.math.Constants;

public class Point
extends ProGAL.geomNd.Point
implements Simplex {
    private static final long serialVersionUID = -2120468832687547475L;

    public Point(double x, double y, double z) {
        super(new double[]{x, y, z});
    }

    public Point(double[] coords) {
        super(coords);
    }

    public Point(ProGAL.geomNd.Point p) {
        super(p);
    }

    public Point(Vector v) {
        super(new double[]{v.x(), v.y(), v.z()});
    }

    public final double x() {
        return this.coords[0];
    }

    public final double y() {
        return this.coords[1];
    }

    public final double z() {
        return this.coords[2];
    }

    public final void setX(double x) {
        this.coords[0] = x;
    }

    public final void setY(double y) {
        this.coords[1] = y;
    }

    public final void setZ(double z) {
        this.coords[2] = z;
    }

    @Override
    public final int getDimension() {
        return 0;
    }

    public Vector vectorTo(Point p) {
        return new Vector(p.coords[0] - this.coords[0], p.coords[1] - this.coords[1], p.coords[2] - this.coords[2]);
    }

    public static boolean collinear(Point p0, Point p1, Point p2) {
        Vector v1v2;
        Vector v1v0 = p1.vectorTo(p0);
        return v1v0.cross(v1v2 = p1.vectorTo(p2)).getLengthSquared() < Constants.EPSILON;
    }

    public static boolean coplanar(Point p0, Point p1, Point p2, Point p3) {
        double az = p0.coords[2];
        double by = p1.coords[1];
        double cx = p2.coords[0];
        double ay = p0.coords[1];
        double bz = p1.coords[2];
        double bx = p1.coords[0];
        double cy = p2.coords[1];
        double ax = p0.coords[0];
        double cz = p2.coords[2];
        double dx = p3.coords[0];
        double dy = p3.coords[1];
        double dz = p3.coords[2];
        return Math.abs(-az * by * cx + ay * bz * cx + az * bx * cy - ax * bz * cy - ay * bx * cz + ax * by * cz + az * by * dx - ay * bz * dx - az * cy * dx + bz * cy * dx + ay * cz * dx - by * cz * dx - az * bx * dy + ax * bz * dy + az * cx * dy - bz * cx * dy - ax * cz * dy + bx * cz * dy + ay * bx * dz - ax * by * dz - ay * cx * dz + by * cx * dz + ax * cy * dz - bx * cy * dz) < Constants.EPSILON;
    }

    public static double orientation(Point p, Point q, Point r, Point s) {
        double M1 = q.x() * (r.y() - s.y()) + r.x() * (s.y() - q.y()) + s.x() * (q.y() - r.y());
        double M2 = p.x() * (r.y() - s.y()) + r.x() * (s.y() - p.y()) + s.x() * (p.y() - r.y());
        double M3 = p.x() * (q.y() - s.y()) + q.x() * (s.y() - p.y()) + s.x() * (p.y() - q.y());
        double M4 = p.x() * (q.y() - r.y()) + q.x() * (r.y() - p.y()) + r.x() * (p.y() - q.y());
        return -p.z() * M1 + q.z() * M2 - r.z() * M3 + s.z() * M4;
    }

    public static double orientation(Point p, Point q, Point r, Point s, Point t) {
        double Mt;
        double pqy = p.y() - q.y();
        double pry = p.y() - r.y();
        double psy = p.y() - s.y();
        double pty = p.y() - t.y();
        double qry = q.y() - r.y();
        double qsy = q.y() - s.y();
        double qty = q.y() - t.y();
        double rsy = r.y() - s.y();
        double rty = r.y() - t.y();
        double Ms1 = q.x() * rsy - r.x() * qsy + s.x() * qry;
        double Ms2 = p.x() * rsy - r.x() * psy + s.x() * pry;
        double Ms3 = p.x() * qsy - q.x() * psy + s.x() * pqy;
        double Mt1 = q.x() * rty - r.x() * qty + t.x() * qry;
        double Mt2 = p.x() * rty - r.x() * pty + t.x() * pry;
        double Mt3 = p.x() * qty - q.x() * pty + t.x() * pqy;
        double M4 = p.x() * qry - q.x() * pry + r.x() * pqy;
        double Ms = -p.z() * Ms1 + q.z() * Ms2 - r.z() * Ms3 + s.z() * M4;
        if (Ms * (Mt = -p.z() * Mt1 + q.z() * Mt2 - r.z() * Mt3 + t.z() * M4) >= 0.0) {
            return Math.abs(Ms);
        }
        return -Math.abs(Ms);
    }

    public static double inSphere(Point p, Point q, Point r, Point s, Point t) {
        double pp = p.x() * p.x() + p.y() * p.y() + p.z() * p.z();
        double qq = q.x() * q.x() + q.y() * q.y() + q.z() * q.z();
        double rr = r.x() * r.x() + r.y() * r.y() + r.z() * r.z();
        double ss = s.x() * s.x() + s.y() * s.y() + s.z() * s.z();
        double tt = t.x() * t.x() + t.y() * t.y() + t.z() * t.z();
        double M12 = r.x() * (s.y() - t.y()) + s.x() * (t.y() - r.y()) + t.x() * (r.y() - s.y());
        double M13 = q.x() * (s.y() - t.y()) + s.x() * (t.y() - q.y()) + t.x() * (q.y() - s.y());
        double M14 = q.x() * (r.y() - t.y()) + r.x() * (t.y() - q.y()) + t.x() * (q.y() - r.y());
        double M15 = q.x() * (r.y() - s.y()) + r.x() * (s.y() - q.y()) + s.x() * (q.y() - r.y());
        double M23 = p.x() * (s.y() - t.y()) + s.x() * (t.y() - p.y()) + t.x() * (p.y() - s.y());
        double M24 = p.x() * (r.y() - t.y()) + r.x() * (t.y() - p.y()) + t.x() * (p.y() - r.y());
        double M25 = p.x() * (r.y() - s.y()) + r.x() * (s.y() - p.y()) + s.x() * (p.y() - r.y());
        double M34 = p.x() * (q.y() - t.y()) + q.x() * (t.y() - p.y()) + t.x() * (p.y() - q.y());
        double M35 = p.x() * (q.y() - s.y()) + q.x() * (s.y() - p.y()) + s.x() * (p.y() - q.y());
        double M45 = p.x() * (q.y() - r.y()) + q.x() * (r.y() - p.y()) + r.x() * (p.y() - q.y());
        double M1 = -q.z() * M12 + r.z() * M13 - s.z() * M14 + t.z() * M15;
        double M2 = -p.z() * M12 + r.z() * M23 - s.z() * M24 + t.z() * M25;
        double M3 = -p.z() * M13 + q.z() * M23 - s.z() * M34 + t.z() * M35;
        double M4 = -p.z() * M14 + q.z() * M24 - r.z() * M34 + t.z() * M45;
        double M5 = -p.z() * M15 + q.z() * M25 - r.z() * M35 + s.z() * M45;
        return pp * M1 - qq * M2 + rr * M3 - ss * M4 + tt * M5;
    }

    public void translateThis(double dx, double dy, double dz) {
        this.coords[0] = this.coords[0] + dx;
        this.coords[1] = this.coords[1] + dy;
        this.coords[2] = this.coords[2] + dz;
    }

    public void translateThis(Point p) {
        this.translateThis(-p.x(), -p.y(), -p.z());
    }

    public void scaleThis(double s) {
        this.coords[0] = this.coords[0] * s;
        this.coords[1] = this.coords[1] * s;
        this.coords[2] = this.coords[2] * s;
    }

    public Point addThis(Vector p) {
        this.translateThis(p.x(), p.y(), p.z());
        return this;
    }

    public Point addThis(Point p) {
        this.translateThis(p.x(), p.y(), p.z());
        return this;
    }

    public Point add(Vector p) {
        return new Point(this.coords[0] + p.x(), this.coords[1] + p.y(), this.coords[2] + p.z());
    }

    public Point add(double x, double y, double z) {
        return new Point(this.coords[0] + x, this.coords[1] + y, this.coords[2] + z);
    }

    public Point add(Point p) {
        return new Point(this.coords[0] + p.x(), this.coords[1] + p.y(), this.coords[2] + p.z());
    }

    public Point subtractThis(Vector p) {
        this.coords[0] = this.coords[0] - p.x();
        this.coords[1] = this.coords[1] - p.y();
        this.coords[2] = this.coords[2] - p.z();
        return this;
    }

    public Point subtractThis(Point p) {
        this.coords[0] = this.coords[0] - p.x();
        this.coords[1] = this.coords[1] - p.y();
        this.coords[2] = this.coords[2] - p.z();
        return this;
    }

    public Point subtract(Vector p) {
        return new Point(this.coords[0] - p.x(), this.coords[1] - p.y(), this.coords[2] - p.z());
    }

    public Point subtract(Point p) {
        return new Point(this.coords[0] - p.x(), this.coords[1] - p.y(), this.coords[2] - p.z());
    }

    public Point reflectThroughOrigoThis() {
        this.coords[0] = this.coords[0] * -1.0;
        this.coords[1] = this.coords[1] * -1.0;
        this.coords[2] = this.coords[2] * -1.0;
        return this;
    }

    public void rotationCW(Vector v, double alpha) {
        double c = Math.cos(alpha);
        double d = 1.0 - c;
        double s = Math.sin(alpha);
        double vxyd = v.x() * v.y() * d;
        double vxzd = v.x() * v.z() * d;
        double vyzd = v.y() * v.z() * d;
        double vxs = v.x() * s;
        double vys = v.y() * s;
        double vzs = v.z() * s;
        double xNew = (v.x() * v.x() * d + c) * this.coords[0] + (vxyd - vzs) * this.coords[1] + (vxzd + vys) * this.coords[2];
        double yNew = (vxyd + vzs) * this.coords[0] + (v.y() * v.y() * d + c) * this.coords[1] + (vyzd - vxs) * this.coords[2];
        double zNew = (vxzd - vys) * this.coords[0] + (vyzd + vxs) * this.coords[1] + (v.z() * v.z() * d + c) * this.coords[2];
        this.setX(xNew);
        this.setY(yNew);
        this.setZ(zNew);
    }

    public void rotationCCW(Vector v, double alpha) {
        double c = Math.cos(alpha);
        double d = 1.0 - c;
        double s = Math.sin(alpha);
        double vxyd = v.x() * v.y() * d;
        double vxzd = v.x() * v.z() * d;
        double vyzd = v.y() * v.z() * d;
        double vxs = v.x() * s;
        double vys = v.y() * s;
        double vzs = v.z() * s;
        double xNew = (v.x() * v.x() * d + c) * this.x() + -(vxyd - vzs) * this.y() + -(vxzd + vys) * this.z();
        double yNew = -(vxyd + vzs) * this.x() + (v.y() * v.y() * d + c) * this.y() + -(vyzd - vxs) * this.z();
        this.setZ(-(vxzd - vys) * this.x() + -(vyzd + vxs) * this.y() + (v.z() * v.z() * d + c) * this.z());
        this.setX(xNew);
        this.setY(yNew);
    }

    public void rotation(Vector v, double alpha, Point p) {
        this.translateThis(-p.x(), -p.y(), -p.z());
        this.rotationCW(v, alpha);
        this.translateThis(p.x(), p.y(), p.z());
    }

    public double polarAngleSinZ() {
        return this.coords[1] / this.distance();
    }

    public double polarAngleCosZ() {
        return this.coords[0] / this.distance();
    }

    public double distanceSquared(Point q) {
        double dx = this.coords[0] - q.coords[0];
        double dy = this.coords[1] - q.coords[1];
        double dz = this.coords[2] - q.coords[2];
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(Point q) {
        double dx = this.coords[0] - q.coords[0];
        double dy = this.coords[1] - q.coords[1];
        double dz = this.coords[2] - q.coords[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double dot(Point p) {
        return this.x() * p.x() + this.y() * p.y() + this.z() * p.z();
    }

    public double dot(Vector v) {
        return this.x() * v.x() + this.y() * v.y() + this.z() * v.z();
    }

    public static Plane getBisector(Point p, Point q) {
        if (!p.equals(q)) {
            return new Plane(Point.getMidpoint(p, q), p.vectorTo(q).normalizeThis());
        }
        return null;
    }

    public static Point getMidpoint(Point p, Point q) {
        return new Point((p.coords[0] + q.coords[0]) / 2.0, (p.coords[1] + q.coords[1]) / 2.0, (p.coords[2] + q.coords[2]) / 2.0);
    }

    public static double getAngle(Point p1, Point p2, Point p3) {
        return p2.vectorTo(p1).angle(p2.vectorTo(p3));
    }

    public static double getDihedralAngle(Point p1, Point p2, Point p3, Point p4) {
        return Vector.getDihedralAngle(p1.vectorTo(p2), p2.vectorTo(p3), p3.vectorTo(p4));
    }

    public static double getCosDihedralAngle(Point p1, Point p2, Point p3, Point p4) {
        return Vector.getCosDihedralAngle(new Vector(p1, p2), new Vector(p2, p3), new Vector(p3, p4));
    }

    public boolean dominates(Point q) {
        if (this.coords[0] > q.coords[0]) {
            return true;
        }
        if (this.coords[0] < q.coords[0]) {
            return false;
        }
        if (this.coords[1] > q.coords[1]) {
            return true;
        }
        if (this.coords[1] < q.coords[1]) {
            return false;
        }
        return this.coords[2] > q.coords[2];
    }

    public boolean dominates(Point q, int i, int j, int k) {
        if (i == j || i == k || j == k) {
            throw new Error(String.format("i, j and k must be distinct coordinate indices (%d,%d,%d)", i, j, k));
        }
        if (this.getCoord(i) > q.getCoord(i)) {
            return true;
        }
        if (this.getCoord(i) < q.getCoord(i)) {
            return false;
        }
        if (this.getCoord(j) > q.getCoord(j)) {
            return true;
        }
        if (this.getCoord(j) < q.getCoord(j)) {
            return false;
        }
        return this.getCoord(k) > q.getCoord(k);
    }

    @Override
    public Point getCenter() {
        return this.clone();
    }

    @Override
    public Point getPoint(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("Invalid index (" + i + ") 0-simplex has one point only");
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            return this.equals((Point)o);
        }
        return false;
    }

    public boolean equals(Point p) {
        if (Math.abs(this.coords[0] - p.coords[0]) > Constants.EPSILON) {
            return false;
        }
        if (Math.abs(this.coords[1] - p.coords[1]) > Constants.EPSILON) {
            return false;
        }
        return !(Math.abs(this.coords[2] - p.coords[2]) > Constants.EPSILON);
    }

    public static Point getCircumCenter(Point a, Point b, Point c) {
        Vector ca = new Vector(c, a);
        Vector cb = new Vector(c, b);
        Vector cr = ca.cross(cb);
        Vector v1 = cb.multiply(ca.getLengthSquared());
        Vector v2 = ca.multiply(cb.getLengthSquared());
        v1.subtractThis(v2);
        v1.crossThis(cr);
        v1.divideThis(2.0 * cr.getLengthSquared());
        return c.add(v1);
    }

    public static Point getEquilateralPoint(Point a, Point b, Point c) {
        Point e = a.clone();
        Vector ba = new Vector(b, a);
        Vector normal = ba.cross(new Vector(b, c));
        normal.normalizeThis();
        e.rotation(normal, -1.0471975511965976, b);
        return e;
    }

    public static Circle getEquilateralCircle(Point a, Point b, Point c) {
        return new Circle(a, b, Point.getEquilateralPoint(a, b, c));
    }

    public static Circle getEquilateralPoints(Point a, Point b) {
        Point center = Point.getMidpoint(a, b);
        double radius = Math.sqrt(3.0) * a.distance(b) / 2.0;
        Vector normal = new Vector(a, b).normalizeThis();
        return new Circle(center, radius, normal);
    }

    public static Point getSteinerPoint(Point a, Point b, Point c) {
        Vector ab = new Vector(a, b);
        Vector ba = new Vector(b, a);
        Vector bc = new Vector(b, c);
        Vector cb = new Vector(c, b);
        Vector ca = new Vector(c, a);
        Vector ac = new Vector(a, c);
        if (!ab.isSteinerAngle(ac)) {
            return a;
        }
        if (!ba.isSteinerAngle(bc)) {
            return b;
        }
        if (!ca.isSteinerAngle(cb)) {
            return c;
        }
        Point eab = Point.getEquilateralPoint(a, b, c);
        Point center = Point.getCircumCenter(a, b, eab);
        Vector normal = ab.cross(ac).normalize();
        Sphere sphere = new Sphere(new Circle(center, a, normal));
        LineSegment sgm = sphere.getIntersection(new Line(eab, c));
        if (sgm.a.distanceSquared(eab) > sgm.b.distanceSquared(eab)) {
            return sgm.a;
        }
        return sgm.b;
    }

    @Override
    public Point clone() {
        return new Point(this.coords[0], this.coords[1], this.coords[2]);
    }

    public static void swap(Point a, Point b) {
        Point temp = a;
        a = b;
        b = temp;
    }

    @Override
    public Vector toVector() {
        return new Vector(this.coords[0], this.coords[1], this.coords[2]);
    }

    @Override
    public String toString() {
        return this.toString(2);
    }

    @Override
    public String toString(int dec) {
        return String.format("Point[%." + dec + "f,%." + dec + "f,%." + dec + "f]", this.coords[0], this.coords[1], this.coords[2]);
    }

    @Override
    public void toConsole() {
        System.out.println(this.toString());
    }

    @Override
    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }
}

