/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Shape;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.math.Constants;

public class Plane
implements Shape {
    protected Vector normal;
    protected Point point;

    public Plane(Point p, Vector n) {
        this.normal = n.normalizeThis();
        this.point = p;
    }

    public Plane(Vector n) {
        this.normal = n.normalizeThis();
        this.point = new Point(0.0, 0.0, 0.0);
    }

    public Plane(Vector n, double d) {
        this.normal = n.normalizeThis();
        this.point = new Point(-d * n.x(), -d * n.y(), -d * n.z());
    }

    public Plane(Point p, Point q, Point r) {
        if (Point.collinear(p, q, r)) {
            throw new Error("Cant construct plane: Points are collinear");
        }
        this.normal = p.vectorTo(q).crossThis(p.vectorTo(r)).normalizeThis();
        this.point = p;
    }

    public Plane(Point p, Point q) {
        this.normal = new Vector(p, q).normalizeThis();
        this.point = Point.getMidpoint(p, q);
    }

    private double getD() {
        return -this.normal.x() * this.point.x() - this.normal.y() * this.point.y() - this.normal.z() * this.point.z();
    }

    public Point getPoint() {
        return this.point;
    }

    public Vector getNormal() {
        return this.normal;
    }

    public void setNormal(Vector n) {
        this.normal = n;
    }

    public Point projectPoint(Point p) {
        double t = this.normal.x() * p.x() + this.normal.y() * p.y() + this.normal.z() * p.z() + this.getD();
        return new Point(p.x() - this.normal.x() * t, p.y() - this.normal.y() * t, p.z() - this.normal.z() * t);
    }

    public int above(Point p) {
        double d;
        double dotP = this.normal.dot(p.toVector());
        if (dotP > -(d = this.getD())) {
            return 1;
        }
        if (dotP < -d) {
            return -1;
        }
        return 0;
    }

    public int below(Point p) {
        return -this.above(p);
    }

    public double getDistance(Point p) {
        return Math.abs(this.normal.dot(p.toVector()) + this.getD());
    }

    public double getUnsignedDihedralAngle(Plane p) {
        return Math.acos(this.normal.dot(p.normal));
    }

    public Point getIntersection(Line line) {
        double denom = this.normal.dot(line.getDir());
        if (denom == 0.0) {
            return null;
        }
        Point a = line.getP();
        Vector pa = this.point.vectorTo(a);
        double u = this.normal.dot(pa) / denom;
        return new Point(a.x() - u * line.dir.x(), a.y() - u * line.dir.y(), a.z() - u * line.dir.z());
    }

    public double getIntersectionParameter(Line line) {
        double denom = this.normal.dot(line.getDir());
        if (denom == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        Point a = line.getP();
        Vector pa = this.point.vectorTo(a);
        double u = this.normal.dot(pa) / denom;
        return u;
    }

    public Point getIntersection(LineSegment sgm) {
        double dist1;
        double dist0 = this.normal.dot(sgm.getA().subtract(this.point));
        if (dist0 * (dist1 = this.normal.dot(sgm.getB().subtract(this.point))) > 0.0) {
            return null;
        }
        Vector x = (Vector)sgm.getB().subtract(sgm.getA()).multiplyThis(1.0 / sgm.getB().distance(sgm.getA())).toVector();
        double cos = this.normal.dot(x);
        if (Math.abs(cos) >= Constants.EPSILON) {
            return sgm.getB().subtract(x.multiply(dist1 / cos));
        }
        return null;
    }

    public Double getIntersectionAngle(Circle circle, Point p, Vector dir) {
        Vector nC = circle.getNormal();
        if (nC.isParallel(this.normal)) {
            return null;
        }
        Plane circlePlane = new Plane(circle.getCenter(), nC);
        Line line = this.getIntersection(circlePlane);
        double dist = line.getDistance(circle.getCenter());
        if (dist > circle.getRadius() - Constants.EPSILON) {
            return null;
        }
        return circle.getFirstIntersection(line, p, dir);
    }

    public Point[] getIntersection(Circle circle) {
        Vector u = circle.getNormal().getOrthonormal().multiply(circle.getRadius());
        return this.getIntersection(circle, u);
    }

    public Point[] getIntersection(Circle circle, Vector u) {
        Vector nC = circle.getNormal();
        if (nC.isParallel(this.normal)) {
            return null;
        }
        Plane circlePlane = new Plane(circle.getCenter(), nC);
        Line line = this.getIntersection(circlePlane);
        double dist = line.getDistance(circle.getCenter());
        if (dist > circle.getRadius() + Constants.EPSILON) {
            return null;
        }
        if (dist > circle.getRadius() - Constants.EPSILON) {
            Point[] intPoints = new Point[]{line.orthogonalProjection(circle.getCenter())};
            return intPoints;
        }
        Vector v = u.clone();
        nC.rotateIn(v, 1.5707963267948966);
        Vector cp = new Vector(circle.getCenter(), this.point);
        double a = u.dot(this.normal);
        double b = v.dot(this.normal);
        double c = cp.dot(this.normal);
        double r = Math.sqrt(a * a + b * b);
        double x = Math.atan2(b / r, a / r);
        double alpha1 = Math.acos(c / r);
        double alpha2 = Math.PI * 2 - alpha1;
        double t1 = alpha1 + x;
        double t2 = alpha2 + x;
        Vector[] intVectors = new Vector[2];
        intVectors[0] = u.clone();
        nC.rotateIn(intVectors[0], t1);
        intVectors[1] = u.clone();
        nC.rotateIn(intVectors[1], t2);
        Point[] intPoints = new Point[]{circle.getCenter().clone().add(intVectors[0]), circle.getCenter().clone().add(intVectors[1])};
        return intPoints;
    }

    public Line getIntersection(Plane pl) {
        Vector dir = this.normal.cross(pl.getNormal());
        if (dir.isZeroVector()) {
            return null;
        }
        double h1 = this.normal.dot(new Vector(this.point));
        double h2 = pl.getNormal().dot(new Vector(pl.getPoint()));
        double dd = this.normal.dot(pl.getNormal());
        double denom = 1.0 - dd * dd;
        double c1 = (h1 - h2 * dd) / denom;
        double c2 = (h2 - h1 * dd) / denom;
        Point q = new Point(c1 * this.normal.x() + c2 * pl.getNormal().x(), c1 * this.normal.y() + c2 * pl.getNormal().y(), c1 * this.normal.z() + c2 * pl.getNormal().z());
        return new Line(q, dir);
    }

    public Circle getIntersection(Sphere sphere) {
        double rad;
        double dist = this.getDistance(sphere.getCenter());
        if (dist - (rad = sphere.getRadius()) > Constants.EPSILON) {
            return null;
        }
        Point center = this.projectPoint(sphere.getCenter());
        if (dist - rad > -Constants.EPSILON) {
            return new Circle(center, 0.0, null);
        }
        return new Circle(center, Math.sqrt(rad * rad - center.distanceSquared(sphere.getCenter())), this.normal);
    }

    @Override
    public Point getCenter() {
        return this.point.clone();
    }

    private static Vector m(Vector v, double beta) {
        return new Vector(v.x() * Math.cos(beta) - v.y() * Math.sin(beta), v.y() * Math.cos(beta) + v.x() * Math.sin(beta), v.z());
    }

    private static Point q(Point q0, double beta) {
        return new Point(q0.distance() * Math.cos(beta), q0.distance() * Math.sin(beta), q0.z());
    }
}

