/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Line;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.math.Matrix3x3;

public class ParametricPlane {
    public Point p;
    public Vector n;
    public Vector v1;
    public Vector v2;
    protected Matrix3x3 projInv;

    public ParametricPlane(Point p, Vector v1, Vector v2) {
        this.p = p;
        this.n = v1.cross(v2).normalizeThis();
        this.v1 = v1;
        this.v2 = v2;
        this.projInv = Matrix3x3.createRowMatrix(v1, v2, this.n);
    }

    public ParametricPlane(Point p, Vector normal) {
        this.p = p;
        this.n = normal.normalize();
        this.v1 = new Vector(1.001, 0.002, 0.0).crossThis(normal).normalizeThis();
        this.v2 = this.n.cross(this.v1);
        this.projInv = Matrix3x3.createRowMatrix(this.v1, this.v2, this.n);
    }

    public double[] projectPoint(Point v) {
        Vector x = this.p.vectorTo(v);
        this.projInv.multiplyIn(x);
        return new double[]{x.x(), x.y(), x.z()};
    }

    public double intersectionParameter(Line l) {
        return this.n.dot(l.p.vectorTo(this.p)) / this.n.dot(l.dir);
    }

    public Point getP() {
        return this.p;
    }

    public Point getP(double[] pars) {
        return this.p.add(this.v1.multiply(pars[0])).addThis(this.v2.multiply(pars[1]));
    }
}

